from .avp import (AvpAddress, AvpEnumerated, AvpFloat32, AvpFloat64, AvpGrouped,
                  AvpInteger32, AvpInteger64, AvpUnsigned32, AvpUnsigned64,
                  AvpOctetString, AvpTime, AvpUtf8String)
from ..constants import *

# base avp dictionary with no vendors
AVP_DICTIONARY = {
    AVP_USER_NAME: {"name": "User-Name", "type": AvpUtf8String, "mandatory": True},
    AVP_USER_PASSWORD: {"name": "User-Password", "type": AvpOctetString, "mandatory": True},
    AVP_CHAP_PASSWORD: {"name": "CHAP-Password", "type": AvpOctetString, "mandatory": True},
    AVP_NAS_IP_ADDRESS: {"name": "NAS-IP-Address", "type": AvpOctetString, "mandatory": True},
    AVP_NAS_PORT: {"name": "NAS-Port", "type": AvpUnsigned32, "mandatory": True},
    AVP_SERVICE_TYPE: {"name": "Service-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_FRAMED_PROTOCOL: {"name": "Framed-Protocol", "type": AvpEnumerated, "mandatory": True},
    AVP_FRAMED_IP_ADDRESS: {"name": "Framed-IP-Address", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_IP_NETMASK: {"name": "Framed-IP-Netmask", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_ROUTING: {"name": "Framed-Routing", "type": AvpEnumerated, "mandatory": True},
    AVP_FILTER_ID: {"name": "Filter-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_FRAMED_MTU: {"name": "Framed-MTU", "type": AvpUnsigned32, "mandatory": True},
    AVP_FRAMED_COMPRESSION: {"name": "Framed-Compression", "type": AvpEnumerated, "mandatory": True},
    AVP_LOGIN_IP_HOST: {"name": "Login-IP-Host", "type": AvpAddress, "mandatory": True},
    AVP_LOGIN_SERVICE: {"name": "Login-Service", "type": AvpEnumerated, "mandatory": True},
    AVP_LOGIN_TCP_PORT: {"name": "Login-TCP-Port", "type": AvpUnsigned32, "mandatory": True},
    AVP_REPLY_MESSAGE: {"name": "Reply-Message", "type": AvpUtf8String, "mandatory": True},
    AVP_CALLBACK_NUMBER: {"name": "Callback-Number", "type": AvpUtf8String, "mandatory": True},
    AVP_CALLBACK_ID: {"name": "Callback-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_FRAMED_ROUTE: {"name": "Framed-Route", "type": AvpUtf8String, "mandatory": True},
    AVP_FRAMED_IPX_NETWORK: {"name": "Framed-IPX-Network", "type": AvpUnsigned32, "mandatory": True},
    AVP_STATE: {"name": "State", "type": AvpOctetString, "mandatory": True},
    AVP_CLASS: {"name": "Class", "type": AvpOctetString, "mandatory": True},
    AVP_VENDOR_SPECIFIC: {"name": "Vendor-Specific", "type": AvpUnsigned32, "mandatory": True},
    AVP_SESSION_TIMEOUT: {"name": "Session-Timeout", "type": AvpUnsigned32, "mandatory": True},
    AVP_IDLE_TIMEOUT: {"name": "Idle-Timeout", "type": AvpUnsigned32, "mandatory": True},
    AVP_TERMINATION_ACTION: {"name": "Termination-Action", "type": AvpEnumerated, "mandatory": True},
    AVP_CALLED_STATION_ID: {"name": "Called-Station-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_CALLING_STATION_ID: {"name": "Calling-Station-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_NAS_IDENTIFIER: {"name": "NAS-Identifier", "type": AvpUtf8String, "mandatory": True},
    AVP_PROXY_STATE: {"name": "Proxy-State", "type": AvpOctetString, "mandatory": True},
    AVP_LOGIN_LAT_SERVICE: {"name": "Login-LAT-Service", "type": AvpOctetString, "mandatory": True},
    AVP_LOGIN_LAT_NODE: {"name": "Login-LAT-Node", "type": AvpOctetString, "mandatory": True},
    AVP_LOGIN_LAT_GROUP: {"name": "Login-LAT-Group", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_APPLETALK_LINK: {"name": "Framed-AppleTalk-Link", "type": AvpUnsigned32, "mandatory": True},
    AVP_FRAMED_APPLETALK_NETWORK: {"name": "Framed-AppleTalk-Network", "type": AvpUnsigned32, "mandatory": True},
    AVP_FRAMED_APPLETALK_ZONE: {"name": "Framed-AppleTalk-Zone", "type": AvpOctetString, "mandatory": True},
    AVP_ACCT_STATUS_TYPE: {"name": "Acct-Status-Type", "type": AvpEnumerated},
    AVP_ACCT_DELAY_TIME: {"name": "Acct-Delay-Time", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_INPUT_OCTETS: {"name": "Acct-Input-Octets", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_OUTPUT_OCTETS: {"name": "Acct-Output-Octets", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_SESSION_ID: {"name": "Acct-Session-Id", "type": AvpOctetString, "mandatory": True},
    AVP_ACCT_AUTHENTIC: {"name": "Acct-Authentic", "type": AvpEnumerated, "mandatory": True},
    AVP_ACCT_SESSION_TIME: {"name": "Acct-Session-Time", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_INPUT_PACKETS: {"name": "Acct-Input-Packets", "type": AvpInteger32, "mandatory": True},
    AVP_ACCT_OUTPUT_PACKETS: {"name": "Acct-Output-Packets", "type": AvpInteger32, "mandatory": True},
    AVP_ACCT_TERMINATE_CAUSE: {"name": "Acct-Terminate-Cause", "type": AvpEnumerated},
    AVP_ACCOUNTING_MULTI_SESSION_ID: {"name": "Accounting-Multi-Session-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_ACCT_LINK_COUNT: {"name": "Acct-Link-Count", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_INPUT_GIGAWORDS: {"name": "Acct-Input-Gigawords", "type": AvpInteger32, "mandatory": True},
    AVP_ACCT_OUTPUT_GIGAWORDS: {"name": "Acct-Output-Gigawords", "type": AvpInteger32, "mandatory": True},
    AVP_EVENT_TIMESTAMP: {"name": "Event-Timestamp", "type": AvpTime, "mandatory": True},
    AVP_EGRESS_VLANID: {"name": "Egress-VLANID", "type": AvpOctetString, "mandatory": True},
    AVP_INGRESS_FILTERS: {"name": "Ingress-Filters", "type": AvpEnumerated, "mandatory": True},
    AVP_EGRESS_VLAN_NAME: {"name": "Egress-VLAN-Name", "type": AvpUtf8String, "mandatory": True},
    AVP_USER_PRIORITY_TABLE: {"name": "User-Priority-Table", "type": AvpOctetString, "mandatory": True},
    AVP_CHAP_CHALLENGE: {"name": "CHAP-Challenge", "type": AvpOctetString, "mandatory": True},
    AVP_NAS_PORT_TYPE: {"name": "NAS-Port-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_PORT_LIMIT: {"name": "Port-Limit", "type": AvpUnsigned32, "mandatory": True},
    AVP_LOGIN_LAT_PORT: {"name": "Login-LAT-Port", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNEL_TYPE: {"name": "Tunnel-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_TUNNEL_MEDIUM_TYPE: {"name": "Tunnel-Medium-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_TUNNEL_CLIENT_ENDPOINT: {"name": "Tunnel-Client-Endpoint", "type": AvpUtf8String, "mandatory": True},
    AVP_TUNNEL_SERVER_ENDPOINT: {"name": "Tunnel-Server-Endpoint", "type": AvpUtf8String, "mandatory": True},
    AVP_TUNNEL_CONNECTION_ID: {"name": "Tunnel-Connection-ID", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNEL_PASSWORD: {"name": "Tunnel-Password", "type": AvpOctetString, "mandatory": True},
    AVP_ARAP_PASSWORD: {"name": "ARAP-Password", "type": AvpOctetString, "mandatory": True},
    AVP_ARAP_FEATURES: {"name": "ARAP-Features", "type": AvpOctetString, "mandatory": True},
    AVP_ARAP_ZONE_ACCESS: {"name": "ARAP-Zone-Access", "type": AvpEnumerated, "mandatory": True},
    AVP_ARAP_SECURITY: {"name": "ARAP-Security", "type": AvpUnsigned32, "mandatory": True},
    AVP_ARAP_SECURITY_DATA: {"name": "ARAP-Security-Data", "type": AvpOctetString, "mandatory": True},
    AVP_PASSWORD_RETRY: {"name": "Password-Retry", "type": AvpUnsigned32, "mandatory": True},
    AVP_PROMPT: {"name": "Prompt", "type": AvpEnumerated, "mandatory": True},
    AVP_CONNECT_INFO: {"name": "Connect-Info", "type": AvpUtf8String, "mandatory": True},
    AVP_CONFIGURATION_TOKEN: {"name": "Configuration-Token", "type": AvpOctetString, "mandatory": True},
    AVP_EAP_MESSAGE: {"name": "EAP-Message", "type": AvpOctetString, "mandatory": True},
    AVP_SIGNATURE: {"name": "Signature", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNEL_PRIVATE_GROUP_ID: {"name": "Tunnel-Private-Group-Id", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNEL_ASSIGNMENT_ID: {"name": "Tunnel-Assignment-Id", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNEL_PREFERENCE: {"name": "Tunnel-Preference", "type": AvpUnsigned32, "mandatory": True},
    AVP_ARAP_CHALLENGE_RESPONSE: {"name": "ARAP-Challenge-Response", "type": AvpOctetString, "mandatory": True},
    AVP_ACCT_INTERIM_INTERVAL: {"name": "Acct-Interim-Interval", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_TUNNEL_PACKETS_LOST: {"name": "Acct-Tunnel-Packets-Lost", "type": AvpUnsigned32, "mandatory": True},
    AVP_NAS_PORT_ID: {"name": "NAS-Port-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_FRAMED_POOL: {"name": "Framed-Pool", "type": AvpOctetString, "mandatory": True},
    AVP_CUI: {"name": "CUI", "type": AvpUtf8String, "mandatory": True},
    AVP_TUNNEL_CLIENT_AUTH_ID: {"name": "Tunnel-Client-Auth-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_TUNNEL_SERVER_AUTH_ID: {"name": "Tunnel-Server-Auth-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_RADIUS_NAS_FILTER_RULE: {"name": "RADIUS-NAS-Filter-Rule", "type": AvpUtf8String, "mandatory": True},
    AVP_ORIGINATING_LINE_INFO: {"name": "Originating-Line-Info", "type": AvpOctetString, "mandatory": True},
    AVP_NAS_IPV6_ADDRESS: {"name": "NAS-IPv6-Address", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_INTERFACE_ID: {"name": "Framed-Interface-Id", "type": AvpUnsigned64, "mandatory": True},
    AVP_FRAMED_IPV6_PREFIX: {"name": "Framed-IPv6-Prefix", "type": AvpOctetString, "mandatory": True},
    AVP_LOGIN_IPV6_HOST: {"name": "Login-IPv6-Host", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_IPV6_ROUTE: {"name": "Framed-IPv6-Route", "type": AvpUtf8String, "mandatory": True},
    AVP_FRAMED_IPV6_POOL: {"name": "Framed-IPv6-Pool", "type": AvpOctetString, "mandatory": True},
    AVP_ERROR_CAUSE: {"name": "Error-Cause", "type": AvpEnumerated, "mandatory": True},
    AVP_EAP_KEY_NAME: {"name": "EAP-Key-Name", "type": AvpOctetString, "mandatory": True},
    AVP_DIGEST_RESPONSE: {"name": "Digest-Response", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_REALM: {"name": "Digest-Realm", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_NONCE: {"name": "Digest-Nonce", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_RESPONSE_AUTH: {"name": "Digest-Response-Auth", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_NEXTNONCE: {"name": "Digest-Nextnonce", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_METHOD: {"name": "Digest-Method", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_URI: {"name": "Digest-URI", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_QOP: {"name": "Digest-Qop", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_ALGORITHM: {"name": "Digest-Algorithm", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_ENTITY_BODY_HASH: {"name": "Digest-Entity-Body-Hash", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_CNONCE: {"name": "Digest-CNonce", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_NONCE_COUNT: {"name": "Digest-Nonce-Count", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_USERNAME: {"name": "Digest-Username", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_OPAQUE: {"name": "Digest-Opaque", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_AUTH_PARAM: {"name": "Digest-Auth-Param", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_AKA_AUTS: {"name": "Digest-AKA-Auts", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_DOMAIN: {"name": "Digest-Domain", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_STALE: {"name": "Digest-Stale", "type": AvpUtf8String, "mandatory": True},
    AVP_DIGEST_HA1: {"name": "Digest-HA1", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_AOR: {"name": "SIP-AOR", "type": AvpUtf8String, "mandatory": True},
    AVP_DELEGATED_IPV6_PREFIX: {"name": "Delegated-IPv6-Prefix", "type": AvpOctetString, "mandatory": True},
    AVP_MIP6_FEATURE_VECTOR: {"name": "MIP6-Feature-Vector", "type": AvpUnsigned64, "mandatory": True},
    AVP_MIP6_HOME_LINK_PREFIX: {"name": "MIP6-Home-Link-Prefix", "type": AvpOctetString, "mandatory": True},
    AVP_OPERATOR_NAME: {"name": "Operator-Name", "type": AvpOctetString, "mandatory": True},
    AVP_LOCATION_INFORMATION: {"name": "Location-Information", "type": AvpOctetString, "mandatory": True},
    AVP_LOCATION_DATA: {"name": "Location-Data", "type": AvpOctetString, "mandatory": True},
    AVP_BASIC_LOCATION_POLICY_RULES: {"name": "Basic-Location-Policy-Rules", "type": AvpOctetString, "mandatory": True},
    AVP_EXTENDED_LOCATION_POLICY_RULES: {"name": "Extended-Location-Policy-Rules", "type": AvpOctetString, "mandatory": True},
    AVP_LOCATION_CAPABLE: {"name": "Location-Capable", "type": AvpOctetString, "mandatory": True},
    AVP_REQUESTED_LOCATION_INFO: {"name": "Requested-Location-Info", "type": AvpOctetString, "mandatory": True},
    AVP_FRAMED_MANAGEMENT_PROTOCOL: {"name": "Framed-Management-Protocol", "type": AvpEnumerated, "mandatory": True},
    AVP_MANAGEMENT_TRANSPORT_PROTECTION: {"name": "Management-Transport-Protection", "type": AvpEnumerated, "mandatory": True},
    AVP_MANAGEMENT_POLICY_ID: {"name": "Management-Policy-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_MANAGEMENT_PRIVILEGE_LEVEL: {"name": "Management-Privilege-Level", "type": AvpInteger32, "mandatory": True},
    AVP_PKM_SS_CERT: {"name": "PKM-SS-Cert", "type": AvpOctetString, "mandatory": True},
    AVP_PKM_CA_CERT: {"name": "PKM-CA-Cert", "type": AvpOctetString, "mandatory": True},
    AVP_PKM_CONFIG_SETTINGS: {"name": "PKM-Config-Settings", "type": AvpOctetString, "mandatory": True},
    AVP_PKM_CRYPTOSUITE_LIST: {"name": "PKM-Cryptosuite-List", "type": AvpOctetString, "mandatory": True},
    AVP_PPKM_SAID: {"name": "PPKM-SAID", "type": AvpOctetString, "mandatory": True},
    AVP_PKM_SA_DESCRIPTOR: {"name": "PKM-SA-Descriptor", "type": AvpOctetString, "mandatory": True},
    AVP_PKM_AUTH_KEY: {"name": "PKM-Auth-Key", "type": AvpOctetString, "mandatory": True},
    AVP_HOST_IP_ADDRESS: {"name": "Host-IP-Address", "type": AvpAddress, "mandatory": True},
    AVP_AUTH_APPLICATION_ID: {"name": "Auth-Application-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_ACCT_APPLICATION_ID: {"name": "Acct-Application-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_VENDOR_SPECIFIC_APPLICATION_ID: {"name": "Vendor-Specific-Application-Id", "type": AvpGrouped, "mandatory": True},
    AVP_REDIRECT_HOST_USAGE: {"name": "Redirect-Host-Usage", "type": AvpEnumerated, "mandatory": True},
    AVP_REDIRECT_MAX_CACHE_TIME: {"name": "Redirect-Max-Cache-Time", "type": AvpUnsigned32, "mandatory": True},
    AVP_SESSION_ID: {"name": "Session-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_ORIGIN_HOST: {"name": "Origin-Host", "type": AvpOctetString, "mandatory": True},
    AVP_SUPPORTED_VENDOR_ID: {"name": "Supported-Vendor-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_VENDOR_ID: {"name": "Vendor-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_FIRMWARE_REVISION: {"name": "Firmware-Revision", "type": AvpUnsigned32, "mandatory": True},
    AVP_RESULT_CODE: {"name": "Result-Code", "type": AvpEnumerated, "mandatory": True},
    AVP_PRODUCT_NAME: {"name": "Product-Name", "type": AvpUtf8String, "mandatory": True},
    AVP_SESSION_BINDING: {"name": "Session-Binding", "type": AvpEnumerated, "mandatory": True},
    AVP_SESSION_SERVER_FAILOVER: {"name": "Session-Server-Failover", "type": AvpEnumerated, "mandatory": True},
    AVP_MULTI_ROUND_TIME_OUT: {"name": "Multi-Round-Time-Out", "type": AvpUnsigned32, "mandatory": True},
    AVP_DISCONNECT_CAUSE: {"name": "Disconnect-Cause", "type": AvpEnumerated, "mandatory": True},
    AVP_AUTH_REQUEST_TYPE: {"name": "Auth-Request-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_ALTERNATE_PEER: {"name": "Alternate-Peer", "type": AvpOctetString, "mandatory": True},
    AVP_AUTH_GRACE_PERIOD: {"name": "Auth-Grace-Period", "type": AvpUnsigned32, "mandatory": True},
    AVP_AUTH_SESSION_STATE: {"name": "Auth-Session-State", "type": AvpEnumerated, "mandatory": True},
    AVP_ORIGIN_STATE_ID: {"name": "Origin-State-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_FAILED_AVP: {"name": "Failed-AVP", "type": AvpGrouped, "mandatory": True},
    AVP_PROXY_HOST: {"name": "Proxy-Host", "type": AvpOctetString, "mandatory": True},
    AVP_ERROR_MESSAGE: {"name": "Error-Message", "type": AvpUtf8String, "mandatory": True},
    AVP_ROUTE_RECORD: {"name": "Route-Record", "type": AvpOctetString, "mandatory": True},
    AVP_DESTINATION_REALM: {"name": "Destination-Realm", "type": AvpOctetString, "mandatory": True},
    AVP_PROXY_INFO: {"name": "Proxy-Info", "type": AvpGrouped, "mandatory": True},
    AVP_RE_AUTH_REQUEST_TYPE: {"name": "Re-Auth-Request-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_ACCOUNTING_SUB_SESSION_ID: {"name": "Accounting-Sub-Session-Id", "type": AvpUnsigned64, "mandatory": True},
    AVP_AUTHORIZATION_LIFETIME: {"name": "Authorization-Lifetime", "type": AvpInteger32, "mandatory": True},
    AVP_REDIRECT_HOST: {"name": "Redirect-Host", "type": AvpUtf8String, "mandatory": True},
    AVP_DESTINATION_HOST: {"name": "Destination-Host", "type": AvpOctetString, "mandatory": True},
    AVP_ERROR_REPORTING_HOST: {"name": "Error-Reporting-Host", "type": AvpOctetString, "mandatory": True},
    AVP_TERMINATION_CAUSE: {"name": "Termination-Cause", "type": AvpEnumerated, "mandatory": True},
    AVP_ORIGIN_REALM: {"name": "Origin-Realm", "type": AvpOctetString, "mandatory": True},
    AVP_EXPERIMENTAL_RESULT: {"name": "Experimental-Result", "type": AvpGrouped, "mandatory": True},
    AVP_EXPERIMENTAL_RESULT_CODE: {"name": "Experimental-Result-Code", "type": AvpUnsigned32, "mandatory": True},
    AVP_INBAND_SECURITY_ID: {"name": "Inband-Security-Id", "type": AvpEnumerated, "mandatory": True},
    AVP_E2E_SEQUENCE: {"name": "E2E-Sequence", "type": AvpGrouped, "mandatory": True},
    AVP_DRMP: {"name": "DRMP", "type": AvpEnumerated},
    AVP_QOS_FILTER_RULE: {"name": "QoS-Filter-Rule", "type": AvpOctetString},
    AVP_ACCOUNTING_RECORD_TYPE: {"name": "Accounting-Record-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_ACCOUNTING_REALTIME_REQUIRED: {"name": "Accounting-Realtime-Required", "type": AvpEnumerated, "mandatory": True},
    AVP_ACCOUNTING_RECORD_NUMBER: {"name": "Accounting-Record-Number", "type": AvpUnsigned32, "mandatory": True},
    AVP_TMOD_1: {"name": "TMOD-1", "type": AvpGrouped, "mandatory": True},
    AVP_TOKEN_RATE: {"name": "Token-Rate", "type": AvpFloat32, "mandatory": True},
    AVP_BUCKET_DEPTH: {"name": "Bucket-Depth", "type": AvpFloat32, "mandatory": True},
    AVP_PEAK_TRAFFIC_RATE: {"name": "Peak-Traffic-Rate", "type": AvpFloat32, "mandatory": True},
    AVP_MINIMUM_POLICED_UNIT: {"name": "Minimum-Policed-Unit", "type": AvpUnsigned32, "mandatory": True},
    AVP_MAXIMUM_PACKET_SIZE: {"name": "Maximum-Packet-Size", "type": AvpUnsigned32, "mandatory": True},
    AVP_TMOD_2: {"name": "TMOD-2", "type": AvpGrouped, "mandatory": True},
    AVP_BANDWIDTH: {"name": "Bandwidth", "type": AvpFloat32, "mandatory": True},
    AVP_PHB_CLASS: {"name": "PHB-Class", "type": AvpUnsigned32, "mandatory": True},
    AVP_QOS_RESOURCES: {"name": "QoS-Resources", "type": AvpGrouped, "mandatory": True},
    AVP_FILTER_RULE: {"name": "Filter-Rule", "type": AvpGrouped, "mandatory": True},
    AVP_FILTER_RULE_PRECEDENCE: {"name": "Filter-Rule-Precedence", "type": AvpUnsigned32, "mandatory": True},
    AVP_CLASSIFIER: {"name": "Classifier", "type": AvpGrouped, "mandatory": True},
    AVP_CLASSIFIER_ID: {"name": "Classifier-ID", "type": AvpOctetString, "mandatory": True},
    AVP_PROTOCOL: {"name": "Protocol", "type": AvpEnumerated, "mandatory": True},
    AVP_DIRECTION: {"name": "Direction", "type": AvpEnumerated, "mandatory": True},
    AVP_FROM_SPEC: {"name": "From-Spec", "type": AvpGrouped, "mandatory": True},
    AVP_TO_SPEC: {"name": "To-Spec", "type": AvpGrouped, "mandatory": True},
    AVP_NEGATED: {"name": "Negated", "type": AvpEnumerated, "mandatory": True},
    AVP_IP_ADDRESS: {"name": "IP-Address", "type": AvpAddress, "mandatory": True},
    AVP_IP_ADDRESS_RANGE: {"name": "IP-Address-Range", "type": AvpGrouped, "mandatory": True},
    AVP_IP_ADDRESS_START: {"name": "IP-Address-Start", "type": AvpAddress, "mandatory": True},
    AVP_IP_ADDRESS_END: {"name": "IP-Address-End", "type": AvpAddress, "mandatory": True},
    AVP_IP_ADDRESS_MASK: {"name": "IP-Address-Mask", "type": AvpGrouped, "mandatory": True},
    AVP_IP_BIT_MASK_WIDTH: {"name": "IP-Bit-Mask-Width", "type": AvpUnsigned32, "mandatory": True},
    AVP_MAC_ADDRESS: {"name": "MAC-Address", "type": AvpOctetString, "mandatory": True},
    AVP_MAC_ADDRESS_MASK: {"name": "MAC-Address-Mask", "type": AvpGrouped, "mandatory": True},
    AVP_MAC_ADDRESS_MASK_PATTERN: {"name": "MAC-Address-Mask-Pattern", "type": AvpOctetString, "mandatory": True},
    AVP_EUI64_ADDRESS: {"name": "EUI64-Address", "type": AvpOctetString, "mandatory": True},
    AVP_EUI64_ADDRESS_MASK: {"name": "EUI64-Address-Mask", "type": AvpGrouped, "mandatory": True},
    AVP_EUI64_ADDRESS_MASK_PATTERN: {"name": "EUI64-Address-Mask-Pattern", "type": AvpOctetString, "mandatory": True},
    AVP_PORT: {"name": "Port", "type": AvpInteger32, "mandatory": True},
    AVP_PORT_RANGE: {"name": "Port-Range", "type": AvpGrouped, "mandatory": True},
    AVP_PORT_START: {"name": "Port-Start", "type": AvpInteger32, "mandatory": True},
    AVP_PORT_END: {"name": "Port-End", "type": AvpInteger32, "mandatory": True},
    AVP_USE_ASSIGNED_ADDRESS: {"name": "Use-Assigned-Address", "type": AvpEnumerated, "mandatory": True},
    AVP_DIFFSERV_CODE_POINT: {"name": "Diffserv-Code-Point", "type": AvpEnumerated, "mandatory": True},
    AVP_FRAGMENTATION_FLAG: {"name": "Fragmentation-Flag", "type": AvpEnumerated, "mandatory": True},
    AVP_IP_OPTION: {"name": "IP-Option", "type": AvpGrouped, "mandatory": True},
    AVP_IP_OPTION_TYPE: {"name": "IP-Option-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_IP_OPTION_VALUE: {"name": "IP-Option-Value", "type": AvpOctetString, "mandatory": True},
    AVP_TCP_OPTION: {"name": "TCP-Option", "type": AvpGrouped, "mandatory": True},
    AVP_TCP_OPTION_TYPE: {"name": "TCP-Option-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_TCP_OPTION_VALUE: {"name": "TCP-Option-Value", "type": AvpOctetString, "mandatory": True},
    AVP_TCP_FLAGS: {"name": "TCP-Flags", "type": AvpGrouped, "mandatory": True},
    AVP_TCP_FLAG_TYPE: {"name": "TCP-Flag-Type", "type": AvpUnsigned32, "mandatory": True},
    AVP_ICMP_TYPE: {"name": "ICMP-Type", "type": AvpGrouped, "mandatory": True},
    AVP_ICMP_TYPE_NUMBER: {"name": "ICMP-Type-Number", "type": AvpEnumerated, "mandatory": True},
    AVP_ICMP_CODE: {"name": "ICMP-Code", "type": AvpEnumerated, "mandatory": True},
    AVP_ETH_OPTION: {"name": "ETH-Option", "type": AvpGrouped, "mandatory": True},
    AVP_ETH_PROTO_TYPE: {"name": "ETH-Proto-Type", "type": AvpGrouped, "mandatory": True},
    AVP_ETH_ETHER_TYPE: {"name": "ETH-Ether-Type", "type": AvpOctetString, "mandatory": True},
    AVP_ETH_SAP: {"name": "ETH-SAP", "type": AvpOctetString, "mandatory": True},
    AVP_VLAN_ID_RANGE: {"name": "VLAN-ID-Range", "type": AvpGrouped, "mandatory": True},
    AVP_S_VID_START: {"name": "S-VID-Start", "type": AvpUnsigned32, "mandatory": True},
    AVP_S_VID_END: {"name": "S-VID-End", "type": AvpUnsigned32, "mandatory": True},
    AVP_C_VID_START: {"name": "C-VID-Start", "type": AvpUnsigned32, "mandatory": True},
    AVP_C_VID_END: {"name": "C-VID-End", "type": AvpUnsigned32, "mandatory": True},
    AVP_USER_PRIORITY_RANGE: {"name": "User-Priority-Range", "type": AvpGrouped, "mandatory": True},
    AVP_LOW_USER_PRIORITY: {"name": "Low-User-Priority", "type": AvpUnsigned32, "mandatory": True},
    AVP_HIGH_USER_PRIORITY: {"name": "High-User-Priority", "type": AvpUnsigned32, "mandatory": True},
    AVP_TIME_OF_DAY_CONDITION: {"name": "Time-Of-Day-Condition", "type": AvpGrouped, "mandatory": True},
    AVP_TIME_OF_DAY_START: {"name": "Time-Of-Day-Start", "type": AvpUnsigned32, "mandatory": True},
    AVP_TIME_OF_DAY_END: {"name": "Time-Of-Day-End", "type": AvpUnsigned32, "mandatory": True},
    AVP_DAY_OF_WEEK_MASK: {"name": "Day-Of-Week-Mask", "type": AvpEnumerated, "mandatory": True},
    AVP_DAY_OF_MONTH_MASK: {"name": "Day-Of-Month-Mask", "type": AvpEnumerated, "mandatory": True},
    AVP_MONTH_OF_YEAR_MASK: {"name": "Month-Of-Year-Mask", "type": AvpEnumerated, "mandatory": True},
    AVP_ABSOLUTE_START_TIME: {"name": "Absolute-Start-Time", "type": AvpTime, "mandatory": True},
    AVP_ABSOLUTE_START_FRACTIONAL_SECONDS: {"name": "Absolute-Start-Fractional-Seconds", "type": AvpUnsigned32, "mandatory": True},
    AVP_ABSOLUTE_END_TIME: {"name": "Absolute-End-Time", "type": AvpTime, "mandatory": True},
    AVP_ABSOLUTE_END_FRACTIONAL_SECONDS: {"name": "Absolute-End-Fractional-Seconds", "type": AvpUnsigned32, "mandatory": True},
    AVP_TIMEZONE_FLAG: {"name": "Timezone-Flag", "type": AvpEnumerated, "mandatory": True},
    AVP_TIMEZONE_OFFSET: {"name": "Timezone-Offset", "type": AvpInteger32, "mandatory": True},
    AVP_TREATMENT_ACTION: {"name": "Treatment-Action", "type": AvpEnumerated, "mandatory": True},
    AVP_QOS_PROFILE_ID: {"name": "QoS-Profile-Id", "type": AvpUnsigned32, "mandatory": True},
    AVP_QOS_PROFILE_TEMPLATE: {"name": "QoS-Profile-Template", "type": AvpGrouped, "mandatory": True},
    AVP_QOS_SEMANTICS: {"name": "QoS-Semantics", "type": AvpEnumerated, "mandatory": True},
    AVP_QOS_PARAMETERS: {"name": "QoS-Parameters", "type": AvpGrouped, "mandatory": True},
    AVP_EXCESS_TREATMENT: {"name": "Excess-Treatment", "type": AvpGrouped, "mandatory": True},
    AVP_REDIRECT_REALM: {"name": "Redirect-Realm", "type": AvpOctetString, "mandatory": True},
    AVP_OC_SUPPORTED_FEATURES: {"name": "OC-Supported-Features", "type": AvpGrouped, "mandatory": True},
    AVP_OC_FEATURE_VECTOR: {"name": "OC-Feature-Vector", "type": AvpUnsigned64, "mandatory": True},
    AVP_OC_OLR: {"name": "OC-OLR", "type": AvpGrouped, "mandatory": True},
    AVP_OC_SEQUENCE_NUMBER: {"name": "OC-Sequence-Number", "type": AvpUnsigned64, "mandatory": True},
    AVP_OC_VALIDITY_DURATION: {"name": "OC-Validity-Duration", "type": AvpUnsigned32, "mandatory": True},
    AVP_OC_REPORT_TYPE: {"name": "OC-Report-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_OC_REDUCTION_PERCENTAGE: {"name": "OC-Reduction-Percentage", "type": AvpUnsigned32, "mandatory": True},
    AVP_OC_PEER_ALGO: {"name": "OC-Peer-Algo", "type": AvpUnsigned64, "mandatory": True},
    AVP_SOURCEID: {"name": "SourceID", "type": AvpOctetString, "mandatory": True},
    AVP_LOAD: {"name": "Load", "type": AvpGrouped, "mandatory": True},
    AVP_LOAD_TYPE: {"name": "Load-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_LOAD_VALUE: {"name": "Load-Value", "type": AvpUnsigned64, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_EXTENSION: {"name": "User-Equipment-Info-Extension", "type": AvpGrouped, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_IMEISV: {"name": "User-Equipment-Info-IMEISV", "type": AvpOctetString, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_MAC: {"name": "User-Equipment-Info-MAC", "type": AvpOctetString, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_EUI64: {"name": "User-Equipment-Info-EUI64", "type": AvpOctetString, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_MODIFIEDEUI64: {"name": "User-Equipment-Info-ModifiedEUI64", "type": AvpOctetString, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_IMEI: {"name": "User-Equipment-Info-IMEI", "type": AvpOctetString, "mandatory": True},
    AVP_ACCOUNTING_INPUT_OCTETS: {"name": "Accounting-Input-Octets", "type": AvpUnsigned64, "mandatory": True},
    AVP_ACCOUNTING_OUTPUT_OCTETS: {"name": "Accounting-Output-Octets", "type": AvpUnsigned64, "mandatory": True},
    AVP_ACCOUNTING_INPUT_PACKETS: {"name": "Accounting-Input-Packets", "type": AvpUnsigned64, "mandatory": True},
    AVP_ACCOUNTING_OUTPUT_PACKETS: {"name": "Accounting-Output-Packets", "type": AvpUnsigned64, "mandatory": True},
    AVP_NAS_FILTER_RULE: {"name": "NAS-Filter-Rule", "type": AvpOctetString, "mandatory": True},
    AVP_TUNNELING: {"name": "Tunneling", "type": AvpGrouped, "mandatory": True},
    AVP_CHAP_AUTH: {"name": "CHAP-Auth", "type": AvpGrouped, "mandatory": True},
    AVP_CHAP_ALGORITHM: {"name": "CHAP-Algorithm", "type": AvpEnumerated, "mandatory": True},
    AVP_CHAP_IDENT: {"name": "CHAP-Ident", "type": AvpOctetString, "mandatory": True},
    AVP_CHAP_RESPONSE: {"name": "CHAP-Response", "type": AvpOctetString, "mandatory": True},
    AVP_ACCOUNTING_AUTH_METHOD: {"name": "Accounting-Auth-Method", "type": AvpEnumerated, "mandatory": True},
    AVP_ORIGIN_AAA_PROTOCOL: {"name": "Origin-AAA-Protocol", "type": AvpEnumerated, "mandatory": True},
    AVP_EAP_PAYLOAD: {"name": "EAP-Payload", "type": AvpOctetString},
    AVP_EAP_REISSUED_PAYLOAD: {"name": "EAP-Reissued-Payload", "type": AvpOctetString},
    AVP_EAP_MASTER_SESSION_KEY: {"name": "EAP-Master-Session-Key", "type": AvpOctetString},
    AVP_ACCOUNTING_EAP_AUTH_METHOD: {"name": "Accounting-EAP-Auth-Method", "type": AvpUnsigned64},
    AVP_MIP_FA_TO_HA_SPI: {"name": "MIP-FA-to-HA-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_FA_TO_MN_SPI: {"name": "MIP-FA-to-MN-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_REG_REQUEST: {"name": "MIP-Reg-Request", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_REG_REPLY: {"name": "MIP-Reg-Reply", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_MN_AAA_AUTH: {"name": "MIP-MN-AAA-Auth", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_HA_TO_FA_SPI: {"name": "MIP-HA-to-FA-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_MN_TO_FA_SPI: {"name": "MIP-MN-to-FA-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_MN_TO_FA_MSA: {"name": "MIP-MN-to-FA-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_FA_TO_MN_MSA: {"name": "MIP-FA-to-MN-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_FA_TO_HA_MSA: {"name": "MIP-FA-to-HA-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_HA_TO_FA_MSA: {"name": "MIP-HA-to-FA-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_MN_TO_HA_MSA: {"name": "MIP-MN-to-HA-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_HA_TO_MN_MSA: {"name": "MIP-HA-to-MN-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_MOBILE_NODE_ADDRESS: {"name": "MIP-Mobile-Node-Address", "type": AvpAddress, "mandatory": True},
    AVP_MIP_HOME_AGENT_ADDRESS: {"name": "MIP-Home-Agent-Address", "type": AvpAddress, "mandatory": True},
    AVP_MIP_NONCE: {"name": "MIP-Nonce", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_CANDIDATE_HOME_AGENT_HOST: {"name": "MIP-Candidate-Home-Agent-Host", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_FEATURE_VECTOR: {"name": "MIP-Feature-Vector", "type": AvpEnumerated, "mandatory": True},
    AVP_MIP_AUTH_INPUT_DATA_LENGTH: {"name": "MIP-Auth-Input-Data-Length", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_AUTHENTICATOR_LENGTH: {"name": "MIP-Authenticator-Length", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_AUTHENTICATOR_OFFSET: {"name": "MIP-Authenticator-Offset", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_MN_AAA_SPI: {"name": "MIP-MN-AAA-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_FILTER_RULE: {"name": "MIP-Filter-Rule", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_SESSION_KEY: {"name": "MIP-Session-Key", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_FA_CHALLENGE: {"name": "MIP-FA-Challenge", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_ALGORITHM_TYPE: {"name": "MIP-Algorithm-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_MIP_REPLAY_MODE: {"name": "MIP-Replay-Mode", "type": AvpEnumerated, "mandatory": True},
    AVP_MIP_ORIGINATING_FOREIGN_AAA: {"name": "MIP-Originating-Foreign-AAA", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_HOME_AGENT_HOST: {"name": "MIP-Home-Agent-Host", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_MSA_LIFETIME: {"name": "MIP-MSA-Lifetime", "type": AvpUnsigned32, "mandatory": True},
    AVP_CC_CORRELATION_ID: {"name": "CC-Correlation-Id", "type": AvpOctetString, "mandatory": True},
    AVP_CC_INPUT_OCTETS: {"name": "CC-Input-Octets", "type": AvpUnsigned64, "mandatory": True},
    AVP_CC_MONEY: {"name": "CC-Money", "type": AvpGrouped, "mandatory": True},
    AVP_CC_OUTPUT_OCTETS: {"name": "CC-Output-Octets", "type": AvpUnsigned64, "mandatory": True},
    AVP_CC_REQUEST_NUMBER: {"name": "CC-Request-Number", "type": AvpUnsigned32, "mandatory": True},
    AVP_CC_REQUEST_TYPE: {"name": "CC-Request-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_CC_SERVICE_SPECIFIC_UNITS: {"name": "CC-Service-Specific-Units", "type": AvpUnsigned64, "mandatory": True},
    AVP_CC_SESSION_FAILOVER: {"name": "CC-Session-Failover", "type": AvpEnumerated, "mandatory": True},
    AVP_CC_SUB_SESSION_ID: {"name": "CC-Sub-Session-Id", "type": AvpUnsigned64, "mandatory": True},
    AVP_CC_TIME: {"name": "CC-Time", "type": AvpUnsigned32, "mandatory": True},
    AVP_CC_TOTAL_OCTETS: {"name": "CC-Total-Octets", "type": AvpUnsigned64, "mandatory": True},
    AVP_CHECK_BALANCE_RESULT: {"name": "Check-Balance-Result", "type": AvpEnumerated, "mandatory": True},
    AVP_COST_INFORMATION: {"name": "Cost-Information", "type": AvpGrouped, "mandatory": True},
    AVP_COST_UNIT: {"name": "Cost-Unit", "type": AvpUtf8String, "mandatory": True},
    AVP_CURRENCY_CODE: {"name": "Currency-Code", "type": AvpUnsigned32, "mandatory": True},
    AVP_CREDIT_CONTROL: {"name": "Credit-Control", "type": AvpEnumerated, "mandatory": True},
    AVP_CREDIT_CONTROL_FAILURE_HANDLING: {"name": "Credit-Control-Failure-Handling", "type": AvpEnumerated, "mandatory": True},
    AVP_DIRECT_DEBITING_FAILURE_HANDLING: {"name": "Direct-Debiting-Failure-Handling", "type": AvpEnumerated, "mandatory": True},
    AVP_EXPONENT: {"name": "Exponent", "type": AvpInteger32, "mandatory": True},
    AVP_FINAL_UNIT_INDICATION: {"name": "Final-Unit-Indication", "type": AvpGrouped, "mandatory": True},
    AVP_GRANTED_SERVICE_UNIT: {"name": "Granted-Service-Unit", "type": AvpGrouped, "mandatory": True},
    AVP_RATING_GROUP: {"name": "Rating-Group", "type": AvpUnsigned32, "mandatory": True},
    AVP_REDIRECT_ADDRESS_TYPE: {"name": "Redirect-Address-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_REDIRECT_SERVER: {"name": "Redirect-Server", "type": AvpGrouped, "mandatory": True},
    AVP_REDIRECT_SERVER_ADDRESS: {"name": "Redirect-Server-Address", "type": AvpUtf8String, "mandatory": True},
    AVP_REQUESTED_ACTION: {"name": "Requested-Action", "type": AvpEnumerated, "mandatory": True},
    AVP_REQUESTED_SERVICE_UNIT: {"name": "Requested-Service-Unit", "type": AvpGrouped, "mandatory": True},
    AVP_RESTRICTION_FILTER_RULE: {"name": "Restriction-Filter-Rule", "type": AvpOctetString, "mandatory": True},
    AVP_SERVICE_IDENTIFIER: {"name": "Service-Identifier", "type": AvpUnsigned32, "mandatory": True},
    AVP_SERVICE_PARAMETER_INFO: {"name": "Service-Parameter-Info", "type": AvpGrouped, "mandatory": True},
    AVP_SERVICE_PARAMETER_TYPE: {"name": "Service-Parameter-Type", "type": AvpUnsigned32, "mandatory": True},
    AVP_SERVICE_PARAMETER_VALUE: {"name": "Service-Parameter-Value", "type": AvpOctetString, "mandatory": True},
    AVP_SUBSCRIPTION_ID: {"name": "Subscription-Id", "type": AvpGrouped, "mandatory": True},
    AVP_SUBSCRIPTION_ID_DATA: {"name": "Subscription-Id-Data", "type": AvpUtf8String, "mandatory": True},
    AVP_UNIT_VALUE: {"name": "Unit-Value", "type": AvpGrouped, "mandatory": True},
    AVP_USED_SERVICE_UNIT: {"name": "Used-Service-Unit", "type": AvpGrouped, "mandatory": True},
    AVP_VALUE_DIGITS: {"name": "Value-Digits", "type": AvpInteger64, "mandatory": True},
    AVP_VALIDITY_TIME: {"name": "Validity-Time", "type": AvpUnsigned32, "mandatory": True},
    AVP_FINAL_UNIT_ACTION: {"name": "Final-Unit-Action", "type": AvpEnumerated, "mandatory": True},
    AVP_SUBSCRIPTION_ID_TYPE: {"name": "Subscription-Id-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_TARIFF_TIME_CHANGE: {"name": "Tariff-Time-Change", "type": AvpTime, "mandatory": True},
    AVP_TARIFF_CHANGE_USAGE: {"name": "Tariff-Change-Usage", "type": AvpEnumerated, "mandatory": True},
    AVP_G_S_U_POOL_IDENTIFIER: {"name": "G-S-U-Pool-Identifier", "type": AvpUnsigned32, "mandatory": True},
    AVP_CC_UNIT_TYPE: {"name": "CC-Unit-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_MULTIPLE_SERVICES_INDICATOR: {"name": "Multiple-Services-Indicator", "type": AvpEnumerated, "mandatory": True},
    AVP_MULTIPLE_SERVICES_CREDIT_CONTROL: {"name": "Multiple-Services-Credit-Control", "type": AvpGrouped, "mandatory": True},
    AVP_G_S_U_POOL_REFERENCE: {"name": "G-S-U-Pool-Reference", "type": AvpGrouped, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO: {"name": "User-Equipment-Info", "type": AvpGrouped, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_TYPE: {"name": "User-Equipment-Info-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_USER_EQUIPMENT_INFO_VALUE: {"name": "User-Equipment-Info-Value", "type": AvpOctetString, "mandatory": True},
    AVP_SERVICE_CONTEXT_ID: {"name": "Service-Context-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_REDIRECT_SERVER_EXTENSION: {"name": "Redirect-Server-Extension", "type": AvpGrouped, "mandatory": False},
    AVP_REDIRECT_ADDRESS_IPADDRESS: {"name": "Redirect-Address-IPAddress", "type": AvpAddress, "mandatory": False},
    AVP_REDIRECT_ADDRESS_URL: {"name": "Redirect-Address-URL", "type": AvpUtf8String, "mandatory": False},
    AVP_REDIRECT_ADDRESS_SIP_URI: {"name": "Redirect-Address-SIP-URI", "type": AvpUtf8String, "mandatory": False},
    AVP_QOS_FINAL_UNIT_INDICATION: {"name": "QoS-Final-Unit-Indication", "type": AvpGrouped, "mandatory": False},
    AVP_SIP_ACCOUNTING_INFORMATION: {"name": "SIP-Accounting-Information", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_ACCOUNTING_SERVER_URI: {"name": "SIP-Accounting-Server-URI", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_CREDIT_CONTROL_SERVER_URI: {"name": "SIP-Credit-Control-Server-URI", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_SERVER_URI: {"name": "SIP-Server-URI", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_SERVER_CAPABILITIES: {"name": "SIP-Server-Capabilities", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_MANDATORY_CAPABILITY: {"name": "SIP-Mandatory-Capability", "type": AvpUnsigned32, "mandatory": True},
    AVP_SIP_OPTIONAL_CAPABILITY: {"name": "SIP-Optional-Capability", "type": AvpUnsigned32, "mandatory": True},
    AVP_SIP_SERVER_ASSIGNMENT_TYPE: {"name": "SIP-Server-Assignment-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_SIP_AUTH_DATA_ITEM: {"name": "SIP-Auth-Data-Item", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_AUTHENTICATION_SCHEME: {"name": "SIP-Authentication-Scheme", "type": AvpEnumerated, "mandatory": True},
    AVP_SIP_ITEM_NUMBER: {"name": "SIP-Item-Number", "type": AvpUnsigned32, "mandatory": True},
    AVP_SIP_AUTHENTICATE: {"name": "SIP-Authenticate", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_AUTHORIZATION: {"name": "SIP-Authorization", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_AUTHENTICATION_INFO: {"name": "SIP-Authentication-Info", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_NUMBER_AUTH_ITEMS: {"name": "SIP-Number-Auth-Items", "type": AvpUnsigned32, "mandatory": True},
    AVP_SIP_DEREGISTRATION_REASON: {"name": "SIP-Deregistration-Reason", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_REASON_CODE: {"name": "SIP-Reason-Code", "type": AvpEnumerated, "mandatory": True},
    AVP_SIP_REASON_INFO: {"name": "SIP-Reason-Info", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_VISITED_NETWORK_ID: {"name": "SIP-Visited-Network-Id", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_USER_AUTHORIZATION_TYPE: {"name": "SIP-User-Authorization-Type", "type": AvpEnumerated, "mandatory": True},
    AVP_SIP_SUPPORTED_USER_DATA_TYPE: {"name": "SIP-Supported-User-Data-Type", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_USER_DATA: {"name": "SIP-User-Data", "type": AvpGrouped, "mandatory": True},
    AVP_SIP_USER_DATA_TYPE: {"name": "SIP-User-Data-Type", "type": AvpUtf8String, "mandatory": True},
    AVP_SIP_USER_DATA_CONTENTS: {"name": "SIP-User-Data-Contents", "type": AvpOctetString, "mandatory": True},
    AVP_SIP_USER_DATA_ALREADY_AVAILABLE: {"name": "SIP-User-Data-Already-Available", "type": AvpEnumerated, "mandatory": True},
    AVP_SIP_METHOD: {"name": "SIP-Method", "type": AvpUtf8String, "mandatory": True},
    AVP_MIP6_AGENT_INFO: {"name": "MIP6-Agent-Info", "type": AvpGrouped, "mandatory": True},
    AVP_MIP_CAREOF_ADDRESS: {"name": "MIP-Careof-Address", "type": AvpAddress, "mandatory": True},
    AVP_MIP_AUTHENTICATOR: {"name": "MIP-Authenticator", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_MAC_MOBILITY_DATA: {"name": "MIP-MAC-Mobility-Data", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_TIMESTAMP: {"name": "MIP-Timestamp", "type": AvpOctetString, "mandatory": True},
    AVP_MIP_MN_HA_SPI: {"name": "MIP-MN-HA-SPI", "type": AvpUnsigned32, "mandatory": True},
    AVP_MIP_MN_HA_MSA: {"name": "MIP-MN-HA-MSA", "type": AvpGrouped, "mandatory": True},
    AVP_SERVICE_SELECTION: {"name": "Service-Selection", "type": AvpUtf8String, "mandatory": True},
    AVP_MIP6_AUTH_MODE: {"name": "MIP6-Auth-Mode", "type": AvpEnumerated, "mandatory": True},
    AVP_PMIP6_DHCP_SERVER_ADDRESS: {"name": "PMIP6-DHCP-Server-Address", "type": AvpAddress},
    AVP_PMIP6_IPV4_HOME_ADDRESS: {"name": "PMIP6-IPv4-Home-Address", "type": AvpAddress},
    AVP_MOBILE_NODE_IDENTIFIER: {"name": "Mobile-Node-Identifier", "type": AvpUtf8String},
    AVP_SERVICE_CONFIGURATION: {"name": "Service-Configuration", "type": AvpGrouped},
    AVP_NONE_S_CSCF_NAME_ORIGINATING: {"name": "S-CSCF-Name-Originating", "type": AvpOctetString, "mandatory": True},
    AVP_NONE_S_CSCF_NAME_TERMINATING: {"name": "S-CSCF-Name-Terminating", "type": AvpOctetString, "mandatory": True},
    AVP_NONE_SIP_SERVER_NAME: {"name": "SIP-Server-Name", "type": AvpOctetString, "mandatory": True}}

# vendor specific
AVP_VENDOR_DICTIONARY = {}
AVP_VENDOR_DICTIONARY[0] = {}
AVP_VENDOR_DICTIONARY[61] = {}
AVP_VENDOR_DICTIONARY[429] = {}
AVP_VENDOR_DICTIONARY[1751] = {}
AVP_VENDOR_DICTIONARY[2937] = {}
AVP_VENDOR_DICTIONARY[3830] = {}
AVP_VENDOR_DICTIONARY[5806] = {}

AVP_VENDOR_DICTIONARY[10415] = {
    AVP_TGPP_GBA_USERSECSETTINGS: {"name": "GBA-UserSecSettings", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_TRANSACTION_IDENTIFIER: {"name": "Transaction-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_NAF_HOSTNAME: {"name": "NAF-Hostname", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_GAA_SERVICE_IDENTIFIER: {"name": "GAA-Service-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_KEY_EXPIRYTIME: {"name": "Key-ExpiryTime", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_ME_KEY_MATERIAL: {"name": "ME-Key-Material", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_UICC_KEY_MATERIAL: {"name": "UICC-Key-Material", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_GBA_U_AWARENESS_INDICATOR: {"name": "GBA_U-Awareness-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_BOOTSTRAPINFOCREATIONTIME: {"name": "BootstrapInfoCreationTime", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_GUSS_TIMESTAMP: {"name": "GUSS-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_GBA_TYPE: {"name": "GBA-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_UE_ID: {"name": "UE-Id", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_UE_ID_TYPE: {"name": "UE-Id-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_UICC_APP_LABEL: {"name": "UICC-App-Label", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_UICC_ME: {"name": "UICC-ME", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_REQUESTED_KEY_LIFETIME: {"name": "Requested-Key-Lifetime", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_PRIVATE_IDENTITY_REQUEST: {"name": "Private-Identity-Request", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_GBA_PUSH_INFO: {"name": "GBA-Push-Info", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_NAF_SA_IDENTIFIER: {"name": "NAF-SA-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SECURITY_FEATURE_REQUEST: {"name": "Security-Feature-Request", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SECURITY_FEATURE_RESPONSE: {"name": "Security-Feature-Response", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_CALLEE_INFORMATION: {"name": "Callee-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_EVENT_TYPE: {"name": "Event-Type", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_METHOD: {"name": "3GPP-SIP-Method", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT: {"name": "Event", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTENT_TYPE: {"name": "Content-Type", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTENT_LENGTH: {"name": "Content-Length", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTENT_DISPOSITION: {"name": "Content-Disposition", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROLE_OF_NODE: {"name": "Role-Of-Node", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_SESSION_ID: {"name": "User-Session-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALLING_PARTY_ADDRESS: {"name": "Calling-Party-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALLED_PARTY_ADDRESS: {"name": "Called-Party-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TIME_STAMPS: {"name": "Time-Stamps", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIP_REQUEST_TIMESTAMP: {"name": "SIP-Request-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIP_RESPONSE_TIMESTAMP: {"name": "SIP-Response-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_SERVER: {"name": "Application-Server", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_PROVIDED_CALLED_PARTY_ADDRESS: {"name": "Application-Provided-Called-Party-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INTER_OPERATOR_IDENTIFIER: {"name": "Inter-Operator-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGINATING_IOI: {"name": "Originating-IOI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TERMINATING_IOI: {"name": "Terminating-IOI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_CHARGING_IDENTIFIER: {"name": "IMS-Charging-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_EMERGENCY_INDICATOR: {"name": "IMS-Emergency-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_CHARGED_PARTY: {"name": "MBMS-Charged-Party", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SDP_SESSION_DESCRIPTION: {"name": "SDP-Session-Description", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SDP_MEDIA_COMPONENT: {"name": "SDP-Media-Component", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SDP_MEDIA_NAME: {"name": "SDP-Media-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SDP_MEDIA_DESCRIPTION: {"name": "SDP-Media-Description", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CG_ADDRESS: {"name": "CG-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GGSN_ADDRESS: {"name": "GGSN-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVED_PARTY_IP_ADDRESS: {"name": "Served-Party-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHORISED_QOS: {"name": "Authorised-QoS", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_SERVER_INFORMATION: {"name": "Application-Server-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRUNK_GROUP_ID: {"name": "Trunk-Group-ID", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INCOMING_TRUNK_GROUP_ID: {"name": "Incoming-Trunk-Group-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OUTGOING_TRUNK_GROUP_ID: {"name": "Outgoing-Trunk-Group-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_SERVICE: {"name": "Bearer-Service", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_ID: {"name": "Service-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSOCIATED_URI: {"name": "Associated-URI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGED_PARTY: {"name": "Charged-Party", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POC_CONTROLLING_ADDRESS: {"name": "PoC-Controlling-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POC_GROUP_NAME: {"name": "PoC-Group-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CAUSE: {"name": "Cause", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CAUSE_CODE: {"name": "Cause-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NODE_FUNCTIONALITY: {"name": "Node-Functionality", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_SPECIFIC_DATA: {"name": "Service-Specific-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGINATOR: {"name": "Originator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PS_FURNISH_CHARGING_INFORMATION: {"name": "PS-Furnish-Charging-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PS_FREE_FORMAT_DATA: {"name": "PS-Free-Format-Data", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PS_APPEND_FREE_FORMAT_DATA: {"name": "PS-Append-Free-Format-Data", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TIME_QUOTA_THRESHOLD: {"name": "Time-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VOLUME_QUOTA_THRESHOLD: {"name": "Volume-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRIGGER_TYPE: {"name": "Trigger-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QUOTA_HOLDING_TIME: {"name": "Quota-Holding-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_REPORTING_REASON: {"name": "3GPP-Reporting-Reason", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_INFORMATION: {"name": "Service-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PS_INFORMATION: {"name": "PS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_INFORMATION: {"name": "WLAN-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_INFORMATION: {"name": "IMS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MMS_INFORMATION: {"name": "MMS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_INFORMATION: {"name": "LCS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POC_INFORMATION: {"name": "PoC-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_INFORMATION: {"name": "MBMS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QUOTA_CONSUMPTION_TIME: {"name": "Quota-Consumption-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_INITIATOR_FLAG: {"name": "Media-Initiator-Flag", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POC_SERVER_ROLE: {"name": "PoC-Server-Role", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POC_SESSION_TYPE: {"name": "PoC-Session-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_PARTICIPANTS: {"name": "Number-Of-Participants", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGINATOR_ADDRESS: {"name": "Originator-Address", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PARTICIPANTS_INVOLVED: {"name": "Participants-Involved", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXPIRES: {"name": "Expires", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MESSAGE_BODY: {"name": "Message-Body", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WAG_ADDRESS: {"name": "WAG-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WAG_PLMN_ID: {"name": "WAG-PLMN-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_RADIO_CONTAINER: {"name": "WLAN-Radio-Container", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_TECHNOLOGY: {"name": "WLAN-Technology", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_UE_LOCAL_IPADDRESS: {"name": "WLAN-UE-Local-IPAddress", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDG_ADDRESS: {"name": "PDG-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDG_CHARGING_ID: {"name": "PDG-Charging-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDRESS_DATA: {"name": "Address-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDRESS_DOMAIN: {"name": "Address-Domain", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDRESS_TYPE: {"name": "Address-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_USAGE: {"name": "Bearer-Usage", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_INSTALL: {"name": "Charging-Rule-Install", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_REMOVE: {"name": "Charging-Rule-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_DEFINITION: {"name": "Charging-Rule-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_BASE_NAME: {"name": "Charging-Rule-Base-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_NAME: {"name": "Charging-Rule-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT_TRIGGER: {"name": "Event-Trigger", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_METERING_METHOD: {"name": "Metering-Method", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OFFLINE: {"name": "Offline", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ONLINE: {"name": "Online", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRECEDENCE: {"name": "Precedence", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORTING_LEVEL: {"name": "Reporting-Level", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TFT_FILTER: {"name": "TFT-Filter", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TFT_PACKET_FILTER_INFORMATION: {"name": "TFT-Packet-Filter-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TOS_TRAFFIC_CLASS: {"name": "ToS-Traffic-Class", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDP_SESSION_OPERATION: {"name": "PDP-Session-operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_INFORMATION: {"name": "QoS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_RULE_REPORT: {"name": "Charging-Rule-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PCC_RULE_STATUS: {"name": "PCC-Rule-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_IDENTIFIER: {"name": "Bearer-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_OPERATION: {"name": "Bearer-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_CHARGING_IDENTIFIER_GX: {"name": "Access-Network-Charging-Identifier-Gx", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_CONTROL_MODE: {"name": "Bearer-Control-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NETWORK_REQUEST_SUPPORT: {"name": "Network-Request-Support", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GUARANTEED_BITRATE_DL: {"name": "Guaranteed-Bitrate-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GUARANTEED_BITRATE_UL: {"name": "Guaranteed-Bitrate-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_CAN_TYPE: {"name": "IP-CAN-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_CLASS_IDENTIFIER: {"name": "QoS-Class-Identifier", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_NEGOTIATION: {"name": "QoS-Negotiation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_UPGRADE: {"name": "QoS-Upgrade", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RULE_FAILURE_CODE: {"name": "Rule-Failure-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAT_TYPE: {"name": "RAT-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT_REPORT_INDICATION: {"name": "Event-Report-Indication", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALLOCATION_RETENTION_PRIORITY: {"name": "Allocation-Retention-Priority", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COA_IP_ADDRESS: {"name": "CoA-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TUNNEL_HEADER_FILTER: {"name": "Tunnel-Header-Filter", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TUNNEL_HEADER_LENGTH: {"name": "Tunnel-Header-Length", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TUNNEL_INFORMATION: {"name": "Tunnel-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COA_INFORMATION: {"name": "CoA-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_AGGREGATE_MAX_BITRATE_DL: {"name": "APN-Aggregate-Max-Bitrate-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_AGGREGATE_MAX_BITRATE_UL: {"name": "APN-Aggregate-Max-Bitrate-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REVALIDATION_TIME: {"name": "Revalidation-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RULE_ACTIVATION_TIME: {"name": "Rule-Activation-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RULE_DEACTIVATION_TIME: {"name": "Rule-Deactivation-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SESSION_RELEASE_CAUSE: {"name": "Session-Release-Cause", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIORITY_LEVEL: {"name": "Priority-Level", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRE_EMPTION_CAPABILITY: {"name": "Pre-emption-Capability", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRE_EMPTION_VULNERABILITY: {"name": "Pre-emption-Vulnerability", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEFAULT_EPS_BEARER_QOS: {"name": "Default-EPS-Bearer-QoS", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AN_GW_ADDRESS: {"name": "AN-GW-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_INSTALL: {"name": "QoS-Rule-Install", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_REMOVE: {"name": "QoS-Rule-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_DEFINITION: {"name": "QoS-Rule-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_NAME: {"name": "QoS-Rule-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_REPORT: {"name": "QoS-Rule-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SECURITY_PARAMETER_INDEX: {"name": "Security-Parameter-Index", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_LABEL: {"name": "Flow-Label", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_INFORMATION: {"name": "Flow-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PACKET_FILTER_CONTENT: {"name": "Packet-Filter-Content", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PACKET_FILTER_IDENTIFIER: {"name": "Packet-Filter-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PACKET_FILTER_INFORMATION: {"name": "Packet-Filter-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PACKET_FILTER_OPERATION: {"name": "Packet-Filter-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RESOURCE_ALLOCATION_NOTIFICATION: {"name": "Resource-Allocation-Notification", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SESSION_LINKING_INDICATOR: {"name": "Session-Linking-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTION_ID: {"name": "PDN-Connection-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_KEY: {"name": "Monitoring-Key", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USAGE_MONITORING_INFORMATION: {"name": "Usage-Monitoring-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USAGE_MONITORING_LEVEL: {"name": "Usage-Monitoring-Level", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USAGE_MONITORING_REPORT: {"name": "Usage-Monitoring-Report", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USAGE_MONITORING_SUPPORT: {"name": "Usage-Monitoring-Support", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CSG_INFORMATION_REPORTING: {"name": "CSG-Information-Reporting", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PACKET_FILTER_USAGE: {"name": "Packet-Filter-Usage", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_CORRELATION_INDICATOR: {"name": "Charging-Correlation-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_RULE_BASE_NAME: {"name": "QoS-Rule-Base-Name", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_REMOVE: {"name": "Routing-Rule-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_DEFINITION: {"name": "Routing-Rule-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_IDENTIFIER: {"name": "Routing-Rule-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_ROUTING_FILTER: {"name": "Routing-Filter", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_IP_ADDRESS: {"name": "Routing-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_DIRECTION: {"name": "Flow-Direction", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_INSTALL: {"name": "Routing-Rule-Install", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CREDIT_MANAGEMENT_STATUS: {"name": "Credit-Management-Status", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REDIRECT_INFORMATION: {"name": "Redirect-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REDIRECT_SUPPORT: {"name": "Redirect-Support", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDF_INFORMATION: {"name": "TDF-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDF_APPLICATION_IDENTIFIER: {"name": "TDF-Application-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDF_DESTINATION_HOST: {"name": "TDF-Destination-Host", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDF_DESTINATION_REALM: {"name": "TDF-Destination-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDF_IP_ADDRESS: {"name": "TDF-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_INSTALL: {"name": "ADC-Rule-Install", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_REMOVE: {"name": "ADC-Rule-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_DEFINITION: {"name": "ADC-Rule-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_BASE_NAME: {"name": "ADC-Rule-Base-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_NAME: {"name": "ADC-Rule-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADC_RULE_REPORT: {"name": "ADC-Rule-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_DETECTION_INFORMATION: {"name": "Application-Detection-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PS_TO_CS_SESSION_CONTINUITY: {"name": "PS-to-CS-Session-Continuity", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVED_USER_IDENTITY: {"name": "Served-User-Identity", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_VASP_ID: {"name": "VASP-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_VAS_ID: {"name": "VAS-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_TRIGGER_EVENT: {"name": "Trigger-Event", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SENDER_ADDRESS: {"name": "Sender-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_INITIAL_RECIPIENT_ADDRESS: {"name": "Initial-Recipient-Address", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RESULT_RECIPIENT_ADDRESS: {"name": "Result-Recipient-Address", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_MM10_SEQUENCE_NUMBER: {"name": "MM10-Sequence-Number", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_MM10_RECIPIENT_ADDRESS: {"name": "MM10-Recipient-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_ROUTEING_ADDRESS: {"name": "Routeing-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_ORIGINATING_INTERFACE: {"name": "Originating-Interface", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_DELIVERY_REPORT: {"name": "Delivery-Report", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_READ_REPLY: {"name": "Read-Reply", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SENDER_VISIBILITY: {"name": "Sender-Visibility", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SERVICE_KEY: {"name": "Service-Key", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_BILLING_INFORMATION: {"name": "Billing-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_STATUS: {"name": "Status", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_STATUS_CODE: {"name": "Status-Code", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_STATUS_TEXT: {"name": "Status-Text", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_ROUTEING_ADDRESS_RESOLUTION: {"name": "Routeing-Address-Resolution", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_DOMAIN_NAME: {"name": "Domain-Name", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_RECIPIENT_ADDRESS: {"name": "Recipient-Address", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SUBMISSION_TIME: {"name": "Submission-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_MM_CONTENT_TYPE: {"name": "MM-Content-Type", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TYPE_NUMBER: {"name": "Type-Number", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_TYPE_INFORMATION: {"name": "Additional-Type-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_CONTENT_SIZE: {"name": "Content-Size", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_CONTENT_INFORMATION: {"name": "Additional-Content-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_ADDRESSEE_TYPE: {"name": "Addressee-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PRIORITY: {"name": "Priority", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MESSAGE_ID: {"name": "Message-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_MESSAGE_TYPE: {"name": "Message-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MESSAGE_SIZE: {"name": "Message-Size", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_MESSAGE_CLASS: {"name": "Message-Class", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_CLASS_IDENTIFIER: {"name": "Class-Identifier", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_TOKEN_TEXT: {"name": "Token-Text", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_DELIVERY_REPORT_REQUESTED: {"name": "Delivery-Report-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ADAPTATIONS: {"name": "Adaptations", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_APPLIC_ID: {"name": "Applic-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_AUX_APPLIC_INFO: {"name": "Aux-Applic-Info", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_CONTENT_CLASS: {"name": "Content-Class", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_DRM_CONTENT: {"name": "DRM-Content", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_READ_REPLY_REPORT_REQUESTED: {"name": "Read-Reply-Report-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_REPLY_APPLIC_ID: {"name": "Reply-Applic-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_FILE_REPAIR_SUPPORTED: {"name": "File-Repair-Supported", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_USER_SERVICE_TYPE: {"name": "MBMS-User-Service-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_UNIT_QUOTA_THRESHOLD: {"name": "Unit-Quota-Threshold", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_PDP_ADDRESS: {"name": "PDP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_SGSN_ADDRESS: {"name": "SGSN-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_POC_SESSION_ID: {"name": "PoC-Session-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEFERRED_LOCATION_EVENT_TYPE: {"name": "Deferred-Location-Event-Type", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_APN: {"name": "LCS-APN", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_CLIENT_ID: {"name": "LCS-Client-ID", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_CLIENT_DIALED_BY_MS: {"name": "LCS-Client-Dialed-By-MS", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_CLIENT_EXTERNAL_ID: {"name": "LCS-Client-External-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_CLIENT_NAME: {"name": "LCS-Client-Name", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_DATA_CODING_SCHEME: {"name": "LCS-Data-Coding-Scheme", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_FORMAT_INDICATOR: {"name": "LCS-Format-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_NAME_STRING: {"name": "LCS-Name-String", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_REQUESTOR_ID: {"name": "LCS-Requestor-ID", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_REQUESTOR_ID_STRING: {"name": "LCS-Requestor-ID-String", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_CLIENT_TYPE: {"name": "LCS-Client-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_ESTIMATE: {"name": "Location-Estimate", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_ESTIMATE_TYPE: {"name": "Location-Estimate-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_TYPE: {"name": "Location-Type", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POSITIONING_DATA: {"name": "Positioning-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_SESSION_ID: {"name": "WLAN-Session-Id", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_PDP_CONTEXT_TYPE: {"name": "PDP-Context-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MMBOX_STORAGE_REQUESTED: {"name": "MMBox-Storage-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SERVICE_SPECIFIC_INFO: {"name": "Service-Specific-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_CALLED_ASSERTED_IDENTITY: {"name": "Called-Asserted-Identity", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_REQUESTED_PARTY_ADDRESS: {"name": "Requested-Party-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_POC_USER_ROLE: {"name": "PoC-User-Role", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_POC_USER_ROLE_IDS: {"name": "PoC-User-Role-IDs", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_POC_USER_ROLE_INFO_UNITS: {"name": "PoC-User-Role-info-Units", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_TALK_BURST_EXCHANGE: {"name": "Talk-Burst-Exchange", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SERVICE_GENERIC_INFORMATION: {"name": "Service-Generic-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SERVICE_SPECIFIC_TYPE: {"name": "Service-Specific-Type", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_EVENT_CHARGING_TIMESTAMP: {"name": "Event-Charging-TimeStamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_PARTICIPANT_ACCESS_PRIORITY: {"name": "Participant-Access-Priority", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PARTICIPANT_GROUP: {"name": "Participant-Group", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_POC_CHANGE_CONDITION: {"name": "PoC-Change-Condition", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_POC_CHANGE_TIME: {"name": "PoC-Change-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_INFORMATION: {"name": "Access-Network-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_TRIGGER: {"name": "Trigger", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_BASE_TIME_INTERVAL: {"name": "Base-Time-Interval", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ENVELOPE: {"name": "Envelope", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_ENVELOPE_END_TIME: {"name": "Envelope-End-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_ENVELOPE_REPORTING: {"name": "Envelope-Reporting", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ENVELOPE_START_TIME: {"name": "Envelope-Start-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_TIME_QUOTA_MECHANISM: {"name": "Time-Quota-Mechanism", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TIME_QUOTA_TYPE: {"name": "Time-Quota-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_EARLY_MEDIA_DESCRIPTION: {"name": "Early-Media-Description", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SDP_TIMESTAMPS: {"name": "SDP-TimeStamps", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SDP_OFFER_TIMESTAMP: {"name": "SDP-Offer-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_SDP_ANSWER_TIMESTAMP: {"name": "SDP-Answer-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_AF_CORRELATION_INFORMATION: {"name": "AF-Correlation-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_POC_SESSION_INITIATION_TYPE: {"name": "PoC-Session-Initiation-type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_OFFLINE_CHARGING: {"name": "Offline-Charging", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_USER_PARTICIPATING_TYPE: {"name": "User-Participating-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ALTERNATE_CHARGED_PARTY_ADDRESS: {"name": "Alternate-Charged-Party-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_IMS_COMMUNICATION_SERVICE_IDENTIFIER: {"name": "IMS-Communication-Service-Identifier", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_RECEIVED_TALK_BURSTS: {"name": "Number-Of-Received-Talk-Bursts", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_TALK_BURSTS: {"name": "Number-Of-Talk-Bursts", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_RECEIVED_TALK_BURST_TIME: {"name": "Received-Talk-Burst-Time", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_RECEIVED_TALK_BURST_VOLUME: {"name": "Received-Talk-Burst-Volume", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_TALK_BURST_TIME: {"name": "Talk-Burst-Time", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_TALK_BURST_VOLUME: {"name": "Talk-Burst-Volume", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_MEDIA_INITIATOR_PARTY: {"name": "Media-Initiator-Party", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_PC5_RADIO_TECHNOLOGY: {"name": "PC5-Radio-Technology", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_RAN_END_TIMESTAMP: {"name": "RAN-End-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_RAN_SECONDARY_RAT_USAGE_REPORT: {"name": "RAN-Secondary-RAT-Usage-Report", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RAN_START_TIMESTAMP: {"name": "RAN-Start-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_SECONDARY_RAT_TYPE: {"name": "Secondary-RAT-Type", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_CIVIC_ADDRESS_INFORMATION: {"name": "Civic-Address-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_WLAN_OPERATOR_ID: {"name": "WLAN-Operator-Id", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_WLAN_OPERATOR_NAME: {"name": "WLAN-Operator-Name", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_WLAN_PLMN_ID: {"name": "WLAN-PLMN-Id", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_API_CONTENT: {"name": "API-Content", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_API_DIRECTION: {"name": "API-Direction", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_API_IDENTIFIER: {"name": "API-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_API_INVOCATION_TIMESTAMP: {"name": "API-Invocation-Timestamp", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_API_RESULT_CODE: {"name": "API-Result-Code", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_API_SIZE: {"name": "API-Size", "type": AvpUnsigned64, "vendor": 10415},
    AVP_TGPP_VOLTE_INFORMATION: {"name": "VoLTE-Information ", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SUBSCRIPTION_DATA: {"name": "Subscription-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TERMINAL_INFORMATION: {"name": "Terminal-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMEI: {"name": "IMEI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SOFTWARE_VERSION: {"name": "Software-Version", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QOS_SUBSCRIBED: {"name": "QoS-Subscribed", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ULR_FLAGS: {"name": "ULR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ULA_FLAGS: {"name": "ULA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VISITED_PLMN_ID: {"name": "Visited-PLMN-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_EUTRAN_AUTHENTICATION_INFO: {"name": "Requested-EUTRAN-Authentication-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_UTRAN_GERAN_AUTHENTICATION_INFO: {"name": "Requested-UTRAN-GERAN-Authentication-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_REQUESTED_VECTORS: {"name": "Number-Of-Requested-Vectors", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RE_SYNCHRONIZATION_INFO: {"name": "Re-Synchronization-Info", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMMEDIATE_RESPONSE_PREFERRED: {"name": "Immediate-Response-Preferred", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHENTICATION_INFO: {"name": "Authentication-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_E_UTRAN_VECTOR: {"name": "E-UTRAN-Vector", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UTRAN_VECTOR: {"name": "UTRAN-Vector", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GERAN_VECTOR: {"name": "GERAN-Vector", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NETWORK_ACCESS_MODE: {"name": "Network-Access-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_HPLMN_ODB: {"name": "HPLMN-ODB", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ITEM_NUMBER: {"name": "Item-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CANCELLATION_TYPE: {"name": "Cancellation-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DSR_FLAGS: {"name": "DSR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DSA_FLAGS: {"name": "DSA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTEXT_IDENTIFIER: {"name": "Context-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIBER_STATUS: {"name": "Subscriber-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OPERATOR_DETERMINED_BARRING: {"name": "Operator-Determined-Barring", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_RESTRICTION_DATA: {"name": "Access-Restriction-Data", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_OI_REPLACEMENT: {"name": "APN-OI-Replacement", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALL_APN_CONFIGURATIONS_INCLUDED_INDICATOR: {"name": "All-APN-Configurations-Included-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_CONFIGURATION_PROFILE: {"name": "APN-Configuration-Profile", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_CONFIGURATION: {"name": "APN-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EPS_SUBSCRIBED_QOS_PROFILE: {"name": "EPS-Subscribed-QoS-Profile", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VPLMN_DYNAMIC_ADDRESS_ALLOWED: {"name": "VPLMN-Dynamic-Address-Allowed", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_STN_SR: {"name": "STN-SR", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALERT_REASON: {"name": "Alert-Reason", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AMBR: {"name": "AMBR", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CSG_SUBSCRIPTION_DATA: {"name": "CSG-Subscription-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CSG_ID: {"name": "CSG-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_GW_ALLOCATION_TYPE: {"name": "PDN-GW-Allocation-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXPIRATION_DATE: {"name": "Expiration-Date", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAT_FREQUENCY_SELECTION_PRIORITY_ID: {"name": "RAT-Frequency-Selection-Priority-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDA_FLAGS: {"name": "IDA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PUA_FLAGS: {"name": "PUA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NOR_FLAGS: {"name": "NOR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_ID: {"name": "User-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EQUIPMENT_STATUS: {"name": "Equipment-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REGIONAL_SUBSCRIPTION_ZONE_CODE: {"name": "Regional-Subscription-Zone-Code", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAND: {"name": "RAND", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_XRES: {"name": "XRES", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTN: {"name": "AUTN", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_KASME: {"name": "KASME", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_COLLECTION_ENTITY: {"name": "Trace-Collection-Entity", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_KC: {"name": "Kc", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SRES: {"name": "SRES", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTING_NODE_TYPE: {"name": "Requesting-Node-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_TYPE: {"name": "PDN-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROAMING_RESTRICTED_DUE_TO_UNSUPPORTED_FEATURE: {"name": "Roaming-Restricted-Due-To-Unsupported-Feature", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_DATA: {"name": "Trace-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_REFERENCE: {"name": "Trace-Reference", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_DEPTH: {"name": "Trace-Depth", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_NE_TYPE_LIST: {"name": "Trace-NE-Type-List", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_INTERFACE_LIST: {"name": "Trace-Interface-List", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_EVENT_LIST: {"name": "Trace-Event-List", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OMC_ID: {"name": "OMC-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GPRS_SUBSCRIPTION_DATA: {"name": "GPRS-Subscription-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COMPLETE_DATA_LIST_INCLUDED_INDICATOR: {"name": "Complete-Data-List-Included-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDP_CONTEXT: {"name": "PDP-Context", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDP_TYPE: {"name": "PDP-Type", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP2_MEID: {"name": "3GPP2-MEID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SPECIFIC_APN_INFO: {"name": "Specific-APN-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_INFO: {"name": "LCS-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GMLC_NUMBER: {"name": "GMLC-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LCS_PRIVACYEXCEPTION: {"name": "LCS-PrivacyException", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SS_CODE: {"name": "SS-Code", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SS_STATUS: {"name": "SS-Status", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NOTIFICATION_TO_UE_USER: {"name": "Notification-To-UE-User", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTERNAL_CLIENT: {"name": "External-Client", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CLIENT_IDENTITY: {"name": "Client-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GMLC_RESTRICTION: {"name": "GMLC-Restriction", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PLMN_CLIENT: {"name": "PLMN-Client", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SERVICE_TYPE: {"name": "3GPP-Service-Type", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICETYPEIDENTITY: {"name": "ServiceTypeIdentity", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MO_LR: {"name": "MO-LR", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TELESERVICE_LIST: {"name": "Teleservice-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TS_CODE: {"name": "TS-Code", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALL_BARRING_INFOR_LIST: {"name": "Call-Barring-Infor-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGSN_NUMBER: {"name": "SGSN-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDR_FLAGS: {"name": "IDR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ICS_INDICATOR: {"name": "ICS-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_VOICE_OVER_PS_SESSIONS_SUPPORTED: {"name": "IMS-Voice-Over-PS-Sessions-Supported", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_HOMOGENEOUS_SUPPORT_OF_IMS_VOICE_OVER_PS_SESSIONS: {"name": "Homogeneous-Support-of-IMS-Voice-Over-PS-Sessions", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LAST_UE_ACTIVITY_TIME: {"name": "Last-UE-Activity-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EPS_USER_STATE: {"name": "EPS-User-State", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EPS_LOCATION_INFORMATION: {"name": "EPS-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MME_USER_STATE: {"name": "MME-User-State", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGSN_USER_STATE: {"name": "SGSN-User-State", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_STATE: {"name": "User-State", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_NON_3GPP_USER_DATA: {"name": "Non-3GPP-User-Data", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_NON_3GPP_IP_ACCESS: {"name": "Non-3GPP-IP-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NON_3GPP_IP_ACCESS_APN: {"name": "Non-3GPP-IP-Access-APN", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AN_TRUSTED: {"name": "AN-Trusted", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANID: {"name": "ANID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACE_INFO: {"name": "Trace-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_MIP_FA_RK: {"name": "MIP-FA-RK", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIP_FA_RK_SPI: {"name": "MIP-FA-RK-SPI", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PPR_FLAGS: {"name": "PPR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_IDENTIFIER: {"name": "WLAN-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_ACCESS_INFO: {"name": "TWAN-Access-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_AUTHORIZATION_FLAGS: {"name": "Access-Authorization-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_DEFAULT_APN_CONTEXT_ID: {"name": "TWAN-Default-APN-Context-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FULL_NETWORK_NAME: {"name": "Full-Network-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SHORT_NETWORK_NAME: {"name": "Short-Network-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AAA_FAILURE_INDICATION: {"name": "AAA-Failure-Indication", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRANSPORT_ACCESS_TYPE: {"name": "Transport-Access-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DER_FLAGS: {"name": "DER-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEA_FLAGS: {"name": "DEA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAR_FLAGS: {"name": "RAR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DER_S6B_FLAGS: {"name": "DER-S6b-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SSID: {"name": "SSID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_HESSID: {"name": "HESSID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_INFO: {"name": "Access-Network-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_CONNECTION_MODE: {"name": "TWAN-Connection-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_CONNECTIVITY_PARAMETERS: {"name": "TWAN-Connectivity-Parameters", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONNECTIVITY_FLAGS: {"name": "Connectivity-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_PCO: {"name": "TWAN-PCO", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAG_CP_ADDRESS: {"name": "TWAG-CP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAG_UP_ADDRESS: {"name": "TWAG-UP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_S2A_FAILURE_CAUSE: {"name": "TWAN-S2a-Failure-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_BACK_OFF_TIMER: {"name": "SM-Back-Off-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLCP_KEY: {"name": "WLCP-Key", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGINATION_TIME_STAMP: {"name": "Origination-Time-Stamp", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_WAIT_TIME: {"name": "Maximum-Wait-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EMERGENCY_SERVICES: {"name": "Emergency-Services", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AAR_FLAGS: {"name": "AAR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMEI_CHECK_IN_VPLMN_RESULT: {"name": "IMEI-Check-In-VPLMN-Result", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ERP_AUTHORIZATION: {"name": "ERP-Authorization", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MME_LOCATION_INFORMATION: {"name": "MME-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGSN_LOCATION_INFORMATION: {"name": "SGSN-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_E_UTRAN_CELL_GLOBAL_IDENTITY: {"name": "E-UTRAN-Cell-Global-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRACKING_AREA_IDENTITY: {"name": "Tracking-Area-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CELL_GLOBAL_IDENTITY: {"name": "Cell-Global-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_AREA_IDENTITY: {"name": "Routing-Area-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_AREA_IDENTITY: {"name": "Location-Area-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_AREA_IDENTITY: {"name": "Service-Area-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GEOGRAPHICAL_INFORMATION: {"name": "Geographical-Information", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GEODETIC_INFORMATION: {"name": "Geodetic-Information", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CURRENT_LOCATION_RETRIEVED: {"name": "Current-Location-Retrieved", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AGE_OF_LOCATION_INFORMATION: {"name": "Age-Of-Location-Information", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACTIVE_APN: {"name": "Active-APN", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIPTO_PERMISSION: {"name": "SIPTO-Permission", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ERROR_DIAGNOSTIC: {"name": "Error-Diagnostic", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_SRVCC_CAPABILITY: {"name": "UE-SRVCC-Capability", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MPS_PRIORITY: {"name": "MPS-Priority", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VPLMN_LIPA_ALLOWED: {"name": "VPLMN-LIPA-Allowed", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LIPA_PERMISSION: {"name": "LIPA-Permission", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIBED_PERIODIC_RAU_TAU_TIMER: {"name": "Subscribed-Periodic-RAU-TAU-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXT_PDP_TYPE: {"name": "Ext-PDP-Type", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXT_PDP_ADDRESS: {"name": "Ext-PDP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MDT_CONFIGURATION: {"name": "MDT-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_JOB_TYPE: {"name": "Job-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AREA_SCOPE: {"name": "Area-Scope", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LIST_OF_MEASUREMENTS: {"name": "List-Of-Measurements", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORTING_TRIGGER: {"name": "Reporting-Trigger", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORT_INTERVAL: {"name": "Report-Interval", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORT_AMOUNT: {"name": "Report-Amount", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT_THRESHOLD_RSRP: {"name": "Event-Threshold-RSRP", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT_THRESHOLD_RSRQ: {"name": "Event-Threshold-RSRQ", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOGGING_INTERVAL: {"name": "Logging-Interval", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOGGING_DURATION: {"name": "Logging-Duration", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELAY_NODE_INDICATOR: {"name": "Relay-Node-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MDT_USER_CONSENT: {"name": "MDT-User-Consent", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PUR_FLAGS: {"name": "PUR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIBED_VSRVCC: {"name": "Subscribed-VSRVCC", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EQUIVALENT_PLMN_LIST: {"name": "Equivalent-PLMN-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CLR_FLAGS: {"name": "CLR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UVR_FLAGS: {"name": "UVR-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_UVA_FLAGS: {"name": "UVA-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_VPLMN_CSG_SUBSCRIPTION_DATA: {"name": "VPLMN-CSG-Subscription-Data", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TIME_ZONE: {"name": "Time-Zone", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_A_MSISDN: {"name": "A-MSISDN", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MME_NUMBER_FOR_MT_SMS: {"name": "MME-Number-for-MT-SMS", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SMS_REGISTER_REQUEST: {"name": "SMS-Register-Request", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_LOCAL_TIME_ZONE: {"name": "Local-Time-Zone", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_DAYLIGHT_SAVING_TIME: {"name": "Daylight-Saving-Time", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SUBSCRIPTION_DATA_FLAGS: {"name": "Subscription-Data-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_MEASUREMENT_PERIOD_LTE: {"name": "Measurement-Period-LTE", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MEASUREMENT_PERIOD_UMTS: {"name": "Measurement-Period-UMTS", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_COLLECTION_PERIOD_RRM_LTE: {"name": "Collection-Period-RRM-LTE", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_COLLECTION_PERIOD_RRM_UMTS: {"name": "Collection-Period-RRM-UMTS", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_POSITIONING_METHOD: {"name": "Positioning-Method", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MEASUREMENT_QUANTITY: {"name": "Measurement-Quantity", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_EVENT_THRESHOLD_EVENT_1F: {"name": "Event-Threshold-Event-1F", "type": AvpInteger32, "vendor": 10415},
    AVP_TGPP_EVENT_THRESHOLD_EVENT_1I: {"name": "Event-Threshold-Event-1I", "type": AvpInteger32, "vendor": 10415},
    AVP_TGPP_RESTORATION_PRIORITY: {"name": "Restoration-Priority", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_SGS_MME_IDENTITY: {"name": "SGs-MME-Identity", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_SIPTO_LOCAL_NETWORK_PERMISSION: {"name": "SIPTO-Local-Network-Permission", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_COUPLED_NODE_DIAMETER_ID: {"name": "Coupled-Node-Diameter-ID", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_WLAN_OFFLOADABILITY: {"name": "WLAN-offloadability", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_WLAN_OFFLOADABILITY_EUTRAN: {"name": "WLAN-offloadability-EUTRAN", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_WLAN_OFFLOADABILITY_UTRAN: {"name": "WLAN-offloadability-UTRAN", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_RESET_ID: {"name": "Reset-ID", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MDT_ALLOWED_PLMN_ID: {"name": "MDT-Allowed-PLMN-Id", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_ADJACENT_PLMNS: {"name": "Adjacent-PLMNs", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_ADJACENT_ACCESS_RESTRICTION_DATA: {"name": "Adjacent-Access-Restriction-Data", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_DL_BUFFERING_SUGGESTED_PACKET_COUNT: {"name": "DL-Buffering-Suggested-Packet-Count", "type": AvpInteger32, "vendor": 10415},
    AVP_TGPP_IMSI_GROUP_ID: {"name": "IMSI-Group-Id", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_GROUP_SERVICE_ID: {"name": "Group-Service-Id", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_GROUP_PLMN_ID: {"name": "Group-PLMN-Id", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_LOCAL_GROUP_ID: {"name": "Local-Group-Id", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_AIR_FLAGS: {"name": "AIR-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_UE_USAGE_TYPE: {"name": "UE-Usage-Type", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_NON_IP_PDN_TYPE_INDICATOR: {"name": "Non-IP-PDN-Type-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NON_IP_DATA_DELIVERY_MECHANISM: {"name": "Non-IP-Data-Delivery-Mechanism", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_CONTEXT_IDENTIFIER: {"name": "Additional-Context-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCEF_REALM: {"name": "SCEF-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIPTION_DATA_DELETION: {"name": "Subscription-Data-Deletion", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PREFERRED_DATA_MODE: {"name": "Preferred-Data-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EMERGENCY_INFO: {"name": "Emergency-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_V2X_SUBSCRIPTION_DATA: {"name": "V2X-Subscription-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_V2X_PERMISSION: {"name": "V2X-Permission", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTION_CONTINUITY: {"name": "PDN-Connection-Continuity", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EDRX_CYCLE_LENGTH: {"name": "eDRX-Cycle-Length", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EDRX_CYCLE_LENGTH_VALUE: {"name": "eDRX-Cycle-Length-Value", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_PC5_AMBR: {"name": "UE-PC5-AMBR", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBSFN_AREA: {"name": "MBSFN-Area", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBSFN_AREA_ID: {"name": "MBSFN-Area-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CARRIER_FREQUENCY: {"name": "Carrier-Frequency", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RDS_INDICATOR: {"name": "RDS-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_GAP_TIME: {"name": "Service-Gap-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AERIAL_UE_SUBSCRIPTION_INFORMATION: {"name": "Aerial-UE-Subscription-Information", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BROADCAST_LOCATION_ASSISTANCE_DATA_TYPES: {"name": "Broadcast-Location-Assistance-Data-Types", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PAGING_TIME_WINDOW: {"name": "Paging-Time-Window", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OPERATION_MODE: {"name": "Operation-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PAGING_TIME_WINDOW_LENGTH: {"name": "Paging-Time-Window-Length", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CORE_NETWORK_RESTRICTIONS: {"name": "Core-Network-Restrictions", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EDRX_RELATED_RAT: {"name": "eDRX-Related-RAT", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INTERWORKING_5GS_INDICATOR: {"name": "Interworking-5GS-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ETHERNET_PDN_TYPE_INDICATOR: {"name": "Ethernet-PDN-Type-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIBED_ARPI: {"name": "Subscribed-ARPI", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IAB_OPERATION_PERMISSION: {"name": "IAB-Operation-Permission", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_V2X_SUBSCRIPTION_DATA_NR: {"name": "V2X-Subscription-Data-Nr", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_PC5_QOS: {"name": "UE-PC5-QoS", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC5_QOS_FLOW: {"name": "PC5-QoS-Flow", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_5QI: {"name": "5QI", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC5_FLOW_BITRATES: {"name": "PC5-Flow-Bitrates", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GUARANTEED_FLOW_BITRATES: {"name": "Guaranteed-Flow-Bitrates", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_FLOW_BITRATES: {"name": "Maximum-Flow-Bitrates", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC5_RANGE: {"name": "PC5-Range", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC5_LINK_AMBR: {"name": "PC5-Link-AMBR", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMS_INFORMATION: {"name": "SMS-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_DATA_CODING_SCHEME: {"name": "Data-Coding-Scheme", "type": AvpInteger32, "vendor": 10415},
    AVP_TGPP_DESTINATION_INTERFACE: {"name": "Destination-Interface", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_INTERFACE_ID: {"name": "Interface-Id", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_INTERFACE_PORT: {"name": "Interface-Port", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_INTERFACE_TEXT: {"name": "Interface-Text", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_INTERFACE_TYPE: {"name": "Interface-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SM_MESSAGE_TYPE: {"name": "SM-Message-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ORIGINATOR_SCCP_ADDRESS: {"name": "Originator-SCCP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_ORIGINATOR_INTERFACE: {"name": "Originator-Interface", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RECIPIENT_SCCP_ADDRESS: {"name": "Recipient-SCCP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_REPLY_PATH_REQUESTED: {"name": "Reply-Path-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SM_DISCHARGE_TIME: {"name": "SM-Discharge-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_SM_PROTOCOL_ID: {"name": "SM-Protocol-ID", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SM_STATUS: {"name": "SM-Status", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SM_USER_DATA_HEADER: {"name": "SM-User-Data-Header", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SMS_NODE: {"name": "SMS-Node", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SMSC_ADDRESS: {"name": "SMSC-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_CLIENT_ADDRESS: {"name": "Client-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_MESSAGES_SENT: {"name": "Number-of-Messages-Sent", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_LOW_BALANCE_INDICATION: {"name": "Low-Balance-Indication", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_REMAINING_BALANCE: {"name": "Remaining-Balance", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_REFUND_INFORMATION: {"name": "Refund-Information", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_CARRIER_SELECT_ROUTING_INFORMATION: {"name": "Carrier-Select-Routing-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_NUMBER_PORTABILITY_ROUTING_INFORMATION: {"name": "Number-Portability-Routing-Information", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_POC_EVENT_TYPE: {"name": "PoC-Event-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_RECIPIENT_INFO: {"name": "Recipient-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_ORIGINATOR_RECEIVED_ADDRESS: {"name": "Originator-Received-Address", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RECIPIENT_RECEIVED_ADDRESS: {"name": "Recipient-Received-Address", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SM_SERVICE_TYPE: {"name": "SM-Service-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MMTEL_INFORMATION: {"name": "MMTel-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_MMTEL_SERVICE_TYPE: {"name": "MMTel-Service-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SERVICE_MODE: {"name": "Service-Mode", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SUBSCRIBER_ROLE: {"name": "Subscriber-Role", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_DIVERSIONS: {"name": "Number-Of-Diversions", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ASSOCIATED_PARTY_ADDRESS: {"name": "Associated-Party-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_SDP_TYPE: {"name": "SDP-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_CHANGE_CONDITION: {"name": "Change-Condition", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_CHANGE_TIME: {"name": "Change-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_DIAGNOSTICS: {"name": "Diagnostics", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SERVICE_DATA_CONTAINER: {"name": "Service-Data-Container", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_START_TIME: {"name": "Start-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_STOP_TIME: {"name": "Stop-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_TIME_FIRST_USAGE: {"name": "Time-First-Usage", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_TIME_LAST_USAGE: {"name": "Time-Last-Usage", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_TIME_USAGE: {"name": "Time-Usage", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_TRAFFIC_DATA_VOLUMES: {"name": "Traffic-Data-Volumes", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SERVING_NODE_TYPE: {"name": "Serving-Node-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SUPPLEMENTARY_SERVICE: {"name": "Supplementary-Service", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_PARTICIPANT_ACTION_TYPE: {"name": "Participant-Action-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTION_CHARGING_ID: {"name": "PDN-Connection-Charging-ID", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_DYNAMIC_ADDRESS_FLAG: {"name": "Dynamic-Address-Flag", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ACCUMULATED_COST: {"name": "Accumulated-Cost", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AOC_COST_INFORMATION: {"name": "AoC-Cost-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AOC_INFORMATION: {"name": "AoC-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AOC_REQUEST_TYPE: {"name": "AoC-Request-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_CURRENT_TARIFF: {"name": "Current-Tariff", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_NEXT_TARIFF: {"name": "Next-Tariff", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RATE_ELEMENT: {"name": "Rate-Element", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_SCALE_FACTOR: {"name": "Scale-Factor", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TARIFF_INFORMATION: {"name": "Tariff-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_UNIT_COST: {"name": "Unit-Cost", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_INCREMENTAL_COST: {"name": "Incremental-Cost", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LOCAL_SEQUENCE_NUMBER: {"name": "Local-Sequence-Number", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_NODE_ID: {"name": "Node-Id", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_SGW_CHANGE: {"name": "SGW-Change", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_CHARACTERISTICS_SELECTION_MODE: {"name": "Charging-Characteristics-Selection-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGW_ADDRESS: {"name": "SGW-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_DYNAMIC_ADDRESS_FLAG_EXTENSION: {"name": "Dynamic-Address-Flag-Extension", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_APPLICATION_SERVER_ID: {"name": "Application-Server-ID", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_APPLICATION_SERVICE_TYPE: {"name": "Application-Service-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_APPLICATION_SESSION_ID: {"name": "Application-Session-ID", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_DELIVERY_STATUS: {"name": "Delivery-Status", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_IM_INFORMATION: {"name": "IM-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_MESSAGES_SUCCESSFULLY_EXPLODED: {"name": "Number-Of-Messages-Successfully-Exploded", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_MESSAGES_SUCCESSFULLY_SENT: {"name": "Number-Of-Messages-Successfully-Sent", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_TOTAL_NUMBER_OF_MESSAGES_EXPLODED: {"name": "Total-Number-Of-Messages-Exploded", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_TOTAL_NUMBER_OF_MESSAGES_SENT: {"name": "Total-Number-Of-Messages-Sent", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_DCD_INFORMATION: {"name": "DCD-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_CONTENT_ID: {"name": "Content-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_CONTENT_PROVIDER_ID: {"name": "Content-provider-ID", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_CHARGE_REASON_CODE: {"name": "Charge-Reason-Code", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SIP_REQUEST_TIMESTAMP_FRACTION: {"name": "SIP-Request-Timestamp-Fraction", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_SIP_RESPONSE_TIMESTAMP_FRACTION: {"name": "SIP-Response-Timestamp-Fraction", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ONLINE_CHARGING_FLAG: {"name": "Online-Charging-Flag", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_CUG_INFORMATION: {"name": "CUG-Information", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_REAL_TIME_TARIFF_INFORMATION: {"name": "Real-Time-Tariff-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TARIFF_XML: {"name": "Tariff-XML", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_MBMS_GW_ADDRESS: {"name": "MBMS-GW-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_IMSI_UNAUTHENTICATED_FLAG: {"name": "IMSI-Unauthenticated-Flag", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ACCOUNT_EXPIRATION: {"name": "Account-Expiration", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_AOC_FORMAT: {"name": "AoC-Format", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_AOC_SERVICE: {"name": "AoC-Service", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AOC_SERVICE_OBLIGATORY_TYPE: {"name": "AoC-Service-Obligatory-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_AOC_SERVICE_TYPE: {"name": "AoC-Service-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_AOC_SUBSCRIPTION_INFORMATION: {"name": "AoC-Subscription-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_PREFERRED_AOC_CURRENCY: {"name": "Preferred-AoC-Currency", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_CSG_ACCESS_MODE: {"name": "CSG-Access-Mode", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_CSG_MEMBERSHIP_INDICATION: {"name": "CSG-Membership-Indication", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_USER_CSG_INFORMATION: {"name": "User-CSG-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_OUTGOING_SESSION_ID: {"name": "Outgoing-Session-Id", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_INITIAL_IMS_CHARGING_IDENTIFIER: {"name": "Initial-IMS-Charging-Identifier", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_LMSI: {"name": "LMSI", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SERVING_NODE: {"name": "Serving-Node", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_MME_NAME: {"name": "MME-Name", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MSC_NUMBER: {"name": "MSC-Number", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_LCS_CAPABILITIES_SETS: {"name": "LCS-Capabilities-Sets", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_GMLC_ADDRESS: {"name": "GMLC-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_SERVING_NODE: {"name": "Additional-Serving-Node", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PSR_ADDRESS: {"name": "PSR-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_MME_REALM: {"name": "MME-Realm", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SGSN_NAME: {"name": "SGSN-Name", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_SGSN_REALM: {"name": "SGSN-Realm", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_RIA_FLAGS: {"name": "RIA-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_SLG_LOCATION_TYPE: {"name": "Slg-Location-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_LCS_EPS_CLIENT_NAME: {"name": "LCS-EPS-Client-Name", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LCS_REQUESTOR_NAME: {"name": "LCS-Requestor-Name", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LCS_PRIORITY: {"name": "LCS-Priority", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_LCS_QOS: {"name": "LCS-QoS", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_HORIZONTAL_ACCURACY: {"name": "Horizontal-Accuracy", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_VERTICAL_ACCURACY: {"name": "Vertical-Accuracy", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_VERTICAL_REQUESTED: {"name": "Vertical-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_VELOCITY_REQUESTED: {"name": "Velocity-Requested", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_RESPONSE_TIME: {"name": "Response-Time", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SUPPORTED_GAD_SHAPES: {"name": "Supported-GAD-Shapes", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_LCS_CODEWORD: {"name": "LCS-Codeword", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_LCS_PRIVACY_CHECK: {"name": "LCS-Privacy-Check", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ACCURACY_FULFILMENT_INDICATOR: {"name": "Accuracy-Fulfilment-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_AGE_OF_LOCATION_ESTIMATE: {"name": "Age-Of-Location-Estimate", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_VELOCITY_ESTIMATE: {"name": "Velocity-Estimate", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_EUTRAN_POSITIONING_DATA: {"name": "EUTRAN-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_ECGI: {"name": "ECGI", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_LOCATION_EVENT: {"name": "Location-Event", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PSEUDONYM_INDICATOR: {"name": "Pseudonym-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_LCS_SERVICE_TYPE_ID: {"name": "LCS-Service-Type-ID", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_LCS_PRIVACY_CHECK_NON_SESSION: {"name": "LCS-Privacy-Check-Non-Session", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LCS_PRIVACY_CHECK_SESSION: {"name": "LCS-Privacy-Check-Session", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LCS_QOS_CLASS: {"name": "LCS-QoS-Class", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_GERAN_POSITIONING_INFO: {"name": "GERAN-Positioning-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_GERAN_POSITIONING_DATA: {"name": "GERAN-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_GERAN_GANSS_POSITIONING_DATA: {"name": "GERAN-GANSS-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_UTRAN_POSITIONING_INFO: {"name": "UTRAN-Positioning-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_UTRAN_POSITIONING_DATA: {"name": "UTRAN-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_UTRAN_GANSS_POSITIONING_DATA: {"name": "UTRAN-GANSS-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_LRR_FLAGS: {"name": "LRR-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_LCS_REFERENCE_NUMBER: {"name": "LCS-Reference-Number", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_DEFERRED_LOCATION_TYPE: {"name": "Deferred-Location-Type", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_AREA_EVENT_INFO: {"name": "Area-Event-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AREA_DEFINITION: {"name": "Area-Definition", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AREA: {"name": "Area", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_AREA_TYPE: {"name": "Area-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_AREA_IDENTIFICATION: {"name": "Area-Identification", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_OCCURRENCE_INFO: {"name": "Occurrence-Info", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_INTERVAL_TIME: {"name": "Interval-Time", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_PERIODIC_LDR_INFORMATION: {"name": "Periodic-LDR-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_REPORTING_AMOUNT: {"name": "Reporting-Amount", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_REPORTING_INTERVAL: {"name": "Reporting-Interval", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_REPORTING_PLMN_LIST: {"name": "Reporting-PLMN-List", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_PLMN_ID_LIST: {"name": "PLMN-ID-List", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_PLR_FLAGS: {"name": "PLR-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_PLA_FLAGS: {"name": "PLA-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_DEFERRED_MT_LR_DATA: {"name": "Deferred-MT-LR-Data", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_TERMINATION_CAUSE_3GPP: {"name": "Termination-Cause-3GPP", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_LRA_FLAGS: {"name": "LRA-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_PERIODIC_LOCATION_SUPPORT_INDICATOR: {"name": "Periodic-Location-Support-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PRIORITIZED_LIST_INDICATOR: {"name": "Prioritized-List-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_ESMLC_CELL_INFO: {"name": "ESMLC-Cell-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_CELL_PORTION_ID: {"name": "Cell-Portion-ID", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_ONEXRTT_RCID: {"name": "OnexRTT-RCID", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_DELAYED_LOCATION_REPORTING_DATA: {"name": "Delayed-Location-Reporting-Data", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_CIVIC_ADDRESS: {"name": "Civic-Address", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_BAROMETRIC_PRESSURE: {"name": "Barometric-Pressure", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_UTRAN_ADDITIONAL_POSITIONING_DATA: {"name": "UTRAN-Additional-Positioning-Data", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MOTION_EVENT_INFO: {"name": "Motion-Event-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_LINEAR_DISTANCE: {"name": "Linear-Distance", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_MAXIMUM_INTERVAL: {"name": "Maximum-Interval", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_SAMPLING_INTERVAL: {"name": "Sampling-Interval", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_REPORTING_DURATION: {"name": "Reporting-Duration", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_REPORTING_LOCATION_REQUIREMENTS: {"name": "Reporting-Location-Requirements", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_AREA: {"name": "Additional-Area", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_IMS_APPLICATION_REFERENCE_IDENTIFIER: {"name": "IMS-Application-Reference-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOW_PRIORITY_INDICATOR: {"name": "Low-Priority-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_IP_REALM_DEFAULT_INDICATOR: {"name": "IP-Realm-Default-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_LOCAL_GW_INSERTED_INDICATOR: {"name": "Local-GW-Inserted-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_TRANSCODER_INSERTED_INDICATOR: {"name": "Transcoder-Inserted-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_PDP_ADDRESS_PREFIX_LENGTH: {"name": "PDP-Address-Prefix-Length", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRANSIT_IOI_LIST: {"name": "Transit-IOI-List", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_STATUS_AS_CODE: {"name": "Status-AS-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NNI_INFORMATION: {"name": "NNI-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NNI_TYPE: {"name": "NNI-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_NEIGHBOUR_NODE_ADDRESS: {"name": "Neighbour-Node-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELATIONSHIP_MODE: {"name": "Relationship-Mode", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_SESSION_DIRECTION: {"name": "Session-Direction", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_FROM_ADDRESS: {"name": "From-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_TRANSFER_INFORMATION: {"name": "Access-Transfer-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_TRANSFER_TYPE: {"name": "Access-Transfer-Type", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_RELATED_IMS_CHARGING_IDENTIFIER: {"name": "Related-IMS-Charging-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELATED_IMS_CHARGING_IDENTIFIER_NODE: {"name": "Related-IMS-Charging-Identifier-Node", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_VISITED_NETWORK_IDENTIFIER: {"name": "IMS-Visited-Network-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAN_USER_LOCATION_INFO: {"name": "TWAN-User-Location-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BSSID: {"name": "BSSID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TAD_IDENTIFIER: {"name": "TAD-Identifier", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_TDF_APPLICATION_INSTANCE_IDENTIFIER: {"name": "TDF-Application-Instance-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_HENB_LOCAL_IP_ADDRESS: {"name": "HeNB-Local-IP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_UE_LOCAL_IP_ADDRESS: {"name": "UE-Local-IP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_UDP_SOURCE_PORT: {"name": "UDP-Source-Port", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_CS_SERVICE_QOS_REQUEST_IDENTIFIER: {"name": "CS-Service-QoS-Request-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CS_SERVICE_QOS_REQUEST_OPERATION: {"name": "CS-Service-QoS-Request-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MUTE_NOTIFICATION: {"name": "Mute-Notification", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_TIME: {"name": "Monitoring-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_AN_GW_STATUS: {"name": "AN-GW-Status", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_USER_LOCATION_INFO_TIME: {"name": "User-Location-Info-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_CS_SERVICE_RESOURCE_REPORT: {"name": "CS-Service-Resource-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CS_SERVICE_RESOURCE_FAILURE_CAUSE: {"name": "CS-Service-Resource-Failure-Cause", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CS_SERVICE_RESOURCE_RESULT_OPERATION: {"name": "CS-Service-Resource-Result-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEFAULT_QOS_INFORMATION: {"name": "Default-QoS-Information", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_DEFAULT_QOS_NAME: {"name": "Default-QoS-Name", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_CONDITIONAL_APN_AGGREGATE_MAX_BITRATE: {"name": "Conditional-APN-Aggregate-Max-Bitrate", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_RAN_NAS_RELEASE_CAUSE: {"name": "RAN-NAS-Release-Cause", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_PRESENCE_REPORTING_AREA_ELEMENTS_LIST: {"name": "Presence-Reporting-Area-Elements-List", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_PRESENCE_REPORTING_AREA_IDENTIFIER: {"name": "Presence-Reporting-Area-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRESENCE_REPORTING_AREA_INFORMATION: {"name": "Presence-Reporting-Area-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRESENCE_REPORTING_AREA_STATUS: {"name": "Presence-Reporting-Area-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NETLOC_ACCESS_SUPPORT: {"name": "NetLoc-Access-Support", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_FIXED_USER_LOCATION_INFO: {"name": "Fixed-User-Location-Info", "type": AvpGrouped, "vendor": 10415},
    AVP_TGPP_PCSCF_RESTORATION_INDICATION: {"name": "PCSCF-Restoration-Indication", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_IP_CAN_SESSION_CHARGING_SCOPE: {"name": "IP-CAN-Session-Charging-Scope", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MONITORING_FLAGS: {"name": "Monitoring-Flags", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_DEFAULT_ACCESS: {"name": "Default-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NBIFOM_MODE: {"name": "NBIFOM-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NBIFOM_SUPPORT: {"name": "NBIFOM-Support", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAN_RULE_SUPPORT: {"name": "RAN-Rule-Support", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ACCESS_AVAILABILITY_CHANGE_REASON: {"name": "Access-Availability-Change-Reason", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_FAILURE_CODE: {"name": "Routing-Rule-Failure-Code", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_ROUTING_RULE_REPORT: {"name": "Routing-Rule-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRAFFIC_STEERING_POLICY_IDENTIFIER_DL: {"name": "Traffic-Steering-Policy-Identifier-DL", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_TRAFFIC_STEERING_POLICY_IDENTIFIER_UL: {"name": "Traffic-Steering-Policy-Identifier-UL", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_REQUEST_TYPE: {"name": "Request-Type", "type": AvpUnsigned32, "vendor": 10415},
    AVP_TGPP_EXECUTION_TIME: {"name": "Execution-Time", "type": AvpTime, "vendor": 10415},
    AVP_TGPP_CONDITIONAL_POLICY_INFORMATION: {"name": "Conditional-Policy-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RESOURCE_RELEASE_NOTIFICATION: {"name": "Resource-Release-Notification", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REMOVAL_OF_ACCESS: {"name": "Removal-Of-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TCP_SOURCE_PORT: {"name": "TCP-Source-Port", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEFAULT_BEARER_INDICATION: {"name": "Default-Bearer-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRA_INSTALL: {"name": "PRA-Install", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRA_REMOVE: {"name": "PRA-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_PS_DATA_OFF_STATUS_GX: {"name": "3GPP-PS-Data-Off-Status-Gx", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_APN_AMBR_DL: {"name": "Extended-APN-AMBR-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_APN_AMBR_UL: {"name": "Extended-APN-AMBR-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_GBR_DL: {"name": "Extended-GBR-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_GBR_UL: {"name": "Extended-GBR-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_PLR_DL: {"name": "Max-PLR-DL", "type": AvpFloat32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_PLR_UL: {"name": "Max-PLR-UL", "type": AvpFloat32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_STATUS: {"name": "UE-Status", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRESENCE_REPORTING_AREA_NODE: {"name": "Presence-Reporting-Area-Node", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POLICY_COUNTER_IDENTIFIER: {"name": "Policy-Counter-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POLICY_COUNTER_STATUS: {"name": "Policy-Counter-Status", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_POLICY_COUNTER_STATUS_REPORT: {"name": "Policy-Counter-Status-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SL_REQUEST_TYPE: {"name": "SL-Request-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SN_REQUEST_TYPE: {"name": "SN-Request-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PENDING_POLICY_COUNTER_INFORMATION: {"name": "Pending-Policy-Counter-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PENDING_POLICY_COUNTER_CHANGE_TIME: {"name": "Pending-Policy-Counter-Change-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEVICE_ACTION: {"name": "Device-Action", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEVICE_NOTIFICATION: {"name": "Device-Notification", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRIGGER_DATA: {"name": "Trigger-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PAYLOAD: {"name": "Payload", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACTION_TYPE: {"name": "Action-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIORITY_INDICATION: {"name": "Priority-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REFERENCE_NUMBER: {"name": "Reference-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUEST_STATUS: {"name": "Request-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DELIVERY_OUTCOME: {"name": "Delivery-Outcome", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_PORT_IDENTIFIER: {"name": "Application-Port-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OLD_REFERENCE_NUMBER: {"name": "Old-Reference-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_SM_GW_NUMBER: {"name": "IP-SM-GW-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_SM_GW_NAME: {"name": "IP-SM-GW-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_IDENTIFIER: {"name": "User-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_S6_SERVICE_ID: {"name": "S6-Service-ID", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCS_IDENTITY: {"name": "SCS-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_PARAMETERS: {"name": "Service-Parameters", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_T4_PARAMETERS: {"name": "T4-Parameters", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_DATA: {"name": "Service-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_T4_DATA: {"name": "T4-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_HSS_CAUSE: {"name": "HSS-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIR_FLAGS: {"name": "SIR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTERNAL_IDENTIFIER: {"name": "External-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_SM_GW_REALM: {"name": "IP-SM-GW-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AESE_COMMUNICATION_PATTERN: {"name": "AESE-Communication-Pattern", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COMMUNICATION_PATTERN_SET: {"name": "Communication-Pattern-Set", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PERIODIC_COMMUNICATION_INDICATOR: {"name": "Periodic-Communication-Indicator", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COMMUNICATION_DURATION_TIME: {"name": "Communication-Duration-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PERIODIC_TIME: {"name": "Periodic-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCHEDULED_COMMUNICATION_TIME: {"name": "Scheduled-Communication-Time", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_STATIONARY_INDICATION: {"name": "Stationary-Indication", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AESE_COMMUNICATION_PATTERN_CONFIG_STATUS: {"name": "AESE-Communication-Pattern-Config-Status", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AESE_ERROR_REPORT: {"name": "AESE-Error-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_CONFIGURATION: {"name": "Monitoring-Event-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_REPORT: {"name": "Monitoring-Event-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCEF_REFERENCE_ID: {"name": "SCEF-Reference-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCEF_ID: {"name": "SCEF-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCEF_REFERENCE_ID_FOR_DELETION: {"name": "SCEF-Reference-ID-for-Deletion", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_TYPE: {"name": "Monitoring-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_NUMBER_OF_REPORTS: {"name": "Maximum-Number-of-Reports", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_REACHABILITY_CONFIGURATION: {"name": "UE-Reachability-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_DURATION: {"name": "Monitoring-Duration", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_DETECTION_TIME: {"name": "Maximum-Detection-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REACHABILITY_TYPE: {"name": "Reachability-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_LATENCY: {"name": "Maximum-Latency", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_RESPONSE_TIME: {"name": "Maximum-Response-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_INFORMATION_CONFIGURATION: {"name": "Location-Information-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONTE_LOCATION_TYPE: {"name": "MONTE-Location-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCURACY: {"name": "Accuracy", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSOCIATION_TYPE: {"name": "Association-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROAMING_INFORMATION: {"name": "Roaming-Information", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REACHABILITY_INFORMATION: {"name": "Reachability-Information", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMEI_CHANGE: {"name": "IMEI-Change", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_CONFIG_STATUS: {"name": "Monitoring-Event-Config-Status", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUPPORTED_SERVICES: {"name": "Supported-Services", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUPPORTED_MONITORING_EVENTS: {"name": "Supported-Monitoring-Events", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CIR_FLAGS: {"name": "CIR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_RESULT: {"name": "Service-Result", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_RESULT_CODE: {"name": "Service-Result-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REFERENCE_ID_VALIDITY_TIME: {"name": "Reference-ID-Validity-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EVENT_HANDLING: {"name": "Event-Handling", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIDD_AUTHORIZATION_REQUEST: {"name": "NIDD-Authorization-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIDD_AUTHORIZATION_RESPONSE: {"name": "NIDD-Authorization-Response", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_REPORT: {"name": "Service-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NODE_TYPE: {"name": "Node-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_S6T_HSS_CAUSE: {"name": "S6t-HSS-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENHANCED_COVERAGE_RESTRICTION: {"name": "Enhanced-Coverage-Restriction", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENHANCED_COVERAGE_RESTRICTION_DATA: {"name": "Enhanced-Coverage-Restriction-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RESTRICTED_PLMN_LIST: {"name": "Restricted-PLMN-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALLOWED_PLMN_LIST: {"name": "Allowed-PLMN-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_VALIDITY_TIME: {"name": "Requested-Validity-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GRANTED_VALIDITY_TIME: {"name": "Granted-Validity-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIDD_AUTHORIZATION_UPDATE: {"name": "NIDD-Authorization-Update", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOSS_OF_CONNECTIVITY_REASON: {"name": "Loss-Of-Connectivity-Reason", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GROUP_REPORTING_GUARD_TIMER: {"name": "Group-Reporting-Guard-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CIA_FLAGS: {"name": "CIA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GROUP_MONITORING_EVENT_REPORT: {"name": "Group-Monitoring-Event-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GROUP_MONITORING_EVENT_REPORT_ITEM: {"name": "Group-Monitoring-Event-Report-Item", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RIR_FLAGS: {"name": "RIR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TYPE_OF_EXTERNAL_IDENTIFIER: {"name": "Type-Of-External-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_VALIDITY_TIME: {"name": "APN-Validity-Time", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUGGESTED_NETWORK_CONFIGURATION: {"name": "Suggested-Network-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_REPORT_STATUS: {"name": "Monitoring-Event-Report-Status", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PLMN_ID_REQUESTED: {"name": "PLMN-ID-Requested", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDITIONALIDENTIFIERS: {"name": "AdditionalIdentifiers", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIR_FLAGS: {"name": "NIR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORTING_TIME_STAMP: {"name": "Reporting-Time-Stamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIA_FLAGS: {"name": "NIA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GROUP_USER_IDENTIFIER: {"name": "Group-User-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MTC_PROVIDER_INFO: {"name": "MTC-Provider-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MTC_PROVIDER_ID: {"name": "MTC-Provider-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTIVITY_STATUS_CONFIGURATION: {"name": "PDN-Connectivity-Status-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTIVITY_STATUS_REPORT: {"name": "PDN-Connectivity-Status-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDN_CONNECTIVITY_STATUS_TYPE: {"name": "PDN-Connectivity-Status-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRAFFIC_PROFILE: {"name": "Traffic-Profile", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_OUTCOME_T4: {"name": "SM-Delivery-Outcome-T4", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ABSENT_SUBSCRIBER_DIAGNOSTIC_T4: {"name": "Absent-Subscriber-Diagnostic-T4", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRIGGER_ACTION: {"name": "Trigger-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MTC_ERROR_DIAGNOSTIC: {"name": "MTC-Error-Diagnostic", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REASON_HEADER: {"name": "Reason-Header", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INSTANCE_ID: {"name": "Instance-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTE_HEADER_RECEIVED: {"name": "Route-Header-Received", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTE_HEADER_TRANSMITTED: {"name": "Route-Header-Transmitted", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DEVICE_TRIGGER_INFORMATION: {"name": "SM-Device-Trigger-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MTC_IWF_ADDRESS: {"name": "MTC-IWF-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DEVICE_TRIGGER_INDICATOR: {"name": "SM-Device-Trigger-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_SEQUENCE_NUMBER: {"name": "SM-Sequence-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMS_RESULT: {"name": "SMS-Result", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VCS_INFORMATION: {"name": "VCS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BASIC_SERVICE_CODE: {"name": "Basic-Service-Code", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEARER_CAPABILITY: {"name": "Bearer-Capability", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TELESERVICE: {"name": "Teleservice", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_LOCATION_NUMBER: {"name": "ISUP-Location-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FORWARDING_PENDING: {"name": "Forwarding-Pending", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_CAUSE: {"name": "ISUP-Cause", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_RELEASE_CAUSE: {"name": "ISUP-Release-Cause", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MSC_ADDRESS: {"name": "MSC-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NETWORK_CALL_REFERENCE_NUMBER: {"name": "Network-Call-Reference-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_START_OF_CHARGING: {"name": "Start-of-Charging", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VLR_NUMBER: {"name": "VLR-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CN_OPERATOR_SELECTION_ENTITY: {"name": "CN-Operator-Selection-Entity", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_CAUSE_DIAGNOSTICS: {"name": "ISUP-Cause-Diagnostics", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_CAUSE_LOCATION: {"name": "ISUP-Cause-Location", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ISUP_CAUSE_VALUE: {"name": "ISUP-Cause-Value", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EPDG_ADDRESS: {"name": "ePDG-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCING_UE_HPLMN_IDENTIFIER: {"name": "Announcing-UE-HPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCING_UE_VPLMN_IDENTIFIER: {"name": "Announcing-UE-VPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COVERAGE_STATUS: {"name": "Coverage-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LAYER_2_GROUP_ID: {"name": "Layer-2-Group-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORED_PLMN_IDENTIFIER: {"name": "Monitored-PLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_UE_HPLMN_IDENTIFIER: {"name": "Monitoring-UE-HPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_UE_IDENTIFIER: {"name": "Monitoring-UE-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_UE_VPLMN_IDENTIFIER: {"name": "Monitoring-UE-VPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC3_CONTROL_PROTOCOL_CAUSE: {"name": "PC3-Control-Protocol-Cause", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC3_EPC_CONTROL_PROTOCOL_CAUSE: {"name": "PC3-EPC-Control-Protocol-Cause", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_PLMN_IDENTIFIER: {"name": "Requested-PLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTOR_PLMN_IDENTIFIER: {"name": "Requestor-PLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROLE_OF_PROSE_FUNCTION: {"name": "Role-Of-ProSe-Function", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USAGE_INFORMATION_REPORT_SEQUENCE_NUMBER: {"name": "Usage-Information-Report-Sequence-Number", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_3RD_PARTY_APPLICATION_ID: {"name": "ProSe-3rd-Party-Application-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_DIRECT_COMMUNICATION_TRANSMISSION_DATA_CONTAINER: {"name": "ProSe-Direct-Communication-Transmission-Data-Containe", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_DIRECT_DISCOVERY_MODEL: {"name": "ProSe-Direct-Discovery-Model", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_EVENT_TYPE: {"name": "ProSe-Event-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_FUNCTION_IP_ADDRESS: {"name": "ProSe-Function-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_GROUP_IP_MULTICAST_ADDRESS: {"name": "ProSe-Group-IP-Multicast-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_INFORMATION: {"name": "ProSe-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_RANGE_CLASS: {"name": "ProSe-Range-Class", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_REASON_FOR_CANCELLATION: {"name": "ProSe-Reason-For-Cancellation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_REQUEST_TIMESTAMP: {"name": "ProSe-Requested-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_ROLE_OF_UE: {"name": "ProSe-Role-Of-UE", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_SOURCE_IP_ADDRESS: {"name": "ProSe-Source-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_UE_ID: {"name": "ProSe-UE-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROXIMITY_ALERT_INDICATION: {"name": "Proximity-Alert-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROXIMITY_ALERT_TIMESTAMP: {"name": "Proximity-Alert-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROXIMITY_CANCELLATION_TIMESTAMP: {"name": "Proximity-Cancellation-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TIME_FIRST_TRANSMISSION: {"name": "Time-First-Transmission", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_FUNCTION_PLMN_IDENTIFIER: {"name": "ProSe-Function-PLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_SPECIFIC_DATA: {"name": "Application-Specific-Data", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COVERAGE_INFO: {"name": "Coverage-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_INFO: {"name": "Location-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_DIRECT_COMMUNICATION_RECEPTION_DATA_CONTAINER: {"name": "ProSe-Direct-Communication-Reception-Data-Container", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RADIO_PARAMETER_SET_INFO: {"name": "Radio-Parameter-Set-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RADIO_PARAMETER_SET_VALUES: {"name": "Radio-Parameter-Set-Values", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RADIO_RESOURCES_INDICATOR: {"name": "Radio-Resources-Indicator", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TRANSMITTER_INFO: {"name": "Transmitter-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGIN_APP_LAYER_USER_ID: {"name": "Origin-App-Layer-User-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TARGET_APP_LAYER_USER_ID: {"name": "Target-App-Layer-User-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_FUNCTION_ID: {"name": "ProSe-Function-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_REQUEST_TYPE: {"name": "ProSe-Request-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PDUID: {"name": "PDUID", "type": AvpOctetString, "mandatory": False, "vendor": 10415},
    AVP_TGPP_APPLICATION_DATA: {"name": "Application-Data", "type": AvpUtf8String, "mandatory": False, "vendor": 10415},
    AVP_TGPP_ALLOWED_SUFFIXES_NUMBER: {"name": "Allowed-Suffixes-Number", "type": AvpUnsigned32, "mandatory": False, "vendor": 10415},
    AVP_TGPP_MONITOR_TARGET: {"name": "Monitor-Target", "type": AvpGrouped, "mandatory": False, "vendor": 10415},
    AVP_TGPP_PROSE_CODE_SUFFIX_MASK: {"name": "ProSe-Code-Suffix-Mask", "type": AvpGrouped, "mandatory": False, "vendor": 10415},
    AVP_TGPP_SUFFIX_CODE: {"name": "Suffix-Code", "type": AvpOctetString, "mandatory": False, "vendor": 10415},
    AVP_TGPP_SUFFIX_MASK: {"name": "Suffix-Mask", "type": AvpOctetString, "mandatory": False, "vendor": 10415},
    AVP_TGPP_BANNED_USER_TARGET: {"name": "Banned-User-Target", "type": AvpGrouped, "mandatory": False, "vendor": 10415},
    AVP_TGPP_METADATA_INDICATOR: {"name": "Metadata-Indicator", "type": AvpUnsigned32, "mandatory": False, "vendor": 10415},
    AVP_TGPP_APP_LAYER_USER_ID: {"name": "App-Layer-User-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSISTANCE_INFO: {"name": "Assistance-info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSISTANCE_INFO_VALIDITY_TIMER: {"name": "Assistance-Info-Validity-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERY_TYPE: {"name": "Discovery-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FILTER_ID: {"name": "Filter-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAC_ADDRESS: {"name": "MAC-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MATCH_REPORT: {"name": "Match-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OPERATING_CHANNEL: {"name": "Operating-Channel", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_P2P_FEATURES: {"name": "P2P-Features", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APP_CODE: {"name": "ProSe-App-Code", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APP_ID: {"name": "ProSe-App-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APP_MASK: {"name": "ProSe-App-Mask", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_DISCOVERY_FILTER: {"name": "ProSe-Discovery-Filter", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRR_FLAGS: {"name": "PRR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_VALIDITY_TIMER: {"name": "Application-Specific-Data", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTING_EPUID: {"name": "Requesting-EPUID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TARGETED_EPUID: {"name": "Targeted-EPUID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TIME_WINDOW: {"name": "Time-Window", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WIFI_P2P_ASSISTANCE_INFO: {"name": "WiFi-P2P-Assistance-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_ASSISTANCE_INFO: {"name": "WLAN-Assistance-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_LINK_LAYER_ID: {"name": "WLAN-Link-Layer-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_LINK_LAYER_ID_LIST: {"name": "WLAN-Link-Layer-Id-List", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_UPDATE_TRIGGER: {"name": "Location-Update-Trigger", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_UPDATE_EVENT_TYPE: {"name": "Location-Update-Event-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHANGE_OF_AREA_TYPE: {"name": "Change-Of-Area-Type", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_UPDATE_EVENT_TRIGGER: {"name": "Location-Update-Event-Trigger", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPORT_CARDINALITY: {"name": "Report-Cardinality", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MINIMUM_INTERVAL_TIME: {"name": "Minimum-Interval-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PERIODIC_LOCATION_TYPE: {"name": "Periodic-Location-Type", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCATION_REPORT_INTERVAL_TIME: {"name": "Location-Report-Interval-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TOTAL_NUMBER_OF_REPORTS: {"name": "Total-Number-Of-Reports", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VALIDITY_TIME_ANNOUNCE: {"name": "Validity-Time-Announce", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VALIDITY_TIME_MONITOR: {"name": "Validity-Time-Monitor", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VALIDITY_TIME_COMMUNICATION: {"name": "Validity-Time-Communication", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APP_CODE_INFO: {"name": "ProSe-App-Code-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIC: {"name": "MIC", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UTC_BASED_COUNTER: {"name": "UTC-based-Counter", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_MATCH_REFRESH_TIMER: {"name": "ProSe-Match-Refresh-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_METADATA_INDEX_MASK: {"name": "ProSe-Metadata-Index-Mask", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APP_IDENTIFIER: {"name": "App-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OS_ID: {"name": "OS-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OS_APP_ID: {"name": "OS-App-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTING_RPAUID: {"name": "Requesting-RPAUID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TARGET_RPAUID: {"name": "Target-RPAUID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TARGET_PDUID: {"name": "Target-PDUID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_RESTRICTED_CODE: {"name": "ProSe-Restricted-Code", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_RESTRICTED_CODE_SUFFIXRANGE: {"name": "ProSe-Restricted-Code-SuffixRange", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BEGINNING_SUFFIX: {"name": "Beginning-Suffix", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENDING_SUFFIX: {"name": "Ending-Suffix", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERY_ENTRY_ID: {"name": "Discovery-Entry-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MATCH_TIMESTAMP: {"name": "Match-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PMR_FLAGS: {"name": "PMR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APPLICATION_METADATA: {"name": "ProSe-Application-Metadata", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERY_AUTH_REQUEST: {"name": "Discovery-Auth-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERY_AUTH_RESPONSE: {"name": "Discovery-Auth-Response", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MATCH_REQUEST: {"name": "Match-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MATCH_REPORT_INFO: {"name": "Match-Report-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BANNED_RPAUID: {"name": "Banned-RPAUID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BANNED_PDUID: {"name": "Banned-PDUID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CODE_RECEIVING_SECURITYMATERIAL: {"name": "Code-Receiving-SecurityMaterial", "type": AvpGrouped, "mandatory": True , "vendor": 10415},
    AVP_TGPP_DUSK: {"name": "DUSK", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DUIK: {"name": "DUIK", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DUCK: {"name": "DUCK", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIC_CHECK_INDICATOR: {"name": "MIC-Check-indicator", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENCRYPTED_BITMASK: {"name": "Encrypted-Bitmask", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_APP_CODE_SUFFIX_RANGE: {"name": "ProSe-App-Code-Suffix-Range", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PC5_TECH: {"name": "PC5-tech", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENHANCED_DIAGNOSTICS: {"name": "Enhanced-Diagnostics", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INTER_UE_TRANSFER: {"name": "Inter-UE-Transfer", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TWAG_ADDRESS: {"name": "TWAG-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCEMENT_INFORMATION: {"name": "Announcement-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCEMENT_IDENTIFIER: {"name": "Announcement-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCEMENT_ORDER: {"name": "Announcement-Order", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VARIABLE_PART: {"name": "Variable-Part", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VARIABLE_PART_ORDER: {"name": "Variable-Part-Order", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VARIABLE_PART_TYPE: {"name": "Variable-Part-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VARIABLE_PART_VALUE: {"name": "Variable-Part-Value", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TIME_INDICATOR: {"name": "Time-Indicator", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_QUOTA_INDICATOR: {"name": "Quota-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PLAY_ALTERNATIVE: {"name": "Play-Alternative", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LANGUAGE: {"name": "Language", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIVACY_INDICATOR: {"name": "Privacy-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALLED_IDENTITY: {"name": "Called-Identity", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALLED_IDENTITY_CHANGE: {"name": "Called-Identity-Change", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UWAN_USER_LOCATION_INFO: {"name": "UWAN-User-Location-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_CONFIGURATION_ACTIVITY: {"name": "Monitoring-Event-Configuration-Activity", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_REPORT_DATA: {"name": "Monitoring-Event-Report-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_INFORMATION: {"name": "Monitoring-Event-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_FUNCTIONALITY: {"name": "Monitoring-Event-Functionality", "type": AvpInteger32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MONITORING_EVENT_REPORT_NUMBER: {"name": "Monitoring-Event-Report-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CELLULAR_NETWORK_INFORMATION: {"name": "Cellular-Network-Information ", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELATED_CHANGE_CONDITION_INFORMATION: {"name": "Related-Change-Condition-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELATED_TRIGGER: {"name": "Related-Trigger", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CPDT_INFORMATION: {"name": "CPDT-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NIDD_SUBMISSION: {"name": "NIDD-Submission", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVING_NODE_IDENTITY: {"name": "Serving-Node-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CP_CIOT_EPS_OPTIMISATION_INDICATOR: {"name": "CP-CIoT-EPS-Optimisation-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGI_PTP_TUNNELLING_METHOD: {"name": "SGi-PtP-Tunnelling-Method", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UNI_PDU_CP_ONLY_FLAG: {"name": "UNI-PDU-CP-Only-Flag", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_RATE_CONTROL: {"name": "APN-Rate-Control", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_RATE_CONTROL_DOWNLINK: {"name": "APN-Rate-Control-Downlink", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_RATE_CONTROL_UPLINK: {"name": "APN-Rate-Control-Uplink", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_EXCEPTION_REPORTS: {"name": "Additional-Exception-Reports", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RATE_CONTROL_MAX_MESSAGE_SIZE: {"name": "Rate-Control-Max-Message-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RATE_CONTROL_MAX_RATE: {"name": "Rate-Control-Max-Rate", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RATE_CONTROL_TIME_UNIT: {"name": "Rate-Control-Time-Unit", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCS_AS_ADDRESS: {"name": "SCS-AS-Address", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCS_ADDRESS: {"name": "SCS-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCS_REALM: {"name": "SCS-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ENODEB_ID: {"name": "eNodeB-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_ENODEB_ID: {"name": "Extended-eNodeB-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_PER_IP_CAN_SESSION_INDICATOR: {"name": "Charging-Per-IP-CAN-Session-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_INFO_CHANGE: {"name": "Access-Network-Info-Change", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVEREE_UE_HPLMN_IDENTIFIER: {"name": "Discoveree-UE-HPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVEREE_UE_VPLMN_IDENTIFIER: {"name": "Discoveree-UE-VPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERER_UE_HPLMN_IDENTIFIER: {"name": "Discoverer-UE-HPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DISCOVERER_UE_VPLMN_IDENTIFIER: {"name": "Discoverer-UE-VPLMN-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_PS_DATA_OFF_STATUS: {"name": "3GPP-PS-Data-Off-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UNUSED_QUOTA_TIMER: {"name": "Unused-Quota-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ANNOUNCING_PLMN_ID: {"name": "Announcing-PLMN-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_UE_TO_NETWORK_RELAY_UE_ID: {"name": "ProSe-UE-to-Network-Relay-UE-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_TARGET_LAYER_2_ID: {"name": "ProSe-Target-Layer-2-ID", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RELAY_IP_ADDRESS: {"name": "Relay-IP-address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TARGET_IP_ADDRESS: {"name": "Target-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FE_IDENTIFIER_LIST: {"name": "FE-Identifier-List", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_IMSI: {"name": "3GPP-IMSI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_CHARGING_ID: {"name": "3GPP-Charging-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_PDP_TYPE: {"name": "3GPP-PDP-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_CG_ADDRESS: {"name": "3GPP-CG-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_GPRS_NEGOTIATED_QOS_PROFILE: {"name": "3GPP-GPRS-Negotiated-QoS-Profile", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SGSN_ADDRESS: {"name": "3GPP-SGSN-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_GGSN_ADDRESS: {"name": "3GPP-GGSN-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_IMSI_MCC_MNC: {"name": "3GPP-IMSI-MCC-MNC", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_GGSN_MCC_MNC: {"name": "3GPP-GGSN-MCC-MNC", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_NSAPI: {"name": "3GPP-NSAPI", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SESSION_STOP_INDICATOR: {"name": "3GPP-Session-Stop-Indicator", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SELECTION_MODE: {"name": "3GPP-Selection-Mode", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_CHARGING_CHARACTERISTICS: {"name": "3GPP-Charging-Characteristics", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_CG_IPV6_ADDRESS: {"name": "3GPP-CG-IPv6-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SGSN_IPV6_ADDRESS: {"name": "3GPP-SGSN-IPv6-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_GGSN_IPV6_ADDRESS: {"name": "3GPP-GGSN-IPv6-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_IPV6_DNS_SERVER: {"name": "3GPP-IPv6-DNS-Server", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SGSN_MCC_MNC: {"name": "3GPP-SGSN-MCC-MNC", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_TEARDOWN_INDICATOR: {"name": "3GPP-Teardown-Indicator", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_IMEISV: {"name": "3GPP-IMEISV", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_RAT_TYPE: {"name": "3GPP-RAT-Type", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_USER_LOCATION_INFO: {"name": "3GPP-User-Location-Info", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_MS_TIMEZONE: {"name": "3GPP-MS-TimeZone", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_CAMEL_CHARGING_INFO: {"name": "3GPP-CAMEL-Charging-Info", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_PACKET_FILTER: {"name": "3GPP-Packet-Filter", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_NEGOTIATED_DSCP: {"name": "3GPP-Negotiated-DSCP", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_ALLOCATE_IP_TYPE: {"name": "3GPP-Allocate-IP-Type", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_TWAN_IDENTIFIER: {"name": "3GPP-TWAN-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_USER_LOCATION_INFO_TIME: {"name": "3GPP-User-Location-Info-Time", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SECONDARY_RAT_USAGE: {"name": "3GPP-Secondary-RAT-Usage", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_UE_LOCAL_IP_ADDRESS: {"name": "3GPP-UE-Local-IP-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_UE_SOURCE_PORT: {"name": "3GPP-UE-Source-Port", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ABORT_CAUSE: {"name": "Abort-Cause", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_CHARGING_ADDRESS: {"name": "Access-Network-Charging-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_CHARGING_IDENTIFIER: {"name": "Access-Network-Charging-Identifier", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCESS_NETWORK_CHARGING_IDENTIFIER_VALUE: {"name": "Access-Network-Charging-Identifier-Value", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AF_APPLICATION_IDENTIFIER: {"name": "AF-Application-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AF_CHARGING_IDENTIFIER: {"name": "AF-Charging-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHORIZATION_TOKEN: {"name": "Authorization-Token", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_DESCRIPTION: {"name": "Flow-Description", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_GROUPING: {"name": "Flow-Grouping", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_NUMBER: {"name": "Flow-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOWS: {"name": "Flows", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_STATUS: {"name": "Flow-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FLOW_USAGE: {"name": "Flow-Usage", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SPECIFIC_ACTION: {"name": "Specific-Action", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_REQUESTED_BANDWIDTH_DL: {"name": "Max-Requested-Bandwidth-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_REQUESTED_BANDWIDTH_UL: {"name": "Max-Requested-Bandwidth-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_COMPONENT_DESCRIPTION: {"name": "Media-Component-Description", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_COMPONENT_NUMBER: {"name": "Media-Component-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_SUB_COMPONENT: {"name": "Media-Sub-Component", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_TYPE: {"name": "Media-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RR_BANDWIDTH: {"name": "RR-Bandwidth", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RS_BANDWIDTH: {"name": "RS-Bandwidth", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIP_FORKING_INDICATION: {"name": "SIP-Forking-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CODEC_DATA: {"name": "Codec-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_URN: {"name": "Service-URN", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACCEPTABLE_SERVICE_INFO: {"name": "Acceptable-Service-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_INFO_STATUS: {"name": "Service-Info-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MPS_IDENTIFIER: {"name": "MPS-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AF_SIGNALLING_PROTOCOL: {"name": "AF-Signalling-Protocol", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SPONSORED_CONNECTIVITY_DATA: {"name": "Sponsored-Connectivity-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SPONSOR_IDENTITY: {"name": "Sponsor-Identity", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APPLICATION_SERVICE_PROVIDER_IDENTITY: {"name": "Application-Service-Provider-Identity", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RX_REQUEST_TYPE: {"name": "Rx-Request-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIN_REQUESTED_BANDWIDTH_DL: {"name": "Min-Requested-Bandwidth-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIN_REQUESTED_BANDWIDTH_UL: {"name": "Min-Requested-Bandwidth-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUIRED_ACCESS_INFO: {"name": "Required-Access-Info", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_DOMAIN_ID: {"name": "IP-Domain-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GCS_IDENTIFIER: {"name": "GCS-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SHARING_KEY_DL: {"name": "Sharing-Key-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SHARING_KEY_UL: {"name": "Sharing-Key-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RETRY_INTERVAL: {"name": "Retry-Interval", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SPONSORING_ACTION: {"name": "Sponsoring-Action", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_SUPPORTED_BANDWIDTH_DL: {"name": "Max-Supported-Bandwidth-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_SUPPORTED_BANDWIDTH_UL: {"name": "Max-Supported-Bandwidth-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIN_DESIRED_BANDWIDTH_DL: {"name": "Min-Desired-Bandwidth-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MIN_DESIRED_BANDWIDTH_UL: {"name": "Min-Desired-Bandwidth-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MCPTT_IDENTIFIER: {"name": "MCPTT-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_AUTHORIZATION_INFO: {"name": "Service-Authorization-Info", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MEDIA_COMPONENT_STATUS: {"name": "Media-Component-Status", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIORITY_SHARING_INDICATOR: {"name": "Priority-Sharing-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AF_REQUESTED_DATA: {"name": "AF-Requested-Data", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTENT_VERSION: {"name": "Content-Version", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRE_EMPTION_CONTROL_INFO: {"name": "Pre-emption-Control-Info", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MAX_REQUESTED_BW_DL: {"name": "Extended-Max-Requested-BW-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MAX_REQUESTED_BW_UL: {"name": "Extended-Max-Requested-BW-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MAX_SUPPORTED_BW_DL: {"name": "Extended-Max-Supported-BW-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MAX_SUPPORTED_BW_UL: {"name": "Extended-Max-Supported-BW-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MIN_DESIRED_BW_DL: {"name": "Extended-Min-Desired-BW-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MIN_DESIRED_BW_UL: {"name": "Extended-Min-Desired-BW-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MIN_REQUESTED_BW_DL: {"name": "Extended-Min-Requested-BW-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_MIN_REQUESTED_BW_UL: {"name": "Extended-Min-Requested-BW-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MCVIDEO_IDENTIFIER: {"name": "MCVideo-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_CONTENT_IDENTIFIER: {"name": "IMS-Content-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IMS_CONTENT_TYPE: {"name": "IMS-Content-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_VISITED_NETWORK_IDENTIFIER: {"name": "Visited-Network-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PUBLIC_IDENTITY: {"name": "Public-Identity", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVER_NAME: {"name": "Server-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVER_CAPABILITIES: {"name": "Server-Capabilities", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MANDATORY_CAPABILITY: {"name": "Mandatory-Capability", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_OPTIONAL_CAPABILITY: {"name": "Optional-Capability", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CX_USER_DATA: {"name": "Cx-User-Data", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_NUMBER_AUTH_ITEMS: {"name": "3GPP-SIP-Number-Auth-Items", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_AUTHENTICATION_SCHEME: {"name": "3GPP-SIP-Authentication-Scheme", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_AUTHENTICATE: {"name": "3GPP-SIP-Authenticate", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_AUTHORIZATION: {"name": "3GPP-SIP-Authorization", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIP_AUTHENTICATION_CONTEXT: {"name": "SIP-Authentication-Context", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_AUTH_DATA_ITEM: {"name": "3GPP-SIP-Auth-Data-Item", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_SIP_ITEM_NUMBER: {"name": "3GPP-SIP-Item-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVER_ASSIGNMENT_TYPE: {"name": "Server-Assignment-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DEREGISTRATION_REASON: {"name": "Deregistration-Reason", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REASON_CODE: {"name": "Reason-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REASON_INFO: {"name": "Reason-Info", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_INFORMATION: {"name": "Charging-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIMARY_EVENT_CHARGING_FUNCTION_NAME: {"name": "Primary-Event-Charging-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SECONDARY_EVENT_CHARGING_FUNCTION_NAME: {"name": "Secondary-Event-Charging-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIMARY_CHARGING_COLLECTION_FUNCTION_NAME: {"name": "Primary-Charging-Collection-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SECONDARY_CHARGING_COLLECTION_FUNCTION_NAME: {"name": "Secondary-Charging-Collection-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_AUTHORIZATION_TYPE: {"name": "User-Authorization-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_DATA_ALREADY_AVAILABLE: {"name": "User-Data-Already-Available", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONFIDENTIALITY_KEY: {"name": "Confidentiality-Key", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INTEGRITY_KEY: {"name": "Integrity-Key", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_DATA_REQUEST_TYPE_OBSOLETE: {"name": "User-Data-Request-Type-OBSOLETE", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUPPORTED_FEATURES: {"name": "Supported-Features", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FEATURE_LIST_ID: {"name": "Feature-List-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FEATURE_LIST: {"name": "Feature-List", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUPPORTED_APPLICATIONS: {"name": "Supported-Applications", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSOCIATED_IDENTITIES: {"name": "Associated-Identities", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ORIGINATING_REQUEST: {"name": "Originating-Request", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WILDCARDED_PSI: {"name": "Wildcarded-PSI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SIP_DIGEST_AUTHENTICATE: {"name": "SIP-Digest-Authenticate", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WILDCARDED_IMPU: {"name": "Wildcarded-IMPU", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UAR_FLAGS: {"name": "UAR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOOSE_ROUTE_INDICATION: {"name": "Loose-Route-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCSCF_RESTORATION_INFO: {"name": "SCSCF-Restoration-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PATH: {"name": "Path", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONTACT: {"name": "Contact", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSCRIPTION_INFO: {"name": "Subscription-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CALL_ID_SIP_HEADER: {"name": "Call-ID-SIP-Header", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_FROM_SIP_HEADER: {"name": "From-SIP-Header", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TO_SIP_HEADER: {"name": "To-SIP-Header", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RECORD_ROUTE: {"name": "Record-Route", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ASSOCIATED_REGISTERED_IDENTITIES: {"name": "Associated-Registered-Identities", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MULTIPLE_REGISTRATION_INDICATION: {"name": "Multiple-Registration-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RESTORATION_INFO: {"name": "Restoration-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SESSION_PRIORITY: {"name": "Session-Priority", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDENTITY_WITH_EMERGENCY_REGISTRATION: {"name": "Identity-with-Emergency-Registration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIVILEDGED_SENDER_INDICATION: {"name": "Priviledged-Sender-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LIA_FLAGS: {"name": "LIA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_INITIAL_CSEQ_SEQUENCE_NUMBER: {"name": "Initial-CSeq-Sequence-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SAR_FLAGS: {"name": "SAR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALLOWED_WAF_WWSF_IDENTITIES: {"name": "Allowed-WAF-WWSF-Identities", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WEBRTC_AUTHENTICATION_FUNCTION_NAME: {"name": "WebRTC-Authentication-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WEBRTC_WEB_SERVER_FUNCTION_NAME: {"name": "WebRTC-Web-Server-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_USER_IDENTITY: {"name": "User-Identity", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MSISDN: {"name": "MSISDN", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SH_USER_DATA: {"name": "Sh-User-Data", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DATA_REFERENCE: {"name": "Data-Reference", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVICE_INDICATION: {"name": "Service-Indication", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBS_REQ_TYPE: {"name": "Subs-Req-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_DOMAIN: {"name": "Requested-Domain", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CURRENT_LOCATION: {"name": "Current-Location", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDENTITY_SET: {"name": "Identity-Set", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXPIRY_TIME: {"name": "Expiry-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SEND_DATA_INDICATION: {"name": "Send-Data-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DSAI_TAG: {"name": "DSAI-Tag", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ONE_TIME_NOTIFICATION: {"name": "One-Time-Notification", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_NODES: {"name": "Requested-Nodes", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVING_NODE_INDICATION: {"name": "Serving-Node-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REPOSITORY_DATA_ID: {"name": "Repository-Data-ID", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SEQUENCE_NUMBER: {"name": "Sequence-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRE_PAGING_SUPPORTED: {"name": "Pre-paging-Supported", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_LOCAL_TIME_ZONE_INDICATION: {"name": "Local-Time-Zone-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UDR_FLAGS: {"name": "UDR-Flags", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_WLAN_APN_ID: {"name": "3GPP-WLAN-APN-Id", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHENTICATION_METHOD: {"name": "Authentication-Method", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHENTICATION_INFORMATION_SIM: {"name": "Authentication-Information-SIM", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHORIZATION_INFORMATION_SIM: {"name": "Authorization-Information-SIM", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_USER_DATA: {"name": "WLAN-User-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_DATA: {"name": "Charging-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_ACCESS: {"name": "WLAN-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_3GPP_IP_ACCESS: {"name": "WLAN-3GPP-IP-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_AUTHORIZED: {"name": "APN-Authorized", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_APN_BARRING_TYPE: {"name": "APN-Barring-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_WLAN_DIRECT_IP_ACCESS: {"name": "WLAN-Direct-IP-Access", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SESSION_REQUEST_TYPE: {"name": "Session-Request-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ROUTING_POLICY: {"name": "Routing-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAX_REQUESTED_BANDWIDTH: {"name": "Max-Requested-Bandwidth", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_CHARACTERISTICS: {"name": "Charging-Characteristics", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CHARGING_NODES: {"name": "Charging-Nodes", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PRIMARY_OCS_CHARGING_FUNCTION_NAME: {"name": "Primary-OCS-Charging-Function-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SECONDARY_OCS_CHARGING_FUNCTION_NAME: {"name": "Secondary-OCS-Charging-Function-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_3GPP_AAA_SERVER_NAME: {"name": "3GPP-AAA-Server-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_NUMBER_ACCESSES: {"name": "Maximum-Number-Accesses", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI: {"name": "TMGI", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUIRED_MBMS_BEARER_CAPABILITIES: {"name": "Required-MBMS-Bearer-Capabilities", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_STARTSTOP_INDICATION: {"name": "MBMS-StartStop-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_SERVICE_AREA: {"name": "MBMS-Service-Area", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_SESSION_DURATION: {"name": "MBMS-Session-Duration", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ALTERNATIVE_APN: {"name": "Alternative-APN", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_SERVICE_TYPE: {"name": "MBMS-Service-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_2G_3G_INDICATOR: {"name": "MBMS-2G-3G-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_SESSION_IDENTITY: {"name": "MBMS-Session-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RAI: {"name": "RAI", "type": AvpUtf8String, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ADDITIONAL_MBMS_TRACE_INFO: {"name": "Additional-MBMS-Trace-Info", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_TIME_TO_DATA_TRANSFER: {"name": "MBMS-Time-To-Data-Transfer", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_SESSION_REPETITION_NUMBER: {"name": "MBMS-Session-Repetition-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_REQUIRED_QOS: {"name": "MBMS-Required-QoS", "type": AvpUtf8String, "vendor": 10415},
    AVP_TGPP_MBMS_COUNTING_INFORMATION: {"name": "MBMS-Counting-Information", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_USER_DATA_MODE_INDICATION: {"name": "MBMS-User-Data-Mode-Indication", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_GGSN_ADDRESS: {"name": "MBMS-GGSN-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_GGSN_IPV6_ADDRESS: {"name": "MBMS-GGSN-IPv6-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BMSC_SSM_IP_ADDRESS: {"name": "MBMS-BMSC-SSM-IP-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BMSC_SSM_IPV6_ADDRESS: {"name": "MBMS-BMSC-SSM-IPv6-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_FLOW_IDENTIFIER: {"name": "MBMS-Flow-Identifier", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_CN_IP_MULTICAST_DISTRIBUTION: {"name": "CN-IP-Multicast-Distribution", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_HC_INDICATOR: {"name": "MBMS-HC-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_ACCESS_INDICATOR: {"name": "MBMS-Access-Indicator", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_GW_SSM_IP_ADDRESS: {"name": "MBMS-GW-SSM-IP-Address", "type": AvpAddress, "vendor": 10415},
    AVP_TGPP_MBMS_GW_SSM_IPV6_ADDRESS: {"name": "MBMS-GW-SSM-IPv6-Address", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MBMS_BMSC_SSM_UDP_PORT: {"name": "MBMS-BMSC-SSM-UDP-Port", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MBMS_GW_UDP_PORT: {"name": "MBMS-GW-UDP-Port", "type": AvpOctetString, "vendor": 10415},
    AVP_TGPP_MBMS_GW_UDP_PORT_INDICATOR: {"name": "MBMS-GW-UDP-Port-Indicator", "type": AvpEnumerated, "vendor": 10415},
    AVP_TGPP_MBMS_DATA_TRANSFER_START: {"name": "MBMS-Data-Transfer-Start", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_DATA_TRANSFER_STOP: {"name": "MBMS-Data-Transfer-Stop", "type": AvpUnsigned64, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_FLAGS: {"name": "MBMS-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RESTART_COUNTER: {"name": "Restart-Counter", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DIAGNOSTIC_INFO: {"name": "Diagnostic-Info", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_CELL_LIST: {"name": "MBMS-Cell-List", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSESSION_DECISION_INFO: {"name": "Subsession-Decision-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSESSION_ENFORCEMENT_INFO: {"name": "Subsession-Enforcement-Info", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSESSION_ID: {"name": "Subsession-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SUBSESSION_OPERATION: {"name": "Subsession-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MULTIPLE_BBERF_ACTION: {"name": "Multiple-BBERF-Action", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SC_ADDRESS: {"name": "SC-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_RP_UI: {"name": "SM-RP-UI", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TFR_FLAGS: {"name": "TFR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_FAILURE_CAUSE: {"name": "SM-Delivery-Failure-Cause", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_ENUMERATED_DELIVERY_FAILURE_CAUSE: {"name": "SM-Enumerated-Delivery-Failure-Cause", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DIAGNOSTIC_INFO: {"name": "SM-Diagnostic-Info", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_TIMER: {"name": "SM-Delivery-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_START_TIME: {"name": "SM-Delivery-Start-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_RP_MTI: {"name": "SM-RP-MTI", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_RP_SMEA: {"name": "SM-RP-SMEA", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SRR_FLAGS: {"name": "SRR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_NOT_INTENDED: {"name": "SM-Delivery-Not-Intended", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MWD_STATUS: {"name": "MWD-Status", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MME_ABSENT_USER_DIAGNOSTIC_SM: {"name": "MME-Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MSC_ABSENT_USER_DIAGNOSTIC_SM: {"name": "MSC-Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGSN_ABSENT_USER_DIAGNOSTIC_SM: {"name": "SGSN-Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_OUTCOME: {"name": "SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MME_SM_DELIVERY_OUTCOME: {"name": "MME-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MSC_SM_DELIVERY_OUTCOME: {"name": "MSC-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SGSN_SM_DELIVERY_OUTCOME: {"name": "SGSN-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IP_SM_GW_SM_DELIVERY_OUTCOME: {"name": "IP-SM-GW-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_DELIVERY_CAUSE: {"name": "SM-Delivery-Cause", "type": AvpEnumerated, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ABSENT_USER_DIAGNOSTIC_SM: {"name": "Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RDR_FLAGS: {"name": "RDR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_UE_AVAILABILITY_TIME: {"name": "Maximum-UE-Availability-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MAXIMUM_RETRANSMISSION_TIME: {"name": "Maximum-Retransmission-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REQUESTED_RETRANSMISSION_TIME: {"name": "Requested-Retransmission-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMS_GMSC_ADDRESS: {"name": "SMS-GMSC-Address", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMS_GMSC_ALERT_EVENT: {"name": "SMS-GMSC-Alert-Event", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_ABSENT_USER_DIAGNOSTIC_SM: {"name": "SMSF-3GPP-Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_ABSENT_USER_DIAGNOSTIC_SM: {"name": "SMSF-Non-3GPP-Absent-User-Diagnostic-SM", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_SM_DELIVERY_OUTCOME: {"name": "SMSF-3GPP-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_SM_DELIVERY_OUTCOME: {"name": "SMSF-Non-3GPP-SM-Delivery-Outcome", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_NUMBER: {"name": "SMSF-3GPP-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_NUMBER: {"name": "SMSF-Non-3GPP-Number", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_NAME: {"name": "SMSF-3GPP-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_NAME: {"name": "SMSF-Non-3GPP-Name", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_REALM: {"name": "SMSF-3GPP-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_REALM: {"name": "SMSF-Non-3GPP-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_3GPP_ADDRESS: {"name": "SMSF-3GPP-Address", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SMSF_NON_3GPP_ADDRESS: {"name": "SMSF-Non-3GPP-Address", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BMSC_ADDRESS: {"name": "BMSC-Address", "type": AvpAddress, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BMSC_PORT: {"name": "BMSC-Port", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BEARER_EVENT: {"name": "MBMS-Bearer-Event", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BEARER_EVENT_NOTIFICATION: {"name": "MBMS-Bearer-Event-Notification", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BEARER_REQUEST: {"name": "MBMS-Bearer-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BEARER_RESPONSE: {"name": "MBMS-Bearer-Response", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_BEARER_RESULT: {"name": "MBMS-Bearer-Result", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MBMS_START_TIME: {"name": "MBMS-Start-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RADIO_FREQUENCY: {"name": "Radio-Frequency", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_ALLOCATION_REQUEST: {"name": "TMGI-Allocation-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_ALLOCATION_RESPONSE: {"name": "TMGI-Allocation-Response", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_ALLOCATION_RESULT: {"name": "TMGI-Allocation-Result", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_DEALLOCATION_REQUEST: {"name": "TMGI-Deallocation-Request", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_DEALLOCATION_RESPONSE: {"name": "TMGI-Deallocation-Response", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_DEALLOCATION_RESULT: {"name": "TMGI-Deallocation-Result", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_EXPIRY: {"name": "TMGI-Expiry", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TMGI_NUMBER: {"name": "TMGI-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_MB2U_SECURITY: {"name": "MB2U-Security", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_SUBSCRIPTION_DATA: {"name": "ProSe-Subscription-Data", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_PERMISSION: {"name": "ProSe-Permission", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_ALLOWED_PLMN: {"name": "ProSe-Allowed-PLMN", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_DIRECT_ALLOWED: {"name": "ProSe-Direct-Allowed", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UPR_FLAGS: {"name": "UPR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PNR_FLAGS: {"name": "PNR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_PROSE_INITIAL_LOCATION_INFORMATION: {"name": "ProSe-Initial-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_AUTHORIZED_DISCOVERY_RANGE: {"name": "Authorized-Discovery-Range", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COMMUNICATION_FAILURE_INFORMATION: {"name": "Communication-Failure-Information", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CAUSE_TYPE: {"name": "Cause-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_S1AP_CAUSE: {"name": "S1AP-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RANAP_CAUSE: {"name": "RANAP-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_GMM_CAUSE: {"name": "GMM-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SM_CAUSE: {"name": "SM-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_UE_PER_LOCATION_CONFIGURATION: {"name": "Number-Of-UE-Per-Location-Configuration", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NUMBER_OF_UE_PER_LOCATION_REPORT: {"name": "Number-Of-UE-Per-Location-Report", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UE_COUNT: {"name": "UE-Count", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_BSSGP_CAUSE: {"name": "BSSGP-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SERVING_PLMN_RATE_CONTROL: {"name": "Serving-PLMN-Rate-Control", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_UPLINK_RATE_LIMIT: {"name": "Uplink-Rate-Limit", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_DOWNLINK_RATE_LIMIT: {"name": "Downlink-Rate-Limit", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_EXTENDED_PCO: {"name": "Extended-PCO", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CONNECTION_ACTION: {"name": "Connection-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_NON_IP_DATA: {"name": "Non-IP-Data", "type": AvpOctetString, "mandatory": True, "vendor": 10415},
    AVP_TGPP_SCEF_WAIT_TIME: {"name": "SCEF-Wait-Time", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_CMR_FLAGS: {"name": "CMR-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RRC_CAUSE_COUNTER: {"name": "RRC-Cause-Counter", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_COUNTER_VALUE: {"name": "Counter-Value", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_RRC_COUNTER_TIMESTAMP: {"name": "RRC-Counter-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_TDA_FLAGS: {"name": "TDA-Flags", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDLE_STATUS_INDICATION: {"name": "Idle-Status-Indication", "type": AvpGrouped, "mandatory": True, "vendor": 10415},
    AVP_TGPP_IDLE_STATUS_TIMESTAMP: {"name": "Idle-Status-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 10415},
    AVP_TGPP_ACTIVE_TIME: {"name": "Active-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415},
    AVP_TGPP_REACHABILITY_CAUSE: {"name": "Reachability-Cause", "type": AvpUnsigned32, "mandatory": True, "vendor": 10415}}

AVP_VENDOR_DICTIONARY[13019] = {
    AVP_ETSI_ETSI_EXPERIMENTAL_RESULT_CODE: {"name": "ETSI-Experimental-Result-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_GLOBALLY_UNIQUE_ADDRESS: {"name": "Globally-Unique-Address", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ADDRESS_REALM: {"name": "Address-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_LOGICAL_ACCESS_ID: {"name": "Logical-Access-ID", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_INITIAL_GATE_SETTING: {"name": "Initial-Gate-Setting", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_QOS_PROFILE: {"name": "QoS-Profile", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_IP_CONNECTIVITY_STATUS: {"name": "IP-Connectivity-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ACCESS_NETWORK_TYPE: {"name": "Access-Network-Type", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_AGGREGATION_NETWORK_TYPE: {"name": "Aggregation-Network-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_MAXIMUM_ALLOWED_BANDWIDTH_UL: {"name": "Maximum-Allowed-Bandwidth-UL", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_MAXIMUM_ALLOWED_BANDWIDTH_DL: {"name": "Maximum-Allowed-Bandwidth-DL", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_MAXIMUM_PRIORITY_DEPRECATED: {"name": "Maximum-Priority-DEPRECATED", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_TRANSPORT_CLASS: {"name": "Transport-Class", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_APPLICATION_CLASS_ID: {"name": "Application-Class-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_PHYSICAL_ACCESS_ID: {"name": "Physical-Access-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_INITIAL_GATE_SETTING_ID: {"name": "Initial-Gate-Setting-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_QOS_PROFILE_ID: {"name": "QoS-Profile-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_LOCATION_INFORMATION: {"name": "ETSI-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_RACS_CONTACT_POINT: {"name": "RACS-Contact-Point", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_TERMINAL_TYPE: {"name": "Terminal-Type", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_REQUESTED_INFORMATION_353: {"name": "Requested-Information-353", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_EVENT_TYPE_354: {"name": "ETSI-Event-Type-354", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_CIVIC_LOCATION: {"name": "Civic-Location", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_GEOSPATIAL_LOCATION: {"name": "Geospatial-Location", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_SESSION_BUNDLE_ID: {"name": "Session-Bundle-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_EVENT_TYPE_420: {"name": "ETSI-Event-Type-420", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_BINDING_INFORMATION: {"name": "Binding-information", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_BINDING_INPUT_LIST: {"name": "Binding-Input-List", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_BINDING_OUTPUT_LIST: {"name": "Binding-Output-List", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_V6_TRANSPORT_ADDRESS: {"name": "V6-Transport-Address", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_V4_TRANSPORT_ADDRESS: {"name": "V4-Transport-Address", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_PORT_NUMBER: {"name": "Port-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_RESERVATION_CLASS: {"name": "Reservation-Class", "type": AvpUnsigned32, "mandatory": True, "vendor": 13019},
    AVP_ETSI_REQUESTED_INFORMATION_457: {"name": "Requested-Information-457", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_RESERVATION_PRIORITY: {"name": "Reservation-Priority", "type": AvpEnumerated, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_SERVICE_CLASS: {"name": "ETSI-Service-Class", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_MEDIA_AUTHORIZATION_CONTEXT_ID: {"name": "Media-Authorization-Context-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_LINE_IDENTIFIER: {"name": "Line-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_SIP_AUTHENTICATE: {"name": "ETSI-SIP-Authenticate", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_SIP_AUTHORIZATION: {"name": "ETSI-SIP-Authorization", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_SIP_AUTHENTICATION_INFO: {"name": "ETSI-SIP-Authentication-Info", "type": AvpGrouped, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_REALM: {"name": "ETSI-Digest-Realm", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_NONCE: {"name": "ETSI-Digest-Nonce", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_DOMAIN: {"name": "ETSI-Digest-Domain", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_OPAQUE: {"name": "ETSI-Digest-Opaque", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_STALE: {"name": "ETSI-Digest-Stale", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_ALGORITHM: {"name": "ETSI-Digest-Algorithm", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_QOP: {"name": "ETSI-Digest-QoP", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_HA1: {"name": "ETSI-Digest-HA1", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_AUTH_PARAM: {"name": "ETSI-Digest-Auth-Param", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_USERNAME: {"name": "ETSI-Digest-Username", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_URI: {"name": "ETSI-Digest-URI", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_RESPONSE: {"name": "ETSI-Digest-Response", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_CNONCE: {"name": "ETSI-Digest-CNonce", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_NONCE_COUNT: {"name": "ETSI-Digest-Nonce-Count", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_METHOD: {"name": "ETSI-Digest-Method", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_ENTITY_BODY_HASH: {"name": "ETSI-Digest-Entity-Body-Hash", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_NEXTNONCE: {"name": "ETSI-Digest-Nextnonce", "type": AvpUtf8String, "mandatory": True, "vendor": 13019},
    AVP_ETSI_ETSI_DIGEST_RESPONSE_AUTH: {"name": "ETSI-Digest-Response-Auth", "type": AvpUtf8String, "mandatory": True, "vendor": 13019}}

AVP_VENDOR_DICTIONARY[13421] = {}
AVP_VENDOR_DICTIONARY[81000] = {}
AVP_VENDOR_DICTIONARY[16777216] = {}

AVP_VENDOR_DICTIONARY[42] = {
    AVP_SUN_PING_TIMESTAMP_SECS: {"name": "Ping-Timestamp-Secs", "type": AvpUnsigned32, "mandatory": True, "vendor": 42},
    AVP_SUN_PING_TIMESTAMP_USECS: {"name": "Ping-Timestamp-Usecs", "type": AvpUnsigned32, "mandatory": True, "vendor": 42},
    AVP_SUN_PING_TIMESTAMP: {"name": "Ping-Timestamp", "type": AvpGrouped, "mandatory": True, "vendor": 42}}

AVP_VENDOR_DICTIONARY[5535] = {
    AVP_TGPP2_ACCESS_NETWORK_PHYSICAL_ACCESS_ID_REALM: {"name": "Access-Network-Physical-Access-ID-Realm", "type": AvpOctetString, "vendor": 5535},
    AVP_TGPP2_ACCESS_NETWORK_PHYSICAL_ACCESS_ID_VALUE: {"name": "Access-Network-Physical-Access-ID-Value", "type": AvpOctetString, "vendor": 5535},
    AVP_TGPP2_ACCESS_NETWORK_PHYSICAL_ACCESS_ID: {"name": "Access-Network-Physical-Access-ID", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_FLOW_OPERATION: {"name": "Flow-Operation", "type": AvpEnumerated, "vendor": 5535},
    AVP_TGPP2_3GPP2_CHARGING_RULE_INSTALL: {"name": "3GPP2-Charging-Rule-Install", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_3GPP2_CHARGING_RULE_DEFINITION: {"name": "3GPP2-Charging-Rule-Definition", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_3GPP2_EVENT_TRIGGER: {"name": "3GPP2-Event-Trigger", "type": AvpEnumerated, "vendor": 5535},
    AVP_TGPP2_3GPP2_QOS_INFORMATION: {"name": "3GPP2-QoS-Information", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_3GPP2_CHARGING_RULE_REPORT: {"name": "3GPP2-Charging-Rule-Report", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_AGW_IP_ADDRESS: {"name": "AGW-IP-Address", "type": AvpAddress, "vendor": 5535},
    AVP_TGPP2_AGW_IPV6_ADDRESS: {"name": "AGW-IPv6-Address", "type": AvpAddress, "vendor": 5535},
    AVP_TGPP2_3GPP2_RAT_TYPE: {"name": "3GPP2-RAT-Type", "type": AvpEnumerated, "vendor": 5535},
    AVP_TGPP2_FLOW_INFO: {"name": "Flow-Info", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_FLOW_IDENTIFIER: {"name": "Flow-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 5535},
    AVP_TGPP2_GRANTED_QOS: {"name": "Granted-QoS", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_REQUESTED_QOS: {"name": "Requested-QoS", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_FLOW_DESCRIPTION_INFO: {"name": "Flow-Description-Info", "type": AvpGrouped, "vendor": 5535},
    AVP_TGPP2_RULE_REASON_CODE: {"name": "Rule-Reason-Code", "type": AvpEnumerated, "vendor": 5535},
    AVP_TGPP2_AGW_MCC_MNC: {"name": "AGW-MCC-MNC", "type": AvpUtf8String, "mandatory": True, "vendor": 5535},
    AVP_TGPP2_3GPP2_BSID: {"name": "3GPP2-BSID", "type": AvpUtf8String, "mandatory": True, "vendor": 5535}}

AVP_VENDOR_DICTIONARY[193] = {
    AVP_ERICSSON_ACC_SERVICE_TYPE: {"name": "Acc-Service-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SSO_STATUS: {"name": "SSO-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_IMS_SERVICE_IDENTIFICATION: {"name": "IMS-Service-Identification", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ERICSSON_SERVICE_INFORMATION: {"name": "Ericsson_Service_Information", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACTIVITY_INFORMATION: {"name": "Activity-Information", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_FEATURE_TAG: {"name": "Feature-Tag", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_RULE_SPACE_SUGGESTION: {"name": "Rule-Space-Suggestion", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_RULE_SPACE_DECISION: {"name": "Rule-Space-Decision", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_BEARER_CONTROL_OPTIONS: {"name": "Bearer-Control-Options", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_PDP_CONTEXT_TYPE: {"name": "PDP-context-type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACTIVE_TIME_REPORTING: {"name": "Active-Time-Reporting", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACTIVE_TIME_REPORT: {"name": "Active-Time-Report", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACTIVE_TIME_REPORT_START_TIME: {"name": "Active-Time-Report-Start-Time", "type": AvpTime, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACTIVE_TIME_REPORT_END_TIME: {"name": "Active-Time-Report-End-Time", "type": AvpTime, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TIME_QUOTA_MEASUREMENT: {"name": "Time-Quota-Measurement", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TIME_QUOTA_METHOD: {"name": "Time-Quota-Method", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TIME_QUOTA_RESOLUTION: {"name": "Time-Quota-Resolution", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TIME_QUOTA_INACTIVITY_TIME: {"name": "Time-Quota-Inactivity-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_USER_REDIRECTED: {"name": "User-Redirected", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_URL_MODIFIER: {"name": "URL-Modifier", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_GPRS_ROAMING_STATUS: {"name": "GPRS-Roaming-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ERICSSON_WILDCARDED_PUBLIC_IDENTITY: {"name": "Ericsson-Wildcarded-Public-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SIP_RINGING_TIMESTAMP: {"name": "SIP-Ringing-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_CURRENCY_CODE: {"name": "SCAP-Currency-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SUBSCRIPTION_ID: {"name": "SCAP-Subscription-Id", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SUBSCRIPTION_ID_DATA: {"name": "SCAP-Subscription-Id-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SUBSCRIPTION_ID_TYPE: {"name": "SCAP-Subscription-Id-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ORIGINAL_SUBSCRIPTION_ID: {"name": "Original-Subscription-Id", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ABNORMAL_TERMINATION_REASON: {"name": "Abnormal-Termination-Reason", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_FINAL_UNIT_INDICATION: {"name": "SCAP-Final-Unit-Indication", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_GRANTED_SERVICE_UNIT: {"name": "SCAP-Granted-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_COST: {"name": "Cost", "type": AvpFloat64, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_COST_INFORMATION: {"name": "SCAP-Cost-Information", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ACCOUNTING_CORRELATION_ID: {"name": "Accounting-Correlation-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_REQUESTED_SERVICE_UNIT: {"name": "SCAP-Requested-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SERVICE_PARAMETER_INFO: {"name": "SCAP-Service-Parameter-Info", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SERVICE_PARAMETER_TYPE: {"name": "SCAP-Service-Parameter-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_SERVICE_PARAMETER_VALUE: {"name": "SCAP-Service-Parameter-Value", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_EVENT_TIMESTAMP: {"name": "SCAP-Event-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_UNIT_TYPE: {"name": "SCAP-Unit-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_UNIT_VALUE: {"name": "SCAP-Unit-Value", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_USED_SERVICE_UNIT: {"name": "SCAP-Used-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_CHECK_BALANCE_RESULT: {"name": "SCAP-Check-Balance-Result", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_REQUESTED_ACTION: {"name": "SCAP-Requested-Action", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_EXPONENT: {"name": "SCAP-Exponent", "type": AvpInteger32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCAP_VALUE_DIGITS: {"name": "SCAP-Value-Digits", "type": AvpUnsigned64, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_REQUESTED_SERVICE: {"name": "Requested-Service", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CHARGING_RULE_AUTHORIZATION: {"name": "Charging-Rule-Authorization", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_AUTHORIZATION_STATE: {"name": "Authorization-State", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_AUTHORIZATION_STATE_CHANGE_TIME: {"name": "Authorization-State-Change-Time", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_NEXT_AUTHORIZATION_STATE: {"name": "Next-Authorization-State", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_GX_CAPABILITY_LIST: {"name": "Gx-Capability-List", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_MMT_INFORMATION: {"name": "MMT-Information", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_RESULT_CODE_EXTENSION: {"name": "Result-Code-Extension", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SUBSCRIPTION_ID_LOCATION: {"name": "Subscription-Id-Location", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_OTHER_PARTY_ID: {"name": "Other-Party-Id", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_OTHER_PARTY_ID_NATURE: {"name": "Other-Party-Id-Nature", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_OTHER_PARTY_ID_DATA: {"name": "Other-Party-Id-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_OTHER_PARTY_ID_TYPE: {"name": "Other-Party-Id-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SERVICE_PROVIDER_ID: {"name": "Service-Provider-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRAFFIC_CASE: {"name": "Traffic-Case", "type": AvpInteger32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_RELATED_ICID: {"name": "Related-ICID", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SUPPLEMENTARY_SERVICE_INFORMATION: {"name": "Supplementary-Service-Information", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SUPPLEMENTARY_SERVICE_IDENTITY: {"name": "Supplementary-Service-Identity", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SUPPLEMENTARY_SERVICE_ACTION: {"name": "Supplementary-Service-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_REDIRECTING_PARTY_ADDRESS: {"name": "Redirecting-Party-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CALLING_PARTY_ADDRESS_PRESENTATION_STATUS: {"name": "Calling-Party-Address-Presentation-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CALLED_ASSERTED_IDENTITY_PRESENTATION_STATUS: {"name": "Called-Asserted-Identity-Presentation-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CREDIT_INSTANCE_ID: {"name": "Credit-Instance-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SERVICE_START_TIMESTAMP: {"name": "Service-Start-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CUMULATIVE_USED_SERVICE_UNIT: {"name": "Cumulative-Used-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_ERICSSON_CUSTOMER_ID: {"name": "Ericsson-Customer-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_FROM_HEADER: {"name": "From-Header", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SECONDARY_DIGEST_HA1: {"name": "Secondary-Digest-HA1", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SIP_RINGING_TIMESTAMP_FRACTION: {"name": "SIP-Ringing-Timestamp-Fraction", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_AUTHENTICATION_METHOD: {"name": "Authentication_Method", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_FROM_HEADER_PRESENTATION_STATUS: {"name": "From-Header-Presentation-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRANSACTION_INFO: {"name": "Transaction_Info", "type": AvpOctetString, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRANSACTION_TYPE: {"name": "Transaction-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRANSACTION_DATA_NAME: {"name": "Transaction-Data-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRANSACTION_DATA_VALUE: {"name": "Transaction-Data-Value", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_CHARGING_PROFILE_ID: {"name": "Charging-Profile-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SERVICE_NUMBER_TYPE: {"name": "Service-Number-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SCC_SERVICE_IDENTITY: {"name": "SCC_Service_Identity", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SDD_TADS_DECISION: {"name": "SDD-TADS-Decision", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_SERVED_USER: {"name": "Served_User", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TENANT: {"name": "Tenant", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_UHTZ_OFFSET: {"name": "UHTZ-Offset", "type": AvpUtf8String, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_AS_TYPE: {"name": "AS-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 193},
    AVP_ERICSSON_TRANSACTION_SIP_MESSAGE: {"name": "Transaction-SIP-Message", "type": AvpUtf8String, "mandatory": True, "vendor": 193}}

AVP_VENDOR_DICTIONARY[5771] = {
    AVP_CISCO_CISCO_FLOW_DESCRIPTION_507: {"name": "Cisco-Flow-Description-507", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_CHARGING_RULE_DEFINITION: {"name": "Cisco-Charging-Rule-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_DEFINITION: {"name": "Content-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_POLICY_DEFINITION: {"name": "Billing-Policy-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_DEFINITION: {"name": "Policy-Map-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_DEFINITION: {"name": "Service-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_POLICY_MAP: {"name": "Content-Policy-Map", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_INFO: {"name": "Service-Info", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_PLAN_DEFINITION: {"name": "Billing-Plan-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VOLUME_THRESHOLD: {"name": "Volume-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_TIME_THRESHOLD: {"name": "Time-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_IDLE_TIMER: {"name": "Content-Idle-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP_UPLINK: {"name": "Nexthop-Uplink", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP_DOWNLINK: {"name": "Nexthop-Downlink", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_L7_PARSE_PROTOCOL_TYPE: {"name": "L7-Parse-Protocol-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_STATUS: {"name": "Service-Status", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_NAME: {"name": "Service-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_POLICY_NAME: {"name": "Billing-Policy-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_NAME: {"name": "Policy-Map-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_MATCH: {"name": "Policy-Map-Match", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_MATCH_STRING: {"name": "Match-String", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ATTRIBUTE_STRING: {"name": "Attribute-String", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ONLINE_BILLING_BASIS: {"name": "Online-Billing-Basis", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_ACTIVATION: {"name": "Service-Activation", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CDR_VOLUME_THRESHOLD: {"name": "CDR-Volume-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CDR_TIME_THRESHOLD: {"name": "CDR-Time-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ADVICE_OF_CHARGE: {"name": "Advice-Of-Charge", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_APPEND_URL: {"name": "Append-URL", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONFIRM_TOKEN_131099: {"name": "Confirm-Token-131099", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_SERVICE_CLASS: {"name": "Cisco-Service-Class", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_IDLE_TIME: {"name": "Service-Idle-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_OWNER_ID: {"name": "Owner-Id", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_OWNER_NAME: {"name": "Owner-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ONLINE_PASSTHROUGH_QUOTA: {"name": "Online-Passthrough-Quota", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ONLINE_REAUTHORIZATION_THRESHOLD: {"name": "Online-Reauthorization-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ONLINE_REAUTHORIZATION_TIMEOUT: {"name": "Online-Reauthorization-Timeout", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_INITIAL_TIMEOUT: {"name": "Initial-Timeout", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_MAXIMUM_TIMEOUT: {"name": "Maximum-Timeout", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_REFUND_POLICY: {"name": "Refund-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METER_EXCLUDE: {"name": "Meter-Exclude", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METER_INCLUDE_IMAP: {"name": "Meter-Include-Imap", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METERING_GRANULARITY: {"name": "Metering-Granularity", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METER_INCREMENT: {"name": "Meter-Increment", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METER_INITIAL: {"name": "Meter-Initial", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_METER_MINIMUM: {"name": "Meter-Minimum", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VERIFY: {"name": "Verify", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONFIRM_TOKEN_131117: {"name": "Confirm-Token-131117", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_WEIGHT: {"name": "Weight", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_USER_IDLE_TIMER: {"name": "User-Idle-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_PRELOAD_REQ_TYPE: {"name": "Policy-Preload-Req-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_PRELOAD_OBJECT_TYPE: {"name": "Policy-Preload-Object-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_PRELOAD_STATUS: {"name": "Policy-Preload-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CHARGING_RULE_TRIGGER_TYPE: {"name": "Charging-Rule-Trigger-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CHARGING_RULE_EVENT: {"name": "Charging-Rule-Event", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_REPORTING_LEVEL: {"name": "Service-Reporting-Level", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ACCOUNTING: {"name": "Accounting", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ACCOUNTING_CUSTOMER_STRING: {"name": "Accounting-Customer-String", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_L7_PARSE_LENGTH: {"name": "L7-Parse-Length", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_CDR_THRESHOLD: {"name": "Service-CDR-Threshold", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_INTERMEDIATE_CDR_THRESHOLD: {"name": "Intermediate-CDR-Threshold", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CDR_GENERATION_DELAY: {"name": "CDR-Generation-Delay", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_REPLICATE_SESSION: {"name": "Replicate-Session", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_REPLICATE_SESSION_DELAY: {"name": "Replicate-Session-Delay", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_PENDING_TIMER: {"name": "Content-Pending-Timer", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_OPERATION_STATUS: {"name": "Operation-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SUBSCRIBER_IP_SOURCE: {"name": "Subscriber-IP-Source", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP: {"name": "Nexthop", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP_REVERSE: {"name": "Nexthop-Reverse", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CHARGING_RULE_EVENT_TRIGGER: {"name": "Charging-Rule-Event-Trigger", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_PLAN_NAME: {"name": "Billing-Plan-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_FLOW_DESCRIPTION: {"name": "Content-Flow-Description", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_FLOW_FILTER: {"name": "Content-Flow-Filter", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CLIENT_GROUP_ID: {"name": "Client-Group-Id", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ACL_NUMBER: {"name": "ACL-Number", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ACL_NAME: {"name": "ACL-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DESTINATION_IP_ADDRESS: {"name": "Destination-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DESTINATION_MASK: {"name": "Destination-Mask", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_PROTOCOL_ID: {"name": "Protocol-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_START_OF_PORT_RANGE: {"name": "Start-of-Port-Range", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_END_OF_PORT_RANGE: {"name": "End-of-Port-Range", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_NAME: {"name": "Content-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_FAILED_PRELOAD_OBJECT: {"name": "Failed-Preload-Object", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VRF_NAME: {"name": "VRF-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VLAN_ID: {"name": "VLAN-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VOLUME_USAGE: {"name": "Volume-Usage", "type": AvpUnsigned64, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_TIME_USAGE: {"name": "Cisco-Time-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DURATION: {"name": "Duration", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_FIRST_PACKET_TIMESTANP: {"name": "First-Packet-Timestanp", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_LAST_PACKET_TIMESTANP: {"name": "Last-Packet-Timestanp", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_FLOW_DESCRIPTION: {"name": "Cisco-Flow-Description", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_TERMINATE_BEARER: {"name": "Terminate-Bearer", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_RATING_GROUP: {"name": "Service-Rating-Group", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_SCOPE: {"name": "Content-Scope", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_FLOW_STATUS_POLICY_MISMATCH: {"name": "Flow-Status-Policy-Mismatch", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_TYPE: {"name": "Policy-Map-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_MATCH_INSTALL: {"name": "Policy-Map-Match-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_MATCH_REMOVE: {"name": "Policy-Map-Match-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_REPLACE: {"name": "Policy-Map-Replace", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_FLOW_STATUS: {"name": "Cisco-Flow-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_QOS: {"name": "Service-QoS", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_QOS_RATE_LIMIT_UL: {"name": "QoS-Rate-Limit-UL", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_QOS_RATE_LIMIT_DL: {"name": "QoS-Rate-Limit-DL", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_QOS_RATE_LIMIT: {"name": "QoS-Rate-Limit", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_MAX_BANDWIDTH: {"name": "Max-Bandwidth", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RATE_LIMIT_CONFORM_ACTION: {"name": "Rate-Limit-Conform-Action", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RATE_LIMIT_EXCEED_ACTION: {"name": "Rate-Limit-Exceed-Action", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_RATE_LIMIT_ACTION: {"name": "Cisco-Rate-Limit-Action", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_DSCP: {"name": "Cisco-DSCP", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_INSTALL: {"name": "Policy-Map-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_MAP_REMOVE: {"name": "Policy-Map-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_POLICY_INSTALL: {"name": "Billing-Policy-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_POLICY_REMOVE: {"name": "Billing-Policy-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_INSTALL: {"name": "Content-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTENT_REMOVE: {"name": "Content-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_INSTALL: {"name": "Service-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_REMOVE: {"name": "Service-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_PLAN_INSTALL: {"name": "Billing-Plan-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_BILLING_PLAN_REMOVE: {"name": "Billing-Plan-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_POLICY_PRELOAD_ERROR_CODE: {"name": "Policy-Preload-Error-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_MAX_BURST_SIZE: {"name": "Max-Burst-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_FAILED_PRELOAD_OBJ_NAME: {"name": "Failed-Preload-Obj-Name", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_EVENT_TRIGGER_TYPE: {"name": "Cisco-Event-Trigger-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_EVENT_TRIGGER: {"name": "Cisco-Event-Trigger", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_TCP_SYN: {"name": "TCP-SYN", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_EVENT: {"name": "Cisco-Event", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_INTERLEAVED: {"name": "Interleaved", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CONTROL_URL: {"name": "Control-URL", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RELATIVE_URL: {"name": "Relative-URL", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_MINING: {"name": "Mining", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_USER_DEFAULT: {"name": "User-Default", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_PRIORITY: {"name": "Cisco-Priority", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_NAME: {"name": "Domain-Group-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_DEFINITION: {"name": "Domain-Group-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_INSTALL: {"name": "Domain-Group-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_REMOVE: {"name": "Domain-Group-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_ACTIVATION: {"name": "Domain-Group-Activation", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DUAL_BILLING_BASIS: {"name": "Dual-Billing-Basis", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DUAL_PASSTHROUGH_QUOTA: {"name": "Dual-Passthrough-Quota", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DUAL_REAUTHORIZATION_THRESHOLD: {"name": "Dual-Reauthorization-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VIRTUAL_ONLINE: {"name": "Virtual-Online", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP_MEDIA: {"name": "Nexthop-Media", "type": AvpAddress, "mandatory": True, "vendor": 5771},
    AVP_CISCO_NEXTHOP_OVERRIDE: {"name": "Nexthop-Override", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QUOTA_CONSUMPTION_TIME: {"name": "Cisco-Quota-Consumption-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CLASS_MAP_NAME: {"name": "Class-Map-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_GROUP_NAME: {"name": "Header-Group-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_GROUP_DEFINITION: {"name": "Header-Group-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_GROUP_INSTALL: {"name": "Header-Group-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_GROUP_REMOVE: {"name": "Header-Group-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_INSERT_NAME: {"name": "Header-Insert-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_FIELD_NAME: {"name": "Header-Field-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_CLASS_NAME: {"name": "Header-Class-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_CLASS_MODE: {"name": "Header-Class-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_CLASS: {"name": "Header-Class", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RADIUS_ATTRIBUTE_TYPE: {"name": "Radius-Attribute-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RADIUS_VSA_VENDOR_ID: {"name": "Radius-Vsa-Vendor-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_RADIUS_VSA_SUBATTRIBUTE_TYPE: {"name": "Radius-Vsa-Subattribute-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_ITEM_RADIUS: {"name": "Header-Item-Radius", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_ITEM: {"name": "Header-Item", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_ITEM_STRING: {"name": "Header-Item-String", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_ITEMS_ENCRYPTED: {"name": "Header-Items-Encrypted", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_INSERT_DEFINITION: {"name": "Header-Insert-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_INSERT_INSTALL: {"name": "Header-Insert-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_INSERT_REMOVE: {"name": "Header-Insert-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_USER_IDLE_POD: {"name": "User-Idle-Pod", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DOMAIN_GROUP_CLEAR: {"name": "Domain-Group-Clear", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE_NAME: {"name": "Cisco-QoS-Profile-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE: {"name": "Cisco-QoS-Profile", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE_INSTALL: {"name": "Cisco-QoS-Profile-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE_REMOVE: {"name": "Cisco-QoS-Profile-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE_UPLINK: {"name": "Cisco-QoS-Profile-Uplink", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_QOS_PROFILE_DOWNLINK: {"name": "Cisco-QoS-Profile-Downlink", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_HEADER_ITEM_ENCRYPTION: {"name": "Header-Item-Encryption", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_GROUP_NAME: {"name": "Service-Group-Name", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_GROUP_DEFINITION: {"name": "Service-Group-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_GROUP_INSTALL: {"name": "Service-Group-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_GROUP_REMOVE: {"name": "Service-Group-Remove", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_GROUP_EVENT: {"name": "Service-Group-Event", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_REPORT_USAGE: {"name": "Cisco-Report-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_ACCEL: {"name": "Accel", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_ANSWER_USER_USAGE: {"name": "Cisco-Answer-User-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_REQUEST_USAGE_TYPE: {"name": "Cisco-Request-Usage-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_REQUEST_CHARGING_RULE_USAGE: {"name": "Cisco-Request-Charging-Rule-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_REQUEST_SERVICE_GROUP_USAGE: {"name": "Cisco-Request-Service-Group-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_ANSWER_CHARGING_RULE_USAGE: {"name": "Cisco-Answer-Charging-Rule-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_CISCO_ANSWER_SERVICE_GROUP_USAGE: {"name": "Cisco-Answer-Service-Group-Usage", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_USER_AGENT: {"name": "User-Agent", "type": AvpOctetString, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_LIFE_TIME: {"name": "Service-Life-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_VOLUME_THRESHOLD_64: {"name": "Volume-Threshold-64", "type": AvpUnsigned64, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DELEGATED_IP_INSTALL: {"name": "Delegated-IP-Install", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DELEGATED_IPV4_DEFINITION: {"name": "Delegated-IPv4-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_DELEGATED_IPV6_DEFINITION: {"name": "Delegated-IPv6-Definition", "type": AvpGrouped, "mandatory": True, "vendor": 5771},
    AVP_CISCO_AGGR_PREFIX_LEN: {"name": "Aggr-Prefix-Len", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_IDENTIFIER_LO: {"name": "Service-Identifier-Lo", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_IDENTIFIER_HI: {"name": "Service-Identifier-Hi", "type": AvpUnsigned32, "mandatory": True, "vendor": 5771},
    AVP_CISCO_SERVICE_IDENTIFIER_RANGE: {"name": "Service-Identifier-Range", "type": AvpGrouped, "mandatory": True, "vendor": 5771}}

AVP_VENDOR_DICTIONARY[8164] = {
    AVP_STARENT_ACCESS_NETWORK_CHARGING_PHYSICAL_ACCESS_ID: {"name": "Access-Network-Charging-Physical-Access-Id", "type": AvpGrouped, "mandatory": True, "vendor": 8164},
    AVP_STARENT_ACCESS_NETWORK_CHARGING_PHYSICAL_ACCESS_ID_REALM: {"name": "Access-Network-Charging-Physical-Access-Id-Realm", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_ACCESS_NETWORK_CHARGING_PHYSICAL_ACCESS_ID_VALUE: {"name": "Access-Network-Charging-Physical-Access-Id-Value", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CUSTOMER_ID: {"name": "SN-Customer-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ABSOLUTE_VALIDITY_TIME: {"name": "SN-Absolute-Validity-Time", "type": AvpTime, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_BANDWIDTH_CONTROL: {"name": "SN-Bandwidth-Control", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_POLICY_ID: {"name": "SN-CF-Policy-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CHARGING_COLLECTION_FUNCTION_NAME: {"name": "SN-Charging-Collection-Function-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CHARGING_ID: {"name": "SN-Charging-Id", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FAST_REAUTH_USERNAME_11010: {"name": "SN-Fast-Reauth-Username-11010", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FIREWALL_POLICY_515: {"name": "SN-Firewall-Policy-515", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MONITORING_KEY: {"name": "SN-Monitoring-Key", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PHASE0_PSAPNAME: {"name": "SN-Phase0-PSAPName", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PSEUDONYM_USERNAME_11011: {"name": "SN-Pseudonym-Username-11011", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_REMAINING_SERVICE_UNIT: {"name": "SN-Remaining-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_RULEBASE_ID: {"name": "SN-Rulebase-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SERVICE_FLOW_DETECTION: {"name": "SN-Service-Flow-Detection", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SERVICE_START_TIMESTAMP: {"name": "SN-Service-Start-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TIME_QUOTA_THRESHOLD: {"name": "SN-Time-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TOTAL_USED_SERVICE_UNIT: {"name": "SN-Total-Used-Service-Unit", "type": AvpGrouped, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TRAFFIC_POLICY: {"name": "SN-Traffic-Policy", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TRANSPARENT_DATA: {"name": "SN-Transparent-Data", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_UNIT_QUOTA_THRESHOLD: {"name": "SN-Unit-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_USAGE_MONITORING: {"name": "SN-Usage-Monitoring", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_USAGE_MONITORING_CONTROL: {"name": "SN-Usage-Monitoring-Control", "type": AvpGrouped, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_USAGE_VOLUME: {"name": "SN-Usage-Volume", "type": AvpUnsigned64, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VOLUME_QUOTA_THRESHOLD: {"name": "SN-Volume-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SESSION_START_INDICATOR: {"name": "SN-Session-Start-Indicator", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_STARENT_SUBSCRIBER_PERMISSION: {"name": "Starent-Subscriber-Permission", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_PROHIBIT_PAYLOAD_COMPRESSION: {"name": "Prohibit-Payload-Compression", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCESS_LINK_IP_FRAG: {"name": "SN-Access-link-IP-Frag", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_INPUT_GIGA_DROPPED: {"name": "SN-Acct-Input-Giga-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_INPUT_OCTETS_DROPPED: {"name": "SN-Acct-Input-Octets-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_INPUT_PACKETS_DROPPED: {"name": "SN-Acct-Input-Packets-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_OUTPUT_GIGA_DROPPED: {"name": "SN-Acct-Output-Giga-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_OUTPUT_OCTETS_DROPPED: {"name": "SN-Acct-Output-Octets-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACCT_OUTPUT_PACKETS_DROPPED: {"name": "SN-Acct-Output-Packets-Dropped", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ACS_CREDIT_CONTROL_GROUP: {"name": "SN-Acs-Credit-Control-Group", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ADMIN_EXPIRY: {"name": "SN-Admin-Expiry", "type": AvpInteger32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ADMIN_PERMISSION: {"name": "SN-Admin-Permission", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ASSIGNED_VLAN_ID: {"name": "SN-Assigned-VLAN-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_AUTHORISED_QOS: {"name": "SN-Authorised-Qos", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_BANDWIDTH_POLICY: {"name": "SN-Bandwidth-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CALL_ID: {"name": "SN-Call-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CAUSE_CODE: {"name": "SN-Cause-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CAUSE_FOR_REC_CLOSING: {"name": "SN-Cause-For-Rec-Closing", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CBB_POLICY: {"name": "SN-CBB-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_INTERNATIONAL: {"name": "SN-CF-Call-International", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_LOCAL: {"name": "SN-CF-Call-Local", "type": AvpEnumerated, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_LONGDISTANCE: {"name": "SN-CF-Call-LongDistance", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_PREMIUM: {"name": "SN-CF-Call-Premium", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_ROAMINGINTERNATNL: {"name": "SN-CF-Call-RoamingInternatnl", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_TRANSFER: {"name": "SN-CF-Call-Transfer", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CALL_WAITING: {"name": "SN-CF-Call-Waiting", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CID_DISPLAY: {"name": "SN-CF-CId-Display", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_CID_DISPLAY_BLOCKED: {"name": "SN-CF-CId-Display-Blocked", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_FOLLOW_ME: {"name": "SN-CF-Follow-Me", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_FORWARD_BUSY_LINE: {"name": "SN-CF-Forward-Busy-Line", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_FORWARD_NO_ANSWER: {"name": "SN-CF-Forward-No-Answer", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_FORWARD_NOT_REGD: {"name": "SN-CF-Forward-Not-Regd", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CF_FORWARD_UNCONDITIONAL: {"name": "SN-CF-Forward-Unconditional", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CFPOLICY_ID: {"name": "SN-CFPolicy-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CHANGE_CONDITION: {"name": "SN-Change-Condition", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CHARGING_VPN_NAME: {"name": "SN-Charging-VPN-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CHRG_CHAR_SELECTION_MODE: {"name": "SN-Chrg-Char-Selection-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CONTENT_DISPOSITION: {"name": "SN-Content-Disposition", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CONTENT_LENGTH: {"name": "SN-Content-Length", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CONTENT_TYPE: {"name": "SN-Content-Type", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CR_INTERNATIONAL_CID: {"name": "SN-CR-International-Cid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CR_LONGDISTANCE_CID: {"name": "SN-CR-LongDistance-Cid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CSCF_APP_SERVER_INFO: {"name": "SN-CSCF-App-Server-Info", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CSCF_RF_SDP_MEDIA_COMPONENTS: {"name": "SN-CSCF-Rf-SDP-Media-Components", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_CSCF_SUBSCRIBER_IP_ADDRESS: {"name": "SN-Cscf-Subscriber-Ip-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DATA_TUNNEL_IGNORE_DF_BIT: {"name": "SN-Data-Tunnel-Ignore-DF-Bit", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DHCP_LEASE_EXPIRY_POLICY: {"name": "SN-DHCP-Lease-Expiry-Policy", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DHCP_OPTIONS: {"name": "SN-DHCP-Options", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DIRECTION: {"name": "SN-Direction", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DISCONNECT_REASON: {"name": "SN-Disconnect-Reason", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DNS_PROXY_INTERCEPT_LIST: {"name": "SN-DNS-Proxy-Intercept-List", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DNS_PROXY_USE_SUBSCR_ADDR: {"name": "SN-DNS-Proxy-Use-Subscr-Addr", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_DYNAMIC_ADDR_ALLOC_IND_FLAG: {"name": "SN-Dynamic-Addr-Alloc-Ind-Flag", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ECS_DATA_VOLUME: {"name": "SN-Ecs-Data-Volume", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ENABLE_QOS_RENEGOTIATION: {"name": "SN-Enable-QoS-Renegotiation", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EVENT: {"name": "SN-Event", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_CONTEXT: {"name": "SN-Ext-Inline-Srvr-Context", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_DOWN_ADDR: {"name": "SN-Ext-Inline-Srvr-Down-Addr", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_DOWN_VLAN: {"name": "SN-Ext-Inline-Srvr-Down-VLAN", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_PREFERENCE: {"name": "SN-Ext-Inline-Srvr-Preference", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_UP_ADDR: {"name": "SN-Ext-Inline-Srvr-Up-Addr", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_EXT_INLINE_SRVR_UP_VLAN: {"name": "SN-Ext-Inline-Srvr-Up-VLAN", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FAST_REAUTH_USERNAME_304: {"name": "SN-Fast-Reauth-Username-304", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FIREWALL_ENABLED: {"name": "SN-Firewall-Enabled", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FIREWALL_POLICY_239: {"name": "SN-Firewall-Policy-239", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_FMC_LOCATION: {"name": "SN-FMC-Location", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_GGSN_ADDRESS: {"name": "SN-GGSN-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_GGSN_MIP_REQUIRED: {"name": "SN-GGSN-MIP-Required", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_GRATUITOUS_ARP_AGGRESSIVE: {"name": "SN-Gratuitous-ARP-Aggressive", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_GTP_VERSION: {"name": "SN-GTP-Version", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_HA_SEND_DNS_ADDRESS: {"name": "SN-HA-Send-DNS-ADDRESS", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_HANDOFF_INDICATOR: {"name": "SN-Handoff-Indicator", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_HOME_BEHAVIOR: {"name": "SN-Home-Behavior", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_HOME_PROFILE: {"name": "SN-Home-Profile", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_HOME_SUB_USE_GGSN: {"name": "SN-Home-Sub-Use-GGSN", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IMS_AM_ADDRESS: {"name": "SN-IMS-AM-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IMS_AM_DOMAIN_NAME: {"name": "SN-IMS-AM-Domain-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IMS_CHARGING_IDENTIFIER: {"name": "SN-IMS-Charging-Identifier", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IMSI: {"name": "SN-IMSI", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_INACTIVITY_TIME: {"name": "SN-Inactivity-Time", "type": AvpInteger32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_INTERNAL_SM_INDEX: {"name": "SN-Internal-SM-Index", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_ALLOC_METHOD: {"name": "SN-IP-Alloc-Method", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_ALLOC_METHOD: {"name": "SN-IPv6-Alloc-Method", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_FILTER_IN: {"name": "SN-IP-Filter-In", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_FILTER_OUT: {"name": "SN-IP-Filter-Out", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_HEADER_COMPRESSION: {"name": "SN-IP-Header-Compression", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_HIDE_SERVICE_ADDRESS: {"name": "SN-IP-Hide-Service-Address", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_IN_ACL: {"name": "SN-IP-In-ACL", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_IN_PLCY_GRP: {"name": "SN-IP-In-Plcy-Grp", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_OUT_ACL: {"name": "SN-IP-Out-ACL", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_OUT_PLCY_GRP: {"name": "SN-IP-Out-Plcy-Grp", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_POOL_NAME: {"name": "SN-IP-Pool-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_SOURCE_VALIDATION: {"name": "SN-IP-Source-Validation", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_SOURCE_VIOLATE_NO_ACCT: {"name": "SN-IP-Source-Violate-No-Acct", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IP_SRC_VALIDATION_DROP_LIMIT: {"name": "SN-IP-Src-Validation-Drop-Limit", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_DNS_PROXY: {"name": "SN-IPv6-DNS-Proxy", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_EGRESS_FILTERING: {"name": "SN-IPv6-Egress-Filtering", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_MIN_LINK_MTU: {"name": "SN-IPv6-Min-Link-MTU", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_NUM_RTR_ADVT: {"name": "SN-IPv6-num-rtr-advt", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_PRIMARY_DNS: {"name": "SN-IPv6-Primary-DNS", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_RTR_ADVT_INTERVAL: {"name": "SN-IPv6-rtr-advt-interval", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_SECONDARY_DNS: {"name": "SN-IPv6-Secondary-DNS", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_SEC_POOL: {"name": "SN-IPv6-Sec-Pool", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IPV6_SEC_PREFIX: {"name": "SN-IPv6-Sec-Prefix", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ISC_TEMPLATE_NAME: {"name": "SN-ISC-Template-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_IS_UNREGISTERED_SUBSCRIBER: {"name": "SN-Is-Unregistered-Subscriber", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_L3_TO_L2_TUN_ADDR_POLICY: {"name": "SN-L3-to-L2-Tun-Addr-Policy", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_LI_DEST_ADDRESS: {"name": "SN-LI-Dest-Address", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_LOCAL_IP_ADDRESS: {"name": "SN-Local-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_LONG_DURATION_ACTION: {"name": "SN-Long-Duration-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_LONG_DURATION_NOTIFICATION: {"name": "SN-Long-Duration-Notification", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_LONG_DURATION_TIMEOUT: {"name": "SN-Long-Duration-Timeout", "type": AvpInteger32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MAX_SEC_CONTEXTS_PER_SUBS: {"name": "SN-Max-Sec-Contexts-Per-Subs", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MEDIATION_ACCT_RSP_ACTION: {"name": "SN-Mediation-Acct-Rsp-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MEDIATION_ENABLED: {"name": "SN-Mediation-Enabled", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MEDIATION_NO_INTERIMS: {"name": "SN-Mediation-No-Interims", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MEDIATION_VPN_NAME: {"name": "SN-Mediation-VPN-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIN_COMPRESS_SIZE: {"name": "SN-Min-Compress-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_AAA_ASSIGN_ADDR: {"name": "SN-MIP-AAA-Assign-Addr", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_ANCID: {"name": "SN-MIP-ANCID", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_DUAL_ANCHOR: {"name": "SN-MIP-Dual-Anchor", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_HA_ASSIGNMENT_TABLE: {"name": "SN-MIP-HA-Assignment-Table", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_MATCH_AAA_ASSIGN_ADDR: {"name": "SN-MIP-Match-AAA-Assign-Addr", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_REG_LIFETIME_REALM: {"name": "SN-MIP-Reg-Lifetime-Realm", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_SEND_ANCID: {"name": "SN-MIP-Send-Ancid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_SEND_CORRELATION_INFO: {"name": "SN-MIP-Send-Correlation-Info", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_SEND_HOST_CONFIG: {"name": "SN-MIP-Send-Host-Config", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_SEND_IMSI: {"name": "SN-MIP-Send-Imsi", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MIP_SEND_TERM_VERIFICATION: {"name": "SN-MIP-Send-Term-Verification", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MN_HA_HASH_ALGORITHM: {"name": "SN-MN-HA-Hash-Algorithm", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MN_HA_TIMESTAMP_TOLERANCE: {"name": "SN-MN-HA-Timestamp-Tolerance", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MODE: {"name": "SN-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_MS_ISDN: {"name": "SN-MS-ISDN", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NAI_CONSTRUCTION_DOMAIN: {"name": "SN-NAI-Construction-Domain", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NAT_IP_ADDRESS: {"name": "SN-NAT-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NODE_FUNCTIONALITY: {"name": "SN-Node-Functionality", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NPU_QOS_PRIORITY: {"name": "SN-NPU-Qos-Priority", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NTK_INITIATED_CTX_IND_FLAG: {"name": "SN-Ntk-Initiated-Ctx-Ind-Flag", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NTK_SESSION_DISCONNECT_FLAG: {"name": "SN-Ntk-Session-Disconnect-Flag", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_NW_REACHABILITY_SERVER_NAME: {"name": "SN-Nw-Reachability-Server-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ORIGINATING_IOI: {"name": "SN-Originating-IOI", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_OVERLOAD_DISC_CONNECT_TIME: {"name": "SN-Overload-Disc-Connect-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_OVERLOAD_DISC_INACT_TIME: {"name": "SN-Overload-Disc-Inact-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_OVERLOAD_DISCONNECT: {"name": "SN-Overload-Disconnect", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDG_TTG_REQUIRED: {"name": "SN-PDG-TTG-Required", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDIF_MIP_RELEASE_TIA: {"name": "SN-PDIF-MIP-Release-TIA", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDIF_MIP_REQUIRED: {"name": "SN-PDIF-MIP-Required", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDIF_MIP_SIMPLE_IP_FALLBACK: {"name": "SN-PDIF-MIP-Simple-IP-Fallback", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDSN_HANDOFF_REQ_IP_ADDR: {"name": "SN-PDSN-Handoff-Req-IP-Addr", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDSN_NAS_ID: {"name": "SN-PDSN-NAS-Id", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PDSN_NAS_IP_ADDRESS: {"name": "SN-PDSN-NAS-IP-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PERMIT_USER_MCAST_PDUS: {"name": "SN-Permit-User-Mcast-PDUs", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_ACCEPT_PEER_V6IFID: {"name": "SN-PPP-Accept-Peer-v6Ifid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_ALWAYS_ON_VSE: {"name": "SN-PPP-Always-On-Vse", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_DATA_COMPRESSION: {"name": "SN-PPP-Data-Compression", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_DATA_COMPRESSION_MODE: {"name": "SN-PPP-Data-Compression-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_KEEPALIVE: {"name": "SN-PPP-Keepalive", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_NW_LAYER_IPV4: {"name": "SN-PPP-NW-Layer-IPv4", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_NW_LAYER_IPV6: {"name": "SN-PPP-NW-Layer-IPv6", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_OUTBOUND_PASSWORD: {"name": "SN-PPP-Outbound-Password", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_OUTBOUND_USERNAME: {"name": "SN-PPP-Outbound-Username", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_PROGRESS_CODE: {"name": "SN-PPP-Progress-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PPP_RENEG_DISC: {"name": "SN-PPP-Reneg-Disc", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID: {"name": "SN-Prepaid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_COMPRESSED_COUNT: {"name": "SN-Prepaid-Compressed-Count", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_FINAL_DURATION_ALG: {"name": "SN-Prepaid-Final-Duration-Alg", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_INBOUND_OCTETS: {"name": "SN-Prepaid-Inbound-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_OUTBOUND_OCTETS: {"name": "SN-Prepaid-Outbound-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_PREFERENCE: {"name": "SN-Prepaid-Preference", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_TIMEOUT: {"name": "SN-Prepaid-Timeout", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_TOTAL_OCTETS: {"name": "SN-Prepaid-Total-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PREPAID_WATERMARK: {"name": "SN-Prepaid-Watermark", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PRIMARY_DCCA_PEER: {"name": "SN-Primary-DCCA-Peer", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PRIMARY_DNS_SERVER: {"name": "SN-Primary-DNS-Server", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PRIMARY_NBNS_SERVER: {"name": "SN-Primary-NBNS-Server", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PROXY_MIP: {"name": "SN-Proxy-MIP", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PROXY_MIPV6: {"name": "SN-Proxy-MIPV6", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_PSEUDONYM_USERNAME_305: {"name": "SN-Pseudonym-Username-305", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_BACKGROUND_CLASS: {"name": "SN-QoS-Background-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_BACKGROUND_PHB: {"name": "SN-QoS-Class-Background-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_CONVERSATIONAL_PHB: {"name": "SN-QoS-Class-Conversational-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_INTERACTIVE_1_PHB: {"name": "SN-QoS-Class-Interactive-1-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_INTERACTIVE_2_PHB: {"name": "SN-QoS-Class-Interactive-2-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_INTERACTIVE_3_PHB: {"name": "SN-QoS-Class-Interactive-3-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CLASS_STREAMING_PHB: {"name": "SN-QoS-Class-Streaming-PHB", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_CONVERSATION_CLASS: {"name": "SN-QoS-Conversation-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_HLR_PROFILE: {"name": "SN-QOS-HLR-Profile", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_INTERACTIVE1_CLASS: {"name": "SN-QoS-Interactive1-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_INTERACTIVE2_CLASS: {"name": "SN-QoS-Interactive2-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_INTERACTIVE3_CLASS: {"name": "SN-QoS-Interactive3-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_NEGOTIATED: {"name": "SN-QoS-Negotiated", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_RENEGOTIATION_TIMEOUT: {"name": "SN-QoS-Renegotiation-Timeout", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_STREAMING_CLASS: {"name": "SN-QoS-Streaming-Class", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_TP_DNLK: {"name": "SN-QoS-Tp-Dnlk", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_TP_UPLK: {"name": "SN-QoS-Tp-Uplk", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_QOS_TRAFFIC_POLICY: {"name": "SN-QoS-Traffic-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_RAD_APN_NAME: {"name": "SN-Rad-APN-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_RADIUS_RETURNED_USERNAME: {"name": "SN-Radius-Returned-Username", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_RE_CHAP_INTERVAL: {"name": "SN-Re-CHAP-Interval", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROAMING_BEHAVIOR: {"name": "SN-Roaming-Behavior", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROAMING_PROFILE: {"name": "SN-Roaming-Profile", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROAMING_SUB_USE_GGSN: {"name": "SN-Roaming-Sub-Use-GGSN", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROHC_FLOW_MARKING_MODE: {"name": "SN-ROHC-Flow-Marking-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROHC_PROFILE_NAME: {"name": "SN-ROHC-Profile-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROLE_OF_NODE: {"name": "SN-Role-Of-Node", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_ROUTING_AREA_ID: {"name": "SN-Routing-Area-Id", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_RULEBASE: {"name": "SN-Rulebase", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SDP_SESSION_DESCRIPTION: {"name": "SN-SDP-Session-Description", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SEC_IP_POOL_NAME: {"name": "SN-Sec-IP-Pool-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SECONDARY_DCCA_PEER: {"name": "SN-Secondary-DCCA-Peer", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SECONDARY_DNS_SERVER: {"name": "SN-Secondary-DNS-Server", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SECONDARY_NBNS_SERVER: {"name": "SN-Secondary-NBNS-Server", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SERVICE_ADDRESS: {"name": "SN-Service-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SERVICE_TYPE: {"name": "SN-Service-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SESSION_ID: {"name": "SN-Session-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SIMULTANEOUS_SIP_MIP: {"name": "SN-Simultaneous-SIP-MIP", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SIP_METHOD: {"name": "SN-SIP-Method", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SIP_REQUEST_TIME_STAMP: {"name": "SN-SIP-Request-Time-Stamp", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SIP_RESPONSE_TIME_STAMP: {"name": "SN-SIP-Response-Time-Stamp", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SOFTWARE_VERSION: {"name": "SN-Software-Version", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBS_ACC_FLOW_TRAFFIC_VALID: {"name": "SN-Subs-Acc-Flow-Traffic-Valid", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCOUNTING: {"name": "SN-Subscriber-Accounting", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCT_INTERIM: {"name": "SN-Subscriber-Acct-Interim", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCT_MODE: {"name": "SN-Subscriber-Acct-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCT_RSP_ACTION: {"name": "SN-Subscriber-Acct-Rsp-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCT_START: {"name": "SN-Subscriber-Acct-Start", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_ACCT_STOP: {"name": "SN-Subscriber-Acct-Stop", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_CLASS: {"name": "SN-Subscriber-Class", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_IP_HDR_NEG_MODE: {"name": "SN-Subscriber-IP-Hdr-Neg-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_IP_TOS_COPY: {"name": "SN-Subscriber-IP-TOS-Copy", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_NEXTHOP_ADDRESS: {"name": "SN-Subscriber-Nexthop-Address", "type": AvpAddress, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_NO_INTERIMS: {"name": "SN-Subscriber-No-Interims", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBSCRIBER_TEMPLATE_NAME: {"name": "SN-Subscriber-Template-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBS_IMSA_SERVICE_NAME: {"name": "SN-Subs-IMSA-Service-Name", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_SUBS_VJ_SLOTID_CMP_NEG_MODE: {"name": "SN-Subs-VJ-Slotid-Cmp-Neg-Mode", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_DNLK_BURST_SIZE: {"name": "SN-Tp-Dnlk-Burst-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_DNLK_COMMITTED_DATA_RATE: {"name": "SN-Tp-Dnlk-Committed-Data-Rate", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_DNLK_EXCEED_ACTION: {"name": "SN-Tp-Dnlk-Exceed-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_DNLK_PEAK_DATA_RATE: {"name": "SN-Tp-Dnlk-Peak-Data-Rate", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_DNLK_VIOLATE_ACTION: {"name": "SN-Tp-Dnlk-Violate-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_UPLK_BURST_SIZE: {"name": "SN-Tp-Uplk-Burst-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_UPLK_COMMITTED_DATA_RATE: {"name": "SN-Tp-Uplk-Committed-Data-Rate", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_UPLK_EXCEED_ACTION: {"name": "SN-Tp-Uplk-Exceed-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_UPLK_PEAK_DATA_RATE: {"name": "SN-Tp-Uplk-Peak-Data-Rate", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TP_UPLK_VIOLATE_ACTION: {"name": "SN-Tp-Uplk-Violate-Action", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TPO_POLICY: {"name": "SN-TPO-Policy", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TRAFFIC_GROUP: {"name": "SN-Traffic-Group", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TRAFFICSELECTOR_CLASS: {"name": "SN-TrafficSelector-Class", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUN_ADDR_POLICY: {"name": "SN-Tun-Addr-Policy", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUNNEL_GN: {"name": "SN-Tunnel-Gn", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUNNEL_ISAKMP_CRYPTO_MAP: {"name": "SN-Tunnel-ISAKMP-Crypto-Map", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUNNEL_ISAKMP_SECRET: {"name": "SN-Tunnel-ISAKMP-Secret", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUNNEL_LOAD_BALANCING: {"name": "SN-Tunnel-Load-Balancing", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_TUNNEL_PASSWORD: {"name": "SN-Tunnel-Password", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_UNCLASSIFY_LIST_NAME: {"name": "SN-Unclassify-List-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_USER_PRIVILEGE: {"name": "SN-User-Privilege", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VIRTUAL_APN_NAME: {"name": "SN-Virtual-APN-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VISITING_BEHAVIOR: {"name": "SN-Visiting-Behavior", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VISITING_PROFILE: {"name": "SN-Visiting-Profile", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VISITING_SUB_USE_GGSN: {"name": "SN-Visiting-Sub-Use-GGSN", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VOICE_PUSH_LIST_NAME: {"name": "SN-Voice-Push-List-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VPN_ID: {"name": "SN-VPN-ID", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_VPN_NAME: {"name": "SN-VPN-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_WIMAX_AUTH_ONLY: {"name": "SN-WiMAX-Auth-Only", "type": AvpUnsigned32, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_WLAN_AP_IDENTIFIER: {"name": "SN-WLAN-AP-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 8164},
    AVP_STARENT_SN_WLAN_UE_IDENTIFIER: {"name": "SN-WLAN-UE-Identifier", "type": AvpOctetString, "mandatory": True, "vendor": 8164}}

AVP_VENDOR_DICTIONARY[12645] = {
    AVP_VODAFONE_CONTEXT_TYPE: {"name": "Context-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_QUOTA_CONSUMPTION_TIME: {"name": "Vodafone-Quota-Consumption-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_QUOTA_HOLDING_TIME: {"name": "Vodafone-Quota-Holding-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_TIME_QUOTA_THRESHOLD: {"name": "Vodafone-Time-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_RADIO_ACCESS_TECHNOLOGY: {"name": "Radio-Access-Technology", "type": AvpEnumerated, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_REPORTING_REASON: {"name": "Vodafone-Reporting-Reason", "type": AvpEnumerated, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_RULEBASE_ID: {"name": "Vodafone-Rulebase-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_TIME_OF_FIRST_USAGE: {"name": "Vodafone-Time-Of-First-Usage", "type": AvpTime, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_TIME_OF_LAST_USAGE: {"name": "Vodafone-Time-Of-Last-Usage", "type": AvpTime, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_TRIGGER: {"name": "Vodafone-Trigger", "type": AvpGrouped, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_TRIGGER_TYPE: {"name": "Vodafone-Trigger-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_USER_LOCATION_INFORMATION: {"name": "User-Location-Information", "type": AvpOctetString, "mandatory": True, "vendor": 12645},
    AVP_VODAFONE_VODAFONE_VOLUME_QUOTA_THRESHOLD: {"name": "Vodafone-Volume-Quota-Threshold", "type": AvpUnsigned32, "mandatory": True, "vendor": 12645}}

AVP_VENDOR_DICTIONARY[637] = {
    AVP_ALU_DETAILED_RESULT: {"name": "Detailed-Result", "type": AvpGrouped, "mandatory": True, "vendor": 637},
    AVP_ALU_DETAILED_RESULT_CAUSE: {"name": "Detailed-Result-Cause", "type": AvpUtf8String, "mandatory": True, "vendor": 637},
    AVP_ALU_DETAILED_RESULT_CODE: {"name": "Detailed-Result-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 637},
    AVP_ALU_DPA_INSTRUCTION: {"name": "DPA-Instruction", "type": AvpEnumerated, "mandatory": True, "vendor": 637},
    AVP_ALU_CHARGING_POLICY_REPORT: {"name": "Charging-Policy-Report", "type": AvpGrouped, "mandatory": True, "vendor": 637},
    AVP_ALU_POLICY_COUNTER: {"name": "Policy-Counter", "type": AvpGrouped, "mandatory": True, "vendor": 637},
    AVP_ALU_POLICY_COUNTER_ID: {"name": "Policy-Counter-Id", "type": AvpOctetString, "mandatory": True, "vendor": 637},
    AVP_ALU_POLICY_COUNTER_VALUE: {"name": "Policy-Counter-Value", "type": AvpUnsigned32, "mandatory": True, "vendor": 637},
    AVP_ALU_SUBSCRIBER_USER_ID: {"name": "Subscriber-User-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 637}}

AVP_VENDOR_DICTIONARY[94] = {
    AVP_NOKIA_NOKIA_IMS_MEDIA_COMPONENT_ID: {"name": "Nokia-IMS-Media-Component-Id", "type": AvpUnsigned32, "vendor": 94},
    AVP_NOKIA_NOKIA_TIME_OF_FIRST_USAGE: {"name": "Nokia-Time-Of-First-Usage", "type": AvpTime, "vendor": 94},
    AVP_NOKIA_NOKIA_TIME_OF_LAST_USAGE: {"name": "Nokia-Time-Of-Last-Usage", "type": AvpTime, "vendor": 94},
    AVP_NOKIA_NOKIA_SESSION_START_INDICATOR: {"name": "Nokia-Session-Start-Indicator", "type": AvpOctetString, "vendor": 94},
    AVP_NOKIA_NOKIA_RULEBASE_ID: {"name": "Nokia-Rulebase-Id", "type": AvpUtf8String, "vendor": 94},
    AVP_NOKIA_NOKIA_QUOTA_CONSUMPTION_TIME: {"name": "Nokia-Quota-Consumption-Time", "type": AvpUnsigned32, "vendor": 94},
    AVP_NOKIA_NOKIA_QUOTA_HOLDING_TIME: {"name": "Nokia-Quota-Holding-Time", "type": AvpUnsigned32, "vendor": 94},
    AVP_NOKIA_DEFAULT_QUOTA: {"name": "Default-Quota", "type": AvpGrouped, "vendor": 94},
    AVP_NOKIA_NOKIA_URI: {"name": "Nokia-URI", "type": AvpUtf8String, "vendor": 94},
    AVP_NOKIA_NSN_TOKEN_VALUE: {"name": "NSN-Token-Value", "type": AvpOctetString, "vendor": 94}}

AVP_VENDOR_DICTIONARY[28458] = {
    AVP_NOKIASOLUTIONSANDNETWORKS_USER_AGENT_TYPE: {"name": "User-Agent-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_NSN_IN_INFORMATION: {"name": "NSN-IN-Information", "type": AvpGrouped, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_NSN_ACCOUNT_LOCATION_ID: {"name": "NSN-Account-Location-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_ACCOUNT_STATE: {"name": "Account-State", "type": AvpUtf8String, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_SUBSCRIBER_SPECIFIC_INFO: {"name": "Subscriber-Specific-Info", "type": AvpGrouped, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_OFFER_NAME: {"name": "Offer-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_VERSION: {"name": "Version", "type": AvpUtf8String, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_ACTIVE_PRODUCT_OFFER: {"name": "Active-Product-Offer", "type": AvpGrouped, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_EXPIRY_DATE: {"name": "Expiry-Date", "type": AvpTime, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_BILLING_ACCOUNT: {"name": "Billing-Account", "type": AvpGrouped, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_BILLING_ACCOUNT_NUMBER: {"name": "Billing-Account-Number", "type": AvpInteger32, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_ACCOUNT_TYPE: {"name": "Account-Type", "type": AvpUtf8String, "mandatory": True, "vendor": 28458},
    AVP_NOKIASOLUTIONSANDNETWORKS_ACCOUNT_SUBTYPE: {"name": "Account-Subtype", "type": AvpUtf8String, "mandatory": True, "vendor": 28458}}

AVP_VENDOR_DICTIONARY[11] = {
    AVP_HP_PEER_STATE: {"name": "Peer-State", "type": AvpEnumerated, "mandatory": True, "vendor": 11},
    AVP_HP_PEER_NAME: {"name": "Peer-Name", "type": AvpOctetString, "mandatory": True, "vendor": 11},
    AVP_HP_PEER_IDENTITY: {"name": "Peer-Identity", "type": AvpOctetString, "mandatory": True, "vendor": 11},
    AVP_HP_PEER_STATE_CHANGE: {"name": "Peer-State-Change", "type": AvpGrouped, "mandatory": True, "vendor": 11},
    AVP_HP_MORE_PEERS: {"name": "More-Peers", "type": AvpGrouped, "mandatory": True, "vendor": 11},
    AVP_HP_PEER_TYPE: {"name": "Peer-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 11}}

AVP_VENDOR_DICTIONARY[323] = {
    AVP_ORACLETEKELEC_DSR_APPLICATIONINVOKED: {"name": "DSR-ApplicationInvoked", "type": AvpEnumerated, "vendor": 323},
    AVP_ORACLETEKELEC_PDRA_EARLY_BINDING: {"name": "PDRA-Early-Binding", "type": AvpOctetString, "vendor": 323},
    AVP_ORACLETEKELEC_SESSION_RELEASE_REASON: {"name": "Session-Release-Reason", "type": AvpOctetString, "vendor": 323},
    AVP_ORACLETEKELEC_MSGCOPYANSWER: {"name": "MsgCopyAnswer", "type": AvpGrouped, "vendor": 323}}

AVP_VENDOR_DICTIONARY[9] = {
    AVP_CISCOSYSTEMS_DSCP: {"name": "DSCP", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_RATE_LIMIT_ACTION: {"name": "Rate-Limit-Action", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_QOS_GROUP_RULE_INSTALL: {"name": "QoS-Group-Rule-Install", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_QOS_GROUP_RULE_DEFINITION: {"name": "QoS-Group-Rule-Definition", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_QOS_GROUP_RULE_NAME: {"name": "QoS-Group-Rule-Name", "type": AvpOctetString, "vendor": 9},
    AVP_CISCOSYSTEMS_MBR_LIMIT_EXCEED_ACTION_UL: {"name": "MBR-Limit-Exceed-Action-UL", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_MBR_LIMIT_EXCEED_ACTION_DL: {"name": "MBR-Limit-Exceed-Action-DL", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_MBR_BURST_SIZE_UL: {"name": "MBR-Burst-Size-UL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_MBR_BURST_SIZE_DL: {"name": "MBR-Burst-Size-DL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_QOS_LEVEL: {"name": "QoS-Level", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CONTROL: {"name": "Override-Control", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_RULE_NAME: {"name": "Override-Rule-Name", "type": AvpOctetString, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CHARGING_ACTION_PARAMETERS: {"name": "Override-Charging-Action-Parameters", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CHARGING_ACTION_NAME: {"name": "Override-Charging-Action-Name", "type": AvpOctetString, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CHARGING_ACTION_EXCLUDE_RULE: {"name": "Override-Charging-Action-Exclude-Rule", "type": AvpUtf8String, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CHARGING_PARAMETERS: {"name": "Override-Charging-Parameters", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_SERVICE_IDENTIFIER: {"name": "Override-Service-Identifier", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_RATING_GROUP: {"name": "Override-Rating-Group", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_CISCOSYSTEMS_EXECUTION_TIME: {"name": "CiscoSystems-Execution-Time", "type": AvpOctetString, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_ONLINE: {"name": "Override-Online", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_OFFLINE: {"name": "Override-Offline", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CONTENT_FILTERING_STATE: {"name": "Override-Content-Filtering-State", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_POLICY_PARAMETERS: {"name": "Override-Policy-Parameters", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_QOS_INFORMATION: {"name": "Override-QoS-Information", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_QOS_CLASS_IDENTIFIER: {"name": "Override-QoS-Class-Identifier", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_MAX_REQUESTED_BANDWIDTH_UL: {"name": "Override-Max-Requested-Bandwidth-UL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_MAX_REQUESTED_BANDWIDTH_DL: {"name": "Override-Max-Requested-Bandwidth-DL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_GUARANTEED_BITRATE_UL: {"name": "Override-Guaranteed-Bitrate-UL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_GUARANTEED_BITRATE_DL: {"name": "Override-Guaranteed-Bitrate-DL", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_ALLOCATION_RETENTION_PRIORITY: {"name": "Override-Allocation-Retention-Priority", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_PRIORITY_LEVEL: {"name": "Override-Priority-Level", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_PRE_EMPTION_CAPABILITY: {"name": "Override-Pre-Emption-Capability", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_TOS_VALUE: {"name": "Override-Tos-Value", "type": AvpGrouped, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_TOS_DIRECTION: {"name": "Override-Tos-Direction", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_TOS_VALUE_STANDARD: {"name": "Override-Tos-Value-Standard", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_TOS_VALUE_CUSTOM: {"name": "Override-Tos-Value-Custom", "type": AvpUnsigned32, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CONTROL_NAME: {"name": "Override-Control-Name", "type": AvpOctetString, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_NEXTHOP_ADDRESS: {"name": "Override-Nexthop-Address", "type": AvpAddress, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CONTROL_PENDING_QUEUE_ACTION: {"name": "Override-Control-Pending-Queue-Action", "type": AvpEnumerated, "vendor": 9},
    AVP_CISCOSYSTEMS_OVERRIDE_CONTROL_MERGE_WILDCARD: {"name": "Override-Control-Merge-Wildcard", "type": AvpEnumerated, "vendor": 9}}

AVP_VENDOR_DICTIONARY[2636] = {
    AVP_JUNIPER_TDF_APPLICATION_INSTANCE_IDENTIFIER_BASE: {"name": "TDF-Application-Instance-Identifier-Base", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_SERVICE_CHAINING_INFORMATION: {"name": "Service-Chaining-Information", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_LRF_PROFILE_NAME: {"name": "LRF-Profile-Name", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_HCM_PROFILE_NAME: {"name": "HCM-Profile-Name", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_FORWARDING_CLASS_NAME: {"name": "Forwarding-Class-Name", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_REDIRECT_VRF: {"name": "Redirect-VRF", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_REQUESTED_BURSTSIZE_UL: {"name": "Requested-Burstsize-UL", "type": AvpInteger32, "vendor": 2636},
    AVP_JUNIPER_REQUESTED_BURSTSIZE_DL: {"name": "Requested-Burstsize-DL", "type": AvpInteger32, "vendor": 2636},
    AVP_JUNIPER_STEERING_INFORMATION: {"name": "Steering-Information", "type": AvpGrouped, "vendor": 2636},
    AVP_JUNIPER_STEERING_UPLINK_VRF: {"name": "Steering-Uplink-VRF", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_STEERING_DOWNLINK_VRF: {"name": "Steering-Downlink-VRF", "type": AvpUtf8String, "vendor": 2636},
    AVP_JUNIPER_STEERING_IP_ADDRESS: {"name": "Steering-IP-Address", "type": AvpAddress, "vendor": 2636}}

AVP_VENDOR_DICTIONARY[41897] = {
    AVP_INOVAR_INOVAR_FORWARD_TO_PARTY: {"name": "Inovar-Forward-To-Party", "type": AvpUtf8String, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_APP_CODE: {"name": "Inovar-App-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_SERVICE_CODE: {"name": "Inovar-Service-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_SERVICE_ID: {"name": "Inovar-Service-ID", "type": AvpGrouped, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_UNSUCCESSFUL_CALL_REASON: {"name": "Inovar-Unsuccessful-Call-Reason", "type": AvpGrouped, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_SIP_RESPONSE_CODE: {"name": "Inovar-SIP-Response-Code", "type": AvpInteger32, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_ISUP_CAUSE: {"name": "Inovar-ISUP-Cause", "type": AvpInteger32, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_SUPPLEMENTARY_SERVICE_ID: {"name": "Inovar-Supplementary-Service-Id", "type": AvpInteger32, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_PS_REGISTRATION_STATUS: {"name": "Inovar-PS-Registration-Status", "type": AvpEnumerated, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_SERVICE_RESULT: {"name": "Inovar-Service-Result", "type": AvpEnumerated, "mandatory": True, "vendor": 41897},
    AVP_INOVAR_INOVAR_CALLING_PARTY_INFO: {"name": "Inovar-Calling-Party-Info", "type": AvpGrouped, "mandatory": True, "vendor": 41897}}

AVP_VENDOR_DICTIONARY[2011] = {
    AVP_HUAWEI_P2PSMS_INFORMATION: {"name": "P2PSMS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_SMSC_ADDRESS_HUAWEI: {"name": "SMSC-Address-Huawei", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_SM_ID: {"name": "SM-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_SM_LENGTH: {"name": "SM-Length", "type": AvpUnsigned32, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_MO_MSC_ADDRESS: {"name": "MO-MSC-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_MT_MSC_ADDRESS: {"name": "MT-MSC-Address", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_SOURCE_ADDR: {"name": "Source-Addr", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_DEST_ADDR: {"name": "Dest-Addr", "type": AvpUtf8String, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_FEE_FLAG: {"name": "Fee-Flag", "type": AvpEnumerated, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_FEE_TYPE: {"name": "Fee-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_STATUS_REPORT_REQUESTED: {"name": "Status-Report-Requested", "type": AvpEnumerated, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_SEND_RESULT: {"name": "Send-Result", "type": AvpEnumerated, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_OPERATION_RESULT: {"name": "Operation-Result", "type": AvpEnumerated, "mandatory": True, "vendor": 2011},
    AVP_HUAWEI_NOTIFY_MODE: {"name": "Notify-Mode", "type": AvpEnumerated, "mandatory": True, "vendor": 2011}}

AVP_VENDOR_DICTIONARY[12951] = {
    AVP_VERIZONWIRELESS_IDLE_TO_CONNECTED_TRANSITION_COUNT: {"name": "Idle-To-Connected-Transition-Count", "type": AvpInteger32, "mandatory": True, "vendor": 12951},
    AVP_VERIZONWIRELESS_CONNECTED_DURATION: {"name": "Connected-Duration", "type": AvpUnsigned32, "mandatory": True, "vendor": 12951},
    AVP_VERIZONWIRELESS_CHARGING_GATEWAY_FUNCTION_HOST: {"name": "Charging-Gateway-Function-Host", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_CHARGING_GROUP_ID: {"name": "Charging-Group-ID", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_LI_INDICATOR_GX: {"name": "LI-Indicator-Gx", "type": AvpGrouped, "vendor": 12951},
    AVP_VERIZONWIRELESS_RANDOM_VECTOR: {"name": "Random-Vector", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_INTERCEPTION_ACTION: {"name": "Interception-Action", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_LI_CORRELATION_ID: {"name": "LI-Correlation-ID", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_LI_TARGETMFADDRESS: {"name": "LI-TargetMFAddress", "type": AvpGrouped, "vendor": 12951},
    AVP_VERIZONWIRELESS_LI_TARGETID: {"name": "LI-TargetID", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_MF_ADDRESS: {"name": "MF-Address", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_MF_PORT: {"name": "MF-Port", "type": AvpOctetString, "vendor": 12951},
    AVP_VERIZONWIRELESS_SELF_ACTIVATION_STATUS: {"name": "Self-Activation-Status", "type": AvpEnumerated, "vendor": 12951},
    AVP_VERIZONWIRELESS_VIRTUAL_APN_NAME: {"name": "Virtual-APN-Name", "type": AvpUtf8String, "vendor": 12951},
    AVP_VERIZONWIRELESS_ORIGINATION_TIMESTAMP: {"name": "Origination-Timestamp", "type": AvpUnsigned64, "vendor": 12951},
    AVP_VERIZONWIRELESS_MAX_WAIT_TIME: {"name": "Max-Wait-Time", "type": AvpUnsigned32, "vendor": 12951},
    AVP_VERIZONWIRELESS_ONLINE_RESPONSE_REQUIRED: {"name": "Online-Response-Required", "type": AvpEnumerated, "vendor": 12951}}

AVP_VENDOR_DICTIONARY[27640] = {
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ADDITIONAL_CALLING_PARTY_NUMBER: {"name": "CS-Additional-Calling-Party-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT: {"name": "CS-Announcement", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_CODE: {"name": "CS-Announcement-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_DATA: {"name": "CS-Announcement-Data", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_DATA_TYPE: {"name": "CS-Announcement-Data-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_DATA_VALUE: {"name": "CS-Announcement-Data-Value", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_BEARER_CAPABILITY: {"name": "CS-Bearer-Capability", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALL_REFERENCE_NUMBER: {"name": "CS-Call-Reference-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALLED_PARTY_NUMBER: {"name": "CS-Called-Party-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALLING_PARTYS_CATEGORY: {"name": "CS-Calling-Partys-Category", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALLING_PARTY_NUMBER: {"name": "CS-Calling-Party-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_EVENT_TYPE_BCSM: {"name": "CS-Event-Type-BCSM", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_FIRST_CALL_INDICATION: {"name": "CS-First-Call-Indication", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_FREE_FORMAT_DATA: {"name": "CS-Free-Format-Data", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_FURNISH_CHARGING_INFORMATION: {"name": "CS-Furnish-Charging-Information", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_HIGH_LAYER_COMPATIBILITY: {"name": "CS-High-Layer-Compatibility", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_INFORMATION: {"name": "CS-Information", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_LOCATION_INFORMATION: {"name": "CS-Location-Information", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_MSC_ADDRESS: {"name": "CS-MSC-Address", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ORIGINAL_CALLED_PARTY_ID: {"name": "CS-Original-Called-Party-ID", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ORIGINATING_LOCATION_NUMBER: {"name": "CS-Originating-Location-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_PARTY_TO_CHARGE: {"name": "CS-Party-To-Charge", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_REDIRECTING_PARTY_NUMBER: {"name": "CS-Redirecting-Party-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_REDIRECTION_INFORMATION: {"name": "CS-Redirection-Information", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_RELEASE_CAUSE_CODE: {"name": "CS-Release-Cause-Code", "type": AvpInteger32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_REROUTING_NUMBER: {"name": "CS-Rerouting-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_SERVICE_KEY: {"name": "CS-Service-Key", "type": AvpInteger32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_TERMINATING_VLR_NUMBER: {"name": "CS-Terminating-VLR-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_WARNING_PERIOD: {"name": "CS-Warning-Period", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ACCUMULATED_TIME: {"name": "CS-Accumulated-Time", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_LOGIC: {"name": "CS-Announcement-Logic", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ANNOUNCEMENT_TYPE: {"name": "CS-Announcement-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_BALANCE_TOPUP_DATA: {"name": "CS-Balance-TopUp-Data", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALL_SETUP_RESULT_CODE: {"name": "CS-Call-SetUp-Result-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CUSTOMER_DATA: {"name": "CS-Customer-Data", "type": AvpUtf8String, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_DIALOGUE_HANDLING: {"name": "CS-Dialogue-Handling", "type": AvpEnumerated, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_ISUP_RELEASE_CAUSE_CODE: {"name": "CS-ISUP-Release-Cause-Code", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_MAX_CALL_DURATION: {"name": "CS-Max-Call-Duration", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_RESULT_CODE: {"name": "CS-Result-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_START_OF_CHARGING: {"name": "CS-Start-Of-Charging", "type": AvpTime, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_TELESERVICE_CODE: {"name": "CS-Teleservice-Code", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_TRAFFIC_CASE: {"name": "CS-Traffic-Case", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO: {"name": "CS-AoC-Info", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E1: {"name": "CS-AoC-Info-e1", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E2: {"name": "CS-AoC-Info-e2", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E3: {"name": "CS-AoC-Info-e3", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E4: {"name": "CS-AoC-Info-e4", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E5: {"name": "CS-AoC-Info-e5", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E6: {"name": "CS-AoC-Info-e6", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_AOC_INFO_E7: {"name": "CS-AoC-Info-e7", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CALLED_PARTY_BCD_NUMBER: {"name": "CS-Called-Party-BCD-Number", "type": AvpOctetString, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_CONFERENCE_ID: {"name": "CS-Conference-Id", "type": AvpUtf8String, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_MULTIPARTY_CALL_INDICATION: {"name": "CS-MultiParty-Call-Indication", "type": AvpGrouped, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_NETWORK_TYPE: {"name": "CS-Network-Type", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__CS_SERVICE_ID: {"name": "CS-Service-Id", "type": AvpUnsigned32, "mandatory": True, "vendor": 27640},
    AVP_TELEFONICA_MOVILES_ESPA_S_A__OCS_ACCOUNT_MANAGEMENT_OP: {"name": "OCS-Account-Management-Op", "type": AvpUtf8String, "mandatory": True, "vendor": 27640}}

AVP_VENDOR_DICTIONARY[4329] = {
    AVP_SIEMENS_AG_SIEMENS_IMSI: {"name": "Siemens-IMSI", "type": AvpUtf8String, "mandatory": True, "vendor": 4329},
    AVP_SIEMENS_AG_SIEMENS_MSIDN: {"name": "Siemens-MSIDN", "type": AvpUtf8String, "mandatory": True, "vendor": 4329},
    AVP_SIEMENS_AG_SIEMENS_SERVER_NAME: {"name": "Siemens-Server-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 4329}}

AVP_VENDOR_DICTIONARY[311] = {
    AVP_MICROSOFT_MS_CHAP_RESPONSE: {"name": "MS-CHAP-Response", "type": AvpOctetString, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP_ERROR: {"name": "MS-CHAP-Error", "type": AvpUtf8String, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP_NT_ENC_PW: {"name": "MS-CHAP-NT-Enc-PW", "type": AvpOctetString, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP_DOMAIN: {"name": "MS-CHAP-Domain", "type": AvpUtf8String, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP_CHALLENGE: {"name": "MS-CHAP-Challenge", "type": AvpOctetString, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP2_RESPONSE: {"name": "MS-CHAP2-Response", "type": AvpOctetString, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP2_SUCCESS: {"name": "MS-CHAP2-Success", "type": AvpOctetString, "vendor": 311},
    AVP_MICROSOFT_MS_CHAP2_CPW: {"name": "MS-CHAP2-CPW", "type": AvpOctetString, "vendor": 311}}

AVP_VENDOR_DICTIONARY[19444] = {
    AVP_METASWITCH_METASWITCH_INFORMATION: {"name": "Metaswitch-Information", "type": AvpGrouped, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_ADJACENCY_NAME: {"name": "Adjacency-Name", "type": AvpGrouped, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_INCOMING_ADJACENCY_NAME: {"name": "Incoming-Adjacency-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_OUTGOING_ADJACENCY_NAME: {"name": "Outgoing-Adjacency-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_ACCOUNT_NAME: {"name": "Account-Name", "type": AvpGrouped, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_INCOMING_ACCOUNT_NAME: {"name": "Incoming-Account-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_OUTGOING_ACCOUNT_NAME: {"name": "Outgoing-Account-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_SIP_DIVERSION: {"name": "SIP-Diversion", "type": AvpUtf8String, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_INPUT_OUTPUT_OCTETS: {"name": "Input-Output-Octets", "type": AvpGrouped, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_INGRESS_INPUT_OCTETS: {"name": "Ingress-Input-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_INGRESS_OUTPUT_OCTETS: {"name": "Ingress-Output-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_EGRESS_INPUT_OCTETS: {"name": "Egress-Input-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_EGRESS_OUTPUT_OCTETS: {"name": "Egress-Output-Octets", "type": AvpUnsigned32, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_DISCONNECT_DIRECTION: {"name": "Disconnect-Direction", "type": AvpEnumerated, "mandatory": True, "vendor": 19444},
    AVP_METASWITCH_MEDIA_DESCRIPTION: {"name": "Media-Description", "type": AvpUtf8String, "mandatory": True, "vendor": 19444}}

AVP_VENDOR_DICTIONARY[45687] = {
    AVP_ONEM2M_ACCESS_NETWORK_IDENTIFIER: {"name": "Access-Network-Identifier", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_APPLICATION_ENTITY_ID: {"name": "Application-Entity-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_CONTROL_MEMORY_SIZE: {"name": "Control-Memory-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_CURRENT_NUMBER_MEMBERS: {"name": "Current-Number-Members", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_DATA_MEMORY_SIZE: {"name": "Data-Memory-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_EXTERNAL_ID: {"name": "External-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_GROUP_NAME: {"name": "Group-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_HOSTING_CSE_ID: {"name": "Hosting-CSE-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_ORIGINATOR: {"name": "Originator", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_MAXIMUM_NUMBER_MEMBERS: {"name": "Maximum-Number-Members", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_M2M_EVENT_RECORD_TIMESTAMP: {"name": "M2M-Event-Record-Timestamp", "type": AvpTime, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_M2M_INFORMATION: {"name": "M2M-Information", "type": AvpGrouped, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_OCCUPANCY: {"name": "Occupancy", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_PROTOCOL_TYPE: {"name": "Protocol-Type", "type": AvpEnumerated, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_RECEIVER: {"name": "Receiver", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_REQUEST_BODY_SIZE: {"name": "Request-Body-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_REQUEST_HEADERS_SIZE: {"name": "Request-Headers-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_REQUEST_OPERATION: {"name": "Request-Operation", "type": AvpEnumerated, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_RESPONSE_BODY_SIZE: {"name": "Response-Body-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_RESPONSE_HEADERS_SIZE: {"name": "Response-Headers-Size", "type": AvpUnsigned32, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_RESPONSE_STATUS_CODE: {"name": "Response-Status-Code", "type": AvpEnumerated, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_SUBGROUP_NAME: {"name": "Subgroup-Name", "type": AvpUtf8String, "mandatory": True, "vendor": 45687},
    AVP_ONEM2M_TARGET_ID: {"name": "Target-ID", "type": AvpUtf8String, "mandatory": True, "vendor": 45687}
}