import re
from unittest import TestCase

from python_dice.src.syntax.constant_integer_syntax import ConstantIntegerSyntax


class TestConstantIntegerSyntax(TestCase):
    def test_constant_integers_get_token_name(self):
        self.assertEqual(
            "CONSTANT_INTEGER",
            ConstantIntegerSyntax.get_token_name(),
        )

    def test_constant_integers_get_token_regex(self):
        self.assertEqual(r"-?\d+", ConstantIntegerSyntax.get_token_regex())

    def test_constant_integer_regex_will_match(self):
        test_cases = [
            "-31982473918274",
            "-3",
            "0",
            "1",
            "0003",
            "12",
            "41",
            "87",
            "902",
            "12983",
            "15412",
            "1000000000000000000000000000",
        ]
        for test_case in test_cases:
            self.assertTrue(
                re.match(
                    ConstantIntegerSyntax.get_token_regex(),
                    test_case,
                ),
                f"did not match on case test_case {test_case}",
            )

    def test_constant_integer_regex_will_not_match(self):
        test_cases = ["a", "just a string", "", " "]
        for test_case in test_cases:
            self.assertIsNone(
                re.match(
                    ConstantIntegerSyntax.get_token_regex(),
                    test_case,
                ),
                f"matched on case test_case {test_case}",
            )
