import importlib
import json

from rest_framework.response import Response


class Singleton(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(Singleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]


class UrlDefinitionIncomplete(Exception):
    pass


class PermissionDenied(Exception):
    pass


def parametrized(dec):
    def layer(**kwargs):
        def repl(f):
            return dec(f, **kwargs)

        return repl

    return layer



@parametrized
def pass_handler(f, query_method, permissions, response_serializer, schema):
    def inner(request, *args, **kwargs):
        return f(request, query_method,permissions, response_serializer, schema, *args, **kwargs)

    return inner

def validate_allowed_method(allowed_method, incomming_method ):
    if not allowed_method or incomming_method.lower() != allowed_method.lower():
        return Response({'error': "this request method is not allowed"}, status=405)

def verify_permissions(req, cls):
    if not(cls().has_permission(req,None)):
        raise PermissionDenied("You are not Authorised for this request, raising alarms, FIA will soon come to knock at your door")

def extract_res_serialiser(response_serializer):
        if response_serializer:
            module = '.'.join(response_serializer.split('.')[:-1])
            cls = response_serializer.split('.').pop()
            return getattr(importlib.import_module(module), cls)
        return None

def extract_req_data(method, request, schema):
    if method == 'get':
        req_data = getattr(request, 'query_params')
        req_data._mutable = True
    else:
        req_data = getattr(request, 'data')

    if type(req_data) == str:
        req_data = json.loads(req_data)

    if schema:
        for i in schema.keys():
            req_data[i] = schema[i](req_data[i])
    return req_data,tuple(req_data.get('args',[])), dict(req_data.get('kwargs',{})),  dict(req_data.get('__filter_criteria',{}))
