# -*- coding: utf-8 -*-

VERSION = (2020, 9, 30)
PRERELEASE = "alpha"  # alpha, beta or rc
REVISION = 2


def generate_version(version, prerelease=None, revision=None):
    version_parts = [".".join(map(str, version))]
    if prerelease is not None:
        version_parts.append(f"-{prerelease}")
    if revision is not None:
        version_parts.append(f".{revision}")
    return "".join(version_parts)


__title__ = "python-doc"
__description__ = "Open Python docs in the browser."
__url__ = "https://github.com/vinayak-mehta/python-doc"
__version__ = generate_version(VERSION, prerelease=PRERELEASE, revision=REVISION)
__author__ = "Vinayak Mehta"
__author_email__ = "vmehta94@gmail.com"
__license__ = "Apache 2.0"
