from typing import Union, Optional, Literal, Dict
from typing_extensions import TypedDict

class SVGElementProps(TypedDict, total=False):
    ...

class _SVGElementProps(TypedDict, total=False):
    # Attributes also defined in HTMLAttributes
    class_name: Optional[str]
    color: Optional[str]
    height: Optional[Union[int, str]]
    id: Optional[str]
    lang: Optional[str]
    max: Optional[Union[int, str]]
    media: Optional[str]
    method: Optional[str]
    min: Optional[Union[int, str]]
    name: Optional[str]
    style: Optional[Dict]
    target: Optional[str]
    type: Optional[str]
    width: Optional[Union[int, str]]

    # Other HTML properties supported by SVG elements in browsers
    role: Optional[str]
    tab_index: Optional[int]
    cross_origin: Optional[str]

    # SVG Specific attributes
    accent_height: Optional[Union[int, str]]
    accumulate: Optional[Literal["none", "sum"]]
    additive: Optional[Literal["replace", "sum"]]
    alignment_baseline: Optional[
        Literal[
            "auto",
            "baseline",
            "before-edge",
            "text-before-edge",
            "middle",
            "central",
            "after-edge",
            "text-after-edge",
            "ideographic",
            "alphabetic",
            "hanging",
            "mathematical",
            "inherit",
        ]
    ]
    allow_reorder: Optional[Literal["no", "yes"]]
    alphabetic: Optional[Union[int, str]]
    amplitude: Optional[Union[int, str]]
    arabic_form: Optional[Literal["initial", "medial", "terminal", "isolated"]]
    ascent: Optional[Union[int, str]]
    attribute_name: Optional[str]
    attribute_type: Optional[str]
    auto_reverse: Optional[bool]
    azimuth: Optional[Union[int, str]]
    base_frequency: Optional[Union[int, str]]
    baseline_shift: Optional[Union[int, str]]
    base_profile: Optional[Union[int, str]]
    bbox: Optional[Union[int, str]]
    begin: Optional[Union[int, str]]
    bias: Optional[Union[int, str]]
    by: Optional[Union[int, str]]
    calc_mode: Optional[Union[int, str]]
    cap_height: Optional[Union[int, str]]
    clip: Optional[Union[int, str]]
    clip_path: Optional[str]
    clip_path_units: Optional[Union[int, str]]
    clip_rule: Optional[Union[int, str]]
    color_interpolation: Optional[Union[int, str]]
    color_interpolation_filters: Optional[
        Literal["auto", "sRGB", "linearRGB", "inherit"]
    ]
    color_profile: Optional[Union[int, str]]
    color_rendering: Optional[Union[int, str]]
    content_script_type: Optional[Union[int, str]]
    content_style_type: Optional[Union[int, str]]
    cursor: Optional[Union[int, str]]
    cx: Optional[Union[int, str]]
    cy: Optional[Union[int, str]]
    d: Optional[str]
    decelerate: Optional[Union[int, str]]
    descent: Optional[Union[int, str]]
    diffuse_constant: Optional[Union[int, str]]
    direction: Optional[Union[int, str]]
    display: Optional[Union[int, str]]
    divisor: Optional[Union[int, str]]
    dominant_baseline: Optional[Union[int, str]]
    dur: Optional[Union[int, str]]
    dx: Optional[Union[int, str]]
    dy: Optional[Union[int, str]]
    edge_mode: Optional[Union[int, str]]
    elevation: Optional[Union[int, str]]
    enable_background: Optional[Union[int, str]]
    end: Optional[Union[int, str]]
    exponent: Optional[Union[int, str]]
    external_resources_required: Optional[bool]
    fill: Optional[str]
    fill_opacity: Optional[Union[int, str]]
    fill_rule: Optional[Literal["nonzero", "evenodd", "inherit"]]
    filter: Optional[str]
    filter_res: Optional[Union[int, str]]
    filter_units: Optional[Union[int, str]]
    flood_color: Optional[Union[int, str]]
    flood_opacity: Optional[Union[int, str]]
    focusable: Optional[Union[bool, Literal["auto"]]]
    font_family: Optional[str]
    font_size: Optional[Union[int, str]]
    font_size_adjust: Optional[Union[int, str]]
    font_stretch: Optional[Union[int, str]]
    font_style: Optional[Union[int, str]]
    font_variant: Optional[Union[int, str]]
    font_weight: Optional[Union[int, str]]
    format: Optional[Union[int, str]]
    fr: Optional[Union[int, str]]
    from_: Optional[Union[int, str]]
    fx: Optional[Union[int, str]]
    fy: Optional[Union[int, str]]
    g1: Optional[Union[int, str]]
    g2: Optional[Union[int, str]]
    glyph_name: Optional[Union[int, str]]
    glyph_orientation_horizontal: Optional[Union[int, str]]
    glyph_orientation_vertical: Optional[Union[int, str]]
    glyph_ref: Optional[Union[int, str]]
    gradient_transform: Optional[str]
    gradient_units: Optional[str]
    hanging: Optional[Union[int, str]]
    horiz_adv_x: Optional[Union[int, str]]
    horiz_origin_x: Optional[Union[int, str]]
    href: Optional[str]
    ideographic: Optional[Union[int, str]]
    image_rendering: Optional[Union[int, str]]
    in2: Optional[Union[int, str]]
    in_: Optional[str]
    intercept: Optional[Union[int, str]]
    k1: Optional[Union[int, str]]
    k2: Optional[Union[int, str]]
    k3: Optional[Union[int, str]]
    k4: Optional[Union[int, str]]
    k: Optional[Union[int, str]]
    kernel_matrix: Optional[Union[int, str]]
    kernel_unit_length: Optional[Union[int, str]]
    kerning: Optional[Union[int, str]]
    key_points: Optional[Union[int, str]]
    key_splines: Optional[Union[int, str]]
    key_times: Optional[Union[int, str]]
    length_adjust: Optional[Union[int, str]]
    letter_spacing: Optional[Union[int, str]]
    lighting_color: Optional[Union[int, str]]
    limiting_cone_angle: Optional[Union[int, str]]
    local: Optional[Union[int, str]]
    marker_end: Optional[str]
    marker_height: Optional[Union[int, str]]
    marker_mid: Optional[str]
    marker_start: Optional[str]
    marker_units: Optional[Union[int, str]]
    marker_width: Optional[Union[int, str]]
    mask: Optional[str]
    mask_content_units: Optional[Union[int, str]]
    mask_units: Optional[Union[int, str]]
    mathematical: Optional[Union[int, str]]
    mode: Optional[Union[int, str]]
    num_octaves: Optional[Union[int, str]]
    offset: Optional[Union[int, str]]
    opacity: Optional[Union[int, str]]
    operator: Optional[Union[int, str]]
    order: Optional[Union[int, str]]
    orient: Optional[Union[int, str]]
    orientation: Optional[Union[int, str]]
    origin: Optional[Union[int, str]]
    overflow: Optional[Union[int, str]]
    overline_position: Optional[Union[int, str]]
    overline_thickness: Optional[Union[int, str]]
    paint_order: Optional[Union[int, str]]
    panose_1: Optional[Union[int, str]]
    path: Optional[str]
    path_length: Optional[Union[int, str]]
    pattern_content_units: Optional[str]
    pattern_transform: Optional[str]
    pattern_units: Optional[str]
    pointer_events: Optional[Union[int, str]]
    points: Optional[str]
    points_at_x: Optional[Union[int, str]]
    points_at_y: Optional[Union[int, str]]
    points_at_z: Optional[Union[int, str]]
    preserve_alpha: Optional[Union[int, str]]
    preserve_aspect_ratio: Optional[str]
    primitive_units: Optional[Union[int, str]]
    r: Optional[Union[int, str]]
    radius: Optional[Union[int, str]]
    ref_x: Optional[Union[int, str]]
    ref_y: Optional[Union[int, str]]
    rendering_intent: Optional[Union[int, str]]
    repeat_count: Optional[Union[int, str]]
    repeat_dur: Optional[Union[int, str]]
    required_extensions: Optional[Union[int, str]]
    required_features: Optional[Union[int, str]]
    restart: Optional[Union[int, str]]
    result: Optional[str]
    rotate: Optional[Union[int, str]]
    rx: Optional[Union[int, str]]
    ry: Optional[Union[int, str]]
    scale: Optional[Union[int, str]]
    seed: Optional[Union[int, str]]
    shape_rendering: Optional[Union[int, str]]
    slope: Optional[Union[int, str]]
    spacing: Optional[Union[int, str]]
    specular_constant: Optional[Union[int, str]]
    specular_exponent: Optional[Union[int, str]]
    speed: Optional[Union[int, str]]
    spread_method: Optional[str]
    start_offset: Optional[Union[int, str]]
    std_deviation: Optional[Union[int, str]]
    stemh: Optional[Union[int, str]]
    stemv: Optional[Union[int, str]]
    stitch_tiles: Optional[Union[int, str]]
    stop_color: Optional[str]
    stop_opacity: Optional[Union[int, str]]
    strikethrough_position: Optional[Union[int, str]]
    strikethrough_thickness: Optional[Union[int, str]]
    string: Optional[Union[int, str]]
    stroke: Optional[str]
    stroke_dasharray: Optional[Union[int, str]]
    stroke_dashoffset: Optional[Union[int, str]]
    stroke_linecap: Optional[Literal["butt", "round", "square", "inherit"]]
    stroke_linejoin: Optional[Literal["miter", "round", "bevel", "inherit"]]
    stroke_miterlimit: Optional[Union[int, str]]
    stroke_opacity: Optional[Union[int, str]]
    stroke_width: Optional[Union[int, str]]
    surface_scale: Optional[Union[int, str]]
    system_language: Optional[Union[int, str]]
    table_values: Optional[Union[int, str]]
    target_x: Optional[Union[int, str]]
    target_y: Optional[Union[int, str]]
    text_anchor: Optional[Literal["start", "middle", "end", "inherit"]]
    text_decoration: Optional[Union[int, str]]
    text_length: Optional[Union[int, str]]
    text_rendering: Optional[Union[int, str]]
    to: Optional[Union[int, str]]
    transform: Optional[str]
    u1: Optional[Union[int, str]]
    u2: Optional[Union[int, str]]
    underline_position: Optional[Union[int, str]]
    underline_thickness: Optional[Union[int, str]]
    unicode: Optional[str]
    unicode_bidi: Optional[Union[int, str]]
    unicode_range: Optional[Union[int, str]]
    units_per_em: Optional[Union[int, str]]
    v_alphabetic: Optional[Union[int, str]]
    values: Optional[str]
    vector_effect: Optional[Union[int, str]]
    version: Optional[str]
    vert_adv_y: Optional[Union[int, str]]
    vert_origin_x: Optional[Union[int, str]]
    vert_origin_y: Optional[Union[int, str]]
    v_hanging: Optional[Union[int, str]]
    v_ideographic: Optional[Union[int, str]]
    view_box: Optional[str]
    view_target: Optional[Union[int, str]]
    visibility: Optional[Union[int, str]]
    v_mathematical: Optional[Union[int, str]]
    widths: Optional[Union[int, str]]
    word_spacing: Optional[Union[int, str]]
    writing_mode: Optional[Union[int, str]]
    x1: Optional[Union[int, str]]
    x2: Optional[Union[int, str]]
    x: Optional[Union[int, str]]
    x_channel_selector: Optional[Union[int, str]]
    x_height: Optional[Union[int, str]]
    xlink_actuate: Optional[Literal["onLoad", "onRequest", "other", "none"]]
    xlink_arcrole: Optional[str]
    xlink_href: Optional[str]
    xlink_role: Optional[str]
    xlink_show: Optional[Literal["new", "replace", "embed", "other", "none"]]
    xlink_title: Optional[str]
    xlink_type: Optional[
        Literal["simple", "extended", "title", "resource", "locator", "arc"]
    ]
    xmlns: Optional[str]
    xmlns_xlink: Optional[str]
    xml_base: Optional[str]
    xml_lang: Optional[str]
    xml_space: Optional[str]
    y1: Optional[Union[int, str]]
    y2: Optional[Union[int, str]]
    y: Optional[Union[int, str]]
    y_channel_selector: Optional[Union[int, str]]
    z: Optional[Union[int, str]]
    zoom_and_pan: Optional[Union[int, str]]
