from .component import Component
from .context.context import Context, set_default_context
from .html import *
from .svg import *
from .rendering import render
from .version import version as __version__

set_default_context(Context.standard())
del set_default_context

__all__ = [
    # HTML
    "A",
    "Abbr",
    "Address",
    "Area",
    "Article",
    "Aside",
    "B",
    "Base",
    "BlockQuote",
    "Body",
    "Br",
    "Button",
    "Canvas",
    "Cite",
    "Code",
    "Col",
    "Div",
    "Em",
    "Embed",
    "Footer",
    "Form",
    "Fragment",
    "H1",
    "H2",
    "H3",
    "H4",
    "H5",
    "H6",
    "Head",
    "Header",
    "Hr",
    "Html",
    "I",
    "Img",
    "Input",
    "Label",
    "Li",
    "Link",
    "Main",
    "Meta",
    "Nav",
    "Ol",
    "Option",
    "P",
    "Param",
    "Pre",
    "Script",
    "Section",
    "Select",
    "Small",
    "Source",
    "Span",
    "Strong",
    "Style",
    "Sub",
    "Sup",
    "Table",
    "TBody",
    "Td",
    "TextArea",
    "Th",
    "THead",
    "Time",
    "Title",
    "Tr",
    "Track",
    "U",
    "Ul",
    "Wbr",
    # SVG
    "SvgA",
    "Animate",
    "AnimateMotion",
    "AnimateTransform",
    "Circle",
    "ClipPath",
    "Defs",
    "Desc",
    "Ellipse",
    "FeBlend",
    "FeColorMatrix",
    "FeComponentTransfer",
    "FeComposite",
    "FeConvolveMatrix",
    "FeDiffuseLighting",
    "FeDisplacementMap",
    "FeDistantLight",
    "FeDropShadow",
    "FeFlood",
    "FeFuncA",
    "FeFuncB",
    "FeFuncG",
    "FeFuncR",
    "FeGaussianBlur",
    "FeImage",
    "FeMerge",
    "FeMergeNode",
    "FeMorphology",
    "FeOffset",
    "FePointLight",
    "FeSpecularLighting",
    "FeSpotLight",
    "FeTile",
    "FeTurbulence",
    "Filter",
    "ForeignObject",
    "G",
    "Image",
    "Line",
    "LinearGradient",
    "Marker",
    "Mask",
    "Metadata",
    "MPath",
    "Path",
    "Pattern",
    "Polygon",
    "Polyline",
    "RadialGradient",
    "Rect",
    "SvgScript",
    "Set",
    "Stop",
    "SvgStyle",
    "Svg",
    "Switch",
    "Symbol",
    "Text",
    "TextPath",
    "Title",
    "TSpan",
    "Use",
    "View",

    # PyDOM
    "Component",
    "Context",
    "render",
    "__version__",
]
