# Python Data Structures and Algorithms

No non-sense solutions to common Data Structure and Algorithm interview questions in Python.

## Objective

There are a plenty of resources when it comes to interview preparations on the internet. What prompted me to create this project was the dissimilarity across different approaches and the infused complexity of the code.

Feel free to contribute but please follow the Contributing Guidelines as I want to maintain the uniformity of the implementation of data structures and algorithms. Last time around, people bombarded with me with Pull Requests, Issues and Emails insisting me to merge their changes

The open source community has helped me a lot during my interview preparations and studies while I was in my undergrad. I always wanted to give something back to the community. In my endeavour to contribute something back, I will be uploading data structures and algorithms questions in Python in this repo. Feel free to contribute and get in touch!

## Structure of the repository

As of now, the repository contains 3 main directories: [**Bookmarks**](bookmarks), [**Data Structures**](data_structures) and [**Algorithms**](algorithms).

### Data Structures

Contains all data structure questions categorised into sub-directories like stack, queue, etc according to their type.

1. [Array](data_structures/array)
2. [Dictionary]()
3. [Binary Search Tree](data_structures/bst)
4. [Linked List](data_structures/linked_list)
5. [Stack](data_structures/stack)
6. [Graphs](data_structures/graphs)
7. [Circular Linked List](data_structures/circular_linked_list)
8. [Doubly Linked List](data_structures/doubly_linked_list)

### Algorithms

This directory contains various types of algorithm questions like Dynamic Programming, Sorting, Greedy, etc. The current structure of this directory is like -

1. [Dynamic Programming](algorithms/dynamic_programming)
2. [Graphs](algorithms/graph)
3. [Greedy](algorithms/greedy)
4. [Math](algorithms/math)
5. [Misc](algorithms/miscellaneous)
6. [Sorting](algorithms/sorting)
7. [Bit Manipulation](algorithms/bit_manipulation)

### Bookmarks

You can find useful links in this repository in the different markdown files. Below is a table of contents.

| Category | Link |
| :-- | :--: |
| Articles | [Click Here](bookmarks/articles.md) |
| Books | [Click Here](bookmarks/books.md) |
| Topics | [Click Here](bookmarks/topics.md) |
| Tutorials | [Click Here](bookmarks/tutorials.md) |
| Videos | [Click Here](bookmarks/videos.md) |
| Misc. | [Click Here](bookmarks/misc.md) |

## Things need to be done

As you can see, the repo is still in its infancy. Here are some key things in the to-do.

1. Queue questions
2. Algorithms
3. More questions in data structures, especially for graph, circular linked list, trees, heaps and hash.

## Contributing

Contributions are always welcomed.
Feel free to raise new issues, file new PRs. Consider giving it a star and fork this repo!

To follow the guidelines, refer to [Contributing.md](CONTRIBUTING.md)

## License

[MIT](LICENSE)
