# Python EDA in CLI -- Exploratory Data Analysis in Command Line Interface

This project wraps the python exploratory data analysis tool sweetviz in a commandline interface.

---
## Installation
You can install this package with pip. It supports Python versions 3.6+.

```shell
pip install python-eda
```

---
## Usage

### Generate report for a dataset

```
pyeda report <path-to-dataset>
```

### Generate report for a dataset with a target variable

```
pyeda target <path-to-dataset> <target-variable>
```

### Generate comparison report between two datasets

```
pyeda compare <path-to-dataset1> <path-to-dataset2>
```

### Generate comparison report between two datasets with a target variable

```
pyeda compare <path-to-dataset1> <path-to-dataset2> <target-variable>
```

---
## Python EDA Illustration
The creation of this EDA is explained in the Towards data science post [Python Exploratory Data Analysis](https://towardsdatascience.com/how-to-do-a-ton-of-analysis-in-the-blink-of-an-eye-16fa9affce06)

Packaging and distribution of this CLI EDA tool using Poetry, is explained in [You Are Not Still Using Virtualenv, Are You?](https://towardsdatascience.com/poetry-to-complement-virtualenv-44088cc78fd1)

For more interesting data science tactics please visit my [Medium profile](https://thuwarakesh.medium.com). 