# Copyright (C) 2007-2016 various contributors (see AUTHORS)
#
# This file is part of Python-EFL.
#
# Python-EFL is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
#
# Python-EFL is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this Python-EFL.  If not, see <http://www.gnu.org/licenses/>.
#

from cpython cimport PyUnicode_AsUTF8String, PyMem_Malloc, Py_DECREF, Py_INCREF
from libc.string cimport memcpy, strdup
from libc.stdlib cimport malloc, free
from libc.stdint cimport uintptr_t

from efl.evas cimport Object as evasObject, Evas_Coord_Rectangle, Rect

from efl.utils.conversions cimport _touni, _ctouni, \
    python_list_strings_to_eina_list, eina_list_strings_to_python_list

from efl.utils.logger cimport add_logger

from efl.eina cimport EINA_LOG_DOM_DBG, EINA_LOG_DOM_INFO, \
    EINA_LOG_DOM_WARN, EINA_LOG_DOM_ERR, EINA_LOG_DOM_CRIT

from efl.ecore cimport Event, EventHandler, _event_mapping_register


import sys
import traceback
import atexit


cimport efl.elementary.enums as enums


EDJE_CHANNEL_EFFECT = enums.EDJE_CHANNEL_EFFECT
EDJE_CHANNEL_BACKGROUND = enums.EDJE_CHANNEL_BACKGROUND
EDJE_CHANNEL_MUSIC = enums.EDJE_CHANNEL_MUSIC
EDJE_CHANNEL_FOREGROUND = enums.EDJE_CHANNEL_FOREGROUND
EDJE_CHANNEL_INTERFACE = enums.EDJE_CHANNEL_INTERFACE
EDJE_CHANNEL_INPUT = enums.EDJE_CHANNEL_INPUT
EDJE_CHANNEL_ALERT = enums.EDJE_CHANNEL_ALERT
EDJE_CHANNEL_ALL = enums.EDJE_CHANNEL_ALL


ELM_EVENT_CONFIG_ALL_CHANGED = enums.ELM_EVENT_CONFIG_ALL_CHANGED
ELM_EVENT_POLICY_CHANGED = enums.ELM_EVENT_POLICY_CHANGED
ELM_EVENT_PROCESS_BACKGROUND = enums.ELM_EVENT_PROCESS_BACKGROUND
ELM_EVENT_PROCESS_FOREGROUND = enums.ELM_EVENT_PROCESS_FOREGROUND
ELM_ECORE_EVENT_ETHUMB_CONNECT = enums.ELM_ECORE_EVENT_ETHUMB_CONNECT
ELM_EVENT_SYS_NOTIFY_NOTIFICATION_CLOSED = enums.ELM_EVENT_SYS_NOTIFY_NOTIFICATION_CLOSED
ELM_EVENT_SYS_NOTIFY_ACTION_INVOKED = enums.ELM_EVENT_SYS_NOTIFY_ACTION_INVOKED
ELM_EVENT_SYSTRAY_READY = enums.ELM_EVENT_SYSTRAY_READY


ELM_FOCUS_PREVIOUS = enums.ELM_FOCUS_PREVIOUS
ELM_FOCUS_NEXT = enums.ELM_FOCUS_NEXT
ELM_FOCUS_UP = enums.ELM_FOCUS_UP
ELM_FOCUS_DOWN = enums.ELM_FOCUS_DOWN
ELM_FOCUS_RIGHT = enums.ELM_FOCUS_RIGHT
ELM_FOCUS_LEFT = enums.ELM_FOCUS_LEFT

ELM_FOCUS_MOVE_POLICY_CLICK = enums.ELM_FOCUS_MOVE_POLICY_CLICK
ELM_FOCUS_MOVE_POLICY_IN = enums.ELM_FOCUS_MOVE_POLICY_IN
ELM_FOCUS_MOVE_POLICY_KEY_ONLY = enums.ELM_FOCUS_MOVE_POLICY_KEY_ONLY

ELM_FOCUS_REGION_SHOW_WIDGET = enums.ELM_FOCUS_REGION_SHOW_WIDGET
ELM_FOCUS_REGION_SHOW_ITEM = enums.ELM_FOCUS_REGION_SHOW_ITEM

ELM_FOCUS_AUTOSCROLL_MODE_SHOW = enums.ELM_FOCUS_AUTOSCROLL_MODE_SHOW
ELM_FOCUS_AUTOSCROLL_MODE_NONE = enums.ELM_FOCUS_AUTOSCROLL_MODE_NONE
ELM_FOCUS_AUTOSCROLL_MODE_BRING_IN = enums.ELM_FOCUS_AUTOSCROLL_MODE_BRING_IN

ELM_SEL_TYPE_PRIMARY = enums.ELM_SEL_TYPE_PRIMARY
ELM_SEL_TYPE_SECONDARY = enums.ELM_SEL_TYPE_SECONDARY
ELM_SEL_TYPE_XDND = enums.ELM_SEL_TYPE_XDND
ELM_SEL_TYPE_CLIPBOARD = enums.ELM_SEL_TYPE_CLIPBOARD

ELM_SEL_FORMAT_TARGETS = enums.ELM_SEL_FORMAT_TARGETS
ELM_SEL_FORMAT_NONE = enums.ELM_SEL_FORMAT_NONE
ELM_SEL_FORMAT_TEXT = enums.ELM_SEL_FORMAT_TEXT
ELM_SEL_FORMAT_MARKUP = enums.ELM_SEL_FORMAT_MARKUP
ELM_SEL_FORMAT_IMAGE = enums.ELM_SEL_FORMAT_IMAGE
ELM_SEL_FORMAT_VCARD = enums.ELM_SEL_FORMAT_VCARD
ELM_SEL_FORMAT_HTML = enums.ELM_SEL_FORMAT_HTML

ELM_XDND_ACTION_UNKNOWN = enums.ELM_XDND_ACTION_UNKNOWN
ELM_XDND_ACTION_COPY = enums.ELM_XDND_ACTION_COPY
ELM_XDND_ACTION_MOVE = enums.ELM_XDND_ACTION_MOVE
ELM_XDND_ACTION_PRIVATE = enums.ELM_XDND_ACTION_PRIVATE
ELM_XDND_ACTION_ASK = enums.ELM_XDND_ACTION_ASK
ELM_XDND_ACTION_LIST = enums.ELM_XDND_ACTION_LIST
ELM_XDND_ACTION_LINK = enums.ELM_XDND_ACTION_LINK
ELM_XDND_ACTION_DESCRIPTION = enums.ELM_XDND_ACTION_DESCRIPTION

ELM_TOOLTIP_ORIENT_NONE = enums.ELM_TOOLTIP_ORIENT_NONE
ELM_TOOLTIP_ORIENT_TOP_LEFT = enums.ELM_TOOLTIP_ORIENT_TOP_LEFT
ELM_TOOLTIP_ORIENT_TOP = enums.ELM_TOOLTIP_ORIENT_TOP
ELM_TOOLTIP_ORIENT_TOP_RIGHT = enums.ELM_TOOLTIP_ORIENT_TOP_RIGHT
ELM_TOOLTIP_ORIENT_LEFT = enums.ELM_TOOLTIP_ORIENT_LEFT
ELM_TOOLTIP_ORIENT_CENTER = enums.ELM_TOOLTIP_ORIENT_CENTER
ELM_TOOLTIP_ORIENT_RIGHT = enums.ELM_TOOLTIP_ORIENT_RIGHT
ELM_TOOLTIP_ORIENT_BOTTOM_LEFT = enums.ELM_TOOLTIP_ORIENT_BOTTOM_LEFT
ELM_TOOLTIP_ORIENT_BOTTOM = enums.ELM_TOOLTIP_ORIENT_BOTTOM
ELM_TOOLTIP_ORIENT_BOTTOM_RIGHT = enums.ELM_TOOLTIP_ORIENT_BOTTOM_RIGHT
ELM_TOOLTIP_ORIENT_LAST = enums.ELM_TOOLTIP_ORIENT_LAST

ELM_POLICY_QUIT = enums.ELM_POLICY_QUIT
ELM_POLICY_EXIT = enums.ELM_POLICY_EXIT
ELM_POLICY_THROTTLE = enums.ELM_POLICY_THROTTLE
ELM_POLICY_LAST = enums.ELM_POLICY_LAST

ELM_POLICY_QUIT_NONE = enums.ELM_POLICY_QUIT_NONE
ELM_POLICY_QUIT_LAST_WINDOW_CLOSED = enums.ELM_POLICY_QUIT_LAST_WINDOW_CLOSED
ELM_POLICY_QUIT_LAST_WINDOW_HIDDEN = enums.ELM_POLICY_QUIT_LAST_WINDOW_HIDDEN

ELM_POLICY_EXIT_NONE = enums.ELM_POLICY_EXIT_NONE
ELM_POLICY_EXIT_WINDOWS_DEL = enums.ELM_POLICY_EXIT_WINDOWS_DEL

ELM_POLICY_THROTTLE_CONFIG = enums.ELM_POLICY_THROTTLE_CONFIG
ELM_POLICY_THROTTLE_HIDDEN_ALWAYS = enums.ELM_POLICY_THROTTLE_HIDDEN_ALWAYS
ELM_POLICY_THROTTLE_NEVER = enums.ELM_POLICY_THROTTLE_NEVER

ELM_SYS_NOTIFY_URGENCY_LOW = enums.ELM_SYS_NOTIFY_URGENCY_LOW
ELM_SYS_NOTIFY_URGENCY_NORMAL = enums.ELM_SYS_NOTIFY_URGENCY_NORMAL
ELM_SYS_NOTIFY_URGENCY_CRITICAL = enums.ELM_SYS_NOTIFY_URGENCY_CRITICAL

ELM_GLOB_MATCH_NO_ESCAPE = enums.ELM_GLOB_MATCH_NO_ESCAPE
ELM_GLOB_MATCH_PATH = enums.ELM_GLOB_MATCH_PATH
ELM_GLOB_MATCH_PERIOD = enums.ELM_GLOB_MATCH_PERIOD
ELM_GLOB_MATCH_NOCASE = enums.ELM_GLOB_MATCH_NOCASE

ELM_PROCESS_STATE_FOREGROUND = enums.ELM_PROCESS_STATE_FOREGROUND
ELM_PROCESS_STATE_BACKGROUND = enums.ELM_PROCESS_STATE_BACKGROUND

ELM_SYS_NOTIFY_URGENCY_LOW = enums.ELM_SYS_NOTIFY_URGENCY_LOW
ELM_SYS_NOTIFY_URGENCY_NORMAL = enums.ELM_SYS_NOTIFY_URGENCY_NORMAL
ELM_SYS_NOTIFY_URGENCY_CRITICAL = enums.ELM_SYS_NOTIFY_URGENCY_CRITICAL

ELM_ACTIONSLIDER_NONE = enums.ELM_ACTIONSLIDER_NONE
ELM_ACTIONSLIDER_LEFT = enums.ELM_ACTIONSLIDER_LEFT
ELM_ACTIONSLIDER_CENTER = enums.ELM_ACTIONSLIDER_CENTER
ELM_ACTIONSLIDER_RIGHT = enums.ELM_ACTIONSLIDER_RIGHT
ELM_ACTIONSLIDER_ALL = enums.ELM_ACTIONSLIDER_ALL

ELM_BG_OPTION_CENTER = enums.ELM_BG_OPTION_CENTER
ELM_BG_OPTION_SCALE = enums.ELM_BG_OPTION_SCALE
ELM_BG_OPTION_STRETCH = enums.ELM_BG_OPTION_STRETCH
ELM_BG_OPTION_TILE = enums.ELM_BG_OPTION_TILE
ELM_BG_OPTION_LAST = enums.ELM_BG_OPTION_LAST

ELM_BUBBLE_POS_TOP_LEFT = enums.ELM_BUBBLE_POS_TOP_LEFT
ELM_BUBBLE_POS_TOP_RIGHT = enums.ELM_BUBBLE_POS_TOP_RIGHT
ELM_BUBBLE_POS_BOTTOM_LEFT = enums.ELM_BUBBLE_POS_BOTTOM_LEFT
ELM_BUBBLE_POS_BOTTOM_RIGHT = enums.ELM_BUBBLE_POS_BOTTOM_RIGHT

ELM_CALENDAR_UNIQUE = enums.ELM_CALENDAR_UNIQUE
ELM_CALENDAR_DAILY = enums.ELM_CALENDAR_DAILY
ELM_CALENDAR_WEEKLY = enums.ELM_CALENDAR_WEEKLY
ELM_CALENDAR_MONTHLY = enums.ELM_CALENDAR_MONTHLY
ELM_CALENDAR_ANNUALLY = enums.ELM_CALENDAR_ANNUALLY
ELM_CALENDAR_LAST_DAY_OF_MONTH = enums.ELM_CALENDAR_LAST_DAY_OF_MONTH
ELM_CALENDAR_REVERSE_DAILY = enums.ELM_CALENDAR_REVERSE_DAILY

ELM_CALENDAR_SELECT_MODE_DEFAULT = enums.ELM_CALENDAR_SELECT_MODE_DEFAULT
ELM_CALENDAR_SELECT_MODE_ALWAYS = enums.ELM_CALENDAR_SELECT_MODE_ALWAYS
ELM_CALENDAR_SELECT_MODE_NONE = enums.ELM_CALENDAR_SELECT_MODE_NONE
ELM_CALENDAR_SELECT_MODE_ONDEMAND = enums.ELM_CALENDAR_SELECT_MODE_ONDEMAND

ELM_CALENDAR_SELECTABLE_NONE = enums.ELM_CALENDAR_SELECTABLE_NONE
ELM_CALENDAR_SELECTABLE_YEAR = enums.ELM_CALENDAR_SELECTABLE_YEAR
ELM_CALENDAR_SELECTABLE_MONTH = enums.ELM_CALENDAR_SELECTABLE_MONTH
ELM_CALENDAR_SELECTABLE_DAY = enums.ELM_CALENDAR_SELECTABLE_DAY

ELM_DAY_SUNDAY = enums.ELM_DAY_SUNDAY
ELM_DAY_MONDAY = enums.ELM_DAY_MONDAY
ELM_DAY_TUESDAY = enums.ELM_DAY_TUESDAY
ELM_DAY_WEDNESDAY = enums.ELM_DAY_WEDNESDAY
ELM_DAY_THURSDAY = enums.ELM_DAY_THURSDAY
ELM_DAY_FRIDAY = enums.ELM_DAY_FRIDAY
ELM_DAY_SATURDAY = enums.ELM_DAY_SATURDAY
ELM_DAY_LAST = enums.ELM_DAY_LAST

ELM_CLOCK_EDIT_DEFAULT = enums.ELM_CLOCK_EDIT_DEFAULT
ELM_CLOCK_EDIT_HOUR_DECIMAL = enums.ELM_CLOCK_EDIT_HOUR_DECIMAL
ELM_CLOCK_EDIT_HOUR_UNIT = enums.ELM_CLOCK_EDIT_HOUR_UNIT
ELM_CLOCK_EDIT_MIN_DECIMAL = enums.ELM_CLOCK_EDIT_MIN_DECIMAL
ELM_CLOCK_EDIT_MIN_UNIT = enums.ELM_CLOCK_EDIT_MIN_UNIT
ELM_CLOCK_EDIT_SEC_DECIMAL = enums.ELM_CLOCK_EDIT_SEC_DECIMAL
ELM_CLOCK_EDIT_SEC_UNIT = enums.ELM_CLOCK_EDIT_SEC_UNIT
ELM_CLOCK_EDIT_ALL = enums.ELM_CLOCK_EDIT_ALL

ELM_COLORSELECTOR_PALETTE = enums.ELM_COLORSELECTOR_PALETTE
ELM_COLORSELECTOR_COMPONENTS = enums.ELM_COLORSELECTOR_COMPONENTS
ELM_COLORSELECTOR_BOTH = enums.ELM_COLORSELECTOR_BOTH

ELM_SOFTCURSOR_MODE_AUTO = enums.ELM_SOFTCURSOR_MODE_AUTO
ELM_SOFTCURSOR_MODE_ON = enums.ELM_SOFTCURSOR_MODE_ON
ELM_SOFTCURSOR_MODE_OFF = enums.ELM_SOFTCURSOR_MODE_OFF

ELM_SLIDER_INDICATOR_VISIBLE_MODE_DEFAULT = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_DEFAULT
ELM_SLIDER_INDICATOR_VISIBLE_MODE_ALWAYS = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_ALWAYS
ELM_SLIDER_INDICATOR_VISIBLE_MODE_ON_FOCUS = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_ON_FOCUS
ELM_SLIDER_INDICATOR_VISIBLE_MODE_NONE = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_NONE

ELM_CTXPOPUP_DIRECTION_DOWN = enums.ELM_CTXPOPUP_DIRECTION_DOWN
ELM_CTXPOPUP_DIRECTION_RIGHT = enums.ELM_CTXPOPUP_DIRECTION_RIGHT
ELM_CTXPOPUP_DIRECTION_LEFT = enums.ELM_CTXPOPUP_DIRECTION_LEFT
ELM_CTXPOPUP_DIRECTION_UP = enums.ELM_CTXPOPUP_DIRECTION_UP
ELM_CTXPOPUP_DIRECTION_UNKNOWN = enums.ELM_CTXPOPUP_DIRECTION_UNKNOWN

ELM_DATETIME_YEAR = enums.ELM_DATETIME_YEAR
ELM_DATETIME_MONTH = enums.ELM_DATETIME_MONTH
ELM_DATETIME_DATE = enums.ELM_DATETIME_DATE
ELM_DATETIME_HOUR = enums.ELM_DATETIME_HOUR
ELM_DATETIME_MINUTE = enums.ELM_DATETIME_MINUTE
ELM_DATETIME_AMPM = enums.ELM_DATETIME_AMPM

ELM_DAYSELECTOR_SUN = enums.ELM_DAYSELECTOR_SUN
ELM_DAYSELECTOR_MON = enums.ELM_DAYSELECTOR_MON
ELM_DAYSELECTOR_TUE = enums.ELM_DAYSELECTOR_TUE
ELM_DAYSELECTOR_WED = enums.ELM_DAYSELECTOR_WED
ELM_DAYSELECTOR_THU = enums.ELM_DAYSELECTOR_THU
ELM_DAYSELECTOR_FRI = enums.ELM_DAYSELECTOR_FRI
ELM_DAYSELECTOR_SAT = enums.ELM_DAYSELECTOR_SAT
ELM_DAYSELECTOR_MAX = enums.ELM_DAYSELECTOR_MAX

ELM_AUTOCAPITAL_TYPE_NONE = enums.ELM_AUTOCAPITAL_TYPE_NONE
ELM_AUTOCAPITAL_TYPE_WORD = enums.ELM_AUTOCAPITAL_TYPE_WORD
ELM_AUTOCAPITAL_TYPE_SENTENCE = enums.ELM_AUTOCAPITAL_TYPE_SENTENCE
ELM_AUTOCAPITAL_TYPE_ALLCHARACTER = enums.ELM_AUTOCAPITAL_TYPE_ALLCHARACTER

ELM_CNP_MODE_MARKUP = enums.ELM_CNP_MODE_MARKUP
ELM_CNP_MODE_NO_IMAGE = enums.ELM_CNP_MODE_NO_IMAGE
ELM_CNP_MODE_PLAINTEXT = enums.ELM_CNP_MODE_PLAINTEXT

ELM_INPUT_HINT_NONE = enums.ELM_INPUT_HINT_NONE
ELM_INPUT_HINT_AUTO_COMPLETE = enums.ELM_INPUT_HINT_AUTO_COMPLETE
ELM_INPUT_HINT_SENSITIVE_DATA = enums.ELM_INPUT_HINT_SENSITIVE_DATA

ELM_INPUT_PANEL_LANG_AUTOMATIC = enums.ELM_INPUT_PANEL_LANG_AUTOMATIC
ELM_INPUT_PANEL_LANG_ALPHABET = enums.ELM_INPUT_PANEL_LANG_ALPHABET

ELM_INPUT_PANEL_LAYOUT_NORMAL = enums.ELM_INPUT_PANEL_LAYOUT_NORMAL
ELM_INPUT_PANEL_LAYOUT_NUMBER = enums.ELM_INPUT_PANEL_LAYOUT_NUMBER
ELM_INPUT_PANEL_LAYOUT_EMAIL = enums.ELM_INPUT_PANEL_LAYOUT_EMAIL
ELM_INPUT_PANEL_LAYOUT_URL = enums.ELM_INPUT_PANEL_LAYOUT_URL
ELM_INPUT_PANEL_LAYOUT_PHONENUMBER = enums.ELM_INPUT_PANEL_LAYOUT_PHONENUMBER
ELM_INPUT_PANEL_LAYOUT_IP = enums.ELM_INPUT_PANEL_LAYOUT_IP
ELM_INPUT_PANEL_LAYOUT_MONTH = enums.ELM_INPUT_PANEL_LAYOUT_MONTH
ELM_INPUT_PANEL_LAYOUT_NUMBERONLY = enums.ELM_INPUT_PANEL_LAYOUT_NUMBERONLY
ELM_INPUT_PANEL_LAYOUT_INVALID = enums.ELM_INPUT_PANEL_LAYOUT_INVALID
ELM_INPUT_PANEL_LAYOUT_HEX = enums.ELM_INPUT_PANEL_LAYOUT_HEX
ELM_INPUT_PANEL_LAYOUT_TERMINAL = enums.ELM_INPUT_PANEL_LAYOUT_TERMINAL
ELM_INPUT_PANEL_LAYOUT_PASSWORD = enums.ELM_INPUT_PANEL_LAYOUT_PASSWORD
ELM_INPUT_PANEL_LAYOUT_DATETIME = enums.ELM_INPUT_PANEL_LAYOUT_DATETIME
ELM_INPUT_PANEL_LAYOUT_EMOTICON = enums.ELM_INPUT_PANEL_LAYOUT_EMOTICON
ELM_INPUT_PANEL_LAYOUT_VOICE = enums.ELM_INPUT_PANEL_LAYOUT_VOICE

ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_NORMAL = enums.ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_NORMAL
ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_FILENAME = enums.ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_FILENAME
ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_PERSON_NAME = enums.ELM_INPUT_PANEL_LAYOUT_NORMAL_VARIATION_PERSON_NAME

ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_NORMAL = enums.ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_NORMAL
ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_SIGNED = enums.ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_SIGNED
ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_DECIMAL = enums.ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_DECIMAL
ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_SIGNED_AND_DECIMAL = enums.ELM_INPUT_PANEL_LAYOUT_NUMBERONLY_VARIATION_SIGNED_AND_DECIMAL

ELM_INPUT_PANEL_LAYOUT_PASSWORD_VARIATION_NORMAL = enums.ELM_INPUT_PANEL_LAYOUT_PASSWORD_VARIATION_NORMAL
ELM_INPUT_PANEL_LAYOUT_PASSWORD_VARIATION_NUMBERONLY = enums.ELM_INPUT_PANEL_LAYOUT_PASSWORD_VARIATION_NUMBERONLY

ELM_INPUT_PANEL_RETURN_KEY_TYPE_DEFAULT = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_DEFAULT
ELM_INPUT_PANEL_RETURN_KEY_TYPE_DONE = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_DONE
ELM_INPUT_PANEL_RETURN_KEY_TYPE_GO = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_GO
ELM_INPUT_PANEL_RETURN_KEY_TYPE_JOIN = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_JOIN
ELM_INPUT_PANEL_RETURN_KEY_TYPE_LOGIN = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_LOGIN
ELM_INPUT_PANEL_RETURN_KEY_TYPE_NEXT = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_NEXT
ELM_INPUT_PANEL_RETURN_KEY_TYPE_SEARCH = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_SEARCH
ELM_INPUT_PANEL_RETURN_KEY_TYPE_SEND = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_SEND
ELM_INPUT_PANEL_RETURN_KEY_TYPE_SIGNIN = enums.ELM_INPUT_PANEL_RETURN_KEY_TYPE_SIGNIN

ELM_TEXT_FORMAT_PLAIN_UTF8 = enums.ELM_TEXT_FORMAT_PLAIN_UTF8
ELM_TEXT_FORMAT_MARKUP_UTF8 = enums.ELM_TEXT_FORMAT_MARKUP_UTF8

ELM_WRAP_NONE = enums.ELM_WRAP_NONE
ELM_WRAP_CHAR = enums.ELM_WRAP_CHAR
ELM_WRAP_WORD = enums.ELM_WRAP_WORD
ELM_WRAP_MIXED = enums.ELM_WRAP_MIXED

ELM_FILESELECTOR_LIST = enums.ELM_FILESELECTOR_LIST
ELM_FILESELECTOR_GRID = enums.ELM_FILESELECTOR_GRID

ELM_FILESELECTOR_SORT_BY_FILENAME_ASC = enums.ELM_FILESELECTOR_SORT_BY_FILENAME_ASC
ELM_FILESELECTOR_SORT_BY_FILENAME_DESC = enums.ELM_FILESELECTOR_SORT_BY_FILENAME_DESC
ELM_FILESELECTOR_SORT_BY_TYPE_ASC = enums.ELM_FILESELECTOR_SORT_BY_TYPE_ASC
ELM_FILESELECTOR_SORT_BY_TYPE_DESC = enums.ELM_FILESELECTOR_SORT_BY_TYPE_DESC
ELM_FILESELECTOR_SORT_BY_SIZE_ASC = enums.ELM_FILESELECTOR_SORT_BY_SIZE_ASC
ELM_FILESELECTOR_SORT_BY_SIZE_DESC = enums.ELM_FILESELECTOR_SORT_BY_SIZE_DESC
ELM_FILESELECTOR_SORT_BY_MODIFIED_ASC = enums.ELM_FILESELECTOR_SORT_BY_MODIFIED_ASC
ELM_FILESELECTOR_SORT_BY_MODIFIED_DESC = enums.ELM_FILESELECTOR_SORT_BY_MODIFIED_DESC
ELM_FILESELECTOR_SORT_LAST = enums.ELM_FILESELECTOR_SORT_LAST

ELM_FLIP_DIRECTION_UP = enums.ELM_FLIP_DIRECTION_UP
ELM_FLIP_DIRECTION_DOWN = enums.ELM_FLIP_DIRECTION_DOWN
ELM_FLIP_DIRECTION_LEFT = enums.ELM_FLIP_DIRECTION_LEFT
ELM_FLIP_DIRECTION_RIGHT = enums.ELM_FLIP_DIRECTION_RIGHT

ELM_FLIP_INTERACTION_NONE = enums.ELM_FLIP_INTERACTION_NONE
ELM_FLIP_INTERACTION_ROTATE = enums.ELM_FLIP_INTERACTION_ROTATE
ELM_FLIP_INTERACTION_CUBE = enums.ELM_FLIP_INTERACTION_CUBE
ELM_FLIP_INTERACTION_PAGE = enums.ELM_FLIP_INTERACTION_PAGE

ELM_FLIP_ROTATE_Y_CENTER_AXIS = enums.ELM_FLIP_ROTATE_Y_CENTER_AXIS
ELM_FLIP_ROTATE_X_CENTER_AXIS = enums.ELM_FLIP_ROTATE_X_CENTER_AXIS
ELM_FLIP_ROTATE_XZ_CENTER_AXIS = enums.ELM_FLIP_ROTATE_XZ_CENTER_AXIS
ELM_FLIP_ROTATE_YZ_CENTER_AXIS = enums.ELM_FLIP_ROTATE_YZ_CENTER_AXIS
ELM_FLIP_CUBE_LEFT = enums.ELM_FLIP_CUBE_LEFT
ELM_FLIP_CUBE_RIGHT = enums.ELM_FLIP_CUBE_RIGHT
ELM_FLIP_CUBE_UP = enums.ELM_FLIP_CUBE_UP
ELM_FLIP_CUBE_DOWN = enums.ELM_FLIP_CUBE_DOWN
ELM_FLIP_PAGE_LEFT = enums.ELM_FLIP_PAGE_LEFT
ELM_FLIP_PAGE_RIGHT = enums.ELM_FLIP_PAGE_RIGHT
ELM_FLIP_PAGE_UP = enums.ELM_FLIP_PAGE_UP
ELM_FLIP_PAGE_DOWN = enums.ELM_FLIP_PAGE_DOWN

ELM_GENGRID_ITEM_SCROLLTO_NONE = enums.ELM_GENGRID_ITEM_SCROLLTO_NONE
ELM_GENGRID_ITEM_SCROLLTO_IN = enums.ELM_GENGRID_ITEM_SCROLLTO_IN
ELM_GENGRID_ITEM_SCROLLTO_TOP = enums.ELM_GENGRID_ITEM_SCROLLTO_TOP
ELM_GENGRID_ITEM_SCROLLTO_MIDDLE = enums.ELM_GENGRID_ITEM_SCROLLTO_MIDDLE
ELM_GENGRID_ITEM_SCROLLTO_BOTTOM = enums.ELM_GENGRID_ITEM_SCROLLTO_BOTTOM

ELM_GENGRID_REORDER_TYPE_NORMAL = enums.ELM_GENGRID_REORDER_TYPE_NORMAL
ELM_GENGRID_REORDER_TYPE_SWAP = enums.ELM_GENGRID_REORDER_TYPE_SWAP

ELM_GENLIST_ITEM_NONE = enums.ELM_GENLIST_ITEM_NONE
ELM_GENLIST_ITEM_TREE = enums.ELM_GENLIST_ITEM_TREE
ELM_GENLIST_ITEM_GROUP = enums.ELM_GENLIST_ITEM_GROUP
ELM_GENLIST_ITEM_MAX = enums.ELM_GENLIST_ITEM_MAX

ELM_GENLIST_ITEM_FIELD_ALL = enums.ELM_GENLIST_ITEM_FIELD_ALL
ELM_GENLIST_ITEM_FIELD_TEXT = enums.ELM_GENLIST_ITEM_FIELD_TEXT
ELM_GENLIST_ITEM_FIELD_CONTENT = enums.ELM_GENLIST_ITEM_FIELD_CONTENT
ELM_GENLIST_ITEM_FIELD_STATE = enums.ELM_GENLIST_ITEM_FIELD_STATE

ELM_GENLIST_ITEM_SCROLLTO_NONE = enums.ELM_GENLIST_ITEM_SCROLLTO_NONE
ELM_GENLIST_ITEM_SCROLLTO_IN = enums.ELM_GENLIST_ITEM_SCROLLTO_IN
ELM_GENLIST_ITEM_SCROLLTO_TOP = enums.ELM_GENLIST_ITEM_SCROLLTO_TOP
ELM_GENLIST_ITEM_SCROLLTO_MIDDLE = enums.ELM_GENLIST_ITEM_SCROLLTO_MIDDLE
ELM_GENLIST_ITEM_SCROLLTO_BOTTOM = enums.ELM_GENLIST_ITEM_SCROLLTO_BOTTOM

ELM_GESTURE_STATE_UNDEFINED = enums.ELM_GESTURE_STATE_UNDEFINED
ELM_GESTURE_STATE_START = enums.ELM_GESTURE_STATE_START
ELM_GESTURE_STATE_MOVE = enums.ELM_GESTURE_STATE_MOVE
ELM_GESTURE_STATE_END = enums.ELM_GESTURE_STATE_END
ELM_GESTURE_STATE_ABORT = enums.ELM_GESTURE_STATE_ABORT

ELM_GESTURE_FIRST = enums.ELM_GESTURE_FIRST
ELM_GESTURE_N_TAPS = enums.ELM_GESTURE_N_TAPS
ELM_GESTURE_N_LONG_TAPS = enums.ELM_GESTURE_N_LONG_TAPS
ELM_GESTURE_N_DOUBLE_TAPS = enums.ELM_GESTURE_N_DOUBLE_TAPS
ELM_GESTURE_N_TRIPLE_TAPS = enums.ELM_GESTURE_N_TRIPLE_TAPS
ELM_GESTURE_MOMENTUM = enums.ELM_GESTURE_MOMENTUM
ELM_GESTURE_N_LINES = enums.ELM_GESTURE_N_LINES
ELM_GESTURE_N_FLICKS = enums.ELM_GESTURE_N_FLICKS
ELM_GESTURE_ZOOM = enums.ELM_GESTURE_ZOOM
ELM_GESTURE_ROTATE = enums.ELM_GESTURE_ROTATE
ELM_GESTURE_LAST = enums.ELM_GESTURE_LAST

ELM_HOVER_AXIS_NONE = enums.ELM_HOVER_AXIS_NONE
ELM_HOVER_AXIS_HORIZONTAL = enums.ELM_HOVER_AXIS_HORIZONTAL
ELM_HOVER_AXIS_VERTICAL = enums.ELM_HOVER_AXIS_VERTICAL
ELM_HOVER_AXIS_BOTH = enums.ELM_HOVER_AXIS_BOTH

ELM_ICON_LOOKUP_FDO_THEME = enums.ELM_ICON_LOOKUP_FDO_THEME
ELM_ICON_LOOKUP_THEME_FDO = enums.ELM_ICON_LOOKUP_THEME_FDO
ELM_ICON_LOOKUP_FDO = enums.ELM_ICON_LOOKUP_FDO
ELM_ICON_LOOKUP_THEME = enums.ELM_ICON_LOOKUP_THEME

ELM_ICON_NONE = enums.ELM_ICON_NONE
ELM_ICON_FILE = enums.ELM_ICON_FILE
ELM_ICON_STANDARD = enums.ELM_ICON_STANDARD

ELM_IMAGE_ORIENT_NONE = enums.ELM_IMAGE_ORIENT_NONE
ELM_IMAGE_ORIENT_0 = enums.ELM_IMAGE_ORIENT_0
ELM_IMAGE_ROTATE_90 = enums.ELM_IMAGE_ROTATE_90
ELM_IMAGE_ROTATE_180 = enums.ELM_IMAGE_ROTATE_180
ELM_IMAGE_ROTATE_270 = enums.ELM_IMAGE_ROTATE_270
ELM_IMAGE_FLIP_HORIZONTAL = enums.ELM_IMAGE_FLIP_HORIZONTAL
ELM_IMAGE_FLIP_VERTICAL = enums.ELM_IMAGE_FLIP_VERTICAL
ELM_IMAGE_FLIP_TRANSPOSE = enums.ELM_IMAGE_FLIP_TRANSPOSE
ELM_IMAGE_FLIP_TRANSVERSE = enums.ELM_IMAGE_FLIP_TRANSVERSE

ELM_WRAP_NONE = enums.ELM_WRAP_NONE
ELM_WRAP_CHAR = enums.ELM_WRAP_CHAR
ELM_WRAP_WORD = enums.ELM_WRAP_WORD
ELM_WRAP_MIXED = enums.ELM_WRAP_MIXED

ELM_LABEL_SLIDE_MODE_NONE = enums.ELM_LABEL_SLIDE_MODE_NONE
ELM_LABEL_SLIDE_MODE_AUTO = enums.ELM_LABEL_SLIDE_MODE_AUTO
ELM_LABEL_SLIDE_MODE_ALWAYS = enums.ELM_LABEL_SLIDE_MODE_ALWAYS

ELM_LIST_COMPRESS = enums.ELM_LIST_COMPRESS
ELM_LIST_SCROLL = enums.ELM_LIST_SCROLL
ELM_LIST_LIMIT = enums.ELM_LIST_LIMIT
ELM_LIST_EXPAND = enums.ELM_LIST_EXPAND

ELM_MAP_OVERLAY_TYPE_NONE = enums.ELM_MAP_OVERLAY_TYPE_NONE
ELM_MAP_OVERLAY_TYPE_DEFAULT = enums.ELM_MAP_OVERLAY_TYPE_DEFAULT
ELM_MAP_OVERLAY_TYPE_CLASS = enums.ELM_MAP_OVERLAY_TYPE_CLASS
ELM_MAP_OVERLAY_TYPE_GROUP = enums.ELM_MAP_OVERLAY_TYPE_GROUP
ELM_MAP_OVERLAY_TYPE_BUBBLE = enums.ELM_MAP_OVERLAY_TYPE_BUBBLE
ELM_MAP_OVERLAY_TYPE_ROUTE = enums.ELM_MAP_OVERLAY_TYPE_ROUTE
ELM_MAP_OVERLAY_TYPE_LINE = enums.ELM_MAP_OVERLAY_TYPE_LINE
ELM_MAP_OVERLAY_TYPE_POLYGON = enums.ELM_MAP_OVERLAY_TYPE_POLYGON
ELM_MAP_OVERLAY_TYPE_CIRCLE = enums.ELM_MAP_OVERLAY_TYPE_CIRCLE
ELM_MAP_OVERLAY_TYPE_SCALE = enums.ELM_MAP_OVERLAY_TYPE_SCALE

ELM_MAP_ROUTE_METHOD_FASTEST = enums.ELM_MAP_ROUTE_METHOD_FASTEST
ELM_MAP_ROUTE_METHOD_SHORTEST = enums.ELM_MAP_ROUTE_METHOD_SHORTEST
ELM_MAP_ROUTE_METHOD_LAST = enums.ELM_MAP_ROUTE_METHOD_LAST

ELM_MAP_ROUTE_TYPE_MOTOCAR = enums.ELM_MAP_ROUTE_TYPE_MOTOCAR
ELM_MAP_ROUTE_TYPE_BICYCLE = enums.ELM_MAP_ROUTE_TYPE_BICYCLE
ELM_MAP_ROUTE_TYPE_FOOT = enums.ELM_MAP_ROUTE_TYPE_FOOT
ELM_MAP_ROUTE_TYPE_LAST = enums.ELM_MAP_ROUTE_TYPE_LAST

ELM_MAP_SOURCE_TYPE_TILE = enums.ELM_MAP_SOURCE_TYPE_TILE
ELM_MAP_SOURCE_TYPE_ROUTE = enums.ELM_MAP_SOURCE_TYPE_ROUTE
ELM_MAP_SOURCE_TYPE_NAME = enums.ELM_MAP_SOURCE_TYPE_NAME
ELM_MAP_SOURCE_TYPE_LAST = enums.ELM_MAP_SOURCE_TYPE_LAST

ELM_MAP_ZOOM_MODE_MANUAL = enums.ELM_MAP_ZOOM_MODE_MANUAL
ELM_MAP_ZOOM_MODE_AUTO_FIT = enums.ELM_MAP_ZOOM_MODE_AUTO_FIT
ELM_MAP_ZOOM_MODE_AUTO_FILL = enums.ELM_MAP_ZOOM_MODE_AUTO_FILL
ELM_MAP_ZOOM_MODE_LAST = enums.ELM_MAP_ZOOM_MODE_LAST

ELM_SYS_NOTIFY_CLOSED_EXPIRED = enums.ELM_SYS_NOTIFY_CLOSED_EXPIRED
ELM_SYS_NOTIFY_CLOSED_DISMISSED = enums.ELM_SYS_NOTIFY_CLOSED_DISMISSED
ELM_SYS_NOTIFY_CLOSED_REQUESTED = enums.ELM_SYS_NOTIFY_CLOSED_REQUESTED
ELM_SYS_NOTIFY_CLOSED_UNDEFINED = enums.ELM_SYS_NOTIFY_CLOSED_UNDEFINED

ELM_NOTIFY_ORIENT_TOP = enums.ELM_NOTIFY_ORIENT_TOP
ELM_NOTIFY_ORIENT_CENTER = enums.ELM_NOTIFY_ORIENT_CENTER
ELM_NOTIFY_ORIENT_BOTTOM = enums.ELM_NOTIFY_ORIENT_BOTTOM
ELM_NOTIFY_ORIENT_LEFT = enums.ELM_NOTIFY_ORIENT_LEFT
ELM_NOTIFY_ORIENT_RIGHT = enums.ELM_NOTIFY_ORIENT_RIGHT
ELM_NOTIFY_ORIENT_TOP_LEFT = enums.ELM_NOTIFY_ORIENT_TOP_LEFT
ELM_NOTIFY_ORIENT_TOP_RIGHT = enums.ELM_NOTIFY_ORIENT_TOP_RIGHT
ELM_NOTIFY_ORIENT_BOTTOM_LEFT = enums.ELM_NOTIFY_ORIENT_BOTTOM_LEFT
ELM_NOTIFY_ORIENT_BOTTOM_RIGHT = enums.ELM_NOTIFY_ORIENT_BOTTOM_RIGHT
ELM_NOTIFY_ORIENT_LAST = enums.ELM_NOTIFY_ORIENT_LAST

ELM_OBJECT_SELECT_MODE_DEFAULT = enums.ELM_OBJECT_SELECT_MODE_DEFAULT
ELM_OBJECT_SELECT_MODE_ALWAYS = enums.ELM_OBJECT_SELECT_MODE_ALWAYS
ELM_OBJECT_SELECT_MODE_NONE = enums.ELM_OBJECT_SELECT_MODE_NONE
ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY = enums.ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY
ELM_OBJECT_SELECT_MODE_MAX = enums.ELM_OBJECT_SELECT_MODE_MAX

ELM_OBJECT_MULTI_SELECT_MODE_DEFAULT = enums.ELM_OBJECT_MULTI_SELECT_MODE_DEFAULT
ELM_OBJECT_MULTI_SELECT_MODE_WITH_CONTROL = enums.ELM_OBJECT_MULTI_SELECT_MODE_WITH_CONTROL
ELM_OBJECT_MULTI_SELECT_MODE_MAX = enums.ELM_OBJECT_MULTI_SELECT_MODE_MAX

ELM_OBJECT_LAYER_BACKGROUND = enums.ELM_OBJECT_LAYER_BACKGROUND
ELM_OBJECT_LAYER_DEFAULT = enums.ELM_OBJECT_LAYER_DEFAULT
ELM_OBJECT_LAYER_FOCUS = enums.ELM_OBJECT_LAYER_FOCUS
ELM_OBJECT_LAYER_TOOLTIP = enums.ELM_OBJECT_LAYER_TOOLTIP
ELM_OBJECT_LAYER_CURSOR = enums.ELM_OBJECT_LAYER_CURSOR
ELM_OBJECT_LAYER_LAST = enums.ELM_OBJECT_LAYER_LAST

ELM_PANEL_ORIENT_TOP = enums.ELM_PANEL_ORIENT_TOP
ELM_PANEL_ORIENT_BOTTOM = enums.ELM_PANEL_ORIENT_BOTTOM
ELM_PANEL_ORIENT_LEFT = enums.ELM_PANEL_ORIENT_LEFT
ELM_PANEL_ORIENT_RIGHT = enums.ELM_PANEL_ORIENT_RIGHT

ELM_PHOTOCAM_ZOOM_MODE_MANUAL = enums.ELM_PHOTOCAM_ZOOM_MODE_MANUAL
ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT = enums.ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT
ELM_PHOTOCAM_ZOOM_MODE_AUTO_FILL = enums.ELM_PHOTOCAM_ZOOM_MODE_AUTO_FILL
ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT_IN = enums.ELM_PHOTOCAM_ZOOM_MODE_AUTO_FIT_IN
ELM_PHOTOCAM_ZOOM_MODE_LAST = enums.ELM_PHOTOCAM_ZOOM_MODE_LAST

ELM_POPUP_ORIENT_TOP = enums.ELM_POPUP_ORIENT_TOP
ELM_POPUP_ORIENT_CENTER = enums.ELM_POPUP_ORIENT_CENTER
ELM_POPUP_ORIENT_BOTTOM = enums.ELM_POPUP_ORIENT_BOTTOM
ELM_POPUP_ORIENT_LEFT = enums.ELM_POPUP_ORIENT_LEFT
ELM_POPUP_ORIENT_RIGHT = enums.ELM_POPUP_ORIENT_RIGHT
ELM_POPUP_ORIENT_TOP_LEFT = enums.ELM_POPUP_ORIENT_TOP_LEFT
ELM_POPUP_ORIENT_TOP_RIGHT = enums.ELM_POPUP_ORIENT_TOP_RIGHT
ELM_POPUP_ORIENT_BOTTOM_LEFT = enums.ELM_POPUP_ORIENT_BOTTOM_LEFT
ELM_POPUP_ORIENT_BOTTOM_RIGHT = enums.ELM_POPUP_ORIENT_BOTTOM_RIGHT
ELM_POPUP_ORIENT_LAST = enums.ELM_POPUP_ORIENT_LAST

ELM_SCROLLER_POLICY_AUTO = enums.ELM_SCROLLER_POLICY_AUTO
ELM_SCROLLER_POLICY_ON = enums.ELM_SCROLLER_POLICY_ON
ELM_SCROLLER_POLICY_OFF = enums.ELM_SCROLLER_POLICY_OFF

ELM_SCROLLER_SINGLE_DIRECTION_NONE = enums.ELM_SCROLLER_SINGLE_DIRECTION_NONE
ELM_SCROLLER_SINGLE_DIRECTION_SOFT = enums.ELM_SCROLLER_SINGLE_DIRECTION_SOFT
ELM_SCROLLER_SINGLE_DIRECTION_HARD = enums.ELM_SCROLLER_SINGLE_DIRECTION_HARD
ELM_SCROLLER_SINGLE_DIRECTION_LAST = enums.ELM_SCROLLER_SINGLE_DIRECTION_LAST

ELM_SCROLLER_MOVEMENT_NO_BLOCK = enums.ELM_SCROLLER_MOVEMENT_NO_BLOCK
ELM_SCROLLER_MOVEMENT_BLOCK_VERTICAL = enums.ELM_SCROLLER_MOVEMENT_BLOCK_VERTICAL
ELM_SCROLLER_MOVEMENT_BLOCK_HORIZONTAL = enums.ELM_SCROLLER_MOVEMENT_BLOCK_HORIZONTAL

ELM_SLIDER_INDICATOR_VISIBLE_MODE_DEFAULT = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_DEFAULT
ELM_SLIDER_INDICATOR_VISIBLE_MODE_ALWAYS = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_ALWAYS
ELM_SLIDER_INDICATOR_VISIBLE_MODE_ON_FOCUS = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_ON_FOCUS
ELM_SLIDER_INDICATOR_VISIBLE_MODE_NONE = enums.ELM_SLIDER_INDICATOR_VISIBLE_MODE_NONE

ELM_EVENT_SYSTRAY_READY = enums.ELM_EVENT_SYSTRAY_READY

ELM_SYSTRAY_CATEGORY_APP_STATUS = enums.ELM_SYSTRAY_CATEGORY_APP_STATUS
ELM_SYSTRAY_CATEGORY_COMMUNICATIONS = enums.ELM_SYSTRAY_CATEGORY_COMMUNICATIONS
ELM_SYSTRAY_CATEGORY_SYS_SERVICES = enums.ELM_SYSTRAY_CATEGORY_SYS_SERVICES
ELM_SYSTRAY_CATEGORY_HARDWARE = enums.ELM_SYSTRAY_CATEGORY_HARDWARE
ELM_SYSTRAY_CATEGORY_OTHER = enums.ELM_SYSTRAY_CATEGORY_OTHER

ELM_SYSTRAY_STATUS_PASSIVE = enums.ELM_SYSTRAY_STATUS_PASSIVE
ELM_SYSTRAY_STATUS_ACTIVE = enums.ELM_SYSTRAY_STATUS_ACTIVE
ELM_SYSTRAY_STATUS_ATTENTION = enums.ELM_SYSTRAY_STATUS_ATTENTION

ELM_THUMB_ANIMATION_START = enums.ELM_THUMB_ANIMATION_START
ELM_THUMB_ANIMATION_LOOP = enums.ELM_THUMB_ANIMATION_LOOP
ELM_THUMB_ANIMATION_STOP = enums.ELM_THUMB_ANIMATION_STOP
ELM_THUMB_ANIMATION_LAST = enums.ELM_THUMB_ANIMATION_LAST

ETHUMB_THUMB_NORMAL = enums.ETHUMB_THUMB_NORMAL
ETHUMB_THUMB_LARGE = enums.ETHUMB_THUMB_LARGE

ETHUMB_THUMB_FDO = enums.ETHUMB_THUMB_FDO
ETHUMB_THUMB_JPEG = enums.ETHUMB_THUMB_JPEG
ETHUMB_THUMB_EET = enums.ETHUMB_THUMB_EET

ETHUMB_THUMB_KEEP_ASPECT = enums.ETHUMB_THUMB_KEEP_ASPECT
ETHUMB_THUMB_IGNORE_ASPECT = enums.ETHUMB_THUMB_IGNORE_ASPECT
ETHUMB_THUMB_CROP = enums.ETHUMB_THUMB_CROP

ETHUMB_THUMB_ORIENT_NONE = enums.ETHUMB_THUMB_ORIENT_NONE
ETHUMB_THUMB_ROTATE_90_CW = enums.ETHUMB_THUMB_ROTATE_90_CW
ETHUMB_THUMB_ROTATE_180 = enums.ETHUMB_THUMB_ROTATE_180
ETHUMB_THUMB_ROTATE_90_CCW = enums.ETHUMB_THUMB_ROTATE_90_CCW
ETHUMB_THUMB_FLIP_HORIZONTAL = enums.ETHUMB_THUMB_FLIP_HORIZONTAL
ETHUMB_THUMB_FLIP_VERTICAL = enums.ETHUMB_THUMB_FLIP_VERTICAL
ETHUMB_THUMB_FLIP_TRANSPOSE = enums.ETHUMB_THUMB_FLIP_TRANSPOSE
ETHUMB_THUMB_FLIP_TRANSVERSE = enums.ETHUMB_THUMB_FLIP_TRANSVERSE
ETHUMB_THUMB_ORIENT_ORIGINAL = enums.ETHUMB_THUMB_ORIENT_ORIGINAL

ELM_TOOLBAR_ITEM_SCROLLTO_NONE = enums.ELM_TOOLBAR_ITEM_SCROLLTO_NONE
ELM_TOOLBAR_ITEM_SCROLLTO_IN = enums.ELM_TOOLBAR_ITEM_SCROLLTO_IN
ELM_TOOLBAR_ITEM_SCROLLTO_FIRST = enums.ELM_TOOLBAR_ITEM_SCROLLTO_FIRST
ELM_TOOLBAR_ITEM_SCROLLTO_MIDDLE = enums.ELM_TOOLBAR_ITEM_SCROLLTO_MIDDLE
ELM_TOOLBAR_ITEM_SCROLLTO_LAST = enums.ELM_TOOLBAR_ITEM_SCROLLTO_LAST

ELM_TOOLBAR_SHRINK_NONE = enums.ELM_TOOLBAR_SHRINK_NONE
ELM_TOOLBAR_SHRINK_HIDE = enums.ELM_TOOLBAR_SHRINK_HIDE
ELM_TOOLBAR_SHRINK_SCROLL = enums.ELM_TOOLBAR_SHRINK_SCROLL
ELM_TOOLBAR_SHRINK_MENU = enums.ELM_TOOLBAR_SHRINK_MENU
ELM_TOOLBAR_SHRINK_EXPAND = enums.ELM_TOOLBAR_SHRINK_EXPAND
ELM_TOOLBAR_SHRINK_LAST = enums.ELM_TOOLBAR_SHRINK_LAST

ELM_TRANSIT_EFFECT_FLIP_AXIS_X = enums.ELM_TRANSIT_EFFECT_FLIP_AXIS_X
ELM_TRANSIT_EFFECT_FLIP_AXIS_Y = enums.ELM_TRANSIT_EFFECT_FLIP_AXIS_Y

ELM_TRANSIT_EFFECT_WIPE_DIR_LEFT = enums.ELM_TRANSIT_EFFECT_WIPE_DIR_LEFT
ELM_TRANSIT_EFFECT_WIPE_DIR_RIGHT = enums.ELM_TRANSIT_EFFECT_WIPE_DIR_RIGHT
ELM_TRANSIT_EFFECT_WIPE_DIR_UP = enums.ELM_TRANSIT_EFFECT_WIPE_DIR_UP
ELM_TRANSIT_EFFECT_WIPE_DIR_DOWN = enums.ELM_TRANSIT_EFFECT_WIPE_DIR_DOWN

ELM_TRANSIT_EFFECT_WIPE_TYPE_HIDE = enums.ELM_TRANSIT_EFFECT_WIPE_TYPE_HIDE
ELM_TRANSIT_EFFECT_WIPE_TYPE_SHOW = enums.ELM_TRANSIT_EFFECT_WIPE_TYPE_SHOW

ELM_TRANSIT_TWEEN_MODE_LINEAR = enums.ELM_TRANSIT_TWEEN_MODE_LINEAR
ELM_TRANSIT_TWEEN_MODE_SINUSOIDAL = enums.ELM_TRANSIT_TWEEN_MODE_SINUSOIDAL
ELM_TRANSIT_TWEEN_MODE_DECELERATE = enums.ELM_TRANSIT_TWEEN_MODE_DECELERATE
ELM_TRANSIT_TWEEN_MODE_ACCELERATE = enums.ELM_TRANSIT_TWEEN_MODE_ACCELERATE
ELM_TRANSIT_TWEEN_MODE_DIVISOR_INTERP = enums.ELM_TRANSIT_TWEEN_MODE_DIVISOR_INTERP
ELM_TRANSIT_TWEEN_MODE_BOUNCE = enums.ELM_TRANSIT_TWEEN_MODE_BOUNCE
ELM_TRANSIT_TWEEN_MODE_SPRING = enums.ELM_TRANSIT_TWEEN_MODE_SPRING
ELM_TRANSIT_TWEEN_MODE_BEZIER_CURVE = enums.ELM_TRANSIT_TWEEN_MODE_BEZIER_CURVE

ELM_WEB_WINDOW_FEATURE_TOOLBAR = enums.ELM_WEB_WINDOW_FEATURE_TOOLBAR
ELM_WEB_WINDOW_FEATURE_STATUSBAR = enums.ELM_WEB_WINDOW_FEATURE_STATUSBAR
ELM_WEB_WINDOW_FEATURE_SCROLLBARS = enums.ELM_WEB_WINDOW_FEATURE_SCROLLBARS
ELM_WEB_WINDOW_FEATURE_MENUBAR = enums.ELM_WEB_WINDOW_FEATURE_MENUBAR
ELM_WEB_WINDOW_FEATURE_LOCATIONBAR = enums.ELM_WEB_WINDOW_FEATURE_LOCATIONBAR
ELM_WEB_WINDOW_FEATURE_FULLSCREEN = enums.ELM_WEB_WINDOW_FEATURE_FULLSCREEN

ELM_WEB_ZOOM_MODE_MANUAL = enums.ELM_WEB_ZOOM_MODE_MANUAL
ELM_WEB_ZOOM_MODE_AUTO_FIT = enums.ELM_WEB_ZOOM_MODE_AUTO_FIT
ELM_WEB_ZOOM_MODE_AUTO_FILL = enums.ELM_WEB_ZOOM_MODE_AUTO_FILL

ELM_WIN_UNKNOWN = enums.ELM_WIN_UNKNOWN
ELM_WIN_BASIC = enums.ELM_WIN_BASIC
ELM_WIN_DIALOG_BASIC = enums.ELM_WIN_DIALOG_BASIC
ELM_WIN_DESKTOP = enums.ELM_WIN_DESKTOP
ELM_WIN_DOCK = enums.ELM_WIN_DOCK
ELM_WIN_TOOLBAR = enums.ELM_WIN_TOOLBAR
ELM_WIN_MENU = enums.ELM_WIN_MENU
ELM_WIN_UTILITY = enums.ELM_WIN_UTILITY
ELM_WIN_SPLASH = enums.ELM_WIN_SPLASH
ELM_WIN_DROPDOWN_MENU = enums.ELM_WIN_DROPDOWN_MENU
ELM_WIN_POPUP_MENU = enums.ELM_WIN_POPUP_MENU
ELM_WIN_TOOLTIP = enums.ELM_WIN_TOOLTIP
ELM_WIN_NOTIFICATION = enums.ELM_WIN_NOTIFICATION
ELM_WIN_COMBO = enums.ELM_WIN_COMBO
ELM_WIN_DND = enums.ELM_WIN_DND
ELM_WIN_INLINED_IMAGE = enums.ELM_WIN_INLINED_IMAGE
ELM_WIN_SOCKET_IMAGE = enums.ELM_WIN_SOCKET_IMAGE

ELM_WIN_INDICATOR_UNKNOWN = enums.ELM_WIN_INDICATOR_UNKNOWN
ELM_WIN_INDICATOR_HIDE = enums.ELM_WIN_INDICATOR_HIDE
ELM_WIN_INDICATOR_SHOW = enums.ELM_WIN_INDICATOR_SHOW

ELM_WIN_INDICATOR_OPACITY_UNKNOWN = enums.ELM_WIN_INDICATOR_OPACITY_UNKNOWN
ELM_WIN_INDICATOR_OPAQUE = enums.ELM_WIN_INDICATOR_OPAQUE
ELM_WIN_INDICATOR_TRANSLUCENT = enums.ELM_WIN_INDICATOR_TRANSLUCENT
ELM_WIN_INDICATOR_TRANSPARENT = enums.ELM_WIN_INDICATOR_TRANSPARENT

ELM_WIN_KEYBOARD_UNKNOWN = enums.ELM_WIN_KEYBOARD_UNKNOWN
ELM_WIN_KEYBOARD_OFF = enums.ELM_WIN_KEYBOARD_OFF
ELM_WIN_KEYBOARD_ON = enums.ELM_WIN_KEYBOARD_ON
ELM_WIN_KEYBOARD_ALPHA = enums.ELM_WIN_KEYBOARD_ALPHA
ELM_WIN_KEYBOARD_NUMERIC = enums.ELM_WIN_KEYBOARD_NUMERIC
ELM_WIN_KEYBOARD_PIN = enums.ELM_WIN_KEYBOARD_PIN
ELM_WIN_KEYBOARD_PHONE_NUMBER = enums.ELM_WIN_KEYBOARD_PHONE_NUMBER
ELM_WIN_KEYBOARD_HEX = enums.ELM_WIN_KEYBOARD_HEX
ELM_WIN_KEYBOARD_TERMINAL = enums.ELM_WIN_KEYBOARD_TERMINAL
ELM_WIN_KEYBOARD_PASSWORD = enums.ELM_WIN_KEYBOARD_PASSWORD
ELM_WIN_KEYBOARD_IP = enums.ELM_WIN_KEYBOARD_IP
ELM_WIN_KEYBOARD_HOST = enums.ELM_WIN_KEYBOARD_HOST
ELM_WIN_KEYBOARD_FILE = enums.ELM_WIN_KEYBOARD_FILE
ELM_WIN_KEYBOARD_URL = enums.ELM_WIN_KEYBOARD_URL
ELM_WIN_KEYBOARD_KEYPAD = enums.ELM_WIN_KEYBOARD_KEYPAD
ELM_WIN_KEYBOARD_J2ME = enums.ELM_WIN_KEYBOARD_J2ME

ELM_ILLUME_COMMAND_FOCUS_BACK = enums.ELM_ILLUME_COMMAND_FOCUS_BACK
ELM_ILLUME_COMMAND_FOCUS_FORWARD = enums.ELM_ILLUME_COMMAND_FOCUS_FORWARD
ELM_ILLUME_COMMAND_FOCUS_HOME = enums.ELM_ILLUME_COMMAND_FOCUS_HOME
ELM_ILLUME_COMMAND_CLOSE = enums.ELM_ILLUME_COMMAND_CLOSE


include "elementary_cdef.pxi"


elm_log = add_logger("efl.elementary")
cdef int PY_EFL_ELM_LOG_DOMAIN = elm_log.eina_log_domain


cdef class ConfigAllChanged(Event):
    cdef int _set_obj(self, void *o) except 0:
        return 1

    def __repr__(self):
        return "<%s()>" % (self.__class__.__name__,)


cdef class PolicyChanged(Event):

    cdef:
        public unsigned int policy
        public int new_value
        public int old_value

    cdef int _set_obj(self, void *o) except 0:
        cdef Elm_Event_Policy_Changed *obj
        obj = <Elm_Event_Policy_Changed *>o
        self.policy = obj.policy
        self.new_value = obj.new_value
        self.old_value = obj.old_value
        return 1

    def __repr__(self):
        return "<%s(policy=%d, new_value=%d, old_value=%d)>" % (
            self.__class__.__name__,
            self.policy, self.new_value, self.old_value)


cdef class ProcessBackground(Event):
    cdef int _set_obj(self, void *o) except 0:
        return 1

    def __repr__(self):
        return "<%s()>" % (self.__class__.__name__,)


cdef class ProcessForeground(Event):
    cdef int _set_obj(self, void *o) except 0:
        return 1

    def __repr__(self):
        return "<%s()>" % (self.__class__.__name__,)


def init():
    """Initialize Elementary

    :return int: The init counter value.

    This function initializes Elementary and increments a counter of the number
    of calls to it. It returns the new counter's value.

    .. versionchanged:: 1.14

        The Python module calls this function when it is imported so you
        should no longer have any need to call this manually. Calling it does
        not carry any penalty though.

    """
    EINA_LOG_DOM_INFO(PY_EFL_ELM_LOG_DOMAIN, "Initializing efl.elementary")

    # argc and argv are currently used by EFL to support app restart
    # and binary relocation. These are probably not useful to us but we
    # pass the information here regardless because useful functionality
    # may be added in the future.

    cdef:
        int argc = 0, i, arg_len
        char **argv = NULL
        char *arg

    if hasattr(sys, "argv"):
        argc = len(sys.argv)
        argv = <char **>PyMem_Malloc(argc * sizeof(char *))
        for i in range(argc):
            t = sys.argv[i]
            if isinstance(t, unicode): t = PyUnicode_AsUTF8String(t)
            arg = t
            arg_len = len(arg)
            argv[i] = <char *>PyMem_Malloc(arg_len + 1)
            memcpy(argv[i], arg, arg_len + 1)

    return elm_init(argc, argv)

def shutdown():
    """Shut down Elementary

    :return int: The init counter value.

    This should be called at the end of your application, just before it ceases
    to do any more processing. This will clean up any permanent resources your
    application may have allocated via Elementary that would otherwise persist.

    .. note::

        shutdown() will iterate main loop until all ecore_evas are freed. There
        is a possibility to call your ecore callbacks(timer, animator, event,
        job, and etc.) in shutdown()

    .. versionchanged:: 1.14

        The Python module calls this function when it is exiting so you
        should no longer have any need to call this manually. Calling it does
        not carry any penalty though.

    """
    EINA_LOG_DOM_INFO(PY_EFL_ELM_LOG_DOMAIN, "Shutting down efl.elementary")
    return elm_shutdown()


init()
atexit.register(shutdown)

_event_mapping_register(enums.ELM_EVENT_CONFIG_ALL_CHANGED, ConfigAllChanged)
_event_mapping_register(enums.ELM_EVENT_POLICY_CHANGED, PolicyChanged)
_event_mapping_register(enums.ELM_EVENT_PROCESS_BACKGROUND, ProcessBackground)
_event_mapping_register(enums.ELM_EVENT_PROCESS_FOREGROUND, ProcessForeground)


cdef void py_elm_sys_notify_send_cb(void *data, unsigned int id):
    cdef object func, func_data
    func, func_data = <object>data
    # FIXME: Is this cb called more than once? Py_DECREF if not.
    try:
        func(func_data, id)
    except Exception:
        traceback.print_exc()


def on_ethumb_connect(func, *args, **kwargs):
    """Use this to set a handler for the ethumb connect event.

    .. versionadded:: 1.14
    """
    return EventHandler(enums.ELM_ECORE_EVENT_ETHUMB_CONNECT, func, *args, **kwargs)


def on_config_all_changed(func, *args, **kwargs):
    """Use this to set a handler for the config all changed event.

    Emitted when the application has reconfigured elementary settings due to an
    external configuration tool asking it to.

    .. versionadded:: 1.14
    """
    return EventHandler(enums.ELM_EVENT_CONFIG_ALL_CHANGED, func, *args, **kwargs)


def on_policy_changed(func, *args, **kwargs):
    """Use this to set a handler for the policy changed event.

    Emitted when any Elementary's policy value is changed.

    .. versionadded:: 1.14
    """
    return EventHandler(enums.ELM_EVENT_POLICY_CHANGED, func, *args, **kwargs)


def on_process_background(func, *args, **kwargs):
    """Use this to set a handler for the process background event.

    Emitted when nothing is visible and the process as a whole should go into a
    background state.

    .. versionadded:: 1.14
    """
    return EventHandler(enums.ELM_EVENT_PROCESS_BACKGROUND, func, *args, **kwargs)


def on_process_foreground(func, *args, **kwargs):
    """Use this to set a handler for the process foreground event.

    Emitted when going from nothing being visible to at least one window being
    visible.

    .. versionadded:: 1.14
    """
    return EventHandler(enums.ELM_EVENT_PROCESS_FOREGROUND, func, *args, **kwargs)


def on_sys_notify_notification_closed(func, *args, **kargs):
    return EventHandler(
        enums.ELM_EVENT_SYS_NOTIFY_NOTIFICATION_CLOSED, func, *args, **kargs
        )


def on_sys_notify_action_invoked(func, *args, **kargs):
    return EventHandler(
        enums.ELM_EVENT_SYS_NOTIFY_ACTION_INVOKED, func, *args, **kargs
        )


cdef class FontProperties(object):

    """Elementary font properties"""

    cdef Elm_Font_Properties *efp

    def __dealloc__(self):
        elm_font_properties_free(self.efp)
        self.efp = NULL

    property name:
        """:type: unicode"""
        def __set__(self, value):
            if isinstance(value, unicode): value = PyUnicode_AsUTF8String(value)
            self.efp.name = value

        def __get__(self):
            return _ctouni(self.efp.name)

    property styles:
        """:type: list of strings"""
        def __set__(self, value):
            self.efp.styles = python_list_strings_to_eina_list(value)

        def __get__(self):
            return eina_list_strings_to_python_list(self.efp.styles)


def run():
    """Run Elementary's main loop

    This call should be issued just after all initialization is completed. This
    function will not return until exit() is called. It will keep looping,
    running the main (event/processing) loop for Elementary.

    """
    EINA_LOG_DOM_DBG(PY_EFL_ELM_LOG_DOMAIN, "Starting up main loop.")
    with nogil:
        elm_run()

def exit():
    """Ask to exit Elementary's main loop

    If this call is issued, it will flag the main loop to cease processing and
    return back to its parent function (usually your elm_main() function). This
    does not mean the main loop instantly quits. So your ecore callbacks(timer,
    animator, event, job, and etc.) have chances to be called even after
    exit().

    .. note::

        By using the appropriate :attr:`ELM_POLICY_QUIT` on your Elementary
        applications, you'll be able to get this function called automatically
        for you.

    """
    EINA_LOG_DOM_DBG(PY_EFL_ELM_LOG_DOMAIN, "Ending main loop.")
    elm_exit()

def policy_set(Elm_Policy policy, value):
    """Set new policy value.

    This will emit the ecore event ``ELM_EVENT_POLICY_CHANGED`` in the main
    loop giving the event information Elm_Event_Policy_Changed with
    policy identifier, new and old values.

    :param policy: policy identifier as in Elm_Policy.
    :type policy: :ref:`Elm_Policy`
    :param value: policy value, depends on identifiers, usually there is
        an enumeration with the same prefix as the policy name, for
        example: ELM_POLICY_QUIT and Elm_Policy_Quit
        (ELM_POLICY_QUIT_NONE, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED).
    :type value: :ref:`Elm_Policy_Quit`

    :return: True on success or False on error (right
        now just invalid policy identifier, but in future policy
        value might be enforced).

    """
    # TODO: add a function for setting a callback for the event described above
    return bool(elm_policy_set(policy, value))

def policy_get(Elm_Policy policy):
    """Gets the policy value set for given identifier.

    :param policy: policy identifier as in Elm_Policy.
    :type policy: :ref:`Elm_Policy`

    :return: policy value. Will be 0 if policy identifier is invalid.
    :rtype: :ref:`Elm_Policy_Quit`

    """
    return elm_policy_get(policy)

def process_state_get():
    """Get the process state as a while.

    The process may logically be some runnable state. a "foreground" application
    runs as normal and may be user-visible or "active" in some way. A
    background application is not user-visible or otherwise important and
    likely should release resources and not wake up often or process much.

    :return: The current process state
    :rtype: :ref:`Elm_Process_State`

    .. versionadded:: 1.12

    """
    return elm_process_state_get()

def coords_finger_size_adjust(int times_w, int w, int times_h, int h):
    """Adjust size of an element for finger usage.

    :param times_w: How many fingers should fit horizontally
    :type times_w: int
    :param w: Width size to adjust
    :type w: int
    :param times_h: How many fingers should fit vertically
    :type times_h: int
    :param h: Height size to adjust
    :type h: int

    :return: The adjusted width and height
    :rtype: (int **w**, int **h**)

    This takes width and height sizes (in pixels) as input and a
    size multiple (which is how many fingers you want to place
    within the area, being "finger" the size set by
    elm_config_finger_size_set()), and adjusts the size to be large enough
    to accommodate the resulting size -- if it doesn't already
    accommodate it.

    .. note:: This is kind of low level Elementary call, most useful
        on size evaluation times for widgets. An external user wouldn't
        be calling, most of the time.

    """
    cdef Evas_Coord width = w, height = h
    elm_coords_finger_size_adjust(times_w, &width, times_h, &height)
    return (width, height)

def language_set(lang not None):
    """Change the language of the current application

    The ``lang`` passed must be the full name of the locale to use, for
    example ``en_US.utf8`` or ``es_ES@euro``.

    Changing language with this function will make Elementary run through
    all its widgets, translating strings set with
    elm_object_domain_translatable_part_text_set(). This way, an entire
    UI can have its language changed without having to restart the program.

    For more complex cases, like having formatted strings that need
    translation, widgets will also emit a "language,changed" signal that
    the user can listen to and manually translate the text.

    :param lang: Language to set, must be the full name of the locale

    """
    if isinstance(lang, unicode): lang = PyUnicode_AsUTF8String(lang)
    elm_language_set(<const char *>lang)

def cache_all_flush():
    """Frees all data that was in cache and is not currently being used to reduce
    memory usage. This frees Edje's, Evas' and Eet's cache.

    .. note:: Evas caches are flushed for every canvas associated with a window.

    .. versionadded:: 1.8

    """
    elm_cache_all_flush()

def font_properties_get(font not None):
    """Translate a font (family) name string in fontconfig's font names
    syntax into a FontProperties object.

    :param font: The font name and styles string
    :return: the font properties object

    .. note:: The reverse translation can be achieved with
        :py:func:`font_fontconfig_name_get`, for one style only (single font
        instance, not family).

    .. versionadded:: 1.8

    """
    if isinstance(font, unicode): font = PyUnicode_AsUTF8String(font)
    cdef FontProperties ret = FontProperties.__new__(FontProperties)

    ret.efp = elm_font_properties_get(<const char *>font)

    return ret

def font_properties_free(FontProperties fp):
    """Free font properties return by font_properties_get().

    :param fp: the font properties struct

    .. versionadded:: 1.8

    .. versionchanged:: 1.19

        Changed to no-op as we now do the free automatically when there are
        no more references to the FontProperties object

    """
    pass

def font_fontconfig_name_get(font_name, style = None):
    """Translate a font name, bound to a style, into fontconfig's font names
    syntax.

    :param font_name: The font (family) name
    :param style: The given style (may be None)

    :return: the font name and style string

    .. note:: The reverse translation can be achieved with
        :py:func:`font_properties_get`, for one style only (single font
        instance, not family).

    .. versionadded:: 1.8

    """
    cdef:
        unicode ret
        char *fc_name
    if isinstance(font_name, unicode): font_name = PyUnicode_AsUTF8String(font_name)
    if isinstance(style, unicode): style = PyUnicode_AsUTF8String(style)
    fc_name = elm_font_fontconfig_name_get(
        <const char *>font_name,
        <const char *>style if style is not None else NULL
        )

    ret = _touni(fc_name)
    elm_font_fontconfig_name_free(fc_name)
    return ret

# TODO: Create an Eina_Hash -> dict conversion function for this
# def font_available_hash_add(list):
#     """Create a font hash table of available system fonts.

#     One must call it with ``list`` being the return value of
#     evas_font_available_list(). The hash will be indexed by font
#     (family) names, being its values ``Elm_Font_Properties`` blobs.

#     :param list: The list of available system fonts, as returned by
#     evas_font_available_list().
#     :return: the font hash.

#     .. note:: The user is supposed to get it populated at least with 3
#     default font families (Sans, Serif, Monospace), which should be
#     present on most systems.

#     """
#     EAPI Eina_Hash *elm_font_available_hash_add(Eina_List *list)


#     """Free the hash returned by elm_font_available_hash_add().

#     :param hash: the hash to be freed.

#     """
#     elm_font_available_hash_del(Eina_Hash *hash)

def object_tree_dump(evasObject top):
    """Print Tree object hierarchy in stdout

    :param top: The root object

    .. versionadded:: 1.8

    """
    elm_object_tree_dump(top.obj)

def object_tree_dot_dump(evasObject top, path):
    """Print Elm Objects tree hierarchy in file as dot(graphviz) syntax.

    :param top: The root object
    :param path: The path of output file

    .. versionadded:: 1.8

    """
    if isinstance(path, unicode): path = PyUnicode_AsUTF8String(path)
    elm_object_tree_dot_dump(top.obj, <const char *>path)

def sys_notify_close(unsigned int id):
    """Causes a notification to be forcefully closed and removed from the user's
    view. It can be used, for example, in the event that what the notification
    pertains to is no longer relevant, or to cancel a notification * with no
    expiration time.

    :param id: Notification id

    .. note:: If the notification no longer exists,
        an empty D-BUS Error message is sent back.

    .. versionadded:: 1.10

    """
    elm_sys_notify_close(id)

def sys_notify_send(
    unsigned int replaces_id=0,
    icon=None, summary=None, body=None,
    Elm_Sys_Notify_Urgency urgency=enums.ELM_SYS_NOTIFY_URGENCY_NORMAL,
    int timeout=-1, cb=None, cb_data=None
    ):
    """Sends a notification to the notification server.

    :param replaces_id: Notification ID that this notification replaces.
        The value 0 means a new notification.
    :param icon: The optional program icon of the calling application.
    :param summary: The summary text briefly describing the notification.
    :param body: The optional detailed body text. Can be empty.
    :param urgency: The urgency level.
    :param timeout: Timeout display in milliseconds.
    :param cb: Callback used to retrieve the notification id
        return by the Notification Server.
    :param cb_data: Optional context data

    .. versionadded:: 1.10

    """
    if cb is not None:
        if not callable(cb):
            raise TypeError("cb must be callable")
        py_cb_data = (cb, cb_data)
        Py_INCREF(py_cb_data)

    if isinstance(icon, unicode): icon = PyUnicode_AsUTF8String(icon)
    if isinstance(summary, unicode): summary = PyUnicode_AsUTF8String(summary)
    if isinstance(body, unicode): body = PyUnicode_AsUTF8String(body)
    elm_sys_notify_send(
        replaces_id,
        <const char *>icon if icon is not None else NULL,
        <const char *>summary if summary is not None else NULL,
        <const char *>body if body is not None else NULL,
        urgency,
        timeout,
        <Elm_Sys_Notify_Send_Cb>py_elm_sys_notify_send_cb if cb is not None else NULL,
        <const void *>py_cb_data if cb is not None else NULL
        )

from cpython cimport PyObject_GetBuffer, PyBuffer_Release, PyBUF_SIMPLE, \
    PyObject_CheckBuffer

from efl.utils.deprecated import DEPRECATED
from efl.utils.conversions cimport *
from efl.eo cimport Eo, object_from_instance
from efl.evas cimport SmartObject, EventKeyDown, EventKeyUp, EventMouseWheel

from datetime import date, datetime


cdef object _cb_string_conv(void *addr):
    return _ctouni(<const char *>addr) if addr is not NULL else None

cdef object _cb_object_item_conv(void *addr):
    return _object_item_to_python(<Elm_Object_Item *>addr)

cdef object _cb_rectangle_conv(void *addr):
    cdef Evas_Coord_Rectangle *geom = <Evas_Coord_Rectangle *>addr
    return Rect(geom.x, geom.y, geom.w, geom.h)


#include "access.pxi"
include "actionslider.pxi"
include "background.pxi"
include "box.pxi"
include "bubble.pxi"
include "button.pxi"
include "calendar.pxi"
include "check.pxi"
include "clock.pxi"
include "colorselector.pxi"
include "combobox.pxi"
include "configuration.pxi"
include "conformant.pxi"
include "ctxpopup.pxi"
include "datetime.pxi"
include "dayselector.pxi"
include "diskselector.pxi"
include "entry.pxi"
include "fileselector.pxi"
include "fileselector_button.pxi"
include "fileselector_entry.pxi"
include "flip.pxi"
include "flipselector.pxi"
include "frame.pxi"
#include "general.pxi"
include "gengrid.pxi"
include "genlist.pxi"
include "gesture_layer.pxi"
#include "glview.pxi"
include "grid.pxi"
include "hover.pxi"
include "hoversel.pxi"
include "icon.pxi"
include "image.pxi"
include "index.pxi"
include "innerwindow.pxi"
include "label.pxi"
#include "layout_class.pxi"
include "layout.pxi"
include "list.pxi"
include "map.pxi"
include "mapbuf.pxi"
include "menu.pxi"
include "multibuttonentry.pxi"
include "naviframe.pxi"
include "need.pxi"
include "notify.pxi"
include "object.pxi"
include "object_item.pxi"
include "panel.pxi"
include "panes.pxi"
include "photo.pxi"
include "photocam.pxi"
include "plug.pxi"
include "popup.pxi"
include "progressbar.pxi"
include "radio.pxi"
include "scroller.pxi"
include "segment_control.pxi"
include "separator.pxi"
include "slider.pxi"
include "slideshow.pxi"
include "spinner.pxi"
#include "store.pxi"
include "systray.pxi"
include "table.pxi"
include "theme.pxi"
include "thumb.pxi"
include "toolbar.pxi"
include "transit.pxi"
include "video.pxi"
include "web.pxi"
include "window.pxi"
