from setuptools import setup, find_packages
import sys, os

here = os.path.abspath(os.path.dirname(__file__))
README = open(os.path.join(here, 'README.rst')).read()
NEWS = open(os.path.join(here, 'NEWS.txt')).read()


version = '0.3.3'

install_requires = [
    'urllib3>=1.7',
    'pyOpenSSL>=0.14',
]

test_requires = [
    'mock',
    'nose',
]

setup(name='python-etcd-azion',
    version=version,
    description="A python client for etcd - Azion's fork",
    long_description=README + '\n\n' + NEWS,
    classifiers=[
        "Topic :: System :: Distributed Computing",
        "Topic :: Software Development :: Libraries",
        "License :: OSI Approved :: MIT License",
        "Topic :: Database :: Front-Ends",
    ],
    keywords="etcd raft distributed log api client - Azion's fork",
    author='Jose Plana',
    author_email='jplana@gmail.com',
    url='http://github.com/aziontech/python-etcd',
    license='MIT',
    packages=find_packages('src'),
    package_dir = {'': 'src'},
    include_package_data=True,
    zip_safe=False,
    install_requires=install_requires,
    tests_require=test_requires,
    test_suite='nose.collector',

)
