"""Define fixtures for the base API."""
from datetime import datetime, timedelta

import pytest

from ..const import TEST_ACCESS_TOKEN, TEST_EMAIL


@pytest.fixture()
def devices_list_json():
    """Define a successful response to POST /api/v1/app/get_devs_list."""
    return {
        "code": 0,
        "msg": "Succeed.",
        "data": [
            {
                "device_id": 14907,
                "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                "device_name": "Driveway",
                "device_model": "T8111",
                "time_zone": "",
                "device_type": 1,
                "device_channel": 0,
                "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "schedule": "",
                "schedulex": "",
                "wifi_mac": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "sub1g_mac": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "main_sw_version": "1.9.3",
                "main_hw_version": "HAIYI-IMX323",
                "sec_sw_version": "2.0.6.3-0627-us",
                "sec_hw_version": "P1",
                "sector_id": 0,
                "event_num": 1,
                "wifi_ssid": "",
                "ip_addr": "",
                "main_sw_time": 1565008299,
                "sec_sw_time": 1563582100,
                "bind_time": 1546718435,
                "cover_path": "https://path/to/image.jpg",
                "cover_time": 1572460903,
                "local_ip": "",
                "create_time": 1539179003,
                "update_time": 1572460903,
                "status": 1,
                "svr_domain": "",
                "svr_port": 0,
                "station_conn": {
                    "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "station_name": "Home",
                    "station_model": "T8001",
                    "main_sw_version": "1.1.1.5",
                    "main_hw_version": "P1",
                    "p2p_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "push_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "ndt_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "p2p_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "app_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "binded": False,
                    "setup_code": "",
                    "setup_id": "",
                },
                "family_num": 0,
                "member": {
                    "family_id": 18456,
                    "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "admin_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "member_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "member_type": 2,
                    "permissions": 0,
                    "member_nick": "",
                    "action_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "fence_state": 0,
                    "create_time": 1546717990,
                    "update_time": 1546717990,
                    "status": 1,
                    "email": TEST_EMAIL,
                    "nick_name": "",
                    "avatar": "",
                    "action_user_name": "",
                },
                "permission": None,
                "params": [
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1015,
                        "param_value": "0",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1239,
                        "param_value": "9",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1243,
                        "param_value": "2",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1210,
                        "param_value": "50",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1101,
                        "param_value": "80",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1246,
                        "param_value": "0",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1134,
                        "param_value": "0",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1204,
                        "param_value": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                        "create_time": 1553318596,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1145,
                        "param_value": "0",
                        "create_time": 1546722865,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1229,
                        "param_value": "100",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615122,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 99901,
                        "param_value": "0",
                        "create_time": 1546718451,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1141,
                        "param_value": "-89",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1013,
                        "param_value": "1",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1230,
                        "param_value": "100",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1142,
                        "param_value": "-64",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1011,
                        "param_value": "1",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1225,
                        "param_value": "1",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1252,
                        "param_value": "0",
                        "create_time": 1572355417,
                        "update_time": 1572355417,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1146,
                        "param_value": "0",
                        "create_time": 1547260362,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 2111,
                        "param_value": "2",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1241,
                        "param_value": "1",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1131,
                        "param_value": "1",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 99904,
                        "param_value": "0",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1045,
                        "param_value": "0",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1240,
                        "param_value": "1",
                        "create_time": 1546718455,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx1",
                        "param_type": 1138,
                        "param_value": "-5",
                        "create_time": 1546718454,
                        "update_time": 0,
                        "status": 1,
                    },
                ],
                "pir_total": 40,
                "pir_none": 8,
                "week_pir_total": 159,
                "week_pir_none": 90,
                "month_pir_total": 1067,
                "month_pir_none": 831,
            },
            {
                "device_id": 14920,
                "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                "device_name": "Patio",
                "device_model": "T8111",
                "time_zone": "",
                "device_type": 1,
                "device_channel": 1,
                "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "schedule": "",
                "schedulex": "",
                "wifi_mac": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "sub1g_mac": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "main_sw_version": "1.9.3",
                "main_hw_version": "HAIYI-IMX323",
                "sec_sw_version": "2.0.6.3-0627-us",
                "sec_hw_version": "P1",
                "sector_id": 0,
                "event_num": 0,
                "wifi_ssid": "",
                "ip_addr": "",
                "main_sw_time": 1565008350,
                "sec_sw_time": 1563582129,
                "bind_time": 1546718602,
                "cover_path": "https://path/to/image.jpg",
                "cover_time": 1572455103,
                "local_ip": "",
                "create_time": 1539179631,
                "update_time": 1572460765,
                "status": 1,
                "svr_domain": "",
                "svr_port": 0,
                "station_conn": {
                    "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "station_name": "Home",
                    "station_model": "T8001",
                    "main_sw_version": "1.1.1.5",
                    "main_hw_version": "P1",
                    "p2p_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "push_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "ndt_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "p2p_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "app_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "binded": False,
                    "setup_code": "",
                    "setup_id": "",
                },
                "family_num": 0,
                "member": {
                    "family_id": 18456,
                    "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "admin_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "member_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "member_type": 2,
                    "permissions": 0,
                    "member_nick": "",
                    "action_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                    "fence_state": 0,
                    "create_time": 1546717990,
                    "update_time": 1546717990,
                    "status": 1,
                    "email": TEST_EMAIL,
                    "nick_name": "",
                    "avatar": "",
                    "action_user_name": "",
                },
                "permission": None,
                "params": [
                    {
                        "param_id": 615148,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1015,
                        "param_value": "0",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615155,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1239,
                        "param_value": "9",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615147,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1243,
                        "param_value": "2",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615145,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1210,
                        "param_value": "30",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615158,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1101,
                        "param_value": "95",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615146,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1246,
                        "param_value": "0",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1134,
                        "param_value": "0",
                        "create_time": 1546718642,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1204,
                        "param_value": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                        "create_time": 1553318600,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1145,
                        "param_value": "0",
                        "create_time": 1546722873,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615151,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1229,
                        "param_value": "100",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 99901,
                        "param_value": "0",
                        "create_time": 1546718629,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615150,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1013,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1141,
                        "param_value": "-57",
                        "create_time": 1546718642,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1142,
                        "param_value": "-45",
                        "create_time": 1546718642,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615153,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1230,
                        "param_value": "100",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615144,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1011,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615156,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1225,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1252,
                        "param_value": "0",
                        "create_time": 1572357260,
                        "update_time": 1572357260,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1146,
                        "param_value": "0",
                        "create_time": 1547260787,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 2111,
                        "param_value": "2",
                        "create_time": 1546718642,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615154,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1241,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615157,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1131,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615159,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 99904,
                        "param_value": "0",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615149,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1045,
                        "param_value": "0",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 615152,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1240,
                        "param_value": "1",
                        "create_time": 1546718622,
                        "update_time": 0,
                        "status": 1,
                    },
                    {
                        "param_id": 0,
                        "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx2",
                        "param_type": 1138,
                        "param_value": "-11",
                        "create_time": 1546718642,
                        "update_time": 0,
                        "status": 1,
                    },
                ],
                "pir_total": 37,
                "pir_none": 28,
                "week_pir_total": 124,
                "week_pir_none": 82,
                "month_pir_total": 1119,
                "month_pir_none": 603,
            },
        ],
    }


@pytest.fixture()
def empty_response():
    """Define a fixture that returns an empty response."""
    return None


@pytest.fixture()
def history_json():
    """Define a successful response to POST api/v1/event/app/get_all_history_record."""
    return {
        "code": 0,
        "msg": "Succeed.",
        "data": [
            {
                "monitor_id": 128428371,
                "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "storage_type": 1,
                "storage_path": "/media/mmcblk0p1/Camera00/20191028123014.dat",
                "hevc_storage_path": "",
                "cloud_path": "",
                "frame_num": 119,
                "thumb_path": "https://path/to/image.jpg",
                "thumb_data": "",
                "start_time": 1572287416088,
                "end_time": 1572287426100,
                "cipher_id": 158,
                "cipher_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "has_human": 0,
                "volume": "Anker_HmQx0Cp_g",
                "vision": 0,
                "device_name": "Driveway",
                "device_type": 1,
                "video_type": 0,
                "extra": "",
                "viewed": False,
                "create_time": 1572287430,
                "update_time": 1572287430,
                "status": 1,
                "station_name": "",
                "p2p_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "push_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "p2p_license": "WPMWQK",
                "push_license": "BDYNMB",
                "ndt_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "ndt_license": "DKUIYX",
                "p2p_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "app_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "wipn_enc_dec_key": "ZXSecurity17Cam@",
                "wipn_ndt_aes128key": "ZXSecurity17Cam@",
                "query_server_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "prefix": "",
                "ai_faces": None,
                "is_favorite": False,
            },
            {
                "monitor_id": 128340343,
                "station_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "device_sn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "storage_type": 1,
                "storage_path": "/media/mmcblk0p1/Camera00/20191028100453.dat",
                "hevc_storage_path": "",
                "cloud_path": "",
                "frame_num": 113,
                "thumb_path": "https://path/to/image.jpg",
                "thumb_data": "",
                "start_time": 1572278695752,
                "end_time": 1572278702140,
                "cipher_id": 158,
                "cipher_user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "has_human": 1,
                "volume": "Anker_HmQx0Cp_g",
                "vision": 0,
                "device_name": "Driveway",
                "device_type": 1,
                "video_type": 0,
                "extra": "",
                "viewed": False,
                "create_time": 1572278710,
                "update_time": 1572278710,
                "status": 1,
                "station_name": "",
                "p2p_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "push_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "p2p_license": "WPMWQK",
                "push_license": "BDYNMB",
                "ndt_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "ndt_license": "DKUIYX",
                "p2p_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "app_conn": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "wipn_enc_dec_key": "ZXSecurity17Cam@",
                "wipn_ndt_aes128key": "ZXSecurity17Cam@",
                "query_server_did": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                "prefix": "",
                "ai_faces": None,
                "is_favorite": False,
            },
        ],
    }


@pytest.fixture()
def login_invalid_email_json():
    """
    Define a "failure" response to POST /api/v1/passport/login.

    This failure is because of an invalid email address.
    """
    return {"code": 26006, "msg": "This email address does not exist.", "data": None}


@pytest.fixture()
def login_invalid_password_json():
    """
    Define a "failure" response to POST /api/v1/passport/login.

    This failure is because of an invalid email address/password combination.
    """
    return {"code": 26006, "msg": "Email address or password incorrect.", "data": None}


@pytest.fixture()
def login_success_json():
    """Define a successful response to POST /api/v1/passport/login."""
    return {
        "code": 0,
        "msg": "Succeed.",
        "data": {
            "user_id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            "email": TEST_EMAIL,
            "nick_name": "",
            "auth_token": TEST_ACCESS_TOKEN,
            "token_expires_at": int((datetime.now() + timedelta(days=1)).timestamp()),
            "avatar": "",
            "invitation_code": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            "inviter_code": "",
            "mac_addr": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            "domain": "security-app.eufylife.com",
            "ab_code": "US",
            "geo_key": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            "privilege": 0,
            "params": [
                {"param_type": 10000, "param_value": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"}
            ],
        },
    }
