# Generated by Django 5.0.4 on 2024-04-17 19:26

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies: list = []

    operations = [
        migrations.CreateModel(
            name="OutboxEntry",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("created_at", models.DateTimeField()),
                ("data", models.JSONField()),
                (
                    "stream_name",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("position", models.IntegerField()),
                ("tries_left", models.IntegerField(default=3)),
            ],
        ),
        migrations.CreateModel(
            name="Stream",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False)),
                ("name", models.CharField(blank=True, max_length=255, null=True)),
                ("category", models.CharField(default="", max_length=255)),
                ("tenant_id", models.CharField(max_length=255)),
                ("version", models.BigIntegerField(blank=True, null=True)),
            ],
            options={
                "unique_together": {
                    ("name", "category", "tenant_id"),
                    ("uuid", "category", "tenant_id"),
                },
            },
        ),
        migrations.CreateModel(
            name="Snapshot",
            fields=[
                ("uuid", models.UUIDField(primary_key=True, serialize=False)),
                ("version", models.IntegerField()),
                ("name", models.CharField(max_length=50)),
                ("data", models.JSONField()),
                ("event_context", models.JSONField()),
                ("created_at", models.DateTimeField()),
                (
                    "stream",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="snapshots",
                        to="event_sourcery_django.stream",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("version", models.IntegerField(blank=True, null=True)),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("name", models.CharField(max_length=200)),
                ("data", models.JSONField()),
                ("event_context", models.JSONField()),
                ("created_at", models.DateTimeField()),
                (
                    "stream",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="events",
                        to="event_sourcery_django.stream",
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["stream", "version"], name="ix_events_stream_id_version"
                    )
                ],
            },
        ),
    ]
