# EverhourAPI Library 
This library provides a simple interface to interact with the Everhour API.

## Databricks runtime information
- This is a library to connect with everhour from python (using spark). 
- Dependencies current target alignment with Databricks [Runtime v14.3LTS](https://docs.databricks.com/en/release-notes/runtime/14.3lts.html#system-)

## Testing
For the testing of our module, we use mock data provided by the actual Everhour API to simulate production API interactions during testing. This ensures reliable and consistent test results without requiring live API access. The mock data is generated by Everhour and replicates real-world responses. This approach enhances security by keeping API keys safe and improves test speed.

To manage this, we use VCR. VCR records HTTP interactions with the Everhour API and replays them during tests, allowing us to simulate real API calls without hitting the live server. This ensures our tests are both fast and stable while closely mimicking production behavior.

[Everhour API mock data](https://everhour.docs.apiary.io/#reference/0/expenses/get-current-user?console=1)


Run tests: ```uv run pytest ```