#include <pybind11/pybind11.h>

int add(int i, int j) {
    return i + j;
}

int subtract(int i, int j) {
    return i - j;
}

int multiply(int i, int j) {
    return i * j;
}

double divide(int i, int j) {
    return i / j;
}

PYBIND11_MODULE(python_example_wierdre, m) {
    m.doc() = R"pbdoc(
        Pybind11 example plugin by Wierdre
        ----------------------------------

        .. currentmodule:: python_example_wierdre

        .. autosummary::
           :toctree: _generate

           add
           subtract
    )pbdoc";

    m.def("add", &add, "add function");
    m.def("subtract", &subtract, "subtract function");
    m.def("multiply", &multiply, "multiply function");
    m.def("divide", &divide, "divide function");
}