/*
 * Decompiled with CFR 0.152.
 */
package fr.lcdp.codegen;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PythonFastAPIServerCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonRestServerCodegen
extends PythonFastAPIServerCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonRestServerCodegen.class);
    public static final String COMMON_PACKAGE_NAME = "commonPackageName";
    private static final String BASE_CLASS_SUFFIX = "base";
    private String commonPackage = "common";

    public PythonRestServerCodegen() {
        this.additionalProperties.put("sourceFolder", ".");
        LOGGER.info("Start PythonRestServerCodegen");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "python-fastapi-rest-server-codegen";
    }

    public String getHelp() {
        return "Generates a python-lcdp-server.";
    }

    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(COMMON_PACKAGE_NAME)) {
            this.commonPackage = (String)this.additionalProperties.get(COMMON_PACKAGE_NAME);
        }
        this.supportingFiles.add(new SupportingFile("python-fastapi-rest-server/health.mustache", StringUtils.substringAfter((String)this.commonPackageFileFolder(), (String)this.outputFolder), "health.py"));
        this.removeSupportingFile("security_api.mustache");
        this.supportingFiles.add(new SupportingFile("python-fastapi-rest-server/security_api.mustache", StringUtils.substringAfter((String)this.packageFileFolder(), (String)this.outputFolder), "security_api.py"));
        this.supportingFiles.add(new SupportingFile("python-fastapi-rest-server/token.mustache", StringUtils.substringAfter((String)this.packageFileFolder(), (String)this.outputFolder), "token.py"));
        this.supportingFiles.add(new SupportingFile("python-fastapi-rest-server/context.mustache", StringUtils.substringAfter((String)this.packageFileFolder(), (String)this.outputFolder), "context.py"));
        this.removeSupportingFile("gitignore.mustache");
        this.removeSupportingFile(".flake8.mustache");
        this.removeSupportingFile("docker-compose.mustache");
        this.removeSupportingFile("openapi.mustache");
        this.removeSupportingFile("poetry.mustache");
        this.removeSupportingFile("requirements.mustache");
        this.removeSupportingFile("setup_cfg.mustache");
        this.removeSupportingFile("conftest.mustache");
        this.removeSupportingFile("Dockerfile.mustache");
        this.removeSupportingFile("pyproject_toml.mustache");
        this.removeSupportingFile("README.mustache");
        this.supportingFiles.removeIf(supportingFile -> supportingFile.getTemplateFile().equals("__init__.mustache") && supportingFile.getFolder().equals(StringUtils.substringAfter((String)this.apiImplFileFolder(), (String)this.outputFolder)));
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put("python-fastapi-rest-server/api.mustache", ".py");
        this.apiTemplateFiles.remove("base_api.mustache");
        this.apiTemplateFiles.put("python-fastapi-rest-server/base_api.mustache", "_".concat(BASE_CLASS_SUFFIX).concat(".py"));
        this.modelTemplateFiles.remove("model.mustache");
        this.modelTemplateFiles.put("python-fastapi-rest-server/model.mustache", ".py");
    }

    private void removeSupportingFile(String templateName) {
        this.supportingFiles.removeIf(supportingFile -> supportingFile.getTemplateFile().equals(templateName));
    }

    public String commonPackageFileFolder() {
        return String.join((CharSequence)File.separator, this.outputFolder, this.sourceFolder, this.commonPackage.replace('.', File.separatorChar));
    }

    public String packageFileFolder() {
        return String.join((CharSequence)File.separator, this.outputFolder, this.sourceFolder, this.packageName.replace('.', File.separatorChar));
    }

    public void postProcessResponseWithProperty(CodegenResponse response, CodegenProperty property) {
        if (property.isNullable) {
            property.setDataType("Optional[" + property.getDataType() + "]");
            response.setDataType("Optional[" + response.getDataType() + "]");
        }
    }
}

