# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone



from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class RestError(BaseModel):
    """
    RestError
    """ # noqa: E501
    code: StrictStr = Field(description="Unique code to identify an error : * `CODE000` - Using outdated resource * `CODE001` - Invalid credentials * `CODE002` - Cannot renew token * `CODE003` - Invalid User CGV * `CODE004` - Resource already exists * `CODE005` - User account is disabled * `CODE006` - Invalid schedule * `CODE007` - Wrong Address according CHRONOPOST * `CODE008` - Invalid Mangopay Mandate * `CODE009` - Invalid Status * `CODE010` - Empty Meta-Order * `CODE011` - Empty User Address * `CODE012` - Empty User Legal Name * `CODE013` - Invalid quantities * `CODE014` - Invalid Meta-Order * `CODE015` - Can not release quantity greater than claimed * `CODE016` - Can not release a negative quantity of items ")
    message: StrictStr = Field(description="Unique code to identify an error : * `MESSAGE000` - Using outdated resource * `MESSAGE001` - Invalid credentials * `MESSAGE002` - Cannot renew token * `MESSAGE003` - Invalid User CGV * `MESSAGE004` - Resource already exists * `MESSAGE005` - User account is disabled * `MESSAGE006` - Invalid schedule * `MESSAGE007` - Wrong Address according CHRONOPOST * `MESSAGE008` - Invalid Mangopay Mandate * `MESSAGE009` - Invalid Status * `MESSAGE010` - Empty Meta-Order * `MESSAGE011` - Empty User Address * `MESSAGE012` - Empty User Legal Name * `MESSAGE013` - Invalid quantities * `MESSAGE014` - Invalid Meta-Order * `MESSAGE015` - Can not release quantity greater than claimed * `MESSAGE016` - Can not release a negative quantity of items ")
    __properties: ClassVar[List[str]] = ["code", "message"]

    @field_validator('code')
    def code_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('CODE000', 'CODE001', 'CODE002', 'CODE003', 'CODE004', 'CODE005', 'CODE006', 'CODE007', 'CODE008', 'CODE009', 'CODE010', 'CODE011', 'CODE012', 'CODE013', 'CODE014', 'CODE015', 'CODE016'):
            raise ValueError("must be one of enum values ('CODE000', 'CODE001', 'CODE002', 'CODE003', 'CODE004', 'CODE005', 'CODE006', 'CODE007', 'CODE008', 'CODE009', 'CODE010', 'CODE011', 'CODE012', 'CODE013', 'CODE014', 'CODE015', 'CODE016')")
        return value

    @field_validator('message')
    def message_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Using outdated resource', 'Login failed', 'Cannot renew token', 'Invalid User CGV', 'Resource already exists', 'User account is disabled', 'Invalid schedule', 'Wrong Address according CHRONOPOST', 'Invalid Mangopay Mandate', 'Invalid Status', 'Empty Meta-Order', 'Empty User Address', 'Empty User Legal Name', 'Invalid quantities', 'Invalid Meta-Order', 'Can not release quantity greater than claimed', 'Can not release a negative quantity of items'):
            raise ValueError("must be one of enum values ('Using outdated resource', 'Login failed', 'Cannot renew token', 'Invalid User CGV', 'Resource already exists', 'User account is disabled', 'Invalid schedule', 'Wrong Address according CHRONOPOST', 'Invalid Mangopay Mandate', 'Invalid Status', 'Empty Meta-Order', 'Empty User Address', 'Empty User Legal Name', 'Invalid quantities', 'Invalid Meta-Order', 'Can not release quantity greater than claimed', 'Can not release a negative quantity of items')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
        "json_encoders": {
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RestError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of RestError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "message": obj.get("message")
        })
        return _obj


