# coding: utf-8

"""
    LCDP REST API

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401



from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from openapi_server.models.login_credential import LoginCredential
from openapi_server.models.refresh_session_credential import RefreshSessionCredential
from typing import Union, Any, List, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal
from pydantic import StrictStr, Field, RootModel
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self


class LoginCredentialOneof(LoginCredential):
    grant_type: Literal['password']
    pass

class RefreshSessionCredentialOneof(RefreshSessionCredential):
    grant_type: Literal['refresh_token']
    pass


class AnyAuthenticationCredential(RootModel):
    """
    AnyAuthenticationCredential
    """
    root: Union[LoginCredentialOneof, RefreshSessionCredentialOneof] = Field(discriminator="grant_type")

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of AnyAuthenticationCredential from a dictionary"""
        return cls(obj)

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())

    def to_dict(self) -> Dict:
        """Returns the dict representation of the actual instance"""
        if self.root is None:
            return None

        to_dict = getattr(self.root, "to_dict", None)
        if callable(to_dict):
            return self.root.to_dict()
        else:
            # primitive type
            return self.root


