# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone



from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Barcodes(BaseModel):
    """
    Barcodes
    """ # noqa: E501
    cip: Optional[StrictStr] = None
    cip13: Optional[StrictStr] = None
    ean: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cip", "cip13", "ean"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
        "json_encoders": {
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Barcodes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # set to None if cip (nullable) is None
        # and model_fields_set contains the field
        if self.cip is None and "cip" in self.model_fields_set:
            _dict['cip'] = None

        # set to None if cip13 (nullable) is None
        # and model_fields_set contains the field
        if self.cip13 is None and "cip13" in self.model_fields_set:
            _dict['cip13'] = None

        # set to None if ean (nullable) is None
        # and model_fields_set contains the field
        if self.ean is None and "ean" in self.model_fields_set:
            _dict['ean'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Barcodes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cip": obj.get("cip"),
            "cip13": obj.get("cip13"),
            "ean": obj.get("ean")
        })
        return _obj


