# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone



from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_server.models.barcodes import Barcodes
from openapi_server.models.http_link import HttpLink
from openapi_server.models.laboratory_link import LaboratoryLink
from openapi_server.models.product_dispensation_place import ProductDispensationPlace
from openapi_server.models.product_market_status import ProductMarketStatus
from openapi_server.models.product_secondary_type import ProductSecondaryType
from openapi_server.models.product_status import ProductStatus
from openapi_server.models.product_type import ProductType
from openapi_server.models.statistics import Statistics
from openapi_server.models.vat import Vat
from openapi_server.models.vidal_package_link import VidalPackageLink
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Product(BaseModel):
    """
    Product
    """ # noqa: E501
    any_type: Optional[Any] = Field(default=None, alias="anyType")
    id: Optional[StrictInt] = None
    vidal_package: Optional[VidalPackageLink] = Field(default=None, alias="vidalPackage")
    is_automatic_vidal_sync_enabled: Optional[StrictBool] = Field(default=None, description="Indicates if automatic synchronization to vidal is enabled", alias="isAutomaticVidalSyncEnabled")
    barcodes: Optional[Barcodes] = None
    name: Optional[StrictStr] = None
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    dci: Optional[StrictStr] = None
    unit_weight: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Weight of a single unit in grams", alias="unitWeight")
    unit_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Public price of the product", alias="unitPrice")
    manufacturer_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Manufacturer price of the product", alias="manufacturerPrice")
    type: Optional[ProductType] = None
    secondary_type: Optional[ProductSecondaryType] = Field(default=None, alias="secondaryType")
    laboratory: Optional[LaboratoryLink] = None
    vat: Optional[Vat] = None
    narcotic_prescription: Optional[StrictBool] = Field(default=None, alias="narcoticPrescription")
    storage_type: Optional[StrictStr] = Field(default=None, alias="storageType")
    status: Optional[ProductStatus] = None
    market_status: Optional[ProductMarketStatus] = Field(default=None, alias="marketStatus")
    dispensation_place: Optional[ProductDispensationPlace] = Field(default=None, alias="dispensationPlace")
    is_otc: Optional[StrictBool] = Field(default=None, alias="isOtc")
    is_drug_in_sport: Optional[StrictBool] = Field(default=None, alias="isDrugInSport")
    images: Optional[HttpLink] = None
    created_at: Optional[datetime] = Field(default=None, description="Creation date of this product", alias="createdAt")
    statistics: Optional[Statistics] = None
    restricted: Optional[StrictBool] = Field(default=None, description="If True, can only be sold by LABORATORY. If False, it can be sold by anyone.")
    proscriptions: Optional[HttpLink] = None
    __properties: ClassVar[List[str]] = ["anyType", "id", "vidalPackage", "isAutomaticVidalSyncEnabled", "barcodes", "name", "shortName", "dci", "unitWeight", "unitPrice", "manufacturerPrice", "type", "secondaryType", "laboratory", "vat", "narcoticPrescription", "storageType", "status", "marketStatus", "dispensationPlace", "isOtc", "isDrugInSport", "images", "createdAt", "statistics", "restricted", "proscriptions"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
        "json_encoders": {
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Product from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of vidal_package
        if self.vidal_package:
            _dict['vidalPackage'] = self.vidal_package.to_dict()
        # override the default output from pydantic by calling `to_dict()` of barcodes
        if self.barcodes:
            _dict['barcodes'] = self.barcodes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_type
        if self.secondary_type:
            _dict['secondaryType'] = self.secondary_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of laboratory
        if self.laboratory:
            _dict['laboratory'] = self.laboratory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vat
        if self.vat:
            _dict['vat'] = self.vat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of images
        if self.images:
            _dict['images'] = self.images.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proscriptions
        if self.proscriptions:
            _dict['proscriptions'] = self.proscriptions.to_dict()
        # set to None if any_type (nullable) is None
        # and model_fields_set contains the field
        if self.any_type is None and "any_type" in self.model_fields_set:
            _dict['anyType'] = None

        # set to None if vidal_package (nullable) is None
        # and model_fields_set contains the field
        if self.vidal_package is None and "vidal_package" in self.model_fields_set:
            _dict['vidalPackage'] = None

        # set to None if short_name (nullable) is None
        # and model_fields_set contains the field
        if self.short_name is None and "short_name" in self.model_fields_set:
            _dict['shortName'] = None

        # set to None if dci (nullable) is None
        # and model_fields_set contains the field
        if self.dci is None and "dci" in self.model_fields_set:
            _dict['dci'] = None

        # set to None if unit_weight (nullable) is None
        # and model_fields_set contains the field
        if self.unit_weight is None and "unit_weight" in self.model_fields_set:
            _dict['unitWeight'] = None

        # set to None if unit_price (nullable) is None
        # and model_fields_set contains the field
        if self.unit_price is None and "unit_price" in self.model_fields_set:
            _dict['unitPrice'] = None

        # set to None if manufacturer_price (nullable) is None
        # and model_fields_set contains the field
        if self.manufacturer_price is None and "manufacturer_price" in self.model_fields_set:
            _dict['manufacturerPrice'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if secondary_type (nullable) is None
        # and model_fields_set contains the field
        if self.secondary_type is None and "secondary_type" in self.model_fields_set:
            _dict['secondaryType'] = None

        # set to None if laboratory (nullable) is None
        # and model_fields_set contains the field
        if self.laboratory is None and "laboratory" in self.model_fields_set:
            _dict['laboratory'] = None

        # set to None if vat (nullable) is None
        # and model_fields_set contains the field
        if self.vat is None and "vat" in self.model_fields_set:
            _dict['vat'] = None

        # set to None if narcotic_prescription (nullable) is None
        # and model_fields_set contains the field
        if self.narcotic_prescription is None and "narcotic_prescription" in self.model_fields_set:
            _dict['narcoticPrescription'] = None

        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['storageType'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if market_status (nullable) is None
        # and model_fields_set contains the field
        if self.market_status is None and "market_status" in self.model_fields_set:
            _dict['marketStatus'] = None

        # set to None if dispensation_place (nullable) is None
        # and model_fields_set contains the field
        if self.dispensation_place is None and "dispensation_place" in self.model_fields_set:
            _dict['dispensationPlace'] = None

        # set to None if is_drug_in_sport (nullable) is None
        # and model_fields_set contains the field
        if self.is_drug_in_sport is None and "is_drug_in_sport" in self.model_fields_set:
            _dict['isDrugInSport'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Product from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "anyType": obj.get("anyType"),
            "id": obj.get("id"),
            "vidalPackage": VidalPackageLink.from_dict(obj.get("vidalPackage")) if obj.get("vidalPackage") is not None else None,
            "isAutomaticVidalSyncEnabled": obj.get("isAutomaticVidalSyncEnabled"),
            "barcodes": Barcodes.from_dict(obj.get("barcodes")) if obj.get("barcodes") is not None else None,
            "name": obj.get("name"),
            "shortName": obj.get("shortName"),
            "dci": obj.get("dci"),
            "unitWeight": obj.get("unitWeight"),
            "unitPrice": obj.get("unitPrice"),
            "manufacturerPrice": obj.get("manufacturerPrice"),
            "type": ProductType.from_dict(obj.get("type")) if obj.get("type") is not None else None,
            "secondaryType": ProductSecondaryType.from_dict(obj.get("secondaryType")) if obj.get("secondaryType") is not None else None,
            "laboratory": LaboratoryLink.from_dict(obj.get("laboratory")) if obj.get("laboratory") is not None else None,
            "vat": Vat.from_dict(obj.get("vat")) if obj.get("vat") is not None else None,
            "narcoticPrescription": obj.get("narcoticPrescription"),
            "storageType": obj.get("storageType"),
            "status": obj.get("status"),
            "marketStatus": obj.get("marketStatus"),
            "dispensationPlace": obj.get("dispensationPlace"),
            "isOtc": obj.get("isOtc"),
            "isDrugInSport": obj.get("isDrugInSport"),
            "images": HttpLink.from_dict(obj.get("images")) if obj.get("images") is not None else None,
            "createdAt": obj.get("createdAt"),
            "statistics": Statistics.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "restricted": obj.get("restricted"),
            "proscriptions": HttpLink.from_dict(obj.get("proscriptions")) if obj.get("proscriptions") is not None else None
        })
        return _obj


