# coding: utf-8

"""
    lcdp-monolith-service

    This is the REST API of LCDP products

    The version of the OpenAPI document: 1.0.0
    Contact: contact@lecomptoirdespharmacies.fr
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime, timezone



from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_server.models.barcodes import Barcodes
from openapi_server.models.product_dispensation_place import ProductDispensationPlace
from openapi_server.models.product_market_status import ProductMarketStatus
from openapi_server.models.product_status import ProductStatus
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ProductCreationOrUpdateParameters(BaseModel):
    """
    ProductCreationOrUpdateParameters
    """ # noqa: E501
    vidal_package_id: Optional[StrictInt] = Field(default=None, description="Set vidal package id of product. If vidalPackageId is set:   - Product will be created/synchronized from vidal data.   - More fields can be added to override data (after sync) If vidalPackageId is not set:   - Given product is created/updated without vidal sync Restrictions :   - You should be from role 'ADMINISTRATOR' to update it. ", alias="vidalPackageId")
    is_automatic_vidal_sync_enabled: Optional[StrictBool] = Field(default=None, description="Set automatic synchronization to vidal enabled or not. Automatic does not mean periodic here. It means sync can be done without it's clearly asked (Ex: When product is selected in the front end, or when product details export is requested). Triggers (single) synchronization to vidal if set to true. Restrictions :   - You should be from role 'ADMINISTRATOR' to change its value. Otherwise,     you can just set it from true to true to trigger a (single) vidal synchronization. ", alias="isAutomaticVidalSyncEnabled")
    barcodes: Optional[Barcodes] = None
    name: Optional[StrictStr] = None
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    dci: Optional[StrictStr] = None
    unit_weight: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Weight of a single unit in grams", alias="unitWeight")
    unit_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Public price of the product", alias="unitPrice")
    manufacturer_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Manufacturer price of the product", alias="manufacturerPrice")
    type_id: Optional[StrictStr] = Field(default=None, description="Product Type Identifier", alias="typeId")
    secondary_type_id: Optional[StrictStr] = Field(default=None, description="Product Secondary Type Identifier", alias="secondaryTypeId")
    refund_rate: Optional[StrictStr] = Field(default=None, alias="refundRate")
    laboratory_id: Optional[StrictInt] = Field(default=None, description="Laboratory ID", alias="laboratoryId")
    vat_id: Optional[StrictStr] = Field(default=None, description="VAT identifier", alias="vatId")
    narcotic_prescription: Optional[StrictBool] = Field(default=None, alias="narcoticPrescription")
    storage_type: Optional[StrictStr] = Field(default=None, alias="storageType")
    market_status: Optional[ProductMarketStatus] = Field(default=None, alias="marketStatus")
    status: Optional[ProductStatus] = None
    dispensation_place: Optional[ProductDispensationPlace] = Field(default=None, alias="dispensationPlace")
    is_otc: Optional[StrictBool] = Field(default=None, alias="isOtc")
    is_drug_in_sport: Optional[StrictBool] = Field(default=None, alias="isDrugInSport")
    __properties: ClassVar[List[str]] = ["vidalPackageId", "isAutomaticVidalSyncEnabled", "barcodes", "name", "shortName", "dci", "unitWeight", "unitPrice", "manufacturerPrice", "typeId", "secondaryTypeId", "refundRate", "laboratoryId", "vatId", "narcoticPrescription", "storageType", "marketStatus", "status", "dispensationPlace", "isOtc", "isDrugInSport"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
        "json_encoders": {
            datetime: lambda dt: dt.isoformat(timespec='milliseconds')
        }
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ProductCreationOrUpdateParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of barcodes
        if self.barcodes:
            _dict['barcodes'] = self.barcodes.to_dict()
        # set to None if vidal_package_id (nullable) is None
        # and model_fields_set contains the field
        if self.vidal_package_id is None and "vidal_package_id" in self.model_fields_set:
            _dict['vidalPackageId'] = None

        # set to None if short_name (nullable) is None
        # and model_fields_set contains the field
        if self.short_name is None and "short_name" in self.model_fields_set:
            _dict['shortName'] = None

        # set to None if dci (nullable) is None
        # and model_fields_set contains the field
        if self.dci is None and "dci" in self.model_fields_set:
            _dict['dci'] = None

        # set to None if unit_weight (nullable) is None
        # and model_fields_set contains the field
        if self.unit_weight is None and "unit_weight" in self.model_fields_set:
            _dict['unitWeight'] = None

        # set to None if unit_price (nullable) is None
        # and model_fields_set contains the field
        if self.unit_price is None and "unit_price" in self.model_fields_set:
            _dict['unitPrice'] = None

        # set to None if manufacturer_price (nullable) is None
        # and model_fields_set contains the field
        if self.manufacturer_price is None and "manufacturer_price" in self.model_fields_set:
            _dict['manufacturerPrice'] = None

        # set to None if type_id (nullable) is None
        # and model_fields_set contains the field
        if self.type_id is None and "type_id" in self.model_fields_set:
            _dict['typeId'] = None

        # set to None if secondary_type_id (nullable) is None
        # and model_fields_set contains the field
        if self.secondary_type_id is None and "secondary_type_id" in self.model_fields_set:
            _dict['secondaryTypeId'] = None

        # set to None if refund_rate (nullable) is None
        # and model_fields_set contains the field
        if self.refund_rate is None and "refund_rate" in self.model_fields_set:
            _dict['refundRate'] = None

        # set to None if laboratory_id (nullable) is None
        # and model_fields_set contains the field
        if self.laboratory_id is None and "laboratory_id" in self.model_fields_set:
            _dict['laboratoryId'] = None

        # set to None if vat_id (nullable) is None
        # and model_fields_set contains the field
        if self.vat_id is None and "vat_id" in self.model_fields_set:
            _dict['vatId'] = None

        # set to None if narcotic_prescription (nullable) is None
        # and model_fields_set contains the field
        if self.narcotic_prescription is None and "narcotic_prescription" in self.model_fields_set:
            _dict['narcoticPrescription'] = None

        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['storageType'] = None

        # set to None if market_status (nullable) is None
        # and model_fields_set contains the field
        if self.market_status is None and "market_status" in self.model_fields_set:
            _dict['marketStatus'] = None

        # set to None if dispensation_place (nullable) is None
        # and model_fields_set contains the field
        if self.dispensation_place is None and "dispensation_place" in self.model_fields_set:
            _dict['dispensationPlace'] = None

        # set to None if is_drug_in_sport (nullable) is None
        # and model_fields_set contains the field
        if self.is_drug_in_sport is None and "is_drug_in_sport" in self.model_fields_set:
            _dict['isDrugInSport'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ProductCreationOrUpdateParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "vidalPackageId": obj.get("vidalPackageId"),
            "isAutomaticVidalSyncEnabled": obj.get("isAutomaticVidalSyncEnabled"),
            "barcodes": Barcodes.from_dict(obj.get("barcodes")) if obj.get("barcodes") is not None else None,
            "name": obj.get("name"),
            "shortName": obj.get("shortName"),
            "dci": obj.get("dci"),
            "unitWeight": obj.get("unitWeight"),
            "unitPrice": obj.get("unitPrice"),
            "manufacturerPrice": obj.get("manufacturerPrice"),
            "typeId": obj.get("typeId"),
            "secondaryTypeId": obj.get("secondaryTypeId"),
            "refundRate": obj.get("refundRate"),
            "laboratoryId": obj.get("laboratoryId"),
            "vatId": obj.get("vatId"),
            "narcoticPrescription": obj.get("narcoticPrescription"),
            "storageType": obj.get("storageType"),
            "marketStatus": obj.get("marketStatus"),
            "status": obj.get("status"),
            "dispensationPlace": obj.get("dispensationPlace"),
            "isOtc": obj.get("isOtc"),
            "isDrugInSport": obj.get("isDrugInSport")
        })
        return _obj


