# fasthtml


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

`fasthtml` is a library for writing fast and scalable Starlette-powered
web applications, without having to learn much (if any!) Starlette.
Instead, you just use plain python functions for each page in your app –
you don’t even need to learn Javascript. The finished app will be about
as fast as a Python web server can be (which is pretty fast –
e.g. Instagram runs on Python), and you can create pretty much anything.
This isn’t one of those stripped-down dashboard making thingies.

This is a way to write real web applications, without the fuss.

To learn how to use it, please visit the
[documentation](https://answerdotai.github.io/fasthtml/).

## Install

``` sh
pip install python-fasthtml
```

## How to use

Import `fasthtml`, and you’ll probably want the widgets from
`fastcore.xml` too.

``` python
from fasthtml import *
from fastcore.xml import *
```

Create your app.

``` python
app = FastHTML()
```

Create your routes. The syntax is largely the same as the wonderful
[FastAPI](https://fastapi.tiangolo.com/) (which is what you should be
using instead of this if you’re creating a JSON service. FastHTML is for
mainly for making HTML web apps, not APIs).

Note that you need to include the types of your parameters, so that
[`FastHTML`](https://AnswerDotAI.github.io/fasthtml/core.html#fasthtml)
knows what to pass to your function. Here, we’re just expecting a
string:

``` python
@app.get('/user/{nm}')
def get_nm(nm:str): return f"Good day to you, {nm}!"
```

Normally you’d save this into a file such as main.py, and then run it in
`uvicorn` using:

    uvicorn main:app

However, for testing, we can use Starlette’s `TestClient` to try it out:

``` python
from starlette.testclient import TestClient
```

``` python
client = TestClient(app)
r = client.get('/user/Jeremy')
r
```

    <Response [200 OK]>

TestClient uses `httpx` behind the scenes, so it returns a
`httpx.Response`, which has a `text` attribute with our response body:

``` python
r.text
```

    'Good day to you, Jeremy!'

FastHTML has special handling of tags created using `fastcore.xml`, so
you can return web pages without worrying about Jinja, templates, or any
of that stuff. This also means you can `pip install` styled rich
component libraries, since it’s all just pure python:

``` python
@app.get('/html/{idx}')
async def get_html(idx:int):
    return Body(
        H4("Wow look here"),
        P(f'It looks like you are visitor {idx}! Next is {idx+1}.')
    )
```

``` python
from IPython import display
```

``` python
display.HTML(client.get('/html/1').text)
```

<body>
  <h4>
Wow look here
  </h4>
  <p>
It looks like you are visitor 1! Next is 2.
  </p>
</body>
