"""Basic components for generating Pico CSS tags"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/api/04_pico.ipynb.

# %% auto #0
__all__ = ['picocss', 'picolink', 'picocondcss', 'picocondlink', 'set_pico_cls', 'Card', 'Group', 'Search', 'Grid', 'DialogX',
           'Container', 'PicoBusy']

# %% ../nbs/api/04_pico.ipynb #8e2d405b
from typing import Any

from fastcore.utils import *
from fastcore.xml import *
from fastcore.meta import use_kwargs, delegates
from .components import *
from .xtend import *

try: from IPython import display
except ImportError: display=None

# %% ../nbs/api/04_pico.ipynb #100414ae
picocss = "https://cdn.jsdelivr.net/npm/@picocss/pico@latest/css/pico.min.css"
picolink = (Link(rel="stylesheet", href=picocss),
            Style(":root { --pico-font-size: 100%; }"))
picocondcss = "https://cdn.jsdelivr.net/npm/@picocss/pico@latest/css/pico.conditional.min.css"
picocondlink = (Link(rel="stylesheet", href=picocondcss),
                Style(":root { --pico-font-size: 100%; }"))

# %% ../nbs/api/04_pico.ipynb #36d26fb7
def set_pico_cls():
    js = """var sel = '.cell-output, .output_area';
document.querySelectorAll(sel).forEach(e => e.classList.add('pico'));

new MutationObserver(ms => {
  ms.forEach(m => {
    m.addedNodes.forEach(n => {
      if (n.nodeType === 1) {
        var nc = n.classList;
        if (nc && (nc.contains('cell-output') || nc.contains('output_area'))) nc.add('pico');
        n.querySelectorAll(sel).forEach(e => e.classList.add('pico'));
      }
    });
  });
}).observe(document.body, { childList: true, subtree: true });"""
    return display.Javascript(js)

# %% ../nbs/api/04_pico.ipynb #ad99a758
@delegates(ft_hx, keep=True)
def Card(*c, header=None, footer=None, **kwargs)->FT:
    "A PicoCSS Card, implemented as an Article with optional Header and Footer"
    if header: c = (Header(header),) + c
    if footer: c += (Footer(footer),)
    return Article(*c, **kwargs)

# %% ../nbs/api/04_pico.ipynb #6108b84c
@delegates(ft_hx, keep=True)
def Group(*c, **kwargs)->FT:
    "A PicoCSS Group, implemented as a Fieldset with role 'group'"
    return Fieldset(*c, role="group", **kwargs)

# %% ../nbs/api/04_pico.ipynb #e12b6a7c
@delegates(ft_hx, keep=True)
def Search(*c, **kwargs)->FT:
    "A PicoCSS Search, implemented as a Form with role 'search'"
    return Form(*c, role="search", **kwargs)

# %% ../nbs/api/04_pico.ipynb #24c4843f
@delegates(ft_hx, keep=True)
def Grid(*c, cls='grid', **kwargs)->FT:
    "A PicoCSS Grid, implemented as child Divs in a Div with class 'grid'"
    c = tuple(o if isinstance(o,list) else Div(o) for o in c)
    return ft_hx('div', *c, cls=cls, **kwargs)

# %% ../nbs/api/04_pico.ipynb #252a9f5f
@delegates(ft_hx, keep=True)
def DialogX(*c, open=None, header=None, footer=None, id=None, **kwargs)->FT:
    "A PicoCSS Dialog, with children inside a Card"
    card = Card(*c, header=header, footer=footer, **kwargs)
    return Dialog(card, open=open, id=id)

# %% ../nbs/api/04_pico.ipynb #d6e96966
@delegates(ft_hx, keep=True)
def Container(*args, **kwargs)->FT:
    "A PicoCSS Container, implemented as a Main with class 'container'"
    return Main(*args, cls="container", **kwargs)

# %% ../nbs/api/04_pico.ipynb #138dc298
def PicoBusy():
    return (HtmxOn('beforeRequest', "event.detail.elt.setAttribute('aria-busy', 'true' )"),
            HtmxOn('afterRequest',  "event.detail.elt.setAttribute('aria-busy', 'false')"))
