# FastHTML


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

Welcome to the official FastHTML documentation.

FastHTML is a new next-generation web framework for fast, scalable web
applications with minimal, compact code. It’s designed to be:

- Powerful and expressive enough to build the most advanced, interactive
  web apps you can imagine.
- Fast and lightweight, so you can write less code and get more done.
- Easy to learn and use, with a simple, intuitive syntax that makes it
  easy to build complex apps quickly.

FastHTML apps are just Python code, so you can use FastHTML with the
full power of the Python language and ecosystem. FastHTML’s
functionality maps 1:1 directly to HTML and HTTP, but allows them to be
encapsulated using good software engineering practices—so you’ll need to
understand these foundations to use this library fully. To understand
how and why this works, please read this first:
[fastht.ml/about](https://fastht.ml/about).

## Installation

Since `fasthtml` is a Python library, you can install it with:

``` sh
pip install python-fasthtml
```

In the near future, we hope to add component libraries that can likewise
be installed via `pip`.

## Usage

For a minimal app, create a file “main.py” as follows:

<div class="code-with-filename">

**main.py**

``` python
from fasthtml.common import *

app,rt = fast_app()

@rt('/')
def get(): return Div(P('Hello World!'), hx_get="/change")

serve()
```

</div>

Running the app with `python main.py` prints out a link to your running
app: `http://localhost:5001`. Visit that link in your browser and you
should see a page with the text “Hello World!”. Congratulations, you’ve
just created your first FastHTML app!

Adding interactivity is surprisingly easy, thanks to HTMX. Modify the
file to add this function:

<div class="code-with-filename">

**main.py**

``` python
@rt('/change')
def get(): return P('Nice to be here!')
```

</div>

You now have a page with a clickable element that changes the text when
clicked. When clicking on this link, the server will respond with an
“HTML partial”—that is, just a snippet of HTML which will be inserted
into the existing page. In this case, the returned element will replace
the original P element (since that’s the default behavior of HTMX) with
the new version returned by the second route.

This “hypermedia-based” approach to web development is a powerful way to
build web applications.

### Getting help from AI

Because FastHTML is newer than most LLMs, AI systems like Cursor,
ChatGPT, Claude, and Copilot won’t give useful answers about it. To fix
that problem, we’ve provided an LLM-friendly guide that teaches them how
to use FastHTML. To use it, add this link for your AI helper to use:

- [/llms-ctx.txt](https://answerdotai.github.io/fasthtml/llms-ctx.txt)

This example is in a format based on recommendations from Anthropic for
use with [Claude
Projects](https://support.anthropic.com/en/articles/9517075-what-are-projects).
This works so well that we’ve actually found that Claude can provide
even better information than our own documentation! For instance, read
through [this annotated Claude
chat](https://gist.github.com/jph00/9559b0a563f6a370029bec1d1cc97b74)
for some great getting-started information, entirely generated from a
project using the above text file as context.

If you use Cursor, type `@doc` then choose “*Add new doc*”, and use the
/llms-ctx.txt link above. The context file is auto-generated from our
[`llms.txt`](https://llmstxt.org/) (our proposed standard for providing
AI-friendly information)—you can generate alternative versions suitable
for other models as needed.

## Next Steps

Start with the official sources to learn more about FastHTML:

- [About](https://fastht.ml/about): Learn about the core ideas behind
  FastHTML
- [Documentation](https://answerdotai.github.io/fasthtml): Learn from examples how to
  write FastHTML code
- [Idiomatic
  app](https://github.com/AnswerDotAI/fasthtml/blob/main/examples/adv_app.py):
  Heavily commented source code walking through a complete application,
  including custom authentication, JS library connections, and database
  use.

We also have a 1-hour intro video:

<https://www.youtube.com/embed/Auqrm7WFc0I>

The capabilities of FastHTML are vast and growing, and not all the
features and patterns have been documented yet. Be prepared to invest
time into studying and modifying source code, such as the main FastHTML
repo’s notebooks and the official FastHTML examples repo:

- [FastHTML Examples Repo on
  GitHub](https://github.com/AnswerDotAI/fasthtml-example)
- [FastHTML Repo on GitHub](https://github.com/AnswerDotAI/fasthtml)

Then explore the small but growing third-party ecosystem of FastHTML
tutorials, notebooks, libraries, and components:

- [FastHTML Gallery](https://fastht.ml/gallery): Learn from minimal
  examples of components (ie chat bubbles, click-to-edit, infinite
  scroll, etc)
- [Creating Custom FastHTML Tags for Markdown
  Rendering](https://isaac-flath.github.io/website/posts/boots/FasthtmlTutorial.html)
  by Isaac Flath
- [How to Build a Simple Login System in
  FastHTML](https://blog.mariusvach.com/posts/login-fasthtml) by Marius
  Vach
- Your tutorial here!

Finally, join the FastHTML community to ask questions, share your work,
and learn from others:

- [Discord](https://discord.gg/qcXvcxMhdP)

## Other languages and related projects

If you’re not a Python user, or are keen to try out a new language,
we’ll list here other projects that have a similar approach to FastHTML.
(Please reach out if you know of any other projects that you’d like to
see added.)

- [htmgo](https://htmgo.dev/) (Go): “*htmgo is a lightweight pure go way
  to build interactive websites / web applications using go & htmx. By
  combining the speed & simplicity of go + hypermedia attributes (htmx)
  to add interactivity to websites, all conveniently wrapped in pure go,
  you can build simple, fast, interactive websites without touching
  javascript. All compiled to a single deployable binary*”

If you’re just interested in functional HTML components, rather than a
full HTMX server solution, consider:

- [fastcore.xml.FT](https://fastcore.fast.ai/xml.html): This is actually
  what FastHTML uses behind the scenes
- [htpy](https://htpy.dev/): Similar to
  [`fastcore.xml.FT`](https://fastcore.fast.ai/xml.html#ft), but with a
  somewhat different syntax
- [elm-html](https://package.elm-lang.org/packages/elm/html/latest/):
  Elm’s built-in HTML library with a type-safe functional approach
- [hiccup](https://github.com/weavejester/hiccup): Popular library for
  representing HTML in Clojure using vectors
- [hiccl](https://github.com/garlic0x1/hiccl): HTML generation library
  for Common Lisp inspired by Clojure’s Hiccup
- [Falco.Markup](https://github.com/pimbrouwers/Falco): F# HTML DSL and
  web framework with type-safe HTML generation
- [Lucid](https://github.com/chrisdone/lucid): Type-safe HTML generation
  for Haskell using monad transformers
- [dream-html](https://github.com/aantron/dream): Part of the Dream web
  framework for OCaml, provides type-safe HTML templating

For other hypermedia application platforms, not based on HTMX, take a
look at:

- [Hotwire/Turbo](https://turbo.hotwired.dev/): Rails-oriented framework
  that similarly uses HTML-over-the-wire
- [LiveView](https://hexdocs.pm/phoenix_live_view/Phoenix.LiveView.html):
  Phoenix framework’s solution for building interactive web apps with
  minimal JavaScript
- [Unpoly](https://unpoly.com/): Another HTML-over-the-wire framework
  with progressive enhancement
- [Livewire](https://laravel-livewire.com/): Laravel’s take on building
  dynamic interfaces with minimal JavaScript
