from flint._flint cimport mp_bitcnt_t, flint_rand_t, ulong
from flint.flintlib.fmpz cimport fmpz_struct, fmpz_t
from flint.flintlib.fmpz_poly cimport fmpz_poly_t
from flint.flintlib.fmpq cimport fmpq_t

cdef extern from "flint/fmpq_poly.h":
    ctypedef struct fmpq_poly_struct:
        fmpz_struct * coeffs
        long alloc
        long length
        fmpz_t den
    ctypedef fmpq_poly_struct fmpq_poly_t[1]
    void fmpq_poly_init(fmpq_poly_t poly)
    void fmpq_poly_init2(fmpq_poly_t poly, long alloc)
    void fmpq_poly_realloc(fmpq_poly_t poly, long alloc)
    void fmpq_poly_fit_length(fmpq_poly_t poly, long len)
    void fmpq_poly_clear(fmpq_poly_t poly)
    void _fmpq_poly_normalise(fmpq_poly_t poly)
    void fmpq_poly_canonicalise(fmpq_poly_t poly)
    int fmpq_poly_is_canonical(fmpq_poly_t poly)
    fmpz_struct * fmpq_poly_numref(fmpq_poly_t poly)
    fmpz_struct * fmpq_poly_denref(fmpq_poly_t poly)
    void fmpq_poly_get_numerator(fmpz_poly_t res, fmpq_poly_t poly)
    long fmpq_poly_degree(fmpq_poly_t poly)
    long fmpq_poly_length(fmpq_poly_t poly)
    void fmpq_poly_randtest(fmpq_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits_in)
    void fmpq_poly_randtest_unsigned(fmpq_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits_in)
    void fmpq_poly_randtest_not_zero(fmpq_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits_in)
    void fmpq_poly_set(fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_set_si(fmpq_poly_t poly, long x)
    void fmpq_poly_set_ui(fmpq_poly_t poly, ulong x)
    void fmpq_poly_set_fmpz(fmpq_poly_t poly, fmpz_t x)
    void fmpq_poly_set_fmpq(fmpq_poly_t poly, fmpq_t x)
    #void fmpq_poly_set_mpz(fmpq_poly_t poly, mpz_t x)
    #void fmpq_poly_set_mpq(fmpq_poly_t poly, mpq_t x)
    void fmpq_poly_set_fmpz_poly(fmpq_poly_t rop, fmpz_poly_t op)
    #void _fmpq_poly_set_array_mpq(fmpz_struct * poly, fmpz_t den, mpq_t * a, long n)
    #void fmpq_poly_set_array_mpq(fmpq_poly_t poly, mpq_t * a, long n)
    int fmpq_poly_set_str(fmpq_poly_t poly, char * str)
    char * fmpq_poly_get_str(fmpq_poly_t poly)
    char * fmpq_poly_get_str_pretty(fmpq_poly_t poly, char * var)
    void fmpq_poly_zero(fmpq_poly_t poly)
    void fmpq_poly_one(fmpq_poly_t poly)
    void fmpq_poly_neg(fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_inv(fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_swap(fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_truncate(fmpq_poly_t poly, long n)
    void fmpq_poly_get_coeff_fmpq(fmpq_t x, fmpq_poly_t poly, long n)
    void fmpq_poly_set_coeff_si(fmpq_poly_t poly, long n, long x)
    void fmpq_poly_set_coeff_ui(fmpq_poly_t poly, long n, ulong x)
    void fmpq_poly_set_coeff_fmpz(fmpq_poly_t poly, long n, fmpz_t x)
    void fmpq_poly_set_coeff_fmpq(fmpq_poly_t poly, long n, fmpq_t x)
    #void fmpq_poly_set_coeff_mpz(fmpq_poly_t poly, long n, mpz_t x)
    #void fmpq_poly_set_coeff_mpq(fmpq_poly_t poly, long n, mpq_t x)
    int fmpq_poly_equal(fmpq_poly_t poly1, fmpq_poly_t poly2)
    int fmpq_poly_cmp(fmpq_poly_t left, fmpq_poly_t right)
    int fmpq_poly_is_zero(fmpq_poly_t poly)
    int fmpq_poly_is_one(fmpq_poly_t poly)
    void fmpq_poly_add(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_sub(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_scalar_mul_si(fmpq_poly_t rop, fmpq_poly_t op, long c)
    void fmpq_poly_scalar_mul_ui(fmpq_poly_t rop, fmpq_poly_t op, ulong c)
    void fmpq_poly_scalar_mul_fmpz(fmpq_poly_t rop, fmpq_poly_t op, fmpz_t c)
    #void fmpq_poly_scalar_mul_mpz(fmpq_poly_t rop, fmpq_poly_t op, mpz_t c)
    void fmpq_poly_scalar_mul_fmpq(fmpq_poly_t rop, fmpq_poly_t op, fmpq_t c)
    void fmpq_poly_scalar_div_si(fmpq_poly_t rop, fmpq_poly_t op, long c)
    void fmpq_poly_scalar_div_ui(fmpq_poly_t rop, fmpq_poly_t op, ulong c)
    void fmpq_poly_scalar_div_fmpz(fmpq_poly_t rop, fmpq_poly_t op, fmpz_t c)
    #void fmpq_poly_scalar_div_mpz(fmpq_poly_t rop, fmpq_poly_t op, mpz_t c)
    void fmpq_poly_scalar_div_fmpq(fmpq_poly_t rop, fmpq_poly_t op, fmpq_t c)
    void fmpq_poly_mul(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_mullow(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2, long n)
    void fmpq_poly_addmul(fmpq_poly_t rop, fmpq_poly_t op1, fmpq_poly_t op2)
    void fmpq_poly_submul(fmpq_poly_t rop, fmpq_poly_t op1, fmpq_poly_t op2)
    void fmpq_poly_pow(fmpq_poly_t rpoly, fmpq_poly_t poly, ulong e)
    void fmpq_poly_shift_left(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_shift_right(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_divrem(fmpq_poly_t Q, fmpq_poly_t R, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_div(fmpq_poly_t Q, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_gcd(fmpq_poly_t g, fmpq_poly_t a, fmpq_poly_t b)
    void fmpq_poly_xgcd(fmpq_poly_t G, fmpq_poly_t S, fmpq_poly_t T, const fmpq_poly_t A, const fmpq_poly_t B)
    void fmpq_poly_rem(fmpq_poly_t R, fmpq_poly_t poly1, fmpq_poly_t poly2)
    void fmpq_poly_inv_series(fmpq_poly_t Qinv, fmpq_poly_t Q, long n)
    void fmpq_poly_div_series(fmpq_poly_t Q, fmpq_poly_t A, fmpq_poly_t B, long n)
    void fmpq_poly_derivative(fmpq_poly_t res, fmpq_poly_t poly)
    void fmpq_poly_integral(fmpq_poly_t res, fmpq_poly_t poly)
    void fmpq_poly_invsqrt_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_sqrt_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_log_series(fmpq_poly_t res, fmpq_poly_t f, long n)
    void fmpq_poly_exp_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_atan_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_atanh_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_asin_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_asinh_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_tan_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_sin_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_cos_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_sinh_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_cosh_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_tanh_series(fmpq_poly_t res, fmpq_poly_t poly, long n)
    void fmpq_poly_evaluate_fmpz(fmpq_t res, fmpq_poly_t poly, fmpz_t a)
    void fmpq_poly_evaluate_fmpq(fmpq_t res, fmpq_poly_t poly, fmpq_t a)
    # void fmpq_poly_evaluate_mpq(mpq_t res, fmpq_poly_t poly, mpq_t a)
    void fmpq_poly_interpolate_fmpz_vec(fmpq_poly_t poly, fmpz_struct * xs, fmpz_struct * ys, long n)
    void fmpq_poly_compose(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2)
    #void fmpq_poly_rescale(fmpq_poly_t res, fmpq_poly_t poly, mpq_t x)
    #void fmpq_poly_content(mpq_t res, fmpq_poly_t poly)
    void fmpq_poly_primitive_part(fmpq_poly_t res, fmpq_poly_t poly)
    int fmpq_poly_is_monic(fmpq_poly_t poly)
    void fmpq_poly_make_monic(fmpq_poly_t res, fmpq_poly_t poly)
    int fmpq_poly_is_squarefree(fmpq_poly_t poly)
    int fmpq_poly_debug(fmpq_poly_t poly)
    #int fmpq_poly_fprint(FILE * file, fmpq_poly_t poly)
    int fmpq_poly_print(fmpq_poly_t poly)
    int fmpq_poly_print_pretty(fmpq_poly_t poly, char * var)
    #int fmpq_poly_fread(FILE * file, fmpq_poly_t poly)
    int fmpq_poly_read(fmpq_poly_t poly)
    void fmpq_poly_compose_series(fmpq_poly_t res, fmpq_poly_t poly1, fmpq_poly_t poly2, long n)
    void fmpq_poly_revert_series(fmpq_poly_t res, fmpq_poly_t poly1, long n)
