from flint._flint cimport fmpz_struct, ulong, mp_limb_t
from flint._flint cimport mp_size_t, mp_bitcnt_t

cdef extern from "flint/fmpz.h":
    ctypedef fmpz_struct fmpz_t[1]
    int COEFF_IS_MPZ(fmpz_struct v)
    void fmpz_init(fmpz_t op)
    void fmpz_clear(fmpz_t op)
    long fmpz_get_si(fmpz_t f)
    ulong fmpz_get_ui(fmpz_t f)
    void fmpz_set_si(fmpz_t f, long val)
    void fmpz_set_ui(fmpz_t f, ulong val)
    #void fmpz_get_mpz(mpz_t x,  fmpz_t f)
    #void fmpz_set_mpz(fmpz_t f,  mpz_t x)
    int fmpz_set_str(fmpz_t f, char * str, int b)
    int fmpz_abs_fits_ui( fmpz_t f)
    void fmpz_zero(fmpz_t f)
    void fmpz_one(fmpz_t f)
    int fmpz_is_zero(fmpz_t f)
    int fmpz_is_one( fmpz_t f)
    int fmpz_is_pm1( fmpz_t f)
    void fmpz_set(fmpz_t f,  fmpz_t g)
    int fmpz_equal(fmpz_t f,  fmpz_t g)
    int fmpz_read(fmpz_t f)
    int fmpz_print(fmpz_t x)
    size_t fmpz_sizeinbase( fmpz_t f, int b)
    char * fmpz_get_str(char * str, int b,  fmpz_t f)
    void fmpz_swap(fmpz_t f, fmpz_t g)
    int fmpz_cmp( fmpz_t f,  fmpz_t g)
    int fmpz_cmp_ui( fmpz_t f, ulong g)
    int fmpz_cmp_si( fmpz_t f, long g)
    int fmpz_cmpabs( fmpz_t f,  fmpz_t g)
    int fmpz_equal_si(const fmpz_t f, long g)
    int fmpz_is_even(fmpz_t f)
    int fmpz_is_odd(fmpz_t f)
    mp_size_t fmpz_size(fmpz_t f)
    int fmpz_sgn(fmpz_t f)
    mp_bitcnt_t fmpz_bits(fmpz_t f)
    void fmpz_neg(fmpz_t f1, fmpz_t f2)
    void fmpz_abs(fmpz_t f1,  fmpz_t f2)
    void fmpz_add(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_sub(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_mul_ui(fmpz_t f,  fmpz_t g, ulong x)
    void fmpz_mul_si(fmpz_t f,  fmpz_t g, long x)
    void fmpz_mul(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_mul_2exp(fmpz_t f,  fmpz_t g, ulong exp)
    void fmpz_add_ui(fmpz_t f,  fmpz_t g, ulong x)
    void fmpz_sub_ui(fmpz_t f,  fmpz_t g, ulong x)
    void fmpz_addmul_ui(fmpz_t f,  fmpz_t g, ulong x)
    void fmpz_submul_ui(fmpz_t f,  fmpz_t g, ulong x)
    void fmpz_addmul(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_submul(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_pow_ui(fmpz_t f,  fmpz_t g, ulong exp)
    void fmpz_powm_ui(fmpz_t f,  fmpz_t g, ulong exp,  fmpz_t m)
    void fmpz_powm(fmpz_t f,  fmpz_t g,  fmpz_t e,  fmpz_t m)
    int fmpz_pow_fmpz(fmpz_t f, const fmpz_t g, const fmpz_t x)
    int fmpz_sqrtmod(fmpz_t b,  fmpz_t a,  fmpz_t p)
    void fmpz_sqrt(fmpz_t f,  fmpz_t g)
    void fmpz_sqrtrem(fmpz_t f, fmpz_t r,  fmpz_t g)
    void fmpz_root(fmpz_t r, const fmpz_t f, long n)
    ulong fmpz_fdiv_ui(fmpz_t g, ulong h)
    ulong fmpz_mod_ui(fmpz_t f,  fmpz_t g, ulong h)
    void fmpz_mod(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_gcd(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_lcm(fmpz_t f,  fmpz_t g,  fmpz_t h)
    int fmpz_invmod(fmpz_t f,  fmpz_t g,  fmpz_t h)
    long fmpz_remove(fmpz_t rop,  fmpz_t op,  fmpz_t f)
    void fmpz_divexact(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_divexact_si(fmpz_t f,  fmpz_t g, long h)
    void fmpz_divexact_ui(fmpz_t f,  fmpz_t g, ulong h)
    void fmpz_cdiv_q(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_cdiv_q_si(fmpz_t f,  fmpz_t g, long h)
    void fmpz_cdiv_q_ui(fmpz_t f,  fmpz_t g, ulong h)
    void fmpz_fdiv_qr(fmpz_t f, fmpz_t s,  fmpz_t g,  fmpz_t h)
    void fmpz_fdiv_q(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_fdiv_r(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_fdiv_q_ui(fmpz_t f,  fmpz_t g, ulong h)
    void fmpz_fdiv_q_si(fmpz_t f,  fmpz_t g, long h)
    void fmpz_fdiv_q_2exp(fmpz_t f,  fmpz_t g, ulong exp)
    void fmpz_tdiv_q(fmpz_t f,  fmpz_t g,  fmpz_t h)
    void fmpz_tdiv_q_ui(fmpz_t f,  fmpz_t g, ulong h)
    void fmpz_tdiv_q_si(fmpz_t f,  fmpz_t g, long h)
    double fmpz_get_d_2exp(long * exp,  fmpz_t f)
    void fmpz_mul2_uiui(fmpz_t f,  fmpz_t g, ulong h1, ulong h2)
    void fmpz_divexact2_uiui(fmpz_t f,  fmpz_t g, ulong h1, ulong h2)
    void fmpz_fac_ui(fmpz_t f, ulong n)
    void fmpz_bin_uiui(fmpz_t res, ulong n, ulong k)
    void fmpz_CRT_ui(fmpz_t out,  fmpz_t r1,  fmpz_t m1, ulong r2, ulong m2)
    void fmpz_CRT_ui_unsigned(fmpz_t out,  fmpz_t r1,  fmpz_t m1, ulong r2, ulong m2)
    void fmpz_set_ui_mod(fmpz_t f, mp_limb_t x, mp_limb_t m)
    int fmpz_moebius_mu(const fmpz_t f)
    void fmpz_fib_ui(fmpz_t f, ulong n)
    void fmpz_rfac_ui(fmpz_t r, const fmpz_t x, ulong n)
    void fmpz_rfac_uiui(fmpz_t r, ulong x, ulong n)
    void fmpz_primorial(fmpz_t res, ulong n)
    int fmpz_is_perfect_power(fmpz_t root, const fmpz_t f)
    int fmpz_jacobi(const fmpz_t a, const fmpz_t p)
    int fmpz_is_prime(const fmpz_t n)
    int fmpz_is_probabprime(const fmpz_t n)
    void fmpz_complement(fmpz_t r, const fmpz_t f)
    void fmpz_and(fmpz_t r, const fmpz_t a, const fmpz_t b)
    void fmpz_or(fmpz_t r, const fmpz_t a, const fmpz_t b)
    void fmpz_xor(fmpz_t r, const fmpz_t a, const fmpz_t b)
