from flint._flint cimport ulong, mp_limb_t
from flint.flintlib.fmpz cimport fmpz_struct,fmpz_t
from flint.flintlib.nmod_poly cimport nmod_poly_t

cdef extern from "flint/fmpz_poly.h":
    ctypedef struct fmpz_poly_struct:
        fmpz_struct * coeffs
        long alloc
        long length
    ctypedef fmpz_poly_struct fmpz_poly_t[1]

    ctypedef struct fmpz_poly_factor_struct:
        fmpz_struct c
        fmpz_poly_struct *p
        long *exp
        long num
        long alloc
    ctypedef fmpz_poly_factor_struct fmpz_poly_factor_t[1]

    void fmpz_poly_init(fmpz_poly_t poly)
    void fmpz_poly_init2(fmpz_poly_t poly, long alloc)
    void fmpz_poly_realloc(fmpz_poly_t poly, long alloc)
    void fmpz_poly_fit_length(fmpz_poly_t poly, long len)
    void fmpz_poly_clear(fmpz_poly_t poly)
    void _fmpz_poly_normalise(fmpz_poly_t poly)
    void _fmpz_poly_set_length(fmpz_poly_t poly, long newlen)
    long fmpz_poly_length(fmpz_poly_t poly)
    long fmpz_poly_degree(fmpz_poly_t poly)
    ulong fmpz_poly_max_limbs(fmpz_poly_t poly)
    long fmpz_poly_max_bits(fmpz_poly_t poly)
    void fmpz_poly_set(fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_set_ui(fmpz_poly_t poly, ulong c)
    void fmpz_poly_set_si(fmpz_poly_t poly, long c)
    void fmpz_poly_set_fmpz(fmpz_poly_t poly, fmpz_t c)
    #void fmpz_poly_set_mpz(fmpz_poly_t poly, mpz_t c)
    int fmpz_poly_set_str(fmpz_poly_t poly, char * str)
    char * fmpz_poly_get_str(fmpz_poly_t poly)
    char * fmpz_poly_get_str_pretty(fmpz_poly_t poly, char * x)
    fmpz_struct * fmpz_poly_get_coeff_ptr(fmpz_poly_t poly, long n)
    void fmpz_poly_zero(fmpz_poly_t poly)
    void fmpz_poly_one(fmpz_poly_t poly)
    void fmpz_poly_zero_coeffs(fmpz_poly_t poly, long i, long j)
    void fmpz_poly_swap(fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_reverse(fmpz_poly_t res, fmpz_poly_t poly, long n)
    void fmpz_poly_truncate(fmpz_poly_t poly, long newlen)
    #void fmpz_poly_randtest(fmpz_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits)
    #void fmpz_poly_randtest_unsigned(fmpz_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits)
    #void fmpz_poly_randtest_not_zero(fmpz_poly_t f, flint_rand_t state, long len, mp_bitcnt_t bits)
    long fmpz_poly_get_coeff_si(fmpz_poly_t poly, long n)
    void fmpz_poly_set_coeff_si(fmpz_poly_t poly, long n, long x)
    ulong fmpz_poly_get_coeff_ui(fmpz_poly_t poly, long n)
    void fmpz_poly_set_coeff_ui(fmpz_poly_t poly, long n, ulong x)
    void fmpz_poly_set_coeff_fmpz(fmpz_poly_t poly, long n, fmpz_t x)
    void fmpz_poly_get_coeff_fmpz(fmpz_t x, fmpz_poly_t poly, long n)
    int fmpz_poly_equal(fmpz_poly_t poly1, fmpz_poly_t poly2)
    int fmpz_poly_is_zero(fmpz_poly_t poly)
    int fmpz_poly_is_one(fmpz_poly_t op)
    int fmpz_poly_is_unit(fmpz_poly_t op)
    void fmpz_poly_add(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_sub(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_neg(fmpz_poly_t res, fmpz_poly_t poly)
    void fmpz_poly_scalar_mul_ui(fmpz_poly_t poly1, fmpz_poly_t poly2, ulong x)
    void fmpz_poly_scalar_mul_si(fmpz_poly_t poly1, fmpz_poly_t poly2, long x)
    void fmpz_poly_scalar_mul_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_scalar_addmul_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_scalar_submul_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_scalar_fdiv_ui(fmpz_poly_t poly1, fmpz_poly_t poly2, ulong x)
    void fmpz_poly_scalar_fdiv_si(fmpz_poly_t poly1, fmpz_poly_t poly2, long x)
    void fmpz_poly_scalar_fdiv_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_scalar_tdiv_ui(fmpz_poly_t poly1, fmpz_poly_t poly2, ulong x)
    void fmpz_poly_scalar_tdiv_si(fmpz_poly_t poly1, fmpz_poly_t poly2, long x)
    void fmpz_poly_scalar_tdiv_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_scalar_divexact_ui(fmpz_poly_t poly1, fmpz_poly_t poly2, ulong x)
    void fmpz_poly_scalar_divexact_si(fmpz_poly_t poly1, fmpz_poly_t poly2, long x)
    void fmpz_poly_scalar_divexact_fmpz(fmpz_poly_t poly1, fmpz_poly_t poly2, fmpz_t x)
    void fmpz_poly_mul(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_mullow(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2, long n)
    void fmpz_poly_mulhigh_n(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2, long n)
    void fmpz_poly_pow(fmpz_poly_t res, fmpz_poly_t poly, ulong e)
    void fmpz_poly_pow_trunc(fmpz_poly_t res, fmpz_poly_t poly, ulong e, long n)
    void fmpz_poly_shift_left(fmpz_poly_t res, fmpz_poly_t poly, long n)
    void fmpz_poly_shift_right(fmpz_poly_t res, fmpz_poly_t poly, long n)
    void fmpz_poly_2norm(fmpz_t res, fmpz_poly_t poly)
    void fmpz_poly_gcd(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_xgcd(fmpz_t r, fmpz_poly_t s, fmpz_poly_t t, fmpz_poly_t poly1, fmpz_poly_t poly2)
    void fmpz_poly_content(fmpz_t res, fmpz_poly_t poly)
    void fmpz_poly_primitive_part(fmpz_poly_t res, fmpz_poly_t poly)
    void fmpz_poly_divrem(fmpz_poly_t Q, fmpz_poly_t R, fmpz_poly_t A, fmpz_poly_t B)
    void fmpz_poly_div(fmpz_poly_t Q, fmpz_poly_t A, fmpz_poly_t B)
    void fmpz_poly_rem(fmpz_poly_t R, fmpz_poly_t A, fmpz_poly_t B)
    fmpz_poly_inv_series(fmpz_poly_t Qinv, fmpz_poly_t Q, long n)
    void fmpz_poly_div_series(fmpz_poly_t Q, fmpz_poly_t A, fmpz_poly_t B, long n)
    int fmpz_poly_divides(fmpz_poly_t q, fmpz_poly_t a, fmpz_poly_t b)
    void fmpz_poly_derivative(fmpz_poly_t res, fmpz_poly_t poly)
    void fmpz_poly_evaluate_fmpz(fmpz_t res, fmpz_poly_t f, fmpz_t a)
    #void fmpz_poly_evaluate_mpq(mpq_t res, fmpz_poly_t f, mpq_t a)
    mp_limb_t fmpz_poly_evaluate_mod(fmpz_poly_t poly, mp_limb_t a, mp_limb_t n)
    void fmpz_poly_compose(fmpz_poly_t res, fmpz_poly_t poly1, fmpz_poly_t poly2)

    void fmpz_poly_compose_series(fmpz_poly_t res, const fmpz_poly_t poly1, const fmpz_poly_t poly2, long n)
    void fmpz_poly_revert_series(fmpz_poly_t Qinv, const fmpz_poly_t Q, long n)

    void fmpz_poly_signature(long * r1, long * r2, fmpz_poly_t poly)
    int fmpz_poly_print(fmpz_poly_t poly)
    int fmpz_poly_print_pretty(fmpz_poly_t poly, char * x)
    void fmpz_poly_evaluate_fmpz_vec(fmpz_struct * res, fmpz_poly_t f, fmpz_struct * a, long n)
    void fmpz_poly_interpolate_fmpz_vec(fmpz_poly_t poly, fmpz_struct * xs, fmpz_struct * ys, long n)
    void fmpz_poly_get_nmod_poly(nmod_poly_t res, fmpz_poly_t poly)
    void fmpz_poly_set_nmod_poly(fmpz_poly_t res, nmod_poly_t poly)
    void fmpz_poly_set_nmod_poly_unsigned(fmpz_poly_t res, nmod_poly_t poly)
    void fmpz_poly_cyclotomic(fmpz_poly_t, ulong)
    void fmpz_poly_cos_minpoly(fmpz_poly_t, ulong)
    void fmpz_poly_swinnerton_dyer(fmpz_poly_t, ulong)
    int fmpz_poly_sqrt(fmpz_poly_t b, const fmpz_poly_t a)
