#!/usr/bin/env bash

set -e

if [ $# -eq 0 ]
  then
    echo "Usage: bin/all_rst_to_pxd.sh /path/to/flint/doc/source"
    exit 1
fi

FLINT_DOC_DIR=$1

modules=(
    # "flint"
    "mpoly"
    # "thread_pool"
    # "machine_vectors"
    "gr"
    "gr_domains"
    "gr_generic"
    "gr_implementing"
    "gr_mat"
    "gr_mpoly"
    "gr_poly"
    "gr_special"
    "gr_vec"
    "ulong_extras"
    "fmpz"
    # "fmpz_extras"
    "fmpz_factor"
    "fmpz_lll"
    "fmpz_mat"
    "fmpz_mpoly"
    "fmpz_mpoly_factor"
    "fmpz_mpoly_q"
    "fmpz_poly"
    "fmpz_poly_factor"
    # "fmpz_poly_mat"
    # "fmpz_poly_q"
    "fmpz_vec"
    # "long_extras"
    # "longlong"
    # "mpn_extras"
    # "aprcl"
    "arith"
    # "fft"
    # "fft_small"
    # "qsieve"
    "fmpq"
    "fmpq_mat"
    "fmpq_mpoly"
    "fmpq_mpoly_factor"
    "fmpq_poly"
    "fmpq_vec"
    "nmod"
    "nmod_mat"
    "nmod_mpoly"
    "nmod_mpoly_factor"
    "nmod_poly"
    "nmod_poly_factor"
    # "nmod_poly_mat"
    "nmod_vec"
    # "mpn_mod"
    "fmpz_mod"
    "fmpz_mod_mat"
    "fmpz_mod_mpoly"
    "fmpz_mod_mpoly_factor"
    "fmpz_mod_poly"
    "fmpz_mod_poly_factor"
    "fmpz_mod_vec"
    "dirichlet"
    # "dlog"
    # "bool_mat"
    # "perm"
    # "qfb"
    # "nf"
    # "nf_elem"
    # "fmpzi"
    # "qqbar"
    "mag"
    # "nfloat"
    "arf"
    # "acf"
    "arb"
    # "arb_calc"
    "arb_fmpz_poly"
    # "arb_fpwrap"
    "arb_hypgeom"
    "arb_mat"
    "arb_poly"
    "acb"
    "acb_calc"
    "acb_dft"
    "acb_dirichlet"
    "acb_elliptic"
    "acb_hypgeom"
    "acb_mat"
    "acb_modular"
    "acb_poly"
    "acb_theta"
    "bernoulli"
    # "hypgeom"
    "partitions"
    # "ca"
    # "ca_ext"
    # "ca_field"
    # "ca_mat"
    # "ca_poly"
    # "ca_vec"
    # "calcium"
    # "fexpr"
    # "fexpr_builtin"
    "fq"
    # "fq_embed"
    "fq_mat"
    "fq_poly"
    "fq_poly_factor"
    # "fq_vec"
    "fq_nmod"
    # "fq_nmod_embed"
    "fq_nmod_mat"
    # "fq_nmod_mpoly"
    # "fq_nmod_mpoly_factor"
    "fq_nmod_poly"
    "fq_nmod_poly_factor"
    # "fq_nmod_vec"
    "fq_zech"
    # "fq_zech_embed"
    "fq_zech_mat"
    "fq_zech_poly"
    "fq_zech_poly_factor"
    # "fq_zech_vec"
    "fq_default"
    "fq_default_mat"
    "fq_default_poly"
    "fq_default_poly_factor"
    # "padic"
    # "padic_mat"
    # "padic_poly"
    # "qadic"
    # "double_extras"
    # "double_interval"
    # "d_mat"
    # "d_vec"
    # "mpfr_mat"
    # "mpfr_vec"
)

for module in ${modules[@]}; do
    echo "Processing $module"
    bin/rst_to_pxd.py flint/$module \
        --flint-doc-dir=$FLINT_DOC_DIR \
        > src/flint/flintlib/functions/$module.pxd
done
