Cython declarations for functions exported by libflint
======================================================

This directory contains Cython declarations for functions exported by libflint.
The declarations under the `types` directory are for the types defined in
libflint and are hand-written. The declarations under the `functions` directory
are for the functions defined in libflint and are generated by running:
```console
$ bin/all_rst_to_pxd.sh /path/to/flint/doc/source
```
where `/path/to/flint/doc/source` is the path to the source directory of the
flint documentation. This command should always be run on the FLINT docs of the
version of FLINT that is used by default in python-flint's wheels which is the
version shown in the `bin/build_variables.sh` script. Typically this just means
the latest released version of FLINT.

It is important not to edit any of the files in `functions` manually because a
subsequent run of `bin/all_rst_to_pxd.sh` will overwrite them. There are
several reasons why manual editing may be needed but usually it is because
either:

1. The function is not documented in the FLINT docs.
2. The function is a macro and not a function.

In either case, we need to manually write the declaration for the function but
it cannot be done in the `functions` directory. Instead, it should be added
somewhere in the `types` directory.

Generally undocumented functions should be reported/fixed upstream in FLINT.

It might be better to list macros (and undocumented functions) in the
`bin/rst_to_pxd.py` script so that it can add them to the generated files
automatically. Then we can keep them out of the hand-written code but also keep
track of them with a goal of eventually getting all of them added to the FLINT
docs.
