#
#
#
from typing import (
    Generic,
    TypeVar,
    Iterator,
    Iterable,
    Any,
    Final,
    Self,
    Mapping,
    Sequence,
    overload,
)
from abc import abstractmethod
import enum

FLINT_VERSION: Final[str]
FLINT_RELEASE: Final[int]

Telem = TypeVar("Telem", bound=flint_scalar)
Telem_coerce = TypeVar("Telem_coerce", contravariant=True)
Tmpoly = TypeVar("Tmpoly", bound=flint_mpoly)
Tctx = TypeVar("Tctx", bound=flint_mpoly_context)

Sctx = TypeVar("Sctx", bound=flint_mpoly_context)

_str = str

class flint_elem:
    def str(self) -> _str: ...
    def repr(self) -> _str: ...

class flint_scalar(flint_elem):
    def is_zero(self) -> bool: ...
    def __pos__(self) -> Self: ...
    def __neg__(self) -> Self: ...
    def __add__(self, other: int, /) -> Self: ...
    def __radd__(self, other: int, /) -> Self: ...
    def __sub__(self, other: int, /) -> Self: ...
    def __rsub__(self, other: int, /) -> Self: ...
    def __mul__(self, other: int, /) -> Self: ...
    def __rmul__(self, other: int, /) -> Self: ...
    def __truediv__(self, other: int, /) -> Self: ...
    def __rtruediv__(self, other: int, /) -> Self: ...
    def __pow__(self, other: int, /) -> Self: ...
    def __rpow__(self, other: int, /) -> Self: ...

class flint_poly(flint_elem, Generic[Telem]):
    def str(
        self, ascending: bool = False, var: str = "x", *args: Any, **kwargs: Any
    ) -> str: ...
    def __iter__(self) -> Iterator[Telem]: ...
    def __getitem__(self, index: int, /) -> Telem: ...
    def __setitem__(self, index: int, value: Telem | int, /) -> None: ...
    def __len__(self) -> int: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...
    def coeffs(self) -> list[Telem]: ...
    def __call__(self, other: Telem | int, /) -> Telem: ...
    def __pos__(self) -> Self: ...
    def __neg__(self) -> Self: ...
    def __add__(self, other: Telem | int, /) -> Self: ...
    def __radd__(self, other: Telem | int, /) -> Self: ...
    def __sub__(self, other: Telem | int, /) -> Self: ...
    def __rsub__(self, other: Telem | int, /) -> Self: ...
    def __mul__(self, other: Telem | int, /) -> Self: ...
    def __rmul__(self, other: Telem | int, /) -> Self: ...
    def __truediv__(self, other: Telem | int, /) -> Self: ...
    def __rtruediv__(self, other: Telem | int, /) -> Self: ...
    def __floordiv__(self, other: Telem | int, /) -> Self: ...
    def __rfloordiv__(self, other: Telem | int, /) -> Self: ...
    def __mod__(self, other: Telem | int, /) -> Self: ...
    def __rmod__(self, other: Telem | int, /) -> Self: ...
    def __divmod__(self, other: Telem | int, /) -> tuple[Self, Self]: ...
    def __rdivmod__(self, other: Telem | int, /) -> tuple[Self, Self]: ...
    def __pow__(self, other: int, /) -> Self: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def is_gen(self) -> bool: ...
    def roots(self) -> list[tuple[Telem, int]]: ...
    # Should be list[arb]:
    def real_roots(self) -> list[Any]: ...
    # Should be list[acb]:
    def complex_roots(self) -> list[Any]: ...
    def derivative(self) -> Self: ...

class Ordering(enum.Enum):
    lex = "lex"
    deglex = "deglex"
    degrevlex = "degrevlex"

class flint_mpoly(flint_elem, Generic[Tctx, Telem, Telem_coerce]):
    def __init__(
        self,
        val: Self
        | Telem
        | Telem_coerce
        | int
        | dict[tuple[int, ...], Telem | Telem_coerce | int]
        | str = 0,
        ctx: Tctx | None = None,
    ) -> None: ...
    def str(self) -> _str: ...
    def repr(self) -> _str: ...
    def context(self) -> Tctx: ...
    def degrees(self) -> tuple[int, ...]: ...
    def total_degree(self) -> int: ...
    def leading_coefficient(self) -> Telem: ...
    def to_dict(self) -> dict[tuple[int, ...], Telem]: ...
    def is_one(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def __len__(self) -> int: ...
    def __getitem__(self, index: tuple[int, ...]) -> Telem: ...
    def __setitem__(
        self, index: tuple[int, ...], coeff: Telem | Telem_coerce | int
    ) -> None: ...
    def __iter__(self) -> Iterable[tuple[int, ...]]: ...
    def __contains__(self, index: tuple[int, ...]) -> bool: ...
    def coefficient(self, i: int) -> Telem: ...
    def monomial(self, i: int) -> tuple[int, ...]: ...
    def terms(self) -> Iterable[tuple[tuple[int, ...], Telem]]: ...
    def monoms(self) -> list[tuple[int, ...]]: ...
    def coeffs(self) -> list[Telem]: ...
    def __pos__(self) -> Self: ...
    def __neg__(self) -> Self: ...
    def __add__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __radd__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __sub__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rsub__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __mul__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rmul__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __truediv__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rtruediv__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __floordiv__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rfloordiv__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __mod__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rmod__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __divmod__(
        self, other: Telem | Telem_coerce | int
    ) -> tuple[Self, Self]: ...
    def __rdivmod__(self, other: Telem | Telem_coerce | int) -> tuple[Self, Self]: ...
    def __pow__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def __rpow__(self, other: Telem | Telem_coerce | int) -> Self: ...
    def iadd(self, other: Telem | Telem_coerce | int) -> None: ...
    def isub(self, other: Telem | Telem_coerce | int) -> None: ...
    def imul(self, other: Telem | Telem_coerce | int) -> None: ...
    def term_content(self) -> Self: ...
    def factor(self) -> tuple[Telem, Sequence[tuple[Self, int]]]: ...
    def factor_squarefree(self) -> tuple[Telem, Sequence[tuple[Self, int]]]: ...
    def sqrt(self) -> Self: ...
    def discriminant(self, var: _str | int) -> Self: ...
    def deflation_index(self) -> tuple[list[int], list[int]]: ...
    def deflation(self) -> tuple[Self, list[int]]: ...
    def deflation_monom(self) -> tuple[Self, list[int], Self]: ...
    def inflate(self, N: list[int]) -> Self: ...
    def deflate(self, N: list[int]) -> Self: ...
    def subs(self, mapping: dict[_str | int, Telem | Telem_coerce | int]) -> Self: ...
    def __call__(self, *args: Telem | Telem_coerce) -> Telem: ...
    def derivative(self, var: _str | int) -> Self: ...
    def unused_gens(self) -> tuple[_str, ...]: ...
    def project_to_context(
        self, other_ctx: Tctx, mapping: dict[_str | int, _str | int] | None = None
    ) -> Self: ...

class flint_mpoly_context(flint_elem, Generic[Tmpoly, Telem, Telem_coerce]):
    def nvars(self) -> int: ...
    def ordering(self) -> Ordering: ...
    def gen(self, i: int, /) -> Tmpoly: ...
    def from_dict(self, d: Mapping[tuple[int, ...], Telem_coerce], /) -> Tmpoly: ...
    def constant(self, z: Telem_coerce, /) -> Tmpoly: ...
    def name(self, i: int, /) -> str: ...
    def names(self) -> tuple[str]: ...
    def gens(self) -> tuple[Tmpoly, ...]: ...
    def variable_to_index(self, var: str, /) -> int: ...
    def term(
        self, coeff: Telem_coerce | None = None, exp_vec: Iterable[int] | None = None
    ) -> Tmpoly: ...
    def drop_gens(self, gens: Iterable[str | int], /) -> Self: ...
    def append_gens(self, gens: Iterable[str | int], /) -> Self: ...
    def infer_generator_mapping(
        self, ctx: flint_mpoly_context, /
    ) -> dict[int, int]: ...
    @classmethod
    def from_context(
        cls,
        ctx: flint_mpoly_context,
        names: str | Iterable[str | tuple[str, int]] | tuple[str, int] | None = None,
        ordering: Ordering | str = Ordering.lex,
    ) -> Self: ...

class flint_mod_mpoly_context(flint_mpoly_context[Tmpoly, Telem, Telem_coerce]):
    @abstractmethod
    def modulus(self): ...

class flint_series(flint_elem, Generic[Telem]):
    """Base class for power series."""
    def __iter__(self) -> Iterator[Telem]: ...
    def coeffs(self) -> list[Telem]: ...
