from ..flint_base.flint_base import flint_scalar
from typing import overload
from .fmpz import fmpz


_str = str
ifmpz = int | fmpz
ifmpq = int | fmpz | fmpq


class fmpq(flint_scalar):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: ifmpq | _str, /) -> None: ...
    @overload
    def __init__(self, num: ifmpq, den: ifmpq, /): ...

    @property
    def p(self) -> fmpz: ...
    @property
    def q(self) -> fmpz: ...

    @property
    def numerator(self) -> fmpz: ...
    @property
    def denominator(self) -> fmpz: ...

    def numer(self) -> fmpz: ...
    def denom(self) -> fmpz: ...

    def height_bits(self, signed: bool = False) -> int: ...

    def next(self, signed: bool = True, minimal: bool = True) -> fmpq: ...

    def str(self, base: int = 10, condense: int = 0) -> _str: ...
    def repr(self) -> _str: ...

    def __str__(self) -> _str: ...
    def __repr__(self) -> _str: ...

    def __int__(self) -> int: ...

    def __floor__(self) -> fmpz: ...
    def __ceil__(self) -> fmpz: ...
    def __trunc__(self) -> fmpz: ...

    def floor(self) -> fmpz: ...
    def ceil(self) -> fmpz: ...

    @overload
    def __round__(self, ndigits: int) -> fmpq: ...
    @overload
    def __round__(self) -> fmpz: ...

    def __eq__(self, other: object, /) -> bool: ...
    def __hash__(self) -> int: ...

    def __lt__(self, other: ifmpq, /) -> bool: ...
    def __le__(self, other: ifmpq, /) -> bool: ...
    def __gt__(self, other: ifmpq, /) -> bool: ...
    def __ge__(self, other: ifmpq, /) -> bool: ...

    def __neg__(self) -> fmpq: ...
    def __pos__(self) -> fmpq: ...
    def __add__(self, other: ifmpq, /) ->fmpq: ...
    def __radd__(self, other: ifmpz, /) ->fmpq: ...
    def __sub__(self, other: ifmpq, /) ->fmpq: ...
    def __rsub__(self, other: ifmpz, /) ->fmpq: ...
    def __mul__(self, other: ifmpq, /) ->fmpq: ...
    def __rmul__(self, other: ifmpz, /) ->fmpq: ...
    def __truediv__(self, other: ifmpq, /) ->fmpq: ...
    def __rtruediv__(self, other: ifmpz, /) ->fmpq: ...
    def __floordiv__(self, other: ifmpq, /) ->fmpq: ...
    def __rfloordiv__(self, other: ifmpz, /) ->fmpq: ...
    def __mod__(self, other: ifmpq, /) ->fmpq: ...
    def __rmod__(self, other: ifmpz, /) ->fmpq: ...
    def __divmod__(self, other: ifmpq, /) -> tuple[fmpq,fmpq]: ...
    def __rdivmod__(self, other: ifmpz, /) -> tuple[fmpq,fmpq]: ...
    def __pow__(self, other: ifmpz, /) ->fmpq: ...
    def __abs__(self) ->fmpq: ...

    def gcd(self, other: ifmpq, /) -> fmpq: ...

    def sqrt(self) -> fmpq: ...

    @staticmethod
    def bernoulli(n: int, cache: bool = False) -> fmpq: ...

    @staticmethod
    def harmonic(n: int) -> fmpq: ...

    @staticmethod
    def dedekind_sum(n: ifmpz, k: ifmpz) -> fmpq: ...
