from typing import Iterable, Mapping, Any
from ..flint_base.flint_base import flint_mpoly, flint_mpoly_context, Ordering
from .fmpz import fmpz
from .fmpq import fmpq
from .fmpz_mpoly import fmpz_mpoly


_str = str
ifmpz = int | fmpz
ifmpq = int | fmpz | fmpq


class fmpq_mpoly_ctx(flint_mpoly_context[fmpq_mpoly, fmpq, ifmpq]):
    @classmethod
    def get(cls,
        names: _str | Iterable[_str | tuple[_str, int]] | tuple[_str, int],
        ordering: Ordering | _str = Ordering.lex
    ) -> fmpq_mpoly_ctx:
        ...

    def nvars(self) -> int: ...
    def ordering(self) -> Ordering: ...
    def gen(self, i: int, /) -> fmpq_mpoly: ...
    def from_dict(self, d: Mapping[tuple[int, ...], ifmpq], /) -> fmpq_mpoly: ...
    def constant(self, q: ifmpq, /) -> fmpq_mpoly: ...
    def name(self, i: int, /) -> str: ...
    def names(self) -> tuple[str]: ...
    def gens(self) -> tuple[fmpq_mpoly, ...]: ...
    def variable_to_index(self, var: str, /) -> int: ...
    def term(
        self, coeff: ifmpq | None = None, exp_vec: Iterable[int] | None = None
    ) -> fmpq_mpoly: ...
    def drop_gens(self, gens: Iterable[str | int], /) -> fmpq_mpoly_ctx: ...
    def append_gens(self, gens: Iterable[str | int], /) -> fmpq_mpoly_ctx: ...
    def infer_generator_mapping(
        self, ctx: flint_mpoly_context, /
    ) -> dict[int, int]: ...
    @classmethod
    def from_context(
        cls,
        ctx: flint_mpoly_context[Any, Any, Any],
        names: str | Iterable[str | tuple[str, int]] | tuple[str, int] | None = None,
        ordering: Ordering | str = Ordering.lex,
    ) -> fmpq_mpoly_ctx: ...

class fmpq_mpoly(flint_mpoly[fmpq_mpoly_ctx, fmpq, ifmpq]):
    def __init__(self,
        val: fmpq_mpoly | fmpz_mpoly | ifmpq | Mapping[tuple[int, ...], ifmpq] | _str = 0,
        ctx: fmpq_mpoly_ctx | None = None
    ) -> None: ...

    def str(self) -> _str: ...
    def repr(self) -> _str: ...

    def context(self) -> fmpq_mpoly_ctx: ...

    def degrees(self) -> tuple[int, ...]: ...
    def total_degree(self) -> int: ...

    def is_one(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_constant(self) -> bool: ...

    def __len__(self) -> int: ...
    def coefficient(self, i: int) -> fmpq: ...
    def monomial(self, i: int) -> tuple[int, ...]: ...

    def monoms(self) -> list[tuple[int, ...]]: ...
    def coeffs(self) -> list[fmpq]: ...
    def __getitem__(self, index: tuple[int, ...]) -> fmpq: ...
    def __setitem__(self, index: tuple[int, ...], coeff: ifmpq) -> None: ...

    def subs(self, mapping: Mapping[_str | int, ifmpq]) -> fmpq_mpoly: ...
    def compose(self, *args: fmpq_mpoly, ctx: fmpq_mpoly_ctx | None = None) -> fmpq_mpoly: ...

    def __call__(self, *args: ifmpq) -> fmpq: ...

    def __pos__(self) -> fmpq_mpoly: ...
    def __neg__(self) -> fmpq_mpoly: ...
    def __add__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __radd__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __sub__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __rsub__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __mul__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __rmul__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __truediv__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __rtruediv__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __floordiv__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __rfloordiv__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __mod__(self, other: fmpq_mpoly | ifmpq) -> fmpq_mpoly: ...
    def __rmod__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __divmod__(self, other: fmpq_mpoly | ifmpq) -> tuple[fmpq_mpoly, fmpq_mpoly]: ...
    def __rdivmod__(self, other: ifmpq) -> tuple[fmpq_mpoly, fmpq_mpoly]: ...
    def __pow__(self, other: ifmpq) -> fmpq_mpoly: ...
    def __rpow__(self, other: ifmpq) -> fmpq_mpoly: ...

    def iadd(self, other: fmpq_mpoly | ifmpq) -> None: ...
    def isub(self, other: fmpq_mpoly | ifmpq) -> None: ...
    def imul(self, other: fmpq_mpoly | ifmpq) -> None: ...

    def gcd(self, other: fmpq_mpoly) -> fmpq_mpoly: ...
    def xgcd(self, other: fmpq_mpoly, /) -> fmpq: ...
    def term_content(self) -> fmpq_mpoly: ...

    def factor(self) -> tuple[fmpq, list[tuple[fmpq_mpoly, int]]]: ...
    def factor_squarefree(self) -> tuple[fmpq, list[tuple[fmpq_mpoly, int]]]: ...

    def sqrt(self, assume_perfect_square: bool = False) -> fmpq_mpoly: ...

    def resultant(self, other: fmpq_mpoly, var: _str | int) -> fmpq_mpoly: ...
    def discriminant(self, var: _str | int) -> fmpq_mpoly: ...

    def deflation(self) -> tuple[fmpq_mpoly, list[int]]: ...
    def inflate(self, N: list[int]) -> fmpq_mpoly: ...
    def deflate(self, N: list[int]) -> fmpq_mpoly: ...
    def deflation_monom(self) -> tuple[fmpq_mpoly, list[int], fmpq_mpoly]: ...
    def deflation_index(self) -> tuple[list[int], list[int]]: ...

    def derivative(self, var: _str | int) -> fmpq_mpoly: ...
    def integral(self, var: _str | int) -> fmpq_mpoly: ...


class fmpq_mpoly_vec:
    ...
