from typing import overload, Any, Sequence
from flint.flint_base.flint_base import flint_poly
from flint.types.fmpz import fmpz, ifmpz
from flint.types.fmpq import fmpq, ifmpq
from flint.types.fmpz_poly import fmpz_poly, ifmpz_poly


ifmpq_poly = fmpq_poly | ifmpq | ifmpz_poly


class fmpq_poly(flint_poly[fmpq]):
    """
    The *fmpq_poly* type represents dense univariate polynomials
    over the rational numbers. For efficiency reasons, an *fmpq_poly* is
    structurally an integer polynomial with a single common denominator.
    """

    def __init__(self, other: Sequence[ifmpq] | ifmpq_poly = ..., den: ifmpz = ..., /) -> None: ...

    def __len__(self) -> int: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...

    def numer(self) -> fmpz_poly: ...
    def denom(self) -> fmpz: ...

    @property
    def p(self) -> fmpz_poly: ...
    @property
    def q(self) -> fmpz: ...

    def __getitem__(self, i: int, /) -> fmpq: ...
    def __setitem__(self, i: int, x: ifmpq, /) -> None: ...

    def repr(self) -> str: ...

    def __bool__(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def is_gen(self) -> bool: ...

    def leading_coefficient(self) -> fmpq: ...

    @overload
    def __call__(self, other: ifmpq, /) -> fmpq: ...
    @overload
    def __call__(self, other: fmpq_poly | fmpz_poly, /) -> fmpq_poly: ...

    def derivative(self) -> fmpq_poly: ...
    def integral(self) -> fmpq_poly: ...

    def __pos__(self) -> fmpq_poly: ...
    def __neg__(self) -> fmpq_poly: ...
    def __add__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __radd__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __sub__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __rsub__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __mul__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __rmul__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __floordiv__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __rfloordiv__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __mod__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __rmod__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __truediv__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __rtruediv__(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def __divmod__(self, other: ifmpq_poly, /) -> tuple[fmpq_poly, fmpq_poly]: ...
    def __rdivmod__(self, other: ifmpq_poly, /) -> tuple[fmpq_poly, fmpq_poly]: ...
    def __pow__(self, exp: int | ifmpz, /) -> fmpq_poly: ...

    def left_shift(self, n: int, /) -> fmpq_poly: ...
    def right_shift(self, n: int, /) -> fmpq_poly: ...
    def truncate(self, n: int, /) -> fmpq_poly: ...

    def gcd(self, other: ifmpq_poly, /) -> fmpq_poly: ...
    def resultant(self, other: ifmpq_poly, /) -> fmpq: ...
    def xgcd(self, other: ifmpq_poly, /) -> tuple[fmpq_poly, fmpq_poly, fmpq_poly]: ...

    def factor(self, *, monic: bool = False) -> tuple[fmpq, list[tuple[fmpq_poly, int]]]: ...
    def factor_squarefree(self) -> tuple[fmpq, list[tuple[fmpq_poly, int]]]: ...

    def sqrt(self) -> fmpq_poly: ...

    def deflation(self) -> tuple[fmpq_poly, int]: ...
    # XXX: acb
    def complex_roots(self, **kwargs) -> list[Any]: ...

    @staticmethod
    def bernoulli_poly(n: int, /) -> fmpq_poly: ...
    @staticmethod
    def euler_poly(n: int, /) -> fmpq_poly: ...
    @staticmethod
    def legendre_p(n: int, /) -> fmpq_poly: ...
