from typing import Any, Sequence
from flint.flint_base.flint_base import flint_series
from flint.types.fmpz import fmpz, ifmpz
from flint.types.fmpq import fmpq, ifmpq
from flint.types.fmpq_poly import fmpq_poly
from flint.types.fmpz_series import fmpz_series, ifmpz_series


ifmpq_series = fmpq_series | fmpq_poly | ifmpz_series


class fmpq_series(flint_series[fmpq]):
    """Approximate truncated power series with rational coefficients."""

    def __init__(self,
                 val: Sequence[ifmpq] | ifmpq | ifmpq_series | None = None,
                 den: ifmpz | None = None,
                 prec: int | None = None): ...

    @property
    def prec(self) -> int: ...

    def _equal_repr(self, other: object) -> bool: ...

    def __len__(self) -> int: ...
    def length(self) -> int: ...

    def numer(self) -> fmpz_series: ...
    def denom(self) -> fmpz: ...

    @property
    def p(self) -> fmpq_poly: ...
    @property
    def q(self) -> fmpz: ...

    def __getitem__(self, i: int, /) -> fmpq: ...
    def __setitem__(self, i: int, x: ifmpq, /) -> None: ...

    def repr(self, **kwargs: Any) -> str: ...
    def str(self, **kwargs: Any) -> str: ...

    def __pos__(self) -> fmpq_series: ...
    def __neg__(self) -> fmpq_series: ...
    def __add__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __radd__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __sub__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __rsub__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __mul__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __rmul__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __truediv__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __rtruediv__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def __pow__(self, exp: int, /) -> fmpq_series: ...

    def valuation(self) -> int: ...

    def __call__(self, other: ifmpq_series, /) -> fmpq_series: ...
    def reversion(self) -> fmpq_series: ...
    def inv(self) -> fmpq_series: ...

    def zero_constant_term(self) -> bool: ...
    def one_constant_term(self) -> bool: ...

    def derivative(self) -> fmpq_series: ...
    def integral(self) -> fmpq_series: ...
    def sqrt(self) -> fmpq_series: ...
    def rsqrt(self) -> fmpq_series: ...
    def exp(self) -> fmpq_series: ...
    def log(self) -> fmpq_series: ...
    def atan(self) -> fmpq_series: ...
    def atanh(self) -> fmpq_series: ...
    def asin(self) -> fmpq_series: ...
    def asinh(self) -> fmpq_series: ...
    def sin(self) -> fmpq_series: ...
    def cos(self) -> fmpq_series: ...
    def tan(self) -> fmpq_series: ...
    def sinh(self) -> fmpq_series: ...
    def cosh(self) -> fmpq_series: ...
    def tanh(self) -> fmpq_series: ...
