#
# It would be better if many methods accepted SupportsIndex rather than just
# ifmpz but for now these annotations are accurate.
#
from ..flint_base.flint_base import flint_scalar

_str = str
ifmpz = int | fmpz

class fmpz(flint_scalar):
    def __init__(self, arg: ifmpz | _str = 0, /): ...

    @property
    def numerator(self) -> fmpz: ...
    @property
    def denominator(self) -> fmpz: ...

    def bit_length(self) -> int: ...
    def height_bits(self, signed: bool = False) -> int: ...

    def str(self, base: int = 10, condense: int = 0) -> _str: ...
    def repr(self) -> _str: ...

    def __str__(self) -> _str: ...
    def __repr__(self) -> _str: ...

    def __int__(self) -> int: ...
    def __index__(self) -> int: ...

    def __floor__(self) -> fmpz: ...
    def __ceil__(self) -> fmpz: ...
    def __trunc__(self) -> fmpz: ...
    def __round__(self, ndigits: int | None = None) -> fmpz: ...

    def __eq__(self, other: object, /) -> bool: ...
    def __hash__(self) -> int: ...

    def __lt__(self, other: ifmpz, /) -> bool: ...
    def __le__(self, other: ifmpz, /) -> bool: ...
    def __gt__(self, other: ifmpz, /) -> bool: ...
    def __ge__(self, other: ifmpz, /) -> bool: ...

    def __neg__(self) -> fmpz: ...
    def __pos__(self) -> fmpz: ...
    def __add__(self, other: ifmpz, /) -> fmpz: ...
    def __radd__(self, other: int, /) -> fmpz: ...
    def __sub__(self, other: ifmpz, /) -> fmpz: ...
    def __rsub__(self, other: int, /) -> fmpz: ...
    def __mul__(self, other: ifmpz, /) -> fmpz: ...
    def __rmul__(self, other: int, /) -> fmpz: ...
    def __truediv__(self, other: ifmpz, /) -> fmpz: ...
    def __rtruediv__(self, other: int, /) -> fmpz: ...
    def __floordiv__(self, other: ifmpz, /) -> fmpz: ...
    def __rfloordiv__(self, other: int, /) -> fmpz: ...
    def __mod__(self, other: ifmpz, /) -> fmpz: ...
    def __rmod__(self, other: int, /) -> fmpz: ...
    def __divmod__(self, other: ifmpz, /) -> tuple[fmpz, fmpz]: ...
    def __rdivmod__(self, other: int, /) -> tuple[fmpz, fmpz]: ...
    def __pow__(self, other: ifmpz, modulo: int | fmpz | None = None, /) -> fmpz: ...
    def __rpow__(self, other: int, modulo: ifmpz | None = None, /) -> fmpz: ...
    def __abs__(self) -> fmpz: ...

    def __lshift__(self, other: ifmpz, /) -> fmpz: ...
    def __rlshift__(self, other: ifmpz, /) -> fmpz: ...
    def __rshift__(self, other: ifmpz, /) -> fmpz: ...
    def __rrshift__(self, other: ifmpz, /) -> fmpz: ...
    def __and__(self, other: ifmpz, /) -> fmpz: ...
    def __rand__(self, other: int, /) -> fmpz: ...
    def __or__(self, other: ifmpz, /) -> fmpz: ...
    def __ror__(self, other: int, /) -> fmpz: ...
    def __xor__(self, other: ifmpz, /) -> fmpz: ...
    def __rxor__(self, other: int, /) -> fmpz: ...
    def __invert__(self) -> fmpz: ...

    def gcd(self, other: ifmpz, /) -> fmpz: ...
    def lcm(self, other: ifmpz, /) -> fmpz: ...
    def factor(self, trial_limit: int | None = None) -> list[tuple[fmpz, int]]: ...
    def factor_smooth(self, bits: int = 15, proved: int = -1) -> list[tuple[fmpz, int]]: ...

    def is_prime(self) -> bool: ...
    def is_probable_prime(self) -> bool: ...
    def is_square(self) -> bool: ...
    def is_perfect_power(self) -> bool: ...

    def partitions_p(self) -> fmpz: ...
    def moebius_mu(self) -> fmpz: ...
    def fac_ui(self) -> fmpz: ...
    def primorial_ui(self) -> fmpz: ...
    def fib_ui(self) -> fmpz: ...
    def rising(self, n: int) -> fmpz: ...

    @classmethod
    def bin_uiui(cls, n: int, k: int) -> fmpz: ...
    @classmethod
    def bell_number(cls, n: int) -> fmpz: ...
    @classmethod
    def euler_number(cls, n: int) -> fmpz: ...
    @classmethod
    def stirling_s1(cls, n: int, k: int) -> fmpz: ...
    @classmethod
    def stirling_s2(cls, n: int, k: int) -> fmpz: ...

    def divisor_sigma(self, k: int) -> fmpz: ...
    def euler_phi(self) -> fmpz: ...

    def isqrt(self) -> fmpz: ...
    def sqrt(self) -> fmpz: ...
    def sqrtrem(self) -> tuple[fmpz, fmpz]: ...
    def sqrtmod(self, p: ifmpz) -> fmpz: ...
    def root(self, n: int) -> fmpz: ...

    def jacobi(self, other: ifmpz, /) -> int: ...
