from ..flint_base.flint_base import flint_scalar
from .fmpz import fmpz
from .fmpq import fmpq


ifmpz = int | fmpz
ifmpq = int | fmpz | fmpq
ifmpz_mod = ifmpz | fmpz_mod


class fmpz_mod_ctx:

    def __init__(self, mod: ifmpz) -> None: ...
    def modulus(self) -> fmpz: ...
    def is_prime(self) -> bool: ...
    def zero(self) -> fmpz_mod: ...
    def one(self) -> fmpz_mod: ...
    def random_element(self) -> fmpz_mod: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __call__(self, val: ifmpz_mod) -> fmpz_mod: ...


class fmpz_mod(flint_scalar):

    def __init__(self, val: ifmpz_mod, mod: fmpz_mod_ctx) -> None: ...

    def is_zero(self) -> bool: ...


    def is_one(self) -> bool: ...
    def is_unit(self) -> bool: ...

    def inverse(self, check: bool = True) -> fmpz_mod: ...

    def discrete_log(self, a: ifmpz_mod) -> fmpz: ...

    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

    def __bool__(self) -> bool: ...

    def repr(self) -> str: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def __int__(self) -> int: ...
    def str(self) -> str: ...

    def __pos__(self) -> fmpz_mod: ...

    def __neg__(self) -> fmpz_mod: ...

    def __add__(self, other: ifmpz_mod, /) -> fmpz_mod: ...
    def __radd__(self, other: ifmpq, /) -> fmpz_mod: ...
    def __sub__(self, other: ifmpz_mod, /) -> fmpz_mod: ...
    def __rsub__(self, other: ifmpq, /) -> fmpz_mod: ...
    def __mul__(self, other: ifmpz_mod, /) -> fmpz_mod: ...
    def __rmul__(self, other: ifmpq, /) -> fmpz_mod: ...
    def __truediv__(self, other: ifmpz_mod, /) -> fmpz_mod: ...
    def __rtruediv__(self, other: ifmpq, /) -> fmpz_mod: ...
    def __pow__(self, other: ifmpz, /) -> fmpz_mod: ...
    def __invert__(self) -> fmpz_mod: ...

    def sqrt(self) -> fmpz_mod: ...
