from typing import Iterable, Mapping, Any
from ..flint_base.flint_base import (
    flint_mpoly,
    flint_mpoly_context,
    flint_mod_mpoly_context,
    Ordering,
)
from .fmpz import fmpz
from .fmpz_mod import fmpz_mod
from .fmpz_mpoly import fmpz_mpoly


_str = str
ifmpz = int | fmpz
ifmpz_mod = int | fmpz | fmpz_mod


class fmpz_mod_mpoly_ctx(flint_mod_mpoly_context[fmpz_mod_mpoly, fmpz_mod, ifmpz_mod]):

    @classmethod
    def get(cls,
        names: _str | Iterable[_str | tuple[_str, int]] | tuple[_str, int],
        ordering: Ordering | _str = Ordering.lex,
        *,
        modulus: int,
    ) -> fmpz_mod_mpoly_ctx:
        ...

    def modulus(self) -> fmpz: ...

    def nvars(self) -> int: ...
    def ordering(self) -> Ordering: ...

    def gen(self, i: int) -> fmpz_mod_mpoly: ...
    def from_dict(self, d: Mapping[tuple[int, ...], ifmpz_mod]) -> fmpz_mod_mpoly: ...
    def constant(self, z: ifmpz_mod) -> fmpz_mod_mpoly: ...

    def name(self, i: int, /) -> str: ...
    def names(self) -> tuple[str]: ...
    def gens(self) -> tuple[fmpz_mod_mpoly, ...]: ...
    def variable_to_index(self, var: str, /) -> int: ...
    def term(
        self, coeff: ifmpz_mod | None = None, exp_vec: Iterable[int] | None = None
    ) -> fmpz_mod_mpoly: ...
    def drop_gens(self, gens: Iterable[str | int], /) -> fmpz_mod_mpoly_ctx: ...
    def append_gens(self, gens: Iterable[str | int], /) -> fmpz_mod_mpoly_ctx: ...
    def infer_generator_mapping(
        self, ctx: flint_mpoly_context, /
    ) -> dict[int, int]: ...
    @classmethod
    def from_context(
        cls,
        ctx: flint_mpoly_context[Any, Any, Any],
        names: str | Iterable[str | tuple[str, int]] | tuple[str, int] | None = None,
        ordering: Ordering | str = Ordering.lex,
    ) -> fmpz_mod_mpoly_ctx: ...


class fmpz_mod_mpoly(flint_mpoly[fmpz_mod_mpoly_ctx, fmpz_mod, ifmpz_mod]):
    def __init__(self,
        val: fmpz_mod_mpoly | fmpz_mpoly | ifmpz_mod | Mapping[tuple[int, ...], ifmpz_mod] | _str = 0,
        ctx: fmpz_mod_mpoly_ctx | None = None
    ) -> None: ...

    def str(self) -> _str: ...
    def repr(self) -> _str: ...

    def context(self) -> fmpz_mod_mpoly_ctx: ...

    def degrees(self) -> tuple[int, ...]: ...
    def total_degree(self) -> int: ...

    def is_one(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_constant(self) -> bool: ...

    def __len__(self) -> int: ...
    def coefficient(self, i: int) -> fmpz_mod: ...
    def monomial(self, i: int) -> tuple[int, ...]: ...

    def monoms(self) -> list[tuple[int, ...]]: ...
    def coeffs(self) -> list[fmpz_mod]: ...
    def __getitem__(self, index: tuple[int, ...]) -> fmpz_mod: ...
    def __setitem__(self, index: tuple[int, ...], coeff: ifmpz_mod) -> None: ...

    def subs(self, mapping: Mapping[_str | int, ifmpz_mod]) -> fmpz_mod_mpoly: ...
    def compose(self, *args: fmpz_mod_mpoly, ctx: fmpz_mod_mpoly_ctx | None = None) -> fmpz_mod_mpoly: ...

    def __call__(self, *args: ifmpz_mod) -> fmpz_mod: ...

    def __pos__(self) -> fmpz_mod_mpoly: ...
    def __neg__(self) -> fmpz_mod_mpoly: ...
    def __add__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __radd__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __sub__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rsub__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __mul__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rmul__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __truediv__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rtruediv__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __floordiv__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rfloordiv__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __mod__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rmod__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __divmod__(self, other: fmpz_mod_mpoly | ifmpz_mod) -> tuple[fmpz_mod_mpoly, fmpz_mod_mpoly]: ...
    def __rdivmod__(self, other: ifmpz_mod) -> tuple[fmpz_mod_mpoly, fmpz_mod_mpoly]: ...
    def __pow__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...
    def __rpow__(self, other: ifmpz_mod) -> fmpz_mod_mpoly: ...

    def iadd(self, other: fmpz_mod_mpoly | ifmpz_mod) -> None: ...
    def isub(self, other: fmpz_mod_mpoly | ifmpz_mod) -> None: ...
    def imul(self, other: fmpz_mod_mpoly | ifmpz_mod) -> None: ...

    def gcd(self, other: fmpz_mod_mpoly) -> fmpz_mod_mpoly: ...
    def xgcd(self, other: fmpz_mod_mpoly, /) -> fmpz_mod: ...
    def term_content(self) -> fmpz_mod_mpoly: ...
    def primitive(self) -> tuple[fmpz_mod, fmpz_mod_mpoly]: ...

    def factor(self) -> tuple[fmpz_mod, list[tuple[fmpz_mod_mpoly, int]]]: ...
    def factor_squarefree(self) -> tuple[fmpz_mod, list[tuple[fmpz_mod_mpoly, int]]]: ...

    def sqrt(self, assume_perfect_square: bool = False) -> fmpz_mod_mpoly: ...

    def resultant(self, other: fmpz_mod_mpoly, var: _str | int) -> fmpz_mod_mpoly: ...
    def discriminant(self, var: _str | int) -> fmpz_mod_mpoly: ...

    def deflation(self) -> tuple[fmpz_mod_mpoly, list[int]]: ...
    def inflate(self, N: list[int]) -> fmpz_mod_mpoly: ...
    def deflate(self, N: list[int]) -> fmpz_mod_mpoly: ...
    def deflation_monom(self) -> tuple[fmpz_mod_mpoly, list[int], fmpz_mod_mpoly]: ...
    def deflation_index(self) -> tuple[list[int], list[int]]: ...

    def derivative(self, var: _str | int) -> fmpz_mod_mpoly: ...


class fmpz_mod_mpoly_vec:
    ...

