from typing import Literal, Sequence, overload

from flint.flint_base.flint_base import flint_poly
from flint.types.fmpz import fmpz
from flint.types.fmpz_poly import fmpz_poly
from flint.types.fmpz_mod import fmpz_mod, fmpz_mod_ctx, ifmpz, ifmpz_mod

ifmpz_mod_poly = ifmpz_mod | fmpz_mod_poly | fmpz_poly

class fmpz_mod_poly_ctx:
    r"""
    Context object for creating :class:`~.fmpz_mod_poly` initialised
    with a modulus :math:`N`.

        >>> fmpz_mod_poly_ctx(2**127 - 1)
        fmpz_mod_poly_ctx(170141183460469231731687303715884105727)

    """
    def __init__(self, mod: fmpz_mod_ctx | ifmpz): ...
    def modulus(self) -> fmpz: ...
    def is_prime(self) -> bool: ...
    def zero(self) -> fmpz_mod_poly: ...
    def one(self) -> fmpz_mod_poly: ...
    def gen(self) -> fmpz_mod_poly: ...
    def random_element(
        self, degree: int = 3, monic: bool = False, irreducible: bool = False
    ) -> fmpz_mod_poly: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __call__(self, val: ifmpz_mod_poly | list[ifmpz_mod]) -> fmpz_mod_poly: ...
    def minpoly(self, vals: Sequence[ifmpz_mod]) -> fmpz_mod_poly: ...

class fmpz_mod_poly(flint_poly[fmpz_mod]):
    """
    The *fmpz_mod_poly* type represents univariate polynomials
    over integer modulo an arbitrary-size modulus.
    For wordsize modulus, see :class:`~.nmod_poly`.

    An *fmpz_mod_poly* element is constructed from an :class:`~.fmpz_mod_poly_ctx`
    either by passing it as an argument to the type, or
    by directly calling the context:

        >>> fmpz_mod_poly([1,-2,3], fmpz_mod_poly_ctx(2**127 - 1))
        3*x^2 + 170141183460469231731687303715884105725*x + 1
        >>> R = fmpz_mod_poly_ctx(2**127 - 1)
        >>> R([4,5,6])
        6*x^2 + 5*x + 4

    """
    def __init__(self, val: Sequence[ifmpz_mod] | ifmpz_mod_poly, ctx): ...
    def context(self) -> fmpz_mod_poly_ctx: ...
    def modulus(self) -> fmpz: ...
    def __pos__(self) -> fmpz_mod_poly: ...
    def __neg__(self) -> fmpz_mod_poly: ...
    def __add__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __radd__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __sub__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __rsub__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __mul__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __rmul__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __truediv__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __rtruediv__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __floordiv__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __rfloordiv__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __mod__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __rmod__(self, other: ifmpz_mod_poly, /) -> fmpz_mod_poly: ...
    def __pow__(
        self, e: ifmpz, mod: ifmpz_mod_poly | None = None, /
    ) -> fmpz_mod_poly: ...
    def scalar_mul(self, other: ifmpz_mod) -> fmpz_mod_poly: ...
    def exact_division(self, right: ifmpz_mod_poly) -> fmpz_mod_poly: ...
    def left_shift(self, n: int, /) -> fmpz_mod_poly: ...
    def right_shift(self, n: int, /) -> fmpz_mod_poly: ...
    def __getitem__(self, i: int, /) -> fmpz_mod: ...
    def __setitem__(self, i: int, x: ifmpz_mod, /) -> None: ...
    def __len__(self) -> int: ...
    def __hash__(self) -> int: ...
    @overload
    def __call__(self, input: ifmpz_mod) -> fmpz_mod: ...
    @overload
    def __call__(self, input: fmpz_mod_poly) -> fmpz_mod_poly: ...
    @overload
    def __call__(
        self, input: list[ifmpz_mod] | tuple[ifmpz_mod, ...]
    ) -> list[fmpz_mod]: ...
    def evaluate(self, input: ifmpz_mod) -> fmpz_mod: ...
    def multipoint_evaluate(self, vals: Sequence[ifmpz_mod]) -> list[fmpz_mod]: ...
    def compose(self, other: fmpz_mod_poly) -> fmpz_mod_poly: ...
    def compose_mod(
        self, other: ifmpz_mod_poly, modulus: ifmpz_mod_poly
    ) -> fmpz_mod_poly: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_gen(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def constant_coefficient(self) -> fmpz_mod: ...
    def leading_coefficient(self) -> fmpz_mod: ...
    def reverse(self, degree: int | None = None) -> fmpz_mod_poly: ...
    def truncate(self, n: int) -> fmpz_mod_poly: ...
    def is_monic(self) -> bool: ...
    def monic(self, check: bool = True) -> fmpz_mod_poly: ...
    def is_irreducible(self) -> bool: ...
    def is_squarefree(self) -> bool: ...
    def square(self) -> fmpz_mod_poly: ...
    def mul_mod(
        self, other: ifmpz_mod_poly, modulus: ifmpz_mod_poly
    ) -> fmpz_mod_poly: ...
    def pow_mod(
        self, e: int, modulus: ifmpz_mod_poly | None = None, /
    ) -> fmpz_mod_poly: ...
    def divmod(self, other: ifmpz_mod_poly) -> tuple[fmpz_mod, fmpz_mod_poly]: ...
    def __divmod__(self, other: ifmpz_mod_poly) -> tuple[fmpz_mod_poly, fmpz_mod_poly]: ...
    def __rdivmod__(self, other: ifmpz_mod_poly) -> tuple[fmpz_mod_poly, fmpz_mod_poly]: ...
    def gcd(self, other: ifmpz_mod_poly) -> fmpz_mod_poly: ...
    def xgcd(
        self, other: ifmpz_mod_poly
    ) -> tuple[fmpz_mod_poly, fmpz_mod_poly, fmpz_mod_poly]: ...
    def derivative(self) -> fmpz_mod_poly: ...
    def integral(self) -> fmpz_mod_poly: ...
    def discriminant(self) -> fmpz_mod: ...
    def radical(self) -> fmpz_mod_poly: ...
    def inverse_mod(self, other: ifmpz_mod_poly) -> fmpz_mod_poly: ...
    def inverse_series_trunc(self, n: int) -> fmpz_mod_poly: ...
    def resultant(self, other: ifmpz_mod_poly) -> fmpz_mod: ...
    def sqrt(self) -> fmpz_mod_poly: ...
    def sqrt_trunc(self, n: int) -> fmpz_mod_poly: ...
    def inverse_sqrt_trunc(self, n: int) -> fmpz_mod_poly: ...
    def equal_trunc(self, other: object, n: int) -> bool: ...
    def add_trunc(self, other: fmpz_mod_poly, n: int) -> fmpz_mod_poly: ...
    def sub_trunc(self, other: fmpz_mod_poly, n: int) -> fmpz_mod_poly: ...
    def mul_low(self, other: fmpz_mod_poly, n: int) -> fmpz_mod_poly: ...
    def pow_trunc(self, e: int, n: int) -> fmpz_mod_poly: ...
    def inflate(self, n: int) -> fmpz_mod_poly: ...
    def deflate(self, n: int) -> fmpz_mod_poly: ...
    def deflation(self) -> tuple[fmpz_mod_poly, int]: ...
    def factor_squarefree(self) -> tuple[fmpz_mod, list[tuple[fmpz_mod_poly, int]]]: ...
    def factor(
        self, algorithm: str | None = None
    ) -> tuple[fmpz_mod, list[tuple[fmpz_mod_poly, int]]]: ...
    @overload
    def roots(
        self, multiplicities: Literal[True] = ...
    ) -> list[tuple[fmpz_mod, int]]: ...
    @overload
    def roots(self, multiplicities: Literal[False]) -> list[fmpz_mod]: ...
