from typing import Iterable, Iterator, Mapping, Any

from ..flint_base.flint_base import flint_mpoly, flint_mpoly_context, Ordering
from .fmpz import fmpz


_str = str
ifmpz = int | fmpz


class fmpz_mpoly_ctx(flint_mpoly_context[fmpz_mpoly, fmpz, ifmpz]):
    @classmethod
    def get(cls,
        names: _str | Iterable[_str | tuple[_str, int]] | tuple[_str, int],
        ordering: Ordering | _str = Ordering.lex
    ) -> fmpz_mpoly_ctx:
        ...

    def nvars(self) -> int: ...
    def ordering(self) -> Ordering: ...
    def gen(self, i: int, /) -> fmpz_mpoly: ...
    def from_dict(self, d: Mapping[tuple[int, ...], ifmpz], /) -> fmpz_mpoly: ...
    def constant(self, z: ifmpz, /) -> fmpz_mpoly: ...
    def name(self, i: int, /) -> str: ...
    def names(self) -> tuple[str]: ...
    def gens(self) -> tuple[fmpz_mpoly, ...]: ...
    def variable_to_index(self, var: str, /) -> int: ...
    def term(
        self, coeff: ifmpz | None = None, exp_vec: Iterable[int] | None = None
    ) -> fmpz_mpoly: ...
    def drop_gens(self, gens: Iterable[str | int], /) -> fmpz_mpoly_ctx: ...
    def append_gens(self, gens: Iterable[str | int], /) -> fmpz_mpoly_ctx: ...
    def infer_generator_mapping(
        self, ctx: flint_mpoly_context, /
    ) -> dict[int, int]: ...
    @classmethod
    def from_context(
        cls,
        ctx: flint_mpoly_context[Any, Any, Any],
        names: str | Iterable[str | tuple[str, int]] | tuple[str, int] | None = None,
        ordering: Ordering | str = Ordering.lex,
    ) -> fmpz_mpoly_ctx: ...

class fmpz_mpoly(flint_mpoly[fmpz_mpoly_ctx, fmpz, ifmpz]):

    def __init__(self,
        val: fmpz_mpoly | ifmpz | Mapping[tuple[int, ...], ifmpz] | _str = 0,
        ctx: fmpz_mpoly_ctx | None = None
    ) -> None: ...

    def str(self) -> _str: ...
    def repr(self) -> _str: ...

    def context(self) -> fmpz_mpoly_ctx: ...

    def degrees(self) -> tuple[int, ...]: ...
    def total_degree(self) -> int: ...

    def is_one(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_constant(self) -> bool: ...

    def __len__(self) -> int: ...
    def coefficient(self, i: int) -> fmpz: ...
    def monomial(self, i: int) -> tuple[int, ...]: ...

    def monoms(self) -> list[tuple[int, ...]]: ...
    def coeffs(self) -> list[fmpz]: ...
    def __getitem__(self, index: tuple[int, ...]) -> fmpz: ...
    def __setitem__(self, index: tuple[int, ...], coeff: ifmpz) -> None: ...

    def subs(self, mapping: Mapping[_str | int, ifmpz]) -> fmpz_mpoly: ...
    def compose(self, *args: fmpz_mpoly, ctx: fmpz_mpoly_ctx | None = None) -> fmpz_mpoly: ...

    def __call__(self, *args: ifmpz) -> fmpz: ...

    def __pos__(self) -> fmpz_mpoly: ...
    def __neg__(self) -> fmpz_mpoly: ...
    def __add__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __radd__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __sub__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __rsub__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __mul__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __rmul__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __truediv__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __rtruediv__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __floordiv__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __rfloordiv__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __mod__(self, other: fmpz_mpoly | ifmpz) -> fmpz_mpoly: ...
    def __rmod__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __divmod__(self, other: fmpz_mpoly | ifmpz) -> tuple[fmpz_mpoly, fmpz_mpoly]: ...
    def __rdivmod__(self, other: ifmpz) -> tuple[fmpz_mpoly, fmpz_mpoly]: ...
    def __pow__(self, other: ifmpz) -> fmpz_mpoly: ...
    def __rpow__(self, other: ifmpz) -> fmpz_mpoly: ...

    def iadd(self, other: fmpz_mpoly | ifmpz) -> None: ...
    def isub(self, other: fmpz_mpoly | ifmpz) -> None: ...
    def imul(self, other: fmpz_mpoly | ifmpz) -> None: ...

    def gcd(self, other: fmpz_mpoly) -> fmpz_mpoly: ...
    def term_content(self) -> fmpz_mpoly: ...
    def primitive(self) -> tuple[fmpz, fmpz_mpoly]: ...

    def factor(self) -> tuple[fmpz, list[tuple[fmpz_mpoly, int]]]: ...
    def factor_squarefree(self) -> tuple[fmpz, list[tuple[fmpz_mpoly, int]]]: ...

    def sqrt(self, assume_perfect_square: bool = False) -> fmpz_mpoly: ...

    def resultant(self, other: fmpz_mpoly, var: _str | int) -> fmpz_mpoly: ...
    def discriminant(self, var: _str | int) -> fmpz_mpoly: ...

    def deflation(self) -> tuple[fmpz_mpoly, list[int]]: ...
    def inflate(self, N: list[int]) -> fmpz_mpoly: ...
    def deflate(self, N: list[int]) -> fmpz_mpoly: ...
    def deflation_monom(self) -> tuple[fmpz_mpoly, list[int], fmpz_mpoly]: ...
    def deflation_index(self) -> tuple[list[int], list[int]]: ...

    def derivative(self, var: _str | int) -> fmpz_mpoly: ...
    def integral(self, var: _str | int) -> tuple[int, fmpz_mpoly]: ...


class fmpz_mpoly_vec:
    def __init__(self, 
        iterable_or_len: int | Iterable[fmpz_mpoly],
        ctx: fmpz_mpoly_ctx,
        double_indirect: bool = False
    ) -> None: ...

    def __iter__(self) -> Iterator[fmpz_mpoly]: ...
    def __getitem__(self, index: int) -> fmpz_mpoly: ...
    def __setitem__(self, index: int, value: fmpz_mpoly) -> None: ...

    def buchberger_naive(self, limits: tuple[int, int, int] | None = None) -> fmpz_mpoly_vec: ...
    def autoreduction(self) -> fmpz_mpoly_vec: ...

    def is_groebner(self, other: fmpz_mpoly_vec | None = None) -> bool: ...
    def is_autoreduced(self) -> bool: ...
