from typing import overload, Any, Sequence
from flint.flint_base.flint_base import flint_poly
from flint.types.fmpz import fmpz, ifmpz
from flint.types.fmpq import fmpq
from flint.types.fmpq_poly import fmpq_poly

ifmpz_poly = fmpz_poly | ifmpz

class fmpz_poly(flint_poly[fmpz]):
    """
    The *fmpz_poly* type represents dense univariate polynomials over
    the integers.
    """

    def __init__(self, arg: Sequence[ifmpz] | ifmpz_poly = ..., /) -> None: ...
    def __len__(self) -> int: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...
    def __getitem__(self, i: int, /) -> fmpz: ...
    def __setitem__(self, i: int, x: ifmpz, /) -> None: ...
    def repr(self) -> str: ...
    def __bool__(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def is_gen(self) -> bool: ...
    def leading_coefficient(self) -> fmpz: ...
    @overload
    def __call__(self, other: ifmpz, /) -> fmpz: ...
    @overload
    def __call__(self, other: fmpq, /) -> fmpq: ...
    @overload
    def __call__(self, other: fmpz_poly, /) -> fmpz_poly: ...
    @overload
    def __call__(self, other: fmpq_poly, /) -> fmpq_poly: ...
    # @overload
    # def __call__(self, other: arb, /) -> acb: ...
    # @overload
    # def __call__(self, other: acb, /) -> acb: ...
    def derivative(self) -> fmpz_poly: ...
    def __pos__(self) -> fmpz_poly: ...
    def __neg__(self) -> fmpz_poly: ...
    def __add__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __radd__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __sub__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __rsub__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __mul__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __rmul__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __truediv__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __rtruediv__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __floordiv__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __rfloordiv__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __mod__(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def __rmod__(self, other: ifmpz, /) -> fmpz_poly: ...
    def __divmod__(self, other: ifmpz_poly, /) -> tuple[fmpz_poly, fmpz_poly]: ...
    def __rdivmod__(self, other: ifmpz, /) -> tuple[fmpz_poly, fmpz_poly]: ...
    def __pow__(self, other: int, /) -> fmpz_poly: ...

    def left_shift(self, n: int, /) -> fmpz_poly: ...
    def right_shift(self, n: int, /) -> fmpz_poly: ...
    def truncate(self, n: int, /) -> fmpz_poly: ...

    def gcd(self, other: ifmpz_poly, /) -> fmpz_poly: ...
    def content(self) -> fmpz: ...
    def resultant(self, other: ifmpz_poly, /) -> fmpz: ...
    def factor(self) -> tuple[fmpz, list[tuple[fmpz_poly, int]]]: ...
    def factor_squarefree(self) -> tuple[fmpz, list[tuple[fmpz_poly, int]]]: ...
    def sqrt(self) -> fmpz_poly: ...
    def deflation(self) -> tuple[fmpz_poly, int]: ...
    def deflation_monom(self) -> tuple[fmpz_poly, int, fmpz_poly]: ...
    def inflate(self, n: int, /) -> fmpz_poly: ...
    def deflate(self, n: int, /) -> fmpz_poly: ...
    def deflation_index(self) -> tuple[int, int]: ...

    # XXX acb
    def complex_roots(self, verbose: bool = False) -> list[Any]: ...
    @staticmethod
    def cyclotomic(n: int, /) -> fmpz_poly: ...
    def is_cyclotomic(self) -> int: ...
    @staticmethod
    def cos_minpoly(n: int, /) -> fmpz_poly: ...
    @staticmethod
    def chebyshev_t(n: int, /) -> fmpz_poly: ...
    @staticmethod
    def chebyshev_u(n: int, /) -> fmpz_poly: ...
    @staticmethod
    def swinnerton_dyer(n: int, /, use_arb: bool = True) -> fmpz_poly: ...
    @staticmethod
    def hilbert_class_poly(D: int, /) -> fmpz_poly: ...
    def height_bits(self, signed: bool = False) -> int: ...
