from typing import Any, Sequence
from flint.flint_base.flint_base import flint_series
from flint.types.fmpz import fmpz, ifmpz
from flint.types.fmpz_poly import fmpz_poly, ifmpz_poly


ifmpz_series = fmpz_series | ifmpz_poly


class fmpz_series(flint_series[fmpz]):

    def __init__(self,
                 val: Sequence[ifmpz] | fmpz_series | fmpz_poly | ifmpz | None = None,
                 prec: int | None = None): ...

    @property
    def prec(self) -> int: ...

    def _equal_repr(self, other: object) -> bool: ...

    def __len__(self) -> int: ...
    def length(self) -> int: ...

    def __getitem__(self, i: int, /) -> fmpz: ...
    def __setitem__(self, i: int, x: ifmpz, /) -> None: ...

    def repr(self, **kwargs: Any) -> str: ...
    def str(self, **kwargs: Any) -> str: ...

    def __pos__(self) -> fmpz_series: ...
    def __neg__(self) -> fmpz_series: ...
    def __add__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __radd__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __sub__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __rsub__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __mul__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __rmul__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __truediv__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __rtruediv__(self, other: ifmpz_series, /) -> fmpz_series: ...
    def __pow__(self, exp: int, /) -> fmpz_series: ...

    def valuation(self) -> int: ...

    def __call__(self, other: ifmpz_series, /) -> fmpz_series: ...

    def reversion(self) -> fmpz_series: ...
