from enum import Enum
from ..flint_base.flint_base import flint_scalar
from .fmpz import fmpz
from .fmpz_mod import fmpz_mod, ifmpz
from .fmpz_poly import fmpz_poly
from .nmod_poly import nmod_poly
from .fmpz_mod_poly import fmpz_mod_poly

class fq_default_type(Enum):
    DEFAULT = 0
    FQ_ZECH = 1
    FQ_NMOD = 2
    FQ = 3
    NMOD = 4
    FMPZ_MOD = 5

ifmpz_mod = ifmpz | fmpz_mod
ifq_default = fq_default | fmpz_mod_poly | nmod_poly | fmpz_poly | ifmpz_mod

class fq_default_ctx:
    r"""Context object for creating :class:`~.fq_default`."""

    def __init__(
        self,
        p: ifmpz | None = None,
        degree: int | None = None,
        var: str | None = None,
        modulus: fmpz_mod_poly | fmpz_poly | None = None,
        fq_type: str | int | fq_default_type = fq_default_type.DEFAULT,
        check_prime: bool = True,
        check_modulus: bool = True,
    ): ...
    @property
    def fq_type(self) -> fq_default_type: ...
    def degree(self) -> int: ...
    def characteristic(self) -> fmpz: ...
    def prime(self) -> fmpz: ...
    def order(self) -> fmpz: ...
    def multiplicative_order(self) -> fmpz: ...
    def modulus(self) -> fmpz_mod_poly: ...
    def zero(self) -> fq_default: ...
    def one(self) -> fq_default: ...
    def gen(self) -> fq_default: ...
    def random_element(self, not_zero: bool = False) -> fq_default: ...
    def __call__(self, val: ifq_default) -> fq_default: ...

class fq_default(flint_scalar):
    def __init__(self, val: list[ifmpz] | ifq_default, ctx: fq_default_ctx): ...
    def __int__(self) -> int: ...
    def polynomial(self) -> fmpz_mod_poly: ...
    def to_list(self) -> list[ifmpz]: ...
    def str(self) -> str: ...
    def __hash__(self) -> int: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def inverse(self) -> fq_default: ...
    def square(self) -> fq_default: ...
    def __neg__(self) -> fq_default: ...
    def __add__(self, other: ifq_default, /) -> fq_default: ...
    def __radd__(self, other: ifq_default, /) -> fq_default: ...
    def __sub__(self, other: ifq_default, /) -> fq_default: ...
    def __rsub__(self, other: ifq_default, /) -> fq_default: ...
    def __mul__(self, other: ifq_default, /) -> fq_default: ...
    def __rmul__(self, other: ifq_default, /) -> fq_default: ...
    def __truediv__(self, other: ifq_default, /) -> fq_default: ...
    def __rtruediv__(self, other: ifq_default, /) -> fq_default: ...
    def __invert__(self) -> fq_default: ...
    def __pow__(self, e: ifmpz) -> fq_default: ...
    def sqrt(self) -> fq_default: ...
    def is_square(self) -> bool: ...
    def pth_root(self) -> fq_default: ...
    def trace(self) -> fmpz: ...
    def norm(self) -> fmpz: ...
    def frobenius(self, e: int = ...) -> fq_default: ...
