from typing import overload, Sequence
from flint.flint_base.flint_base import flint_poly
from .fmpz import fmpz, ifmpz
from .fmpz_mod import fmpz_mod
from .fmpz_poly import fmpz_poly, ifmpz_poly
from .fmpz_mod_poly import fmpz_mod_poly
from .fq_default import fq_default_type, fq_default_ctx, fq_default, ifq_default

ifmpz_mod = int | fmpz | fmpz_mod
ifq_default_poly = fq_default_poly | ifq_default | ifmpz_poly

class fq_default_poly_ctx:
    r"""Context object for creating :class:`~.fq_default_poly` initialised
    with a finite field `GF(p^d)`.
    """

    @overload
    def __init__(self, p: fq_default_ctx, /) -> None: ...
    @overload
    def __init__(
        self,
        p: fq_default_ctx | ifmpz | None = None,
        degree: int | None = None,
        var: str | None = None,
        modulus: fmpz_mod_poly | fmpz_poly | None = None,
        fq_type: str | int | fq_default_type = fq_default_type.DEFAULT,
        check_prime: bool = True,
        check_modulus: bool = True,
    ): ...
    def base_field(self) -> fq_default_ctx: ...
    def characteristic(self) -> fmpz: ...
    def prime(self) -> fmpz: ...
    def zero(self) -> fq_default_poly: ...
    def one(self) -> fq_default_poly: ...
    def gen(self) -> fq_default_poly: ...
    def random_element(
        self,
        degree: int = 3,
        not_zero: bool = False,
        monic: bool = False,
        irreducible: bool = False,
    ) -> fq_default_poly: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __call__(self, val: ifq_default_poly) -> fq_default_poly: ...

class fq_default_poly(flint_poly[fq_default]):
    """
    The *fq_default_poly* type represents univariate polynomials
    over a finite field.
    """

    def __init__(
        self,
        other: Sequence[ifq_default] | ifq_default_poly,
        ctx: fq_default_poly_ctx,
        /,
    ) -> None: ...
    def context(self) -> fq_default_poly_ctx: ...
    def __getitem__(self, i: int, /) -> fq_default: ...
    def __setitem__(self, i: int, x: ifq_default, /) -> None: ...
    def __len__(self) -> int: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...
    def constant_coefficient(self) -> fq_default: ...
    def leading_coefficient(self) -> fq_default: ...
    def reverse(self, degree: int | None = None) -> fq_default_poly: ...
    def truncate(self, n: int) -> fq_default_poly: ...
    def monic(self) -> fq_default_poly: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_gen(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def is_monic(self) -> bool: ...
    def is_irreducible(self) -> bool: ...
    def is_squarefree(self) -> bool: ...
    def __pos__(self) -> fq_default_poly: ...
    def __neg__(self) -> fq_default_poly: ...
    def __add__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __radd__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __sub__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __rsub__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __mul__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __rmul__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __floordiv__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __rfloordiv__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __mod__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __rmod__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __divmod__(
        self, other: ifq_default_poly, /
    ) -> tuple[fq_default_poly, fq_default_poly]: ...
    def __rdivmod__(
        self, other: ifq_default_poly, /
    ) -> tuple[fq_default_poly, fq_default_poly]: ...
    def __truediv__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __rtruediv__(self, other: ifq_default_poly, /) -> fq_default_poly: ...
    def __pow__(
        self, e: int, mod: ifq_default_poly | None = None
    ) -> fq_default_poly: ...
    def pow_mod(self, e: int, modulus: ifq_default_poly) -> fq_default_poly: ...
    def divmod(
        self, other: ifq_default_poly
    ) -> tuple[fq_default_poly, fq_default_poly]: ...
    def exact_division(self, other: ifq_default_poly) -> fq_default_poly: ...
    def gcd(self, other: ifq_default_poly) -> fq_default_poly: ...
    def xgcd(
        self, other: ifq_default_poly, /
    ) -> tuple[fq_default_poly, fq_default_poly, fq_default_poly]: ...
    def square(self) -> fq_default_poly: ...
    def left_shift(self, n: int) -> fq_default_poly: ...
    def right_shift(self, n: int) -> fq_default_poly: ...
    def sqrt(self) -> fq_default_poly: ...
    def mul_mod(
        self, other: ifq_default_poly, modulus: ifq_default_poly
    ) -> fq_default_poly: ...
    def equal_trunc(self, other: ifq_default_poly, n: int) -> bool: ...
    def add_trunc(self, other: ifq_default_poly, n: int) -> fq_default_poly: ...
    def sub_trunc(self, other: ifq_default_poly, n: int) -> fq_default_poly: ...
    def mul_low(self, other: ifq_default_poly, n: int) -> fq_default_poly: ...
    def pow_trunc(self, e: int, n: int) -> fq_default_poly: ...
    def sqrt_trunc(self, n: int) -> fq_default_poly: ...
    def inv_sqrt_trunc(self, n: int) -> fq_default_poly: ...
    def inverse_series_trunc(self, n: int) -> fq_default_poly: ...
    def inverse_mod(self, other: ifq_default_poly) -> fq_default_poly: ...
    def derivative(self) -> fq_default_poly: ...
    def radical(self) -> fq_default_poly: ...
    def inflate(self, n: int) -> fq_default_poly: ...
    def deflate(self, n: int) -> fq_default_poly: ...
    def deflation(self) -> tuple[fq_default_poly, int]: ...
    @overload
    def __call__(self, input: ifq_default) -> fq_default: ...
    @overload
    def __call__(self, input: fq_default_poly) -> fq_default_poly: ...
    def evaluate(self, input: ifq_default) -> fq_default_poly: ...
    def compose(self, other: ifq_default_poly) -> fq_default_poly: ...
    def compose_mod(
        self, other: ifq_default_poly, modulus: ifq_default_poly
    ) -> fq_default_poly: ...
    def factor_squarefree(
        self,
    ) -> tuple[fq_default, list[tuple[fq_default_poly, int]]]: ...
    def factor(self) -> tuple[fq_default, list[tuple[fq_default_poly, int]]]: ...
    def roots(self, multiplicities=True) -> list[tuple[fq_default, int]]: ...
