from typing import Iterable, Mapping, Self, Any
from ..flint_base.flint_base import (
    flint_mpoly,
    flint_mpoly_context,
    flint_mod_mpoly_context,
    Ordering,
)
from .fmpz import fmpz
from .fmpq import fmpq
from .nmod import nmod
from .fmpz_mpoly import fmpz_mpoly


_str = str
ifmpz = int | fmpz
inmod = int | fmpz | fmpq | nmod


class nmod_mpoly_ctx(flint_mod_mpoly_context[nmod_mpoly, nmod, inmod]):

    @classmethod
    def get(cls,
        names: _str | Iterable[_str | tuple[_str, int]] | tuple[_str, int],
        ordering: Ordering | _str = Ordering.lex,
        *,
        modulus: int,
    ) -> nmod_mpoly_ctx:
        ...

    def modulus(self) -> int: ...

    def nvars(self) -> int: ...
    def ordering(self) -> Ordering: ...

    def gen(self, i: int) -> nmod_mpoly: ...
    def from_dict(self, d: Mapping[tuple[int, ...], inmod]) -> nmod_mpoly: ...
    def constant(self, z: inmod) -> nmod_mpoly: ...

    def name(self, i: int, /) -> str: ...
    def names(self) -> tuple[str]: ...
    def gens(self) -> tuple[nmod_mpoly, ...]: ...
    def variable_to_index(self, var: str, /) -> int: ...
    def term(
        self, coeff: inmod | None = None, exp_vec: Iterable[int] | None = None
    ) -> nmod_mpoly: ...
    def drop_gens(self, gens: Iterable[str | int], /) -> nmod_mpoly_ctx: ...
    def append_gens(self, gens: Iterable[str | int], /) -> nmod_mpoly_ctx: ...
    def infer_generator_mapping(
        self, ctx: flint_mpoly_context, /
    ) -> dict[int, int]: ...
    @classmethod
    def from_context(
        cls,
        ctx: flint_mpoly_context[Any, Any, Any],
        names: str | Iterable[str | tuple[str, int]] | tuple[str, int] | None = None,
        ordering: Ordering | str = Ordering.lex,
    ) -> nmod_mpoly_ctx: ...


class nmod_mpoly(flint_mpoly[nmod_mpoly_ctx, nmod, inmod]):
    def __init__(self,
        val: nmod_mpoly | fmpz_mpoly | inmod | Mapping[tuple[int, ...], inmod] | _str = 0,
        ctx: nmod_mpoly_ctx | None = None
    ) -> None: ...

    def str(self) -> _str: ...
    def repr(self) -> _str: ...

    def context(self) -> nmod_mpoly_ctx: ...

    def degrees(self) -> tuple[int, ...]: ...
    def total_degree(self) -> int: ...

    def is_one(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_constant(self) -> bool: ...

    def __len__(self) -> int: ...
    def coefficient(self, i: int) -> nmod: ...
    def monomial(self, i: int) -> tuple[int, ...]: ...

    def monoms(self) -> list[tuple[int, ...]]: ...
    def coeffs(self) -> list[nmod]: ...
    def __getitem__(self, index: tuple[int, ...]) -> nmod: ...
    def __setitem__(self, index: tuple[int, ...], coeff: inmod) -> None: ...

    def subs(self, mapping: Mapping[_str | int, inmod]) -> nmod_mpoly: ...
    def compose(self, *args: nmod_mpoly, ctx: nmod_mpoly_ctx | None = None) -> nmod_mpoly: ...

    def __call__(self, *args: inmod) -> nmod: ...

    def __pos__(self) -> nmod_mpoly: ...
    def __neg__(self) -> nmod_mpoly: ...
    def __add__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __radd__(self, other: inmod) -> nmod_mpoly: ...
    def __sub__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __rsub__(self, other: inmod) -> nmod_mpoly: ...
    def __mul__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __rmul__(self, other: inmod) -> nmod_mpoly: ...
    def __truediv__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __rtruediv__(self, other: inmod) -> nmod_mpoly: ...
    def __floordiv__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __rfloordiv__(self, other: inmod) -> nmod_mpoly: ...
    def __mod__(self, other: nmod_mpoly | inmod) -> nmod_mpoly: ...
    def __rmod__(self, other: inmod) -> nmod_mpoly: ...
    def __divmod__(self, other: nmod_mpoly | inmod) -> tuple[nmod_mpoly, nmod_mpoly]: ...
    def __rdivmod__(self, other: inmod) -> tuple[nmod_mpoly, nmod_mpoly]: ...
    def __pow__(self, other: inmod) -> nmod_mpoly: ...
    def __rpow__(self, other: inmod) -> nmod_mpoly: ...

    def iadd(self, other: nmod_mpoly | inmod) -> None: ...
    def isub(self, other: nmod_mpoly | inmod) -> None: ...
    def imul(self, other: nmod_mpoly | inmod) -> None: ...

    def gcd(self, other: nmod_mpoly) -> nmod_mpoly: ...
    def xgcd(self, other: nmod_mpoly, /) -> nmod: ...
    def term_content(self) -> nmod_mpoly: ...
    def primitive(self) -> tuple[nmod, nmod_mpoly]: ...

    def factor(self) -> tuple[nmod, list[tuple[nmod_mpoly, int]]]: ...
    def factor_squarefree(self) -> tuple[nmod, list[tuple[nmod_mpoly, int]]]: ...

    def sqrt(self, assume_perfect_square: bool = False) -> nmod_mpoly: ...

    def resultant(self, other: Self, var: _str | int) -> Self: ...
    def discriminant(self, var: _str | int) -> nmod_mpoly: ...

    def deflation(self) -> tuple[nmod_mpoly, list[int]]: ...
    def inflate(self, N: list[int]) -> nmod_mpoly: ...
    def deflate(self, N: list[int]) -> nmod_mpoly: ...
    def deflation_monom(self) -> tuple[nmod_mpoly, list[int], nmod_mpoly]: ...
    def deflation_index(self) -> tuple[list[int], list[int]]: ...

    def derivative(self, var: _str | int) -> nmod_mpoly: ...


class nmod_mpoly_vec:
    ...

