from typing import overload, Iterator, Sequence
from flint.flint_base.flint_base import flint_poly
from flint.types.nmod import inmod, nmod
from flint.types.fmpz_poly import fmpz_poly

inmod_poly = nmod_poly | fmpz_poly | inmod

class nmod_poly(flint_poly[nmod]):
    """Dense univariate polynomials over Z/nZ for word-size n."""

    @overload
    def __init__(self, val: nmod_poly) -> None: ...
    @overload
    def __init__(self, val: Sequence[inmod] | inmod_poly, mod: int) -> None: ...
    def __len__(self) -> int: ...
    def length(self) -> int: ...
    def degree(self) -> int: ...
    def modulus(self) -> int: ...
    def __iter__(self) -> Iterator[nmod]: ...
    def coeffs(self) -> list[nmod]: ...
    def repr(self) -> str: ...
    def __getitem__(self, i: int) -> nmod: ...
    def __setitem__(self, i: int, x: inmod) -> None: ...
    def __bool__(self) -> bool: ...
    def is_zero(self) -> bool: ...
    def is_one(self) -> bool: ...
    def is_constant(self) -> bool: ...
    def is_gen(self) -> bool: ...
    def reverse(self, degree: int | None = None) -> nmod_poly: ...
    def truncate(self, n: int) -> nmod_poly: ...
    def leading_coefficient(self) -> nmod: ...
    def inverse_series_trunc(self, n: int) -> nmod_poly: ...
    def compose(self, other: inmod_poly) -> nmod_poly: ...
    def compose_mod(self, other: inmod_poly, modulus: inmod_poly) -> nmod_poly: ...
    @overload
    def __call__(self, other: inmod) -> nmod: ...
    @overload
    def __call__(self, other: nmod_poly | fmpz_poly) -> nmod_poly: ...
    def derivative(self) -> nmod_poly: ...
    def integral(self) -> nmod_poly: ...
    def __pos__(self) -> nmod_poly: ...
    def __neg__(self) -> nmod_poly: ...
    def __add__(self, other: inmod_poly) -> nmod_poly: ...
    def __radd__(self, other: inmod_poly) -> nmod_poly: ...
    def __sub__(self, other: inmod_poly) -> nmod_poly: ...
    def __rsub__(self, other: inmod_poly) -> nmod_poly: ...
    def __mul__(self, other: inmod_poly) -> nmod_poly: ...
    def __rmul__(self, other: inmod_poly) -> nmod_poly: ...
    def __truediv__(self, other: inmod_poly) -> nmod_poly: ...
    def __rtruediv__(self, other: inmod_poly) -> nmod_poly: ...
    def __floordiv__(self, other: inmod_poly) -> nmod_poly: ...
    def __rfloordiv__(self, other: inmod_poly) -> nmod_poly: ...
    def __mod__(self, other: inmod_poly) -> nmod_poly: ...
    def __rmod__(self, other: inmod_poly) -> nmod_poly: ...
    def __divmod__(self, other: inmod_poly) -> tuple[nmod_poly, nmod_poly]: ...
    def __rdivmod__(self, other: inmod_poly) -> tuple[nmod_poly, nmod_poly]: ...
    def left_shift(self, n: int) -> nmod_poly: ...
    def right_shift(self, n: int) -> nmod_poly: ...
    def __pow__(self, other: int, mod: inmod_poly | None = None) -> nmod_poly: ...
    def pow_mod(
        self, e: int, modulus: inmod_poly, mod_rev_inv: inmod_poly | None = None
    ) -> nmod_poly: ...
    def gcd(self, other: inmod_poly) -> nmod_poly: ...
    def resultant(self, other: inmod_poly) -> nmod: ...
    def xgcd(self, other: inmod_poly) -> tuple[nmod_poly, nmod_poly, nmod_poly]: ...
    def factor(
        self, algorithm: str | None = None
    ) -> tuple[nmod, list[tuple[nmod_poly, int]]]: ...
    def factor_squarefree(self) -> tuple[nmod, list[tuple[nmod_poly, int]]]: ...
    def sqrt(self) -> nmod_poly: ...
    def deflation(self) -> tuple[nmod_poly, int]: ...
    def roots(self) -> list[tuple[nmod, int]]: ...
