# Welcome to FreeIPA client's documentation!

## Installation

```bash
pip install python-freeipa
```

## Example usage

Client using username and password to connect to specific IPA server:

```python
from python_freeipa import ClientMeta
client = ClientMeta('ipa.demo1.freeipa.org')
client.login('admin', 'Secret123')
user = client.user_add('test3', 'John', 'Doe', 'John Doe', o_preferredlanguage='EN')
print(user)
```

Client using DNS service discovery. By default, we will try to find IPA servers using the FQDN of the host trying to connect to an IPA server. Alternatively you can also manually specify a domain here.

For DNS service discovery, you need to have the `srvlookup` module installed.

```python
from python_freeipa import ClientMeta
client = ClientMeta(dns_discovery=True)
client.login('admin', 'Secret123')
user = client.user_add('test3', 'John', 'Doe', 'John Doe', o_preferredlanguage='EN')
print(user)
```

## Breaking changes in 1.0 release

Previously, Python FreeIPA client covered only small fraction of FreeIPA API calls. By introducing code generator we cover all FreeIPA API calls. By default autogenerated client is used. It has different API signatures. Therefore if you want to preserve old behaviour you should just use `ClientLegacy` instead of `Client`. For example:

```python
from python_freeipa import ClientLegacy
client = ClientLegacy('ipa.demo1.freeipa.org', version='2.215')
client.login('admin', 'Secret123')
```

## Contributing

### Development Setup

1. Install `uv` for faster dependency management:

```bash
curl -LsSf https://astral.sh/uv/install.sh | sh
```

2. Create a virtual environment and install dependencies:

```bash
uv venv
source .venv/bin/activate  # On Windows: .venv\Scripts\activate
uv pip install -e ".[dev,test,docs]"
```

3. Install and set up `pre-commit`:

```bash
pre-commit install
```

### Running Tests

```bash
uv run pytest
```

Or with coverage:

```bash
uv run pytest --cov=src/python_freeipa/
```

### Building Documentation

```bash
uv run mkdocs serve
```

## Recreation of MetaClient

It is possible to manually recreate the "ClientMeta" class. This might be needed if the IPA/IdM Server you are using is not matching the one that has been used to build the packaged version.

Here is what you need to do:

```bash
sudo apt-get install libkrb5-dev
# fetch code, create virtual environment, and install required packages
git clone git@github.com:opennode/python-freeipa.git
cd python-freeipa
uv venv
source .venv/bin/activate  # On Windows: .venv\Scripts\activate
uv pip install -e ".[dev]"
# recreate the ClientMeta class
contrib/py_ipa_api_recreate --source-url ipa.demo1.freeipa.org --source-url-user admin --source-url-pass Secret123
# move the file where it belongs
mv meta_api.py src/python_freeipa/client_meta.py
# build the python package
uv build
```

This will give you a python package, which you can install using "pip install"

## Base client module

::: python_freeipa.client

## Autogenerated client module

::: python_freeipa.client_meta

## Exceptions module

::: python_freeipa.exceptions
