def get_fake_account(
    _account_id=1000226, name="John Doe", email="john.doe@example.com", username="john"
):
    """Creates a fake account

    Returns the serialized and parametrized representation of a dumped
    Gerrit Code Review environment.
    """

    return {
        "_account_id": _account_id,
        "name": name,
        "email": email,
        "username": username,
        "status": "Out of Office",
        "secondary_emails": ["fake-email@example.com"],
        "registered_on": "2017-02-16 07:33:57.000000000",
    }


def get_fake_accounts(account_count):
    """Creates a random fake list of accounts."""

    return [
        get_fake_account(_account_id=i, username=f"john-{i}")
        for i in range(1, account_count + 1)
    ]


def get_fake_account_email_info(
    email="jdoe@example.com", preferred=False, no_confirmation=False
):
    """Creates a random fake email info of accounts."""

    return {"email": email, "preferred": preferred, "no_confirmation": no_confirmation}


def get_fake_oauth_token():
    """Creates a random fake oauth access token of account."""

    return {
        "username": "johndow",
        "resource_host": "gerrit.example.org",
        "access_token": "eyJhbGciOiJSUzI1NiJ9.eyJqdGkiOi",
        "provider_id": "oauth-plugin:oauth-provider",
        "expires_at": "922337203775807",
        "type": "bearer",
    }
