# Security Policy

We will support the latest stable release of `python-gitea`.
Please ensure you are using the most recent version before reporting a security issue.

| Version | Supported |
| ------- | --------- |
| Latest  | ✅        |
| < 1.0   | ❌        |

**Notes**:

- Update this table when you release version 1.0 or later
- Consider your project's versioning strategy and support policy
- For pre-1.0 versions, you may want to support multiple recent versions

## Reporting a Vulnerability

If you discover a security vulnerability in `python-gitea`,
please report it using **GitHub's private vulnerability reporting feature**:

<!-- prettier-ignore-start -->

1. Go to the [Security](https://github.com/isaac-cf-wong/python-gitea/security) tab of this repository
2. Click **"Report a vulnerability"**
3. Fill out the vulnerability report form with:
    - A description of the vulnerability
    - Steps to reproduce
    - Affected versions
    - Your operating system and Python version
    - Any proof-of-concept code (if applicable)

**Please do not open a public issue or discussion.**
GitHub's private vulnerability reporting keeps the issue confidential until a fix is available.

<!-- prettier-ignore-end -->

## Response Timeline

We aim to:

- Acknowledge receipt within **24 hours**
- Investigate and assess the vulnerability within **3–5 business days**
- Provide a security patch in a timely manner
- Publish a security advisory once the fix is released
- Credit the reporter (if desired)

## Responsible Disclosure

## Thanks

We value the security of our users and appreciate responsible disclosures.
Thank you for helping make `python-gitea` better and safer!
