# Change Log
All notable changes to this project will be documented in this file.
This project adheres to [Semantic Versioning](http://semver.org/).

## 2.6.1 - 2024-11-18
### Changed
* Parameterized unit tests in nox to test a range of python versions > 3.10 and
  numpy >1.26
  * Trying to get 3.9 to work is a bust

## 2.6.0 - 2024-11-16
### Changed
* In root `meson.build`, replace `import numpy` and `numpy.f2py.get_include()` to 
  `from numpy import f2py` and `f2py.get_include()` to allow numpy < 2.0 to work
* Rewrote unittest-style tests as pytest-style tests
* Add Nox
* Formatting and linting using Ruff
* Revert usage of structural pattern matching so earlier versions of python work

## 2.5.0 - 2024-11-13

### Changed
* Python version support: Allow 3.12 and newer versions of numpy
  that lack numpy.code.distutils
* Replace Numpy-based build system with Meson
* Remove setup.py and move all information into pyproject.toml
* Formatting and linting using Ruff
* Changed package layout to src-type, moved tests outside

## Unreleased

## 2.2.2 - 2024-05-09
### Changed
* [#3](https://github.com/replicahq/python-glmnet/pull/3)
   - Python version support: Add 3.10 and 3.11, drop 3.8 and below.

## 2.2.1 - 2020-06-30
### Fix
* [#65](https://github.com/civisanalytics/python-glmnet/pull/65)
  Remove `six` dependency entirely.

## 2.2.0 - 2020-06-29
### Changed
* [#57](https://github.com/civisanalytics/python-glmnet/pull/57)
  Mark the Fortran code as linguist-vendored so that GitHub classifies
  this project as Python (#37).
* [#62](https://github.com/civisanalytics/python-glmnet/pull/62)
  Update the cross-validation for users to be able to define groups of
  observations, which is equivalent with *foldid* of *cvglmnet* in *R*.
* [#64](https://github.com/civisanalytics/python-glmnet/pull/64)
   - Python version support: Add v3.8, and drop v3.4 + v3.5.
   - Maintenance: Drop versioneer; update and pin dependencies for development.

## 2.1.1 - 2019-03-11
### Fixed
* [#55](https://github.com/civisanalytics/python-glmnet/pull/55)
  Include all Fortran source code in source tarball; exclude autogenerated C.

## 2.1.0 - 2019-03-11

### Added
* [#29](https://github.com/civisanalytics/python-glmnet/pull/29)
  Provide understandable error messages for more glmnet solver errors.
* [#31](https://github.com/civisanalytics/python-glmnet/pull/31)
  Expose `max_features` parameter in `ElasticNet` and `LogitNet`.
* [#34](https://github.com/civisanalytics/python-glmnet/pull/34)
  Use sample weights in `LogitNet`.
* [#41](https://github.com/civisanalytics/python-glmnet/pull/41)
  Add `lower_limits` and `upper_limits` parameters to `ElasticNet`
  and `LogitNet`, allowing users to restrict the range of fitted coefficients.

### Changed
* [#44](https://github.com/civisanalytics/python-glmnet/pull/44)
  Change CircleCI configuration file from v1 to v2, switch to pytest,
  and test in Python versions 3.4 - 3.7.
* [#36](https://github.com/civisanalytics/python-glmnet/pull/36)
  Convert README to .rst format for better display on PyPI (#35).
* [#54](https://github.com/civisanalytics/python-glmnet/pull/54)
  Use `setuptools` in `setup.py` and update author in metadata.

### Fixed
* [#24](https://github.com/civisanalytics/python-glmnet/pull/24)
  Use shuffled splits (controlled by input seed) for cross validation (#23).
* [#47](https://github.com/civisanalytics/python-glmnet/pull/47)
  Remove inappropriate `__init__.py` from the root path (#46).
* [#51](https://github.com/civisanalytics/python-glmnet/pull/51)
  Satisfy scikit-learn estimator checks. Includes:
  Allow one-sample predictions; allow list inputs for sample weights;
  Ensure scikit-learn Estimator compatibility.
* [#53](https://github.com/civisanalytics/python-glmnet/pull/53)
  Return correct dimensions for 1-row predictions, with or without lambda
  path, in both `LogitNet` and `ElasticNet` (#52, #30, #25).

## 2.0.0 - 2017-03-01

### API Changes
* [#10](https://github.com/civisanalytics/python-glmnet/pull/10) the parameter `n_folds` in the constructors of `LogitNet` and `ElasticNet` has been changed to `n_splits` for consistency with Scikit-Learn.

### Added
* [#6](https://github.com/civisanalytics/python-glmnet/pull/6) expose relative penalty

### Changed
* [#10](https://github.com/civisanalytics/python-glmnet/pull/10) update Scikit-Learn to 0.18

### Fixed
* [#3](https://github.com/civisanalytics/python-glmnet/pull/3) ensure license and readme are included in sdist
* [#8](https://github.com/civisanalytics/python-glmnet/pull/8) fix readme encoding
* [#14](https://github.com/civisanalytics/python-glmnet/pull/14) fix reference to `lambda_best_` in docs
* [#16](https://github.com/civisanalytics/python-glmnet/pull/16) fix import path for UndefinedMetricWarning

## 1.0.0 - 2016-06-03
### Added
- Initial release
