# Contributing to python-glmnet

We welcome bug reports and pull requests from everyone!
This project is intended to be a safe, welcoming space for collaboration, and contributors are expected to adhere to the [Contributor Covenant](http://contributor-covenant.org) code of conduct.


## Getting Started

1. Fork it ( https://github.com/civisanalytics/python-glmnet/fork )
2. Install the dependencies (`pip install -r requirements.txt`)
3. Make sure you are able to run the test suite locally (`nosetests -v`)
4. Create a feature branch (`git checkout -b my-new-feature`)
5. Make your change. Don't forget tests
6. Make sure the test suite, including your new tests, passes (`nosetests -v`)
7. Commit your changes (`git commit -am 'Add some feature'`)
8. Push to the branch (`git push origin my-new-feature`)
9. Create a new pull request
10. If the CircleCI build fails, address any issues

## Tips

- All pull requests must include test coverage. If you’re not sure how to test
  your changes, feel free to ask for help.
- Contributions must conform to PEP 8 and the NumPy/SciPy Documentation standards:
   - [PEP 8 -- Style Guide for Python Code](https://www.python.org/dev/peps/pep-0008/)
   - [A Guide to NumPy/SciPy Documentation](https://github.com/numpy/numpy/blob/master/doc/HOWTO_DOCUMENT.rst.txt)
- Don’t forget to add your change to the [CHANGELOG](CHANGELOG.md). See
  [Keep a CHANGELOG](http://keepachangelog.com/) for guidelines.

Thank you for taking the time to contribute to python-glmnet!
