from __future__ import absolute_import

from .creds import BaseCredential, Credential
from .ctx import Context, InitContext, AcceptContext
from .error import GSSException, GSSCException
from .headers.gssapi_h import (
    GSS_C_DELEG_FLAG,
    GSS_C_MUTUAL_FLAG,
    GSS_C_REPLAY_FLAG,
    GSS_C_SEQUENCE_FLAG,
    GSS_C_CONF_FLAG,
    GSS_C_INTEG_FLAG,
    GSS_C_ANON_FLAG,
    GSS_C_PROT_READY_FLAG,
    GSS_C_TRANS_FLAG,
    GSS_C_DELEG_POLICY_FLAG,
    GSS_C_BOTH,
    GSS_C_INITIATE,
    GSS_C_ACCEPT,
    GSS_C_NT_USER_NAME,
    GSS_C_NT_MACHINE_UID_NAME,
    GSS_C_NT_STRING_UID_NAME,
    GSS_C_NT_HOSTBASED_SERVICE,
    GSS_C_NT_ANONYMOUS,
    GSS_C_NT_EXPORT_NAME,
    GSS_S_COMPLETE,
    GSS_S_CALL_INACCESSIBLE_READ,
    GSS_S_CALL_INACCESSIBLE_WRITE,
    GSS_S_CALL_BAD_STRUCTURE,
    GSS_S_BAD_MECH,
    GSS_S_BAD_NAME,
    GSS_S_BAD_NAMETYPE,
    GSS_S_BAD_BINDINGS,
    GSS_S_BAD_STATUS,
    GSS_S_BAD_SIG,
    GSS_S_NO_CRED,
    GSS_S_NO_CONTEXT,
    GSS_S_DEFECTIVE_TOKEN,
    GSS_S_DEFECTIVE_CREDENTIAL,
    GSS_S_CREDENTIALS_EXPIRED,
    GSS_S_CONTEXT_EXPIRED,
    GSS_S_FAILURE,
    GSS_S_BAD_QOP,
    GSS_S_UNAUTHORIZED,
    GSS_S_UNAVAILABLE,
    GSS_S_DUPLICATE_ELEMENT,
    GSS_S_NAME_NOT_MN,
    GSS_S_CONTINUE_NEEDED,
    GSS_S_DUPLICATE_TOKEN,
    GSS_S_OLD_TOKEN,
    GSS_S_UNSEQ_TOKEN,
    GSS_S_GAP_TOKEN,
    GSS_S_CRED_UNAVAIL,
)
from .names import Name, BaseName, MechName
from .oids import OID, OIDSet, get_all_mechs
